
import Queue
import random
import os,sys
from Screens.InfoBar import MoviePlayer, InfoBar
from Components.ServiceEventTracker import ServiceEventTracker, InfoBarBase
from Screens.MessageBox import MessageBox
from Screens.InfoBarGenerics import *

from Components.Pixmap import Pixmap, MovingPixmap
from enigma import eServiceReference, iServiceInformation, iPlayableService, getDesktop
from Components.ServiceEventTracker import ServiceEventTracker
from Components.AVSwitch import AVSwitch
from ServiceReference import ServiceReference
from Screens.PVRState import PVRState, TimeshiftState
THISPLUG = "/usr/lib/enigma2/python/Plugins/Extensions/KodiDirect"
def getserviceinfo(sref):
    try:
        p = ServiceReference(sref)
        servicename = str(p.getServiceName())
        serviceurl = str(p.getPath())
        return (servicename, serviceurl)
    except:
        return (None, None)

    return None,None


import xpath

from SubsSupport import SubsSupport, initSubsSettings


from skin import parseColor


def getrandom(cmax = 10):
    try:
        return random.randrange(0, cmax)
    except:
        return 0

def getaddon_id():
    try:
        defaultfile=sys.argv[0]
        defaultdir=os.path.split(defaultfile)[0]
        addon_id=os.path.split(defaultdir)[1]
        print "addon_id",addon_id
        return addon_id
    except:
        return None

class StatusScreen(Screen):

    def __init__(self, session):
        desktop = getDesktop(0)
        size = desktop.size()
        self.sc_width = size.width()
        self.sc_height = size.height()
        statusPositionX = 50
        statusPositionY = 100
        self.delayTimer = eTimer()
        self.delayTimer.callback.append(self.hideStatus)
        self.delayTimerDelay = 1500
        self.shown = True
        self.skin = '\n            <screen name="StatusScreen" position="%s,%s" size="%s,90" zPosition="0" backgroundColor="transparent" flags="wfNoBorder">\n                    <widget name="status" position="0,0" size="%s,70" valign="center" halign="left" font="Regular;22" transparent="1" foregroundColor="yellow" shadowColor="#40101010" shadowOffset="3,3" />\n            </screen>' % (str(statusPositionX),
         str(statusPositionY),
         str(self.sc_width),
         str(self.sc_width))
        Screen.__init__(self, session)
        self.stand_alone = True
        print 'initializing status display'
        self['status'] = Label('')
        self.onClose.append(self.__onClose)

    def setStatus(self, text, color = 'yellow'):
        self['status'].setText(text)
        self['status'].instance.setForegroundColor(parseColor(color))
        self.show()
        self.delayTimer.start(self.delayTimerDelay, True)

    def hideStatus(self):
        self.hide()
        self['status'].setText('')

    def __onClose(self):
        self.delayTimer.stop()
        del self.delayTimer


class KDplayer(Screen, InfoBarBase, SubsSupport, InfoBarSeek, InfoBarNotifications, InfoBarPVRState, InfoBarShowHide, InfoBarAudioSelection):
    ENABLE_RESUME_SUPPORT = True
    ALLOW_SUSPEND = True

    def __init__(self, session, sref, addon_id = None, playlist = [], playindex = 0):
        Screen.__init__(self, session)
        
        if addon_id is None:
                addon_id=getaddon_id()
        
        try:    
           if '.audio' in addon_id:
            self.audio = True
           else:
            self.audio = False
            
        except:
            self.audio = False 
        playIdx=playindex      
        self.playlist = playlist

        self.addon_id = addon_id
        

        self.sref=sref
        if self.audio == True:
            self.skinName = 'KDRplayer'
        else:
            self.skinName = 'KDMplayer'
        self.onPlayStateChanged = []
       
        initSubsSettings()
        SubsSupport.__init__(self, embeddedSupport=True, searchSupport=True)
        self.subs = True
        InfoBarPVRState.__init__(self, screen=PVRState)
        self.pvrStateDialog = self.session.instantiateDialog(PVRState)
        self.session = session
        
        try:
            self.lastservice = self.session.nav.getCurrentlyPlayingServiceReference()
        except:
            self.lastservice = None

        self.plugin_path = THISPLUG
        self.servicename, self.serviceurl = getserviceinfo(self.sref)
        self['plugin_icon'] = Pixmap()
        self['programm'] = Label('playing stream..')
        self.onPlayStateChanged = []
       
        self.randomplay = False
        
        self.noexit = False
        self.InfoBar_NabDialog = Label('')
        self['channel_number'] = Label(str(playIdx))
        self.statusScreen = self.session.instantiateDialog(StatusScreen)
        self.__event_tracker = ServiceEventTracker(screen=self, eventmap={iPlayableService.evUpdatedInfo: self.__evUpdatedInfo,
         iPlayableService.evUser + 10: self.__evAudioDecodeError,
         iPlayableService.evUser + 11: self.__evVideoDecodeError,
         iPlayableService.evUser + 12: self.__evPluginError})
        self['actions'] = ActionMap(['ColorActions',
         'WizardActions',
         'MediaPlayerSeekActions',
         'InfobarInstantRecord',
         'MediaPlayerActions',
         'EPGSelectActions',
         'MoviePlayerActions',
         'ColorActions',
         'InfobarActions',
         'MenuActions',
         'NumberActions',
         'DirectionActions',
         'MovieSelectionActions'], {'leavePlayer': self.leavePlayer,
         'info': self.openinfo,
         'menu': self.showpluginsbrowser,
         'red': self.startsubtitle,
         'instantRecord': self.startdownload,
         'upUp': self.savetofavorites,
         'downUp': self.av,
         'back': self.leavePlayer,
         'KEY_TV': (self.refreshSubs, _('Refresh subtitles')),
         'left': self.seekBack,
         'blue': self.seekFwdManual,
         '0': self.playnext,
         'right': self.seekFwd}, -1)

        try:
            self.init_aspect = int(self.getAspect())
        except:
            self.init_aspect = 0

        self.new_aspect = self.init_aspect
        self.playIdx = playIdx
        self.startindex = playIdx
        self.playLen = len(self.playlist)
        print 'self.playIdx', self.playIdx
        InfoBarNotifications.__init__(self)
        InfoBarBase.__init__(self)
        if self.audio==False:
            InfoBarShowHide.__init__(self)
        InfoBarAudioSelection.__init__(self)
        self.shown = False
        InfoBarSeek.__init__(self)
        
        self.onClose.append(self.playExit)
        self.onLayoutFinish.append(self.playStream)
        return

    def getAspect(self):
        return AVSwitch().getAspectRatioSetting()

    def getAspectString(self, aspectnum):
        return {0: _('4:3 Letterbox'),
         1: _('4:3 PanScan'),
         2: _('16:9'),
         3: _('16:9 always'),
         4: _('16:10 Letterbox'),
         5: _('16:10 PanScan'),
         6: _('16:9 Letterbox')}[aspectnum]

    def setAspect(self, aspect):
        map = {0: '4_3_letterbox',
         1: '4_3_panscan',
         2: '16_9',
         3: '16_9_always',
         4: '16_10_letterbox',
         5: '16_10_panscan',
         6: '16_9_letterbox'}
        config.av.aspectratio.setValue(map[aspect])
        try:
            AVSwitch().setAspectRatio(aspect)
        except:
            pass

    def av(self):
        temp = int(self.getAspect())
        print self.getAspectString(temp)
        temp = temp + 1
        if temp > 6:
            temp = 0
        self.new_aspect = temp
        self.setAspect(temp)
        print self.getAspectString(temp)
        self.statusScreen.setStatus(self.getAspectString(temp))

    def refreshSubs(self):
        if self.subs == False:
            return
        if not self.shown:
            if not self.isSubsLoaded():
                print 'No external subtitles loaded'
                self.statusScreen.setStatus(_('No external subtitles loaded'))
            else:
                self.playAfterSeek()
                print 'Refreshing subtitles...'
                self.statusScreen.setStatus(_('Refreshing subtitles...'))

    def playnext(self):
        if self.activeplaylist == True:
            self.activeplaylist = False
            self.subs = True
            self['programm'].setText('Autoplay next video is disabled')
        else:
            self.activeplaylist = True
            self.subs = False
            self['programm'].setText('Autoplay next video is enabled')
        try:
            self.show()
        except:
            pass

    def ScreenSaverTimerStart(self):
        return
        try:
            time = int(config.usage.screen_saver.value)
            flag = self.seekstate[0]
            if not flag:
                ref = self.session.nav.getCurrentlyPlayingServiceOrGroup()
                if ref:
                    ref = ref.toString().split(':')
                    flag = ref[2] == '2' or os.path.splitext(ref[10])[1].lower() in AUDIO_EXTENSIONS
            if time and flag:
                self.screenSaverTimer.startLongTimer(time)
            else:
                self.screenSaverTimer.stop()
        except:
            pass

    def ShowPlugin_icon(self):
        micon = self.plugin_path + '/images/XBMCAddons.png' 
        if not os.path.exists(micon):
            micon = self.plugin_path + '/images/XBMCAddons.png' 
        if os.path.exists(micon):
            
            self['plugin_icon'].instance.setPixmapFromFile(micon)

    def startdownload(self):
        servicename, serviceurl = getserviceinfo(self.sref)
        if self.servicename is None:
            self.servicename = 'No title'
        if self.serviceurl is None:
            return
        else:
            from download import startdownload
            startdownload(self.session,answer='download',myurl=self.serviceurl,filename=self.servicename,title=self.servicename)
            return
            return

    def startsubtitle(self):
        try:
           self.subsMenu()
        except:
           self['programm'].setText('Unable to start subtitles player')  
       

    def showpluginsbrowser(self):
        try:
            from Screens.PluginBrowser import PluginBrowser
            self.session.open(PluginBrowser)
            return
        except:
            pass



    def unlockShow(self):
        return
        self.__locked = self.__locked - 1
        if self.execing:
            self.startHideTimer()

    def lockShow(self):
        return
        self.__locked = self.__locked + 1
        if self.execing:
            self.show()
            self.hideTimer.stop()

    def _mayShow(self):
        print '244', self.audio
        if self.audio == True:
            try:
                p = InfoBarShowHide()
                if p.__state == p.STATE_SHOWN:
                    p.hideTimer.stop()
                elif p.__state == p.STATE_HIDDEN:
                    p.show()
            except:
                pass

        elif self.execing and self.seekstate != self.SEEK_STATE_PLAY:
            if self.pvrStateDialog is not None:
                self.pvrStateDialog.show()
        return

    def subsDelayInc(self):
        if self.subs == False:
            return
        if not self.isSubsLoaded():
            print 'No external subtitles loaded'
            self.statusScreen.setStatus(_('No external subtitles loaded'))
        else:
            delay = self.getSubsDelay()
            delay += 200
            self.setSubsDelay(delay)
            if delay > 0:
                print '%d ms' % delay
                self.statusScreen.setStatus('+%d ms' % delay)
            else:
                self.statusScreen.setStatus('%d ms' % delay)
                print '%d ms' % delay

    def subsDelayDec(self):
        if self.subs == False:
            return
        if not self.isSubsLoaded():
            print 'No external subtitles loaded'
            self.statusScreen.setStatus(_('No external subtitles loaded'))
        else:
            delay = self.getSubsDelay()
            delay -= 200
            self.setSubsDelay(delay)
            if delay > 0:
                print '+%d ms' % delay
                self.statusScreen.setStatus('+%d ms' % delay)
            else:
                print '%d ms' % delay
                self.statusScreen.setStatus('%d ms' % delay)

    def seekBack(self):
        if self.subs == True:
            self.subsDelayDec()
            return


    def seekFwd(self, playrandom = False):
        print 'self.playlist451', self.playlist
        if self.subs == True:
            self.subsDelayInc()
            return


    def openinfo(self):
        try:
            servicename, serviceurl = getserviceinfo(self.sref)
            if servicename is not None:
                sTitle = servicename
            else:
                sTitle = ''
            if serviceurl is not None:
                sServiceref = serviceurl
            else:
                sServiceref = ''
            currPlay = self.session.nav.getCurrentService()
            sTagCodec = currPlay.info().getInfoString(iServiceInformation.sTagCodec)
            sTagVideoCodec = currPlay.info().getInfoString(iServiceInformation.sTagVideoCodec)
            sTagAudioCodec = currPlay.info().getInfoString(iServiceInformation.sTagAudioCodec)
            message = 'stitle:' + str(sTitle) + '\n' + 'sServiceref:' + str(sServiceref) + '\n' + 'sTagCodec:' + str(sTagCodec) + '\n' + 'sTagVideoCodec:' + str(sTagVideoCodec) + '\n' + 'sTagAudioCodec :' + str(sTagAudioCodec)
            from XBMCAddonsinfo import XBMCAddonsinfoScreen
            self.session.open(XBMCAddonsinfoScreen, None, 'XBMCAddonsPlayer', message)
        except:
            pass

        return

    def playStream(self):
        self.ShowPlugin_icon()
        self.session.nav.stopService()
        servicename, serviceurl = getserviceinfo(self.sref)
        if servicename is not None:
            sTitle = servicename
        else:
            sTitle = ''


        if not self.sref:
            self['programm'].setText('Error playing stream')
            self.show()
            return
        else:
            self['programm'].setText('Playing stream..')
            
            self.session.nav.stopService()
            try:
                self.session.nav.playService(self.sref)
            except:
                self['programm'].setText('Invalid stream link')

            try:
                self['channel_number'].setText(str(self.playIdx))
            except:
                pass

            
            return

    def leavePlayer(self):
        self.playExit()
        self.is_closing = True
        try:
            f = open('/tmp/index.txt', 'w')
            f.write(str(self.playIdx))
            f.close()
        except:
            pass

        if not self.new_aspect == self.init_aspect:
            try:
                self.setAspect(self.init_aspect)
            except:
                pass

        self.close(self.playIdx)

    def leavePlayerConfirmed(self, answer):
        self.is_closing = True

    def handleLeave(self, how = 'noask'):
        self.is_closing = True
        self.leavePlayerConfirmed([True, how])

    def doEofInternal(self, playing):
        currPlay = self.session.nav.getCurrentService()
        message = currPlay.info().getInfoString(iServiceInformation.sUser + 12)
        if message.find('Flash demuxer not available') != -1 or message.find('(AVI) demuxer not available') != -1:
            self['programm'].setText("Your box can't decode this video stream!\n%s") % message
        elif message.find('GStreamer plugin') != -1 and message.find('not available') != -1:
            self.__evPluginError()
        elif message.find('GStreamer') != -1 and message.find('missing a plug-in') != -1:
            self.__evPluginError()
        elif message.find('GStreamer error') != -1:
            print 'gsstreamer mah eroor', message
            self.__evPluginError()
        elif message.find('No decoder available') != -1:
            self.__evPluginError()
        else:
            if not self.execing:
                return None
            if not playing:
                return None
            if self.noexit == True:
                self.doSeek(0)
                self.setSeekState(self.SEEK_STATE_PLAY)
                self.noexit = False
                return None
                self.canexit = True
                self.doSeek(0)
                self.setSeekState(self.SEEK_STATE_PLAY)
            elif self.activeplaylist == True and config.TSmedia.nonstopplay.value == True:
                try:
                    if config.KodiDirect.randomplaylist.value == True:
                        self.randomplay = True
                except:
                    pass

                self.seekFwd(False)
            else:
                return None
                self.leavePlayer()
        return None

    def __evUpdatedInfo(self):
        sTitle = ''
        currPlay = self.session.nav.getCurrentService()
        if currPlay is not None:
            sTitle = currPlay.info().getInfoString(iServiceInformation.sTagTitle)
        self.show()
        self.sTitle = sTitle
        print '386', self.sTitle
        try:
            self['programm'].setText(sTitle)
        except:
            self['programm'].setText('unknown')

        text = self['programm'].getText()
        return

    def __evAudioDecodeError(self):
        currPlay = self.session.nav.getCurrentService()
        sTagAudioCodec = currPlay.info().getInfoString(iServiceInformation.sTagAudioCodec)
        print "[__evAudioDecodeError] audio-codec %s can't be decoded by hardware" % sTagAudioCodec
        if sTagAudioCodec is not None:
            self['programm'].setText(str(sTagAudioCodec))
        self.show()
        return

    def __evVideoDecodeError(self):
        currPlay = self.session.nav.getCurrentService()
        sTagVideoCodec = currPlay.info().getInfoString(iServiceInformation.sTagVideoCodec)
        print "[__evVideoDecodeError] video-codec %s can't be decoded by hardware" % sTagVideoCodec
        if sTagVideoCodec is not None:
            self['programm'].setText(str(sTagVideoCodec))
        self.show()
        return

    def __evPluginError(self):
        currPlay = self.session.nav.getCurrentService()
        message = currPlay.info().getInfoString(iServiceInformation.sUser + 12)
        print '[__evPluginError]', message
        if message is not None:
            self['programm'].setText(str(message))
        self.show()
        return

    def playExit(self):
        print 'playExit:'
        self.session.nav.stopService()
        self.session.nav.playService(self.lastservice)
        

    def savetofavorites(self):
        servicename, serviceurl = getserviceinfo(self.sref)
        #try:
            #serviceurl = self.playlist[self.playIdx][1]
        #except:
            #serviceurl = None

        print 'serviceurl,len(self.playlist),self.playIdx', serviceurl, len(self.playlist), self.playIdx
        if servicename is None or serviceurl is None:
            return
        else:
               from favorites import addfavorite
               import sys
               
               try:
                  if self.addon_id is None:
                     return
                  result=addfavorite(self.addon_id,servicename,serviceurl)
               except:
                   result=False
               if result == True:
                    self['programm'].setText('Video added successfully to favorites.')
               else:
                    self['programm'].setText('Failed to add video to favorites.')





