#
from struct import pack
from enigma import *
from Screens.Screen import Screen
from Screens.MessageBox import MessageBox
from Screens.InputBox import InputBox
from Screens.ChoiceBox import ChoiceBox
from Components.ActionMap import ActionMap, NumberActionMap
from Components.ScrollLabel import ScrollLabel
from Components.GUIComponent import *
from Components.MenuList import MenuList
from Components.Input import Input
from Components.ConfigList import ConfigList
from Screens.Console import Console
from Plugins.Plugin import PluginDescriptor
from Screens.ServiceInfo import *
from Plugins.Plugin import PluginDescriptor
from Tools import Notifications
from Components.config import *

pauli_pluginversion = "8.0-r0"

import os
import keymapparser
session = None

from time import *
import time
import datetime
if os.path.exists("/usr/share/enigma2/skin_default/rc0.png"):
	pauli_remote="/usr/share/enigma2/skin_default/rc0.png"
else:
	pauli_remote="/usr/share/enigma2/skin_default/rc.png"

pauli_readme = "/usr/lib/enigma2/python/Plugins/Extensions/Pauli/readme.txt"
pauli_keymap = "/usr/share/enigma2/keymap.xml"
pauli_mytest = "/usr/lib/enigma2/python/mytest.py"
pauli_recordinfo = "/usr/lib/enigma2/python/RecordTimer.py"
pauli_pluginlist = "/usr/lib/enigma2/python/Screens/PluginBrowser.py"
pauli_infobar = "/usr/lib/enigma2/python/Screens/InfoBarGenerics.py"
pauli_pvrstate = "/usr/lib/enigma2/python/Screens/PVRState.py"
pauli_timerentry = "/usr/lib/enigma2/python/Screens/TimerEntry.py"
pauli_channelonboot = "/etc/enigma2/channelonboot"
pauli_720p_file = "/etc/enigma2/720p.channels"
pauli_1080i_file = "/etc/enigma2/1080i.channels"
pauli_repatch = "/usr/lib/ipkg/info/enigma2-plugin-extensions-pauli.postinst"
standbyonbootfile = "/etc/enigma2/paulistandbyonboot"
audiodelayfile = "/etc/enigma2/pauliaudiodelay"

def autostart(reason, **kwargs):
    global session
    if reason == 0 and kwargs.has_key("session"):
       session = kwargs["session"]
#      session.open(PauliStartup)
       
def main(session, **kwargs):
    session.open(Pauli)

def Plugins(**kwargs):
    return [PluginDescriptor(where = [PluginDescriptor.WHERE_SESSIONSTART, PluginDescriptor.WHERE_AUTOSTART], fnc = autostart),PluginDescriptor(name="Pauli Neutrino Keymap", description="Switch Keymap & other usefull things", where = PluginDescriptor.WHERE_PLUGINMENU, icon="pauli.png", fnc=main)]

class Pauli(Screen):
    skin = """
        <screen position="center,center" size="370,350" title="Pauli Neutrino Keymap" >
            <widget name="menu" position="10,10" size="360,340" scrollbarMode="showOnDemand" />
            <ePixmap position="225,195" size="160,160" pixmap="%s" transparent="1" alphatest="on" />	
        </screen>""" % pauli_remote
        
    def __init__(self, session, args = 0):
        self.skin = Pauli.skin
        self.session = session
        Screen.__init__(self, session)
        self.menu = args
        if os.path.exists("/usr/share/enigma2/keymap.xml.pauli.ori") == False:
           os.system("cp /usr/share/enigma2/keymap.xml /usr/share/enigma2/keymap.xml.pauli.ori")
           
        list = []
        list.append((_("Change Keymap"), "togglekeymap"))        
#        list.append((_("Change Plugin List reload"), "pluginlist"))        
#        list.append((_("Change Default Timer Action "), "timeraction"))
        list.append((_("Change Systemtime"), "changetime"))        
        list.append((_("readme.txt"), "readme"))        
        list.append((_("about"), "about"))        
        self["menu"] = MenuList(list)
        self["actions"] = ActionMap(["WizardActions", "DirectionActions"],{"ok": self.go,"back": self.close,}, -1)
        
    def go(self):
        returnValue = self["menu"].l.getCurrentSelection()[1]
        if returnValue is not None:
           if returnValue is "togglekeymap":
              self.session.open(PauliRemoteControlSetup)
           elif returnValue is "pluginlist":
              TogglePluginList(self.session)
           elif returnValue is "pvrstate":
              TogglePVRState(self.session)
           elif returnValue is "timeraction":
              ToggleTimerAction(self.session)
           elif returnValue is "changetime":
              ChangeSystemTime(self.session)
           elif returnValue is "readme":
              self.session.open(Console,_("readme.txt of Pauli Neutrino Keymap"),["cat %s" % pauli_readme])
           elif returnValue is "about":
              self.session.open(MessageBox,_("Pauli Neutrino Keymap Plugin Version %s\nby romeo-golf, powerd by gutemine and AliAbdul\n\nWolfgang Pauli was an Austrian physicist and\nNobel price winner and postulated the Neutrino particle" % pauli_pluginversion), MessageBox.TYPE_INFO)
              
class TogglePVRState(Screen):
    def __init__(self, session):

        self.session = session
        pvrfile = open(pauli_pvrstate, "r")
        text=pvrfile.read()
        pvrfile.close()
        if text.find("self.hideTimer.timeout.get().append(self.hide)") is -1:
	   text=text.replace("self[\"state\"] = Label(text=\"\")","self[\"state\"] = Label(text=\"\")\n		self.hideTimer = eTimer()\n		self.hideTimer.timeout.get().append(self.hide)\n		self.onShow.append(self.startHideTimer)\n	def startHideTimer(self):\n		self.hideTimer.start(3000, 1)")
	   text=text.replace("from Components.Label import Label","from Components.Label import Label\nfrom enigma import eTimer")
           pvrfile = open(pauli_pvrstate, "w")
           pvrfile.write(text)
           pvrfile.close()
           self.session.openWithCallback(self.DoPVRStateRestart,MessageBox,_("disabeld PVR State autohide symbols, restarting Enigma2 to activate - OK ?"), MessageBox.TYPE_YESNO)
        else:
	   text=text.replace("self[\"state\"] = Label(text=\"\")\n		self.hideTimer = eTimer()\n		self.hideTimer.timeout.get().append(self.hide)\n		self.onShow.append(self.startHideTimer)\n	def startHideTimer(self):\n		self.hideTimer.start(3000, 1)","self[\"state\"] = Label(text=\"\")")
	   text=text.replace("from Components.Label import Label\nfrom enigma import eTimer","from Components.Label import Label")
           pvrfile = open(pauli_pvrstate, "w")
           pvrfile.write(text)
           pvrfile.close()
           self.session.openWithCallback(self.DoPVRStateRestart,MessageBox,_("enabled PVR State autohide symbols, restarting Enigma2 to activate - OK ?"), MessageBox.TYPE_YESNO)

    def DoPVRStateRestart(self,answer):
        if answer is None:
            self.skipPVRStateToggle("answer is None, restart later")
        if answer is False:
            self.skipPVRStateToggle("you were not confirming, restart later")
        else:
            quitMainloop(3)
            
    def skipPVRStateToggle(self,reason):
        self.session.open(MessageBox,_("Enigma2 restart was canceled, because %s" % reason), MessageBox.TYPE_WARNING)

class TogglePluginList(Screen):
    def __init__(self, session):

        self.session = session
        pluginfile = open(pauli_pluginlist, "r")
        text=pluginfile.read()
        pluginfile.close()
        if text.find("#               plugins.readPluginList(resolveFilename(SCOPE_PLUGINS)) # Pauli") is -1:
	   text=text.replace("                plugins.readPluginList(resolveFilename(SCOPE_PLUGINS)) # Pauli","#               plugins.readPluginList(resolveFilename(SCOPE_PLUGINS)) # Pauli")
           pluginfile = open(pauli_pluginlist, "w")
           pluginfile.write(text)
           pluginfile.close()
           self.session.openWithCallback(self.DoPluginListRestart,MessageBox,_("disabeld Plugin List reload, restarting enigma2 to activate - OK ?"), MessageBox.TYPE_YESNO)
        else:
	   text=text.replace("#               plugins.readPluginList(resolveFilename(SCOPE_PLUGINS)) # Pauli","                plugins.readPluginList(resolveFilename(SCOPE_PLUGINS)) # Pauli")
           pluginfile = open(pauli_pluginlist, "w")
           pluginfile.write(text)
           pluginfile.close()
           self.session.openWithCallback(self.DoPluginListRestart,MessageBox,_("enabeld Plugin List reload, restarting enigma2 to activate - OK ?"), MessageBox.TYPE_YESNO)

    def DoPluginListRestart(self,answer):
        if answer is None:
            self.skipPluginListToggle("answer is None, restart later")
        if answer is False:
            self.skipPluginListToggle("you were not confirming, restart later")
        else:
            quitMainloop(3)
            
    def skipPluginListToggle(self,reason):
        self.session.open(MessageBox,_("Enigma2 restart was canceled, because %s" % reason), MessageBox.TYPE_WARNING)

class ToggleTimerAction(Screen):
    def __init__(self, session):
        self.session = session
        self.session.openWithCallback(self.DoTimerAction,ChoiceBox,_("select default timer action"),self.getTimerActionList())

    def getTimerActionList(self):
        timeraction = []
        timeraction.append((_("none"),"NONE"))
        timeraction.append((_("deepstandby"),"DEEPSTANDBY"))
        timeraction.append((_("standby"),"STANDBY"))
        return timeraction

    def DoTimerAction(self,answer):
        if answer is None:
           self.skipTimerActionToggle("answer is None")
        elif answer is False:
           self.skipTimerActionToggle("you were not confirming")
        else:
           actionfile = open(pauli_timerentry, "r")
           text=actionfile.read()
           actionfile.close()
           # remove old patch if still there
           if text.find("default = afterevent") is -1:
              text=text.replace("default = \"deepstandby\"","default = afterevent")
              actionfile = open(pauli_timerentry, "w")
              actionfile.write(text)
           actionfile = open(pauli_recordinfo, "r")
           text=actionfile.read()
           actionfile.close()
	   text=text.replace("AFTEREVENT.NONE, checkOldTimers","AFTEREVENT.%s, checkOldTimers" % answer[1])
	   text=text.replace("AFTEREVENT.DEEPSTANDBY, checkOldTimers","AFTEREVENT.%s, checkOldTimers" % answer[1])
	   text=text.replace("AFTEREVENT.STANDBY, checkOldTimers","AFTEREVENT.%s, checkOldTimers" % answer[1])
           actionfile = open(pauli_recordinfo, "w")
           actionfile.write(text)
           actionfile.close()
           self.session.openWithCallback(self.DoTimerActionRestart,MessageBox,_("new Default Timer Action %s needs restarting enigma2 to activate - OK ?" % answer[0]), MessageBox.TYPE_YESNO)

    def DoTimerActionRestart(self,answer):
        if answer is None:
            self.skipTimerActionToggle("answer is None, no restart needed")
        if answer is False:
            self.skipTimerActionToggle("you were not confirming, restart later")
        else:
            quitMainloop(3)
            
    def skipTimerActionToggle(self,reason):
        self.session.open(MessageBox,_("Change Default Timer Action was canceled, because %s" % reason), MessageBox.TYPE_WARNING)
        
        
class ChangeSystemTime(Screen):
    def __init__(self, session):

        self.session = session

        jetzt = time.time()
        timezone = datetime.datetime.utcnow()
        delta = (jetzt - time.mktime(timezone.timetuple())) 
        print "delta: %i" % delta
        print "oldtime: %i" % jetzt
        # always add 1 min so that there is time for typing
        self.oldtime = strftime("%Y:%m:%d %H:%M",localtime())
        self.session.openWithCallback(self.askForNewTime,InputBox, title=_("Enter new Systemtime"), text="%s" % (self.oldtime), maxSize=16, type=Input.NUMBER)

    def askForNewTime(self,newclock):
        try:
           length=len(newclock)
        except:
           length=0
        if newclock is None:
            self.skipChangeTime("no new time")
        elif (length == 16) is False:
           self.skipChangeTime("new time string too short")
        elif (newclock.count(" ") < 1) is True:
            self.skipChangeTime("invalid format")
        elif (newclock.count(":") < 3) is True:
            self.skipChangeTime("invalid format")
        else:
            full=[]
            full=newclock.split(" ",1)
            newdate=full[0]
            newtime=full[1]
            print "newdate %s newtime %s" % (newdate, newtime)
            parts=[]
            parts=newdate.split(":",2)
            newyear=parts[0]
            newmonth=parts[1]
            newday=parts[2]
            parts=newtime.split(":",1)
            newhour=parts[0]
            newmin=parts[1]
            #
            # da some checks to make sure that date & time are OK !
            #
            maxmonth = 31
            if (int(newmonth) == 4) or (int(newmonth) == 6) or (int(newmonth) == 9) or (int(newmonth) == 11) is True:
               maxmonth=30
            elif (int(newmonth) == 2) is True:
               if ((4*int(int(newyear)/4)) == int(newyear)) is True:
                  maxmonth=28
               else:
                  maxmonth=27
            if (int(newyear) < 2007) or (int(newyear) > 2027)  or (len(newyear) < 4) is True:
               self.skipChangeTime("invalid year %s" %newyear)
            elif (int(newmonth) < 0) or (int(newmonth) >12) or (len(newmonth) < 2) is True:
               self.skipChangeTime("invalid month %s" %newmonth)
            elif (int(newday) < 1) or (int(newday) > maxmonth) or (len(newday) < 2) is True:              self.skipChangeTime("invalid day %s" %newday)
            elif (int(newhour) < 0) or (int(newhour) > 23) or (len(newhour) < 2) is True:
               self.skipChangeTime("invalid hour %s" %newhour)
            elif (int(newmin) < 0) or (int(newmin) > 59) or (len(newmin) < 2) is True:
               self.skipChangeTime("invalid minute %s" %newmin)
            else:
#              self.newtime = mktime(strptime(newtime,"%Y:%m:%d %H:%M"))
               self.newtime = "%s%s%s%s%s" %(newmonth,newday,newhour,newmin,newyear)
               print "date %s" % self.newtime
               self.session.openWithCallback(self.DoChangeTimeRestart,MessageBox,_("Enigma2 needs to be restarted to activate new system time - OK ?"), MessageBox.TYPE_YESNO)

    def DoChangeTimeRestart(self,answer):
        if answer is None:
            self.skipChangeTime("answer is None")
        if answer is False:
            self.skipChangeTime("you were not confirming")
        else:
            os.system("date %s" % (self.newtime))
            quitMainloop(3)

    def skipChangeTime(self,reason):
        self.session.open(MessageBox,_("System Time was NOT changed, because %s" % reason), MessageBox.TYPE_WARNING)


class PauliStartup(Screen):
    skin = """
        <screen position="center,center" size="400,300" title="Pauli Startup" >
        </screen>"""
    def __init__(self,session):
        self.skin = PauliStartup.skin
	self.session = session
	Screen.__init__(self,session)
        print "[PAULI] currently no autostart"

##
## PauliRemoteControlSetup
##
## By AliAbdul 
##
## He was so friendly to allow this code piece from LT Image to be used by Pauli
##
## Thank You !!!
##

class PauliRemoteControlSetup(Screen):
	skin = """
		<screen position="center,center" size="644,496" title="Remote Control Setup" >
		<widget name="config" position="10,5" size="628,320" scrollbarMode="showOnDemand" />
		<ePixmap position="10,275" size="36,20" pixmap="/usr/share/enigma2/skin_default/buttons/blue.png" transparent="1" alphatest="on" />
		<ePixmap position="10,300" size="36,20" pixmap="/usr/share/enigma2/skin_default/buttons/green.png" transparent="1" alphatest="on" />
		<ePixmap position="260,300" size="36,20" pixmap="/usr/share/enigma2/skin_default/buttons/yellow.png" transparent="1" alphatest="on" />
		<ePixmap position="10,325" size="36,20" pixmap="/usr/share/enigma2/skin_default/buttons/key_0.png" transparent="1" alphatest="on" />
		<ePixmap position="10,350" size="36,20" pixmap="/usr/share/enigma2/skin_default/buttons/key_1.png" transparent="1" alphatest="on" />
		<ePixmap position="10,375" size="36,20" pixmap="/usr/share/enigma2/skin_default/buttons/key_2.png" transparent="1" alphatest="on" />
		<ePixmap position="10,400" size="36,20" pixmap="/usr/share/enigma2/skin_default/buttons/key_3.png" transparent="1" alphatest="on" />
		<ePixmap position="10,425" size="36,20" pixmap="/usr/share/enigma2/skin_default/buttons/key_4.png" transparent="1" alphatest="on" />
		<ePixmap position="10,460" size="36,20" pixmap="/usr/share/enigma2/skin_default/buttons/key_5.png" transparent="1" alphatest="on" />
		<eLabel text="Activate above User-defined keymap" position="50,278" size="460,25" font="Regular;19" transparent="1" />
		<eLabel text="Enigma2 (default)" position="50,302" size="200,25" font="Regular;19" transparent="1" />
		<eLabel text="Neutrino (classic)" position="300,302" size="200,25" font="Regular;19" transparent="1" />
		<eLabel text="Restore original keymap" position="50,327" size="460,25" font="Regular;19" transparent="1" />
		<eLabel text="Short Power for Deepstandby or Standby" position="50,352" size="460,25" font="Regular;19" transparent="1" />
		<eLabel text="Left Right activity in Listbox" position="50,377" size="460,25" font="Regular;19" transparent="1" />
		<eLabel text="OK zap activity in EPG" position="50,402" size="460,25" font="Regular;19" transparent="1" />
		<eLabel text="Long/Short Info" position="50,427" size="430,25" font="Regular;19" transparent="1" />
		<eLabel text="PluginExtensions(PIP) on shortRED and longBLUE" position="50,451" size="460,25" font="Regular;19" transparent="1" />
		<eLabel text="! ! ! ATTENTION - RED can be recording ! ! !" position="50,473" size="460,25" font="Regular;19" transparent="1" />		
		<ePixmap position="510,336" size="160,160" pixmap="%s" transparent="1" alphatest="on" />	
	</screen>""" % pauli_remote

	def __init__(self, session, args = 0):
		self.skin = PauliRemoteControlSetup.skin
		self.session = session
		Screen.__init__(self, session)
		functionKeyLeft = "DoNothing"
		functionKeyRight = "DoNothing"
		functionKeyUp = "DoNothing"
		functionKeyDown = "DoNothing"
		functionKeyOK = "DoNothing"
		functionKeyPrevious = "DoNothing"
		functionKeyNext = "DoNothing"
		functionKeyChannelUp = "DoNothing"
		functionKeyChannelDown = "DoNothing"
		functionKeyButton0 = "DoNothing"
		functionKeyButton1 = "DoNothing"
		buttonList = ["zapUp", "zapDown", "pageUp", "pageDown", "switchChannelUp", "switchChannelDown", "openServiceList", "historyBack", "historyNext"]
		try:
			endRead = False
			endRead2 = False
			xmlFile = open(pauli_keymap, 'r')
			while endRead == False:
				line = xmlFile.readline()
				if line.__contains__('<'):
					position = line.index('<')
					line = line[position:999]
					if line.startswith('<map context="InfobarChannelSelection">'):
						while endRead2 == False:
							line = xmlFile.readline()
							position = line.index('<')
							line = line[position:999]
							if line.startswith('</map>'):
								endRead = True
								endRead2 = True
							elif line.startswith('<key id="'):
								completeLine = line
								position = line.index('mapto')
								line = line[position+7:999]
								position = line.index('"')
								line = line[0:position]
								if buttonList.__contains__(line):
									if completeLine.startswith('<key id="KEY_LEFT"'):
										functionKeyLeft = line
									elif completeLine.startswith('<key id="KEY_RIGHT"'):
										functionKeyRight = line
									elif completeLine.startswith('<key id="KEY_UP"'):
										functionKeyUp = line
									elif completeLine.startswith('<key id="KEY_DOWN"'):
										functionKeyDown = line
									elif completeLine.startswith('<key id="KEY_OK"'):
										functionKeyOK = line
									elif completeLine.startswith('<key id="KEY_PREVIOUS"'):
										functionKeyPrevious = line
									elif completeLine.startswith('<key id="KEY_NEXT"'):
										functionKeyNext = line
									elif completeLine.startswith('<key id="KEY_CHANNELUP"'):
										functionKeyChannelUp = line
									elif completeLine.startswith('<key id="KEY_CHANNELDOWN"'):
										functionKeyChannelDown = line
									elif completeLine.startswith('<key id="BTN_0"'):
										functionKeyButton0 = line
									elif completeLine.startswith('<key id="BTN_1"'):
										functionKeyButton1 = line
							else:
								DoNothing = True
			xmlFile.close()
		except:
			print "[PAULI] Could not read the file /usr/share/enigma2/keymap.xml"
		list = []
		self["config"] = ConfigList(list)
		self.buttons = ConfigSubsection()
		self.buttons.keyLeft = ConfigSelection(choices = [("zapUp", _("zapUp")), ("zapDown", _("zapDown")), ("pageUp", _("pageUp")), ("pageDown", _("pageDown")), ("switchChannelUp", _("switchChannelUp")), ("switchChannelDown", _("switchChannelDown")), ("openServiceList", _("openServiceList")), ("historyBack", _("historyBack")), ("historyNext", _("historyNext")), ("DoNothing", _("DoNothing"))], default = (functionKeyLeft))
		self.buttons.keyRight = ConfigSelection(choices = [("zapUp", _("zapUp")), ("zapDown", _("zapDown")), ("pageUp", _("pageUp")), ("pageDown", _("pageDown")), ("switchChannelUp", _("switchChannelUp")), ("switchChannelDown", _("switchChannelDown")), ("openServiceList", _("openServiceList")), ("historyBack", _("historyBack")), ("historyNext", _("historyNext")), ("DoNothing", _("DoNothing"))], default = (functionKeyRight))
		self.buttons.keyUp = ConfigSelection(choices = [("zapUp", _("zapUp")), ("zapDown", _("zapDown")), ("pageUp", _("pageUp")), ("pageDown", _("pageDown")), ("switchChannelUp", _("switchChannelUp")), ("switchChannelDown", _("switchChannelDown")), ("openServiceList", _("openServiceList")), ("historyBack", _("historyBack")), ("historyNext", _("historyNext")), ("DoNothing", _("DoNothing"))], default = (functionKeyUp))
		self.buttons.keyDown = ConfigSelection(choices = [("zapUp", _("zapUp")), ("zapDown", _("zapDown")), ("pageUp", _("pageUp")), ("pageDown", _("pageDown")), ("switchChannelUp", _("switchChannelUp")), ("switchChannelDown", _("switchChannelDown")), ("openServiceList", _("openServiceList")), ("historyBack", _("historyBack")), ("historyNext", _("historyNext")), ("DoNothing", _("DoNothing"))], default = (functionKeyDown))
		self.buttons.keyOK = ConfigSelection(choices = [("zapUp", _("zapUp")), ("zapDown", _("zapDown")), ("pageUp", _("pageUp")), ("pageDown", _("pageDown")), ("switchChannelUp", _("switchChannelUp")), ("switchChannelDown", _("switchChannelDown")), ("openServiceList", _("openServiceList")), ("historyBack", _("historyBack")), ("historyNext", _("historyNext")), ("DoNothing", _("DoNothing"))], default = (functionKeyOK))
		self.buttons.keyPrevious = ConfigSelection(choices = [("zapUp", _("zapUp")), ("zapDown", _("zapDown")), ("pageUp", _("pageUp")), ("pageDown", _("pageDown")), ("switchChannelUp", _("switchChannelUp")), ("switchChannelDown", _("switchChannelDown")), ("openServiceList", _("openServiceList")), ("historyBack", _("historyBack")), ("historyNext", _("historyNext")), ("DoNothing", _("DoNothing"))], default = (functionKeyPrevious))
		self.buttons.keyNext = ConfigSelection(choices = [("zapUp", _("zapUp")), ("zapDown", _("zapDown")), ("pageUp", _("pageUp")), ("pageDown", _("pageDown")), ("switchChannelUp", _("switchChannelUp")), ("switchChannelDown", _("switchChannelDown")), ("openServiceList", _("openServiceList")), ("historyBack", _("historyBack")), ("historyNext", _("historyNext")), ("DoNothing", _("DoNothing"))], default = (functionKeyNext))
		self.buttons.keyChannelUp = ConfigSelection(choices = [("zapUp", _("zapUp")), ("zapDown", _("zapDown")), ("pageUp", _("pageUp")), ("pageDown", _("pageDown")), ("switchChannelUp", _("switchChannelUp")), ("switchChannelDown", _("switchChannelDown")), ("openServiceList", _("openServiceList")), ("historyBack", _("historyBack")), ("historyNext", _("historyNext")), ("DoNothing", _("DoNothing"))], default = (functionKeyChannelUp))
		self.buttons.keyChannelDown = ConfigSelection(choices = [("zapUp", _("zapUp")), ("zapDown", _("zapDown")), ("pageUp", _("pageUp")), ("pageDown", _("pageDown")), ("switchChannelUp", _("switchChannelUp")), ("switchChannelDown", _("switchChannelDown")), ("openServiceList", _("openServiceList")), ("historyBack", _("historyBack")), ("historyNext", _("historyNext")), ("DoNothing", _("DoNothing"))], default = (functionKeyChannelDown))
		self.buttons.keyButton0 = ConfigSelection(choices = [("zapUp", _("zapUp")), ("zapDown", _("zapDown")), ("pageUp", _("pageUp")), ("pageDown", _("pageDown")), ("switchChannelUp", _("switchChannelUp")), ("switchChannelDown", _("switchChannelDown")), ("openServiceList", _("openServiceList")), ("historyBack", _("historyBack")), ("historyNext", _("historyNext")), ("DoNothing", _("DoNothing"))], default = (functionKeyButton0))
		self.buttons.keyButton1 = ConfigSelection(choices = [("zapUp", _("zapUp")), ("zapDown", _("zapDown")), ("pageUp", _("pageUp")), ("pageDown", _("pageDown")), ("switchChannelUp", _("switchChannelUp")), ("switchChannelDown", _("switchChannelDown")), ("openServiceList", _("openServiceList")), ("historyBack", _("historyBack")), ("historyNext", _("historyNext")), ("DoNothing", _("DoNothing"))], default = (functionKeyButton1))
		list.append(getConfigListEntry(_("KEY_LEFT"), self.buttons.keyLeft))
		list.append(getConfigListEntry(_("KEY_RIGHT"), self.buttons.keyRight))
		list.append(getConfigListEntry(_("KEY_UP"), self.buttons.keyUp))
		list.append(getConfigListEntry(_("KEY_DOWN"), self.buttons.keyDown))
		list.append(getConfigListEntry(_("KEY_OK"), self.buttons.keyOK))
		list.append(getConfigListEntry(_("KEY_PREVIOUS"), self.buttons.keyPrevious))
		list.append(getConfigListEntry(_("KEY_NEXT"), self.buttons.keyNext))
		list.append(getConfigListEntry(_("KEY_CHANNELUP"), self.buttons.keyChannelUp))
		list.append(getConfigListEntry(_("KEY_CHANNELDOWN"), self.buttons.keyChannelDown))
		list.append(getConfigListEntry(_("BTN_0"), self.buttons.keyButton0))
		list.append(getConfigListEntry(_("BTN_1"), self.buttons.keyButton1))
 		self["shortcuts"] = ActionMap(["ShortcutActions"],
		{
			"green": self.setEnigma,
			"yellow": self.setNeutrino,
			"blue": self.setUser
		})
		self["actions"] = NumberActionMap(["SetupActions"],
		{
			"0": self.setOriginal,
			"1": self.setDeepstandby,
			"2": self.setLeftRight,
			"3": self.setOKzap,
			"4": self.setInfoLongShort,
			"5": self.setREDtolBLUE,
			"cancel": self.close,
			"left": self.keyLeft,
			"right": self.keyRight
		}, -1)


 	def keyLeft(self):
		self["config"].handleKey(KEY_LEFT)

	def keyRight(self):
		self["config"].handleKey(KEY_RIGHT)

	def setOriginal(self,number):
                if os.path.exists("/usr/share/enigma2/keymap.xml.pauli.ori") == True:
                   os.system("cp /usr/share/enigma2/keymap.xml.pauli.ori /usr/share/enigma2/keymap.xml")
                   keymapparser.removeKeymap(pauli_keymap)
                   keymapparser.readKeymap(pauli_keymap)
                   self.session.open(MessageBox,_("Pauli restored original Keymap"), MessageBox.TYPE_INFO)
                else:
                   self.session.open(MessageBox,_("Pauli could not find original Keymap"), MessageBox.TYPE_ERROR)
                   
	def setOKzap(self,number):
                keymapfile = open(pauli_keymap, "r")
                text=keymapfile.read()
                keymapfile.close()
	        if text.find("<key id=\"KEY_OK\" mapto=\"red\" flags=\"m\" />") is -1:
	           text=text.replace("<key id=\"KEY_MENU\" mapto=\"input_date_time\" flags=\"m\" />","<key id=\"KEY_MENU\" mapto=\"input_date_time\" flags=\"m\" />\n		<key id=\"KEY_OK\" mapto=\"red\" flags=\"m\" />")
                   keymapfile = open(pauli_keymap, "w")
                   keymapfile.write(text)
                   keymapfile.close()
                   keymapparser.removeKeymap(pauli_keymap)
                   keymapparser.readKeymap(pauli_keymap)
                   self.session.open(MessageBox,_("Pauli enabled zapping with OK in EPG"), MessageBox.TYPE_INFO)
                else:
	           text=text.replace("<key id=\"KEY_MENU\" mapto=\"input_date_time\" flags=\"m\" />\n		<key id=\"KEY_OK\" mapto=\"red\" flags=\"m\" />","<key id=\"KEY_MENU\" mapto=\"input_date_time\" flags=\"m\" />")
                   keymapfile = open(pauli_keymap, "w")
                   keymapfile.write(text)
                   keymapfile.close()
                   keymapparser.removeKeymap(pauli_keymap)
                   keymapparser.readKeymap(pauli_keymap)
                   self.session.open(MessageBox,_("Pauli disabled zapping with OK in EPG"), MessageBox.TYPE_INFO)

	def setInfoLongShort(self,number):
                keymapfile = open(pauli_keymap, "r")
                text=keymapfile.read()
                keymapfile.close()
	        if text.find("<key id=\"KEY_INFO\" mapto=\"showEventInfo\" flags=\"l\" />") is -1 and text.find("<key id=\"KEY_INFO\" mapto=\"showEventView\" flags=\"l\" />") is -1:
	           text=text.replace("<key id=\"KEY_INFO\" mapto=\"showEventView\" flags=\"b\" />","<key id=\"KEY_INFO\" mapto=\"showEventView\" flags=\"l\" />")
	           text=text.replace("<key id=\"KEY_INFO\" mapto=\"showEventInfo\" flags=\"b\" />","<key id=\"KEY_INFO\" mapto=\"showEventInfo\" flags=\"l\" />")
	           text=text.replace("<key id=\"KEY_INFO\" mapto=\"showEventInfoPlugin\" flags=\"l\" />","<key id=\"KEY_INFO\" mapto=\"showEventInfoPlugin\" flags=\"b\" />")
	           text=text.replace("<key id=\"KEY_INFO\" mapto=\"showSingleServiceEPG\" flags=\"l\" />","<key id=\"KEY_INFO\" mapto=\"showSingleServiceEPG\" flags=\"b\" />")
                   keymapfile = open(pauli_keymap, "w")
                   keymapfile.write(text)
                   keymapfile.close()
                   keymapparser.removeKeymap(pauli_keymap)
                   keymapparser.readKeymap(pauli_keymap)
                   self.session.open(MessageBox,_("Pauli enabled Simple EPG on short Info"), MessageBox.TYPE_INFO)
                else:
	           text=text.replace("<key id=\"KEY_INFO\" mapto=\"showEventView\" flags=\"l\" />","<key id=\"KEY_INFO\" mapto=\"showEventView\" flags=\"b\" />")
	           text=text.replace("<key id=\"KEY_INFO\" mapto=\"showEventInfo\" flags=\"l\" />","<key id=\"KEY_INFO\" mapto=\"showEventInfo\" flags=\"b\" />")
	           text=text.replace("<key id=\"KEY_INFO\" mapto=\"showEventInfoPlugin\" flags=\"b\" />","<key id=\"KEY_INFO\" mapto=\"showEventInfoPlugin\" flags=\"l\" />")
	           text=text.replace("<key id=\"KEY_INFO\" mapto=\"showSingleServiceEPG\" flags=\"b\" />","<key id=\"KEY_INFO\" mapto=\"showSingleServiceEPG\" flags=\"l\" />")
                   keymapfile = open(pauli_keymap, "w")
                   keymapfile.write(text)
                   keymapfile.close()
                   keymapparser.removeKeymap(pauli_keymap)
                   keymapparser.readKeymap(pauli_keymap)
                   self.session.open(MessageBox,_("Pauli enabled Simple EPG on long Info"), MessageBox.TYPE_INFO)

	def setLeftRight(self,number):
                # toggle Left/Right enable in ListboxActions to make romeo-golf happy
                keymapfile = open(pauli_keymap, "r")
                text=keymapfile.read()
                keymapfile.close()
	        if text.find("<!-- key id=\"KEY_REWIND\" mapto=\"prevBouquet\" flags=\"mr\" />") is -1:			   
	           text=text.replace("<key id=\"KEY_REWIND\" mapto=\"prevBouquet\" flags=\"m\" />","<key id=\"KEY_LEFT\" mapto=\"prevBouquet\" flags=\"m\" />")
	           text=text.replace("<key id=\"KEY_FASTFORWARD\" mapto=\"nextBouquet\" flags=\"m\" />","<key id=\"KEY_RIGHT\" mapto=\"nextBouquet\" flags=\"m\" />")
	        if text.find("<!-- key id=\"KEY_LEFT\" mapto=\"pageUp\" flags=\"mr\" />") is -1:			   
	           text=text.replace("<key id=\"KEY_LEFT\" mapto=\"pageUp\" flags=\"mr\" />","<!-- key id=\"KEY_LEFT\" mapto=\"pageUp\" flags=\"mr\" />")
	           text=text.replace("<key id=\"KEY_RIGHT\" mapto=\"pageDown\" flags=\"mr\" />","<key id=\"KEY_RIGHT\" mapto=\"pageDown\" flags=\"mr\" /-->")			   
			   
                   keymapfile = open(pauli_keymap, "w")
                   keymapfile.write(text)
                   keymapfile.close()
                   keymapparser.removeKeymap(pauli_keymap)
                   keymapparser.readKeymap(pauli_keymap)
                   self.session.open(MessageBox,_("LEFT/RIGHT = switch Bouquets"), MessageBox.TYPE_INFO)
                else:
	           text=text.replace("<!-- key id=\"KEY_LEFT\" mapto=\"pageUp\" flags=\"mr\" />","<key id=\"KEY_LEFT\" mapto=\"pageUp\" flags=\"mr\" />")
	           text=text.replace("<key id=\"KEY_RIGHT\" mapto=\"pageDown\" flags=\"mr\" /-->","<key id=\"KEY_RIGHT\" mapto=\"pageDown\" flags=\"mr\" />")
	           text=text.replace("<key id=\"KEY_LEFT\" mapto=\"prevBouquet\" flags=\"m\" />","<key id=\"KEY_REWIND\" mapto=\"prevBouquet\" flags=\"m\" />")
	           text=text.replace("<key id=\"KEY_RIGHT\" mapto=\"nextBouquet\" flags=\"m\" />","<key id=\"KEY_FASTFORWARD\" mapto=\"nextBouquet\" flags=\"m\" />")
			   
                   keymapfile = open(pauli_keymap, "w")
                   keymapfile.write(text)
                   keymapfile.close()
                   keymapparser.removeKeymap(pauli_keymap)
                   keymapparser.readKeymap(pauli_keymap)
                   self.session.open(MessageBox,_("LEFT/RIGHT = Page Up/Down"), MessageBox.TYPE_INFO)

	def setREDtolBLUE(self,number):
                keymapfile = open(pauli_keymap, "r")
                text=keymapfile.read()
                keymapfile.close()
	        if text.find("<key id=\"KEY_RED\" mapto=\"startBP_ext\" flags=\"m\" />") is -1:
	           text=text.replace("<key id=\"KEY_BLUE\" mapto=\"startBP_ext\" flags=\"l\" />","<key id=\"KEY_BLUE\" mapto=\"startBP_ext\" flags=\"l\" />\n		<key id=\"KEY_RED\" mapto=\"startBP_ext\" flags=\"m\" />")
                   keymapfile = open(pauli_keymap, "w")
                   keymapfile.write(text)
                   keymapfile.close()
                   keymapparser.removeKeymap(pauli_keymap)
                   keymapparser.readKeymap(pauli_keymap)
                   self.session.open(MessageBox,_("BP extensions (PiP) on long BLUE and short RED"), MessageBox.TYPE_INFO)
                else:
	           text=text.replace("<key id=\"KEY_BLUE\" mapto=\"startBP_ext\" flags=\"l\" />\n		<key id=\"KEY_RED\" mapto=\"startBP_ext\" flags=\"m\" />","<key id=\"KEY_BLUE\" mapto=\"startBP_ext\" flags=\"l\" />")
                   keymapfile = open(pauli_keymap, "w")
                   keymapfile.write(text)
                   keymapfile.close()
                   keymapparser.removeKeymap(pauli_keymap)
                   keymapparser.readKeymap(pauli_keymap)
                   self.session.open(MessageBox,_("BP extensions (PiP) only on long BLUE (original)"), MessageBox.TYPE_INFO)

	def setNeutrino(self):
	        # do the stuff AliAbdul ignores
                keymapfile = open(pauli_keymap, "r")
                text=keymapfile.read()
                keymapfile.close()
                # for ListboxActions
 	        if text.find("<key id=\"KEY_CHANNELUP\" mapto=\"pageUp\" flags=\"mr\" />") is -1:
	           text=text.replace("<key id=\"KEY_PAGEDOWN\" mapto=\"pageDown\" flags=\"mr\" />","<key id=\"KEY_PAGEDOWN\" mapto=\"pageDown\" flags=\"mr\" />\n		<key id=\"KEY_CHANNELUP\" mapto=\"pageUp\" flags=\"mr\" />\n		<key id=\"KEY_CHANNELDOWN\" mapto=\"pageDown\" flags=\"mr\" />")
 	        if text.find("<key id=\"KEY_PREVIOUS\" mapto=\"pageUp\" flags=\"mr\" />") is -1:
	           text=text.replace("<key id=\"KEY_PAGEDOWN\" mapto=\"pageDown\" flags=\"mr\" />","<key id=\"KEY_PAGEDOWN\" mapto=\"pageDown\" flags=\"mr\" />\n		<key id=\"KEY_PREVIOUS\" mapto=\"pageUp\" flags=\"mr\" />\n		<key id=\"KEY_NEXT\" mapto=\"pageDown\" flags=\"mr\" />")
	        if text.find("<!-- key id=\"KEY_LEFT\" mapto=\"pageUp\" flags=\"mr\" />") is -1:
	           text=text.replace("<key id=\"KEY_LEFT\" mapto=\"pageUp\" flags=\"mr\" />","<!-- key id=\"KEY_LEFT\" mapto=\"pageUp\" flags=\"mr\" />")
	           text=text.replace("<key id=\"KEY_RIGHT\" mapto=\"pageDown\" flags=\"mr\" />","<key id=\"KEY_RIGHT\" mapto=\"pageDown\" flags=\"mr\" /-->")
                # for InfobarShowHideActions
 	        if text.find("<key id=\"KEY_EXIT\" mapto=\"toggleShow\" flags=\"m\" />") is -1:
                   text=text.replace("<key id=\"KEY_EXIT\" mapto=\"hide\" flags=\"m\" />","<key id=\"KEY_EXIT\" mapto=\"toggleShow\" flags=\"m\" />")
                # for InfobarSubserviceSelectionActions
 	        if text.find("<key id=\"KEY_LEFT\" mapto=\"subserviceSelection\" flags=\"mr\" />") is -1:
	           text=text.replace("<key id=\"KEY_GREEN\" mapto=\"subserviceSelection\" flags=\"m\" />","<key id=\"KEY_GREEN\" mapto=\"subserviceSelection\" flags=\"m\" />\n		<key id=\"KEY_LEFT\" mapto=\"subserviceSelection\" flags=\"mr\" />\n		<key id=\"KEY_RIGHT\" mapto=\"subserviceSelection\" flags=\"mr\" />")
	           # for Green Quickbutton in GP
	           text=text.replace("<key id=\"KEY_GREEN\" mapto=\"subserviceSelection\" flags=\"b\" />","<key id=\"KEY_GREEN\" mapto=\"subserviceSelection\" flags=\"b\" />\n		<key id=\"KEY_LEFT\" mapto=\"subserviceSelection\" flags=\"mr\" />\n		<key id=\"KEY_RIGHT\" mapto=\"subserviceSelection\" flags=\"mr\" />")
	        # for InfobarSubserviceQuickzapActions
 	        if text.find("<key id=\"KEY_LEFT\" mapto=\"prevSubservice\" flags=\"m\" />") is -1:
                   text=text.replace("<key id=\"KEY_BACK\" mapto=\"prevSubservice\" flags=\"m\" />","<key id=\"KEY_LEFT\" mapto=\"prevSubservice\" flags=\"m\" />")
                   text=text.replace("<key id=\"KEY_FORWARD\" mapto=\"nextSubservice\" flags=\"m\" />","<key id=\"KEY_RIGHT\" mapto=\"nextSubservice\" flags=\"m\" />")
	        # for ChannelSelectBaseActions
 	        if text.find("<key id=\"KEY_RIGHT\" mapto=\"nextBouquet\" flags=\"m\" />") is -1:
                   text=text.replace("<key id=\"KEY_CHANNELDOWN\" mapto=\"prevBouquet\" flags=\"m\" />","<key id=\"KEY_LEFT\" mapto=\"prevBouquet\" flags=\"m\" />")
                   text=text.replace("<key id=\"KEY_CHANNELUP\" mapto=\"nextBouquet\" flags=\"m\" />","<key id=\"KEY_RIGHT\" mapto=\"nextBouquet\" flags=\"m\" />")
                   # fix MediaPlayerActions
                   text=text.replace("<key id=\"KEY_8\" mapto=\"skipListend\" flags=\"m\" />\n		<key id=\"KEY_RIGHT\" mapto=\"nextBouquet\" flags=\"m\" />\n		<key id=\"KEY_LEFT\" mapto=\"prevBouquet\" flags=\"m\" />","<key id=\"KEY_8\" mapto=\"skipListend\" flags=\"m\" />\n		<key id=\"KEY_CHANNELUP\" mapto=\"nextBouquet\" flags=\"m\" />\n		<key id=\"KEY_CHANNELDOWN\" mapto=\"prevBouquet\" flags=\"m\" />")
		# for latest iCVS
		restart=False
                ibgfile = open(pauli_infobar, "r")
       	        text2=ibgfile.read()
      	 	ibgfile.close()
 	        if text2.find("\"openServiceList\": ") is -1:
		   	restart=True
                   	text2=text2.replace("\"historyNext\": (self.historyNext, _(\"next channel in history\")),","\"historyNext\": (self.historyNext, _(\"next channel in history\")),\n				\"openServiceList\": (self.openServiceList, _(\"open servicelist\")),")
	                ibgfile = open(pauli_infobar, "w")
        	        ibgfile.write(text2)
               	 	ibgfile.close()

                keymapfile = open(pauli_keymap, "w")
                keymapfile.write(text)
                keymapfile.close()
		list = ["DoNothing", "DoNothing", "zapDown", "zapUp", "openServiceList", "historyBack", "historyNext", "openServiceList", "openServiceList", "zapUp", "zapDown"]
		self.writeConfigs(list)
		if restart:
			self.session.openWithCallback(self.DoEnigma2Restart,MessageBox,_("Pauli changed Keymap to Neutrino\nrestarting Enigma2 to activate - OK ?"), MessageBox.TYPE_YESNO)
		else:
			self.session.openWithCallback(self.close,MessageBox,_("Pauli changed Keymap to Neutrino"), MessageBox.TYPE_INFO)

	def DoEnigma2Restart(self,answer):
	        if answer is None:
        		self.skipEnigma2Restart("answer is None, restart later")
       	 	if answer is False:
            		self.skipEnigma2Restart("you were not confirming, restart later")
        	else:
            		quitMainloop(3)
            
	def skipEnigma2Restart(self,reason):
        	self.session.open(MessageBox,_("Enigma2 restart was canceled, because %s" % reason), MessageBox.TYPE_WARNING)


	def setEnigma(self):
                keymapfile = open(pauli_keymap, "r")
                text=keymapfile.read()
                keymapfile.close()
                #for ListboxActions
	        text=text.replace("<key id=\"KEY_PAGEDOWN\" mapto=\"pageDown\" flags=\"mr\" />\n		<key id=\"KEY_PREVIOUS\" mapto=\"pageUp\" flags=\"mr\" />\n		<key id=\"KEY_NEXT\" mapto=\"pageDown\" flags=\"mr\" />","<key id=\"KEY_PAGEDOWN\" mapto=\"pageDown\" flags=\"mr\" />")
	        text=text.replace("<key id=\"KEY_PAGEDOWN\" mapto=\"pageDown\" flags=\"mr\" />\n		<key id=\"KEY_CHANNELUP\" mapto=\"pageUp\" flags=\"mr\" />\n		<key id=\"KEY_CHANNELDOWN\" mapto=\"pageDown\" flags=\"mr\" />","<key id=\"KEY_PAGEDOWN\" mapto=\"pageDown\" flags=\"mr\" />")
	        text=text.replace("<!-- key id=\"KEY_LEFT\" mapto=\"pageUp\" flags=\"mr\" />","<key id=\"KEY_LEFT\" mapto=\"pageUp\" flags=\"mr\" />")
	        text=text.replace("<key id=\"KEY_RIGHT\" mapto=\"pageDown\" flags=\"mr\" /-->","<key id=\"KEY_RIGHT\" mapto=\"pageDown\" flags=\"mr\" />")
                # for InfobarShowHideActions
	        text=text.replace("<key id=\"KEY_EXIT\" mapto=\"toggleShow\" flags=\"m\" />","<key id=\"KEY_EXIT\" mapto=\"hide\" flags=\"m\" />")
                # for InfobarSubserviceSelectionActions
	        text=text.replace("<key id=\"KEY_GREEN\" mapto=\"subserviceSelection\" flags=\"m\" />\n		<key id=\"KEY_LEFT\" mapto=\"subserviceSelection\" flags=\"mr\" />\n		<key id=\"KEY_RIGHT\" mapto=\"subserviceSelection\" flags=\"mr\" />","<key id=\"KEY_GREEN\" mapto=\"subserviceSelection\" flags=\"m\" />")
                # for Green Quickbutton in GP
	        text=text.replace("<key id=\"KEY_GREEN\" mapto=\"subserviceSelection\" flags=\"b\" />\n		<key id=\"KEY_LEFT\" mapto=\"subserviceSelection\" flags=\"mr\" />\n		<key id=\"KEY_RIGHT\" mapto=\"subserviceSelection\" flags=\"mr\" />","<key id=\"KEY_GREEN\" mapto=\"subserviceSelection\" flags=\"b\" />")
	        # for InfobarSubserviceQuickzapActions
                text=text.replace("<key id=\"KEY_LEFT\" mapto=\"prevSubservice\" flags=\"m\" />","<key id=\"KEY_BACK\" mapto=\"prevSubservice\" flags=\"m\" />")
                text=text.replace("<key id=\"KEY_RIGHT\" mapto=\"nextSubservice\" flags=\"m\" />","<key id=\"KEY_FORWARD\" mapto=\"nextSubservice\" flags=\"m\" />")
	        # for ChannelSelectBaseActions
                text=text.replace("<key id=\"KEY_LEFT\" mapto=\"prevBouquet\" flags=\"m\" />","<key id=\"KEY_CHANNELDOWN\" mapto=\"prevBouquet\" flags=\"m\" />")
                text=text.replace("<key id=\"KEY_RIGHT\" mapto=\"nextBouquet\" flags=\"m\" />","<key id=\"KEY_CHANNELUP\" mapto=\"nextBouquet\" flags=\"m\" />")

                keymapfile = open(pauli_keymap, "w")
                keymapfile.write(text)
                keymapfile.close()
		list = ["zapUp", "zapDown", "switchChannelUp", "switchChannelDown", "DoNothing", "historyBack", "historyNext", "openServiceList", "openServiceList", "zapUp", "zapDown"]
		self.writeConfigs(list)
                self.session.openWithCallback(self.close,MessageBox,_("Pauli changed Keymap to Enigma2"), MessageBox.TYPE_INFO)

	def setUser(self):
		list = [self.buttons.keyLeft.value, self.buttons.keyRight.value, self.buttons.keyUp.value, self.buttons.keyDown.value, self.buttons.keyOK.value, self.buttons.keyPrevious.value, self.buttons.keyNext.value, self.buttons.keyChannelUp.value, self.buttons.keyChannelDown.value, self.buttons.keyButton0.value, self.buttons.keyButton1.value]
		self.writeConfigs(list)
                self.session.openWithCallback(self.close,MessageBox,_("Pauli changed Keymap to user-defined"), MessageBox.TYPE_INFO)

	def writeConfigs(self, list):
		functionKeyLeft = list[0]
		functionKeyRight = list[1]
		functionKeyUp = list[2]
		functionKeyDown = list[3]
		functionKeyOK = list[4]
		functionKeyPrevious = list[5]
		functionKeyNext = list[6]
		functionKeyChannelUp = list[7]
		functionKeyChannelDown = list[8]
		functionKeyButton0 = list[9]
		functionKeyButton1 = list[10]
		config = ""
		TAB = ""
		doWrite = True
		try:
			xmlFile = open(pauli_keymap, 'r')
			for line in xmlFile:
				if doWrite == True:
					config = config + line
					if line.__contains__('<'):
						position = line.index('<')
						tmp = line[position:999]
						if tmp.startswith('<map context="InfobarChannelSelection">'):
							doWrite = False
				else:
					if line.__contains__('<'):
						tmp = line[position:999]
						if tmp.startswith('</map>'):
							doWrite = True
							if functionKeyLeft != "DoNothing":
								config = config + TAB + TAB + '<key id="KEY_LEFT" mapto="' + functionKeyLeft + '" flags="mr" />' + "\n"	
							if functionKeyRight != "DoNothing":
								config = config + TAB + TAB + '<key id="KEY_RIGHT" mapto="' + functionKeyRight + '" flags="mr" />' + "\n"
							if functionKeyUp != "DoNothing":
								config = config + TAB + TAB + '<key id="KEY_UP" mapto="' + functionKeyUp + '" flags="mr" />' + "\n"
							if functionKeyDown != "DoNothing":
								config = config + TAB + TAB + '<key id="KEY_DOWN" mapto="' + functionKeyDown + '" flags="mr" />' + "\n"
							if functionKeyOK != "DoNothing":
								config = config + TAB + TAB + '<key id="KEY_OK" mapto="' + functionKeyOK + '" flags="mr" />' + "\n"
							if functionKeyPrevious != "DoNothing":
								config = config + TAB + TAB + '<key id="KEY_PREVIOUS" mapto="' + functionKeyPrevious + '" flags="mr" />' + "\n"
							if functionKeyNext != "DoNothing":
								config = config + TAB + TAB + '<key id="KEY_NEXT" mapto="' + functionKeyNext + '" flags="mr" />' + "\n"
							if functionKeyPrevious != "DoNothing":
                                                                # forgotten BACK key - use same as PREVIOUS
								config = config + TAB + TAB + '<key id="KEY_BACK" mapto="' + functionKeyPrevious + '" flags="mr" />' + "\n"
							if functionKeyNext != "DoNothing":
                                                                # forgotten FORWARD key - use same as NEXT
								config = config + TAB + TAB + '<key id="KEY_FORWARD" mapto="' + functionKeyNext + '" flags="mr" />' + "\n"
							if functionKeyChannelUp != "DoNothing":
								config = config + TAB + TAB + '<key id="KEY_CHANNELUP" mapto="' + functionKeyChannelUp + '" flags="mr" />' + "\n"
							if functionKeyChannelDown != "DoNothing":
								config = config + TAB + TAB + '<key id="KEY_CHANNELDOWN" mapto="' + functionKeyChannelDown + '" flags="mr" />' + "\n"
							if functionKeyButton0 != "DoNothing":
								config = config + TAB + TAB + '<key id="BTN_0" mapto="' + functionKeyButton0 + '" flags="mr" />' + "\n"
							if functionKeyButton1 != "DoNothing":
								config = config + TAB + TAB + '<key id="BTN_1" mapto="' + functionKeyButton1 + '" flags="mr" />' + "\n"
							config = config + line
						else:
							if TAB == "":
								TAB = line[0:position]
			xmlFile.close()
			xmlFile = open(pauli_keymap, 'w')
			xmlFile.write(config)
			xmlFile.close()
                        keymapparser.removeKeymap(pauli_keymap)
                        keymapparser.readKeymap(pauli_keymap)
		except:
			print "[PAULI] Could not write the file /usr/share/enigma2/keymap.xml"

	def setDeepstandby(self,number):
                keymapfile = open(pauli_keymap, "r")
                text=keymapfile.read()
                keymapfile.close()
                if text.find("power_long") is -1:
                   # old image - so let's patch mytest.py
                   mytestfile = open(pauli_mytest, "r")
                   text=mytestfile.read()
                   mytestfile.close()
                   if text.find("self.powerKeyTimer.start(3000, True)") is -1:
	              text=text.replace("self.powerKeyTimer.start(0000, True)","self.powerKeyTimer.start(3000, True)")
                      mytestfile = open(pauli_mytest, "w")
                      mytestfile.write(text)
                      mytestfile.close()
                      self.session.openWithCallback(self.close,MessageBox,_("Pauli enabled Deepstandby after 3 sec, restart Enigma2 to activate"), MessageBox.TYPE_INFO)
                   else:
	              text=text.replace("self.powerKeyTimer.start(3000, True)","self.powerKeyTimer.start(0000, True)")
                      mytestfile = open(pauli_mytest, "w")
                      mytestfile.write(text)
                      mytestfile.close()
                      self.session.openWithCallback(self.close,MessageBox,_("Pauli enabled Deepstandby immediate, restart Enigma2 to activate"), MessageBox.TYPE_INFO)
                else:
                   # new image - so let's only patch keymap.xml
                   if text.find("<key id=\"KEY_POWER\" mapto=\"power_long\" flags=\"l\" />") is -1:
                      text=text.replace("<key id=\"KEY_POWER\" mapto=\"power_long\" flags=\"m\" />","<key id=\"KEY_POWER\" mapto=\"power_long\" flags=\"l\" />")
	              text=text.replace("<key id=\"KEY_POWER\" mapto=\"power_down\" flags=\"l\" />","<key id=\"KEY_POWER\" mapto=\"power_down\" flags=\"m\" />")
                      keymapfile = open(pauli_keymap, "w")
                      keymapfile.write(text)
                      keymapfile.close()
                      keymapparser.removeKeymap(pauli_keymap)
                      keymapparser.readKeymap(pauli_keymap)
                      self.session.open(MessageBox,_("Pauli swapped Deepstandby with power short"), MessageBox.TYPE_INFO)
                   else:
	              text=text.replace("<key id=\"KEY_POWER\" mapto=\"power_long\" flags=\"l\" />","<key id=\"KEY_POWER\" mapto=\"power_long\" flags=\"m\" />")
	              text=text.replace("<key id=\"KEY_POWER\" mapto=\"power_down\" flags=\"m\" />","<key id=\"KEY_POWER\" mapto=\"power_down\" flags=\"l\" />")
                      keymapfile = open(pauli_keymap, "w")
                      keymapfile.write(text)
                      keymapfile.close()
                      keymapparser.removeKeymap(pauli_keymap)
                      keymapparser.readKeymap(pauli_keymap)
                      self.session.open(MessageBox,_("Pauli enabled normal Deepstandby with power long"), MessageBox.TYPE_INFO)
            
