﻿# -*- coding: utf-8 -*-
from Plugins.Extensions.MediaPortal.plugin import _
from Plugins.Extensions.MediaPortal.resources.imports import *
from Plugins.Extensions.MediaPortal.resources.choiceboxext import ChoiceBoxExt

ck = {}
config.mediaportal.tapetv_maxquali = ConfigText(default="2", fixed_size=False)
myqualities = [['HD720p', "0"],['SD480p', "1"],['highHQ', "2"],['mediumMQ', "3"],['lowLQ', "4"]]

class Tapetvhelper:

	def __init__(self, session):
		self.session = session

	def keyOK(self):
		exist = self['liste'].getCurrent()
		if self.keyLocked or exist == None:
			return
		idx = self['liste'].getSelectedIndex()
		self.session.open(tapeTVListPlayer, self.filmliste, int(idx) , True, self.CatName)

	def showInfos(self):
		Image = self['liste'].getCurrent()[0][2]
		CoverHelper(self['coverArt']).getCover(Image)

	def keyQuali(self):
		if self.keyLocked:
			return
		self.session.openWithCallback(self.returnkeyQuali, ChoiceBoxExt, title=_('Videoresolution'), list = myqualities)

	def returnkeyQuali(self, data):
		if data:
			self['F3'].setText(data[0].upper())
			config.mediaportal.tapetv_maxquali.value = data[1]
			config.mediaportal.tapetv_maxquali.save()
			configfile.save()

	def keytapetvAction(self):
		if self.keyLocked:
			return
		
		if re.match(' Artist ->', self.CatName):
			rangelist = [['Follow current Song', '0'], ['Show Similar Artists', '1']]
		else:
			rangelist = [['Follow current Song', '0'], ['Show Similar Artists', '1'],['Show Songs current Artist','2']]
		self.session.openWithCallback(self.backkeyAction, ChoiceBoxExt, title=_('Select Action'), list = rangelist)

	def backkeyAction(self, result):
		if result:
			Title = self['liste'].getCurrent()[0][0]
			Url = self['liste'].getCurrent()[0][1]
			if result[1] == '0':
				title = 'Follow Song: %s' % Title
				self.session.open(tapetvFollowScreen, Url, title)
			elif result[1] == '1':
				artlink = re.search('http://www.tape.tv/(.*?)/', Url)
				if artlink:
					url = 'http://www.tape.tv/%s' % artlink.group(1)
					self.session.open(tapetvSimilarScreen , url, artlink.group(1).capitalize())
			elif result[1] == '2':
				artlink = re.search('http://www.tape.tv/(.*?)/', Url)
				if artlink:
					url = 'http://www.tape.tv/%s' % artlink.group(1)
					self.session.open(tapetvFilmScreen, artlink.group(1), " Artist -> " + artlink.group(1).capitalize())

	def keyAdd(self):
		exist = self['liste'].getCurrent()
		if self.keyLocked or exist == None:
			return
		muTitle = self['liste'].getCurrent()[0][0]
		muID = self['liste'].getCurrent()[0][1]
		muCover = self['liste'].getCurrent()[0][2]

		if not fileExists(config.mediaportal.watchlistpath.value+"mp_tapetv_watchlist"):
			open(config.mediaportal.watchlistpath.value+"mp_tapetv_watchlist","w").close()
		if fileExists(config.mediaportal.watchlistpath.value+"mp_tapetv_watchlist"):
			writePlaylist = open(config.mediaportal.watchlistpath.value+"mp_tapetv_watchlist","a")
			writePlaylist.write('"%s" "%s" "%s" "0"\n' % (muTitle, muID, muCover))
			writePlaylist.close()
			message = self.session.open(MessageBoxExt, _("Selection was added to the local Playlist."), MessageBoxExt.TYPE_INFO, timeout=3)

class tapetvGenreScreen(MPScreen, Tapetvhelper):

	def __init__(self, session):
		self.plugin_path = mp_globals.pluginPath
		self.skin_path = mp_globals.pluginPath + mp_globals.skinsPath
		path = "%s/%s/defaultListWideScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + mp_globals.skinFallback + "/defaultListWideScreen.xml"
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()
		MPScreen.__init__(self, session)

		self["actions"] = ActionMap(["MP_Actions"], {
			"0"		: self.closeAll,
			"ok" : self.keyOK,
			"cancel" : self.keyCancel,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"yellow" : self.keyQuali
		}, -1)

		myQuali = myqualities[int(config.mediaportal.tapetv_maxquali.value)][0].upper()
		self['title'] = Label("Tape.tv")
		self['ContentTitle'] = Label("Genre:")
		self['F3'] = Label(myQuali)
		self.keyLocked = True
		self.suchString = ''
		self.genreliste = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.onLayoutFinish.append(self.layoutFinished)

	def layoutFinished(self):
		self.genreliste.append(("--- Search ---", "callSuchen"))
		self.genreliste.append(("Local Playlist", ""))
		self.genreliste.append(("New Videos", "/explore/new"))
		self.genreliste.append(("Popular Videos", "/explore/popular"))
		self.genreliste.append(("Editorial Videos", "/explore/editorial"))
		self.ml.setList(map(self._defaultlistcenter, self.genreliste))
		self.ml.moveToIndex(0)
		self.keyLocked = False

	def keyOK(self):
		if self.keyLocked:
			return
		streamGenreName = self['liste'].getCurrent()[0][0]
		if streamGenreName == "--- Search ---":
			self.suchen()
		elif streamGenreName == "Local Playlist":
			self.session.open(tapetvWatchlist)
		else:
			streamGenreLink = "http://www.tape.tv/%s" % self['liste'].getCurrent()[0][1]
			self.session.open(tapetvFilmScreen, streamGenreLink, streamGenreName)

	def SuchenCallback(self, callback = None, entry = None):
		if callback is not None and len(callback):
			self.suchString = callback.replace(' ', '%20')
			streamGenreLink = '%s' % (self.suchString)
			selfGenreName = "--- Search ---"
			self.session.open(tapetvFilmScreen, streamGenreLink, selfGenreName)

class tapetvFilmScreen(Tapetvhelper, MPScreen, ThumbsHelper):

	def __init__(self, session, CatLink, CatName):
		self.CatLink = CatLink
		self.CatName = CatName
		self.plugin_path = mp_globals.pluginPath
		self.skin_path = mp_globals.pluginPath + mp_globals.skinsPath
		path = "%s/%s/defaultListWideScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + mp_globals.skinFallback + "/defaultListWideScreen.xml"
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()

		Tapetvhelper.__init__(self,session)
		MPScreen.__init__(self, session)
		ThumbsHelper.__init__(self)

		self["actions"] = ActionMap(["MP_Actions"], {
			"0"		: self.closeAll,
			"ok" : self.keyOK,
			"cancel" : self.keyCancel,
			"5" : self.keyShowThumb,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft,
			"green" : self.keyAdd,
			"yellow" : self.keyQuali,
			"blue" : self.keytapetvAction
		}, -1)

		myQuali = myqualities[int(config.mediaportal.tapetv_maxquali.value)][0].upper()
		self['title'] = Label("Tape.tv")
		self['ContentTitle'] = Label("Genre: %s" % (self.CatName))
		self['F2'] = Label(_("Add to Playlist"))
		self['F3'] = Label(myQuali)
		self['F4'] = Label("Action")

		self.keyLocked = True
		self.filmliste = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		self.keyLocked = True
		self['name'].setText(_('Please wait...'))
		self.filmliste = []
		if 'New' in self.CatName or 'Popular' in self.CatName or 'Editorial' in self.CatName:
			self['ContentTitle'].setText("Genre: %s" % self.CatName)
			url = self.CatLink
		else:
			self['ContentTitle'].setText("Search: %s" % self.CatName)
			url = "http://search.tape.tv/betamax/videos?q=%s" % (self.CatLink)
		getPage(url, cookies=ck, headers={'Content-Type':'application/x-www-form-urlencoded'}).addCallback(self.loadData).addErrback(self.dataError)

	def loadData(self, data):
		if re.match(".*?Videos", self.CatName):
			raw = re.search('Videos diese Woche</h2>(.*?)<script>', data, re.S)
			if re.match(".*?Editorial", self.CatName):
				raw = re.search('Lieblingsvideos</h2>(.*?)<script>', data, re.S)
			else:
				raw = re.search('Videos diese Woche</h2>(.*?)<script>', data, re.S)
			Songs = re.findall('<li class="tile video.*?src="(.*?)".*?<a class="title" href="(.*?)">(.*?)<.*?<a class="artist" href=".*?>(.*?)<', raw.group(1), re.S)
			if Songs:
				for (Image, Url, Title, Artist) in Songs:
					Url = "http://www.tape.tv%s" % Url
					Title = Artist + ' - ' + Title
					self.filmliste.append((decodeHtml(Title), Url, decodeHtml(Image)))
		else:
			Songs = re.findall('"artist_title":"(.*?)".*?"artist_name":"(.*?)".*?"id":(.*?),"share_url":"(.*?)"', data, re.S)
			if Songs:
				for (Title, Artist, Id, Url) in Songs:
					Title = Artist + ' - ' + Title
					Image = "http://api.tape.tv/images/video/%s_300x225.jpg" % Id
					self.filmliste.append((decodeHtml(Title), Url, decodeHtml(Image)))
		if len(self.filmliste) == 0:
			self.filmliste.append((_("No songs found!"),'','',''))
		self.ml.setList(map(self._defaultlistleft, self.filmliste))
		self.ml.moveToIndex(0)
		self.keyLocked = False
		self['name'].setText(self.CatName)
		self.th_ThumbsQuery(self.filmliste, 0, 1, 2, None, None, 1, 1, mode=1)
		self.showInfos()

class tapetvFollowScreen(Tapetvhelper, MPScreen, ThumbsHelper):

	def __init__(self, session, CatLink, CatName):
		self.CatLink = CatLink
		self.CatName = CatName
		self.plugin_path = mp_globals.pluginPath
		self.skin_path = mp_globals.pluginPath + mp_globals.skinsPath
		path = "%s/%s/defaultListWideScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + mp_globals.skinFallback + "/defaultListWideScreen.xml"
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()

		Tapetvhelper.__init__(self,session)
		MPScreen.__init__(self, session)
		ThumbsHelper.__init__(self)

		self["actions"] = ActionMap(["MP_Actions"], {
			"0"		: self.closeAll,
			"ok" : self.keyOK,
			"cancel" : self.keyCancel,
			"5" : self.keyShowThumb,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft,
			"green" : self.keyAdd
		}, -1)

		self['title'] = Label("Tape.tv")
		self['ContentTitle'] = Label(self.CatName)
		self['F2'] = Label(_("Add to Playlist"))

		self.page = 1
		self.keyLocked = True
		self.filmliste = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		self.keyLocked = True
		self['name'].setText(_('Please wait...'))
		if re.match('Artist:', self.CatName):
			url ='%s/videos?page=%s&page_size=100' % (self.CatLink, str(self.page))
		else:
			url ='%s/related_content?page=%s' % (self.CatLink, str(self.page))
		getPage(url, cookies=ck, headers={'X-Requested-With':"XMLHttpRequest",'Referer': self.CatLink, 'Accept':'application/json, text/javascript, */*; q=0.01'}).addCallback(self.loadData).addErrback(self.dataError)

	def loadData(self, data):
		Songs = re.findall('type":"video","title":"(.*?)".*?"artist_name":"(.*?)".*?"path":"(.*?)".*?image_url":"(.*?)"', data, re.S)
		if Songs:
			for (Title, Artist ,Url, Image) in Songs:
				Url = "http://www.tape.tv%s" % Url
				Image = Image.replace('https','http')
				if not re.match('http:', Image):
					Image = 'http:%s' % Image
				Title = Artist + ' - ' + Title
				self.filmliste.append((decodeHtml(Title), Url, decodeHtml(Image)))
		if data != '[]' and self.page <= 10:
			self.page += 1
			self.loadPage()
		else:
			if len(self.filmliste) == 0:
				self.filmliste.append((_("No songs found!"),'','',''))
			self.ml.setList(map(self._defaultlistleft, self.filmliste))
			self.ml.moveToIndex(0)
			self.keyLocked = False
			self['name'].setText(self.CatName)
			self.th_ThumbsQuery(self.filmliste, 0, 1, 2, None, None, 1, 1, mode=1)
			self.showInfos()

class tapetvSimilarScreen(Tapetvhelper, MPScreen, ThumbsHelper):

	def __init__(self, session, CatLink, CatName):
		self.CatLink = CatLink
		self.CatName = CatName
		self.plugin_path = mp_globals.pluginPath
		self.skin_path = mp_globals.pluginPath + mp_globals.skinsPath
		path = "%s/%s/defaultListWideScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + mp_globals.skinFallback + "/defaultListWideScreen.xml"
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()

		Tapetvhelper.__init__(self,session)
		MPScreen.__init__(self, session)
		ThumbsHelper.__init__(self)

		self["actions"] = ActionMap(["MP_Actions"], {
			"0"		: self.closeAll,
			"ok" : self.keyOK,
			"cancel" : self.keyCancel,
			"5" : self.keyShowThumb,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft
		}, -1)

		self['title'] = Label("Tape.tv")
		self['ContentTitle'] = Label(self.CatName)

		self.page = 1
		self.keyLocked = True
		self.filmliste = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		self.keyLocked = True
		self['name'].setText(_('Please wait...'))
		url ='%s/similar?page=%s&page_size=200' % (self.CatLink, str(self.page))
		getPage(url, cookies=ck, headers={'X-Requested-With':"XMLHttpRequest",'Referer': self.CatLink, 'Accept':'application/json, text/javascript, */*; q=0.01'}).addCallback(self.loadData).addErrback(self.dataError)

	def loadData(self, data):
		Songs = re.findall('"name":"(.*?)".*?"share_url":"(.*?)".*?"image_url":"(.*?)"', data, re.S)
		if Songs:
			for (Artist ,Url, Image) in Songs:
				Title = "Artist: %s" % Artist
				Image = Image.replace('https','http')
				if not re.match('http:', Image):
					Image = 'http:%s' % Image
				self.filmliste.append((decodeHtml(Title), Url, decodeHtml(Image)))
		if len(self.filmliste) == 0:
			self.filmliste.append(('No Artists found!','','',''))
		self.ml.setList(map(self._defaultlistleft, self.filmliste))
		self.ml.moveToIndex(0)
		self.keyLocked = False
		self['name'].setText(self.CatName)
		self.th_ThumbsQuery(self.filmliste, 0, 1, 2, None, None, 1, 1, mode=1)
		self.showInfos()

	def keyOK(self):
		exist = self['liste'].getCurrent()
		if self.keyLocked or exist == None:
			return
		url = self['liste'].getCurrent()[0][1]
		title = self['liste'].getCurrent()[0][0]
		self.session.open(tapetvFollowScreen, url, title)

class tapetvWatchlist(Tapetvhelper, MPScreen, ThumbsHelper):

	def __init__(self, session):
		self.plugin_path = mp_globals.pluginPath
		self.skin_path = mp_globals.pluginPath + mp_globals.skinsPath
		path = "%s/%s/defaultListWideScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + mp_globals.skinFallback + "/defaultListWideScreen.xml"
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()

		Tapetvhelper.__init__(self,session)
		MPScreen.__init__(self, session)
		ThumbsHelper.__init__(self)

		self["actions"] = ActionMap(["MP_Actions"], {
			"0": self.closeAll,
			"5" : self.keyShowThumb,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft,
			"ok" : self.keyOK,
			"cancel": self.keyCancel,
			"red" : self.keyDel,
			"yellow" : self.keyQuali,
			"blue" : self.keytapetvAction
		}, -1)

		myQuali = myqualities[int(config.mediaportal.tapetv_maxquali.value)][0].upper()
		self['title'] = Label("Tape.tv")
		self['ContentTitle'] = Label("Local Playlist")
		self['F1'] = Label(_("Delete"))
		self['F3'] = Label(myQuali)
		self['F4'] = Label("Action")

		self.CatName = 'Local Playlist'
		self.filmliste = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml
		self.keyLocked = True

		self.onLayoutFinish.append(self.loadPlaylist)

	def loadPlaylist(self):
		self.filmliste = []
		if fileExists(config.mediaportal.watchlistpath.value+"mp_tapetv_watchlist"):
			readStations = open(config.mediaportal.watchlistpath.value+"mp_tapetv_watchlist","r")
			for rawData in readStations.readlines():
				data = re.findall('"(.*?)" "(.*?)" "(.*?)" "(.*?)"', rawData, re.S)
				if data:
					(Title, Url, Image, null) = data[0]
					self.filmliste.append((decodeHtml(Title), Url, Image, False))
			print "Load Watchlist.."
			if len(self.filmliste) == 0:
				self.filmliste.append((_("No songs found!"),'','',''))
			self.ml.setList(map(self._defaultlistleft, self.filmliste))
			readStations.close()
			self.keyLocked = False
			self.th_ThumbsQuery(self.filmliste, 0, 1, 2, None, None, 1, 1, mode=1)
			self.showInfos()

	def keyDel(self):
		exist = self['liste'].getCurrent()
		if self.keyLocked or exist == None:
			return
		selectedName = self['liste'].getCurrent()[0][0]
		writeTmp = open(config.mediaportal.watchlistpath.value+"mp_tapetv_watchlist.tmp","w")
		if fileExists(config.mediaportal.watchlistpath.value+"mp_tapetv_watchlist"):
			readStations = open(config.mediaportal.watchlistpath.value+"mp_tapetv_watchlist","r")
			for rawData in readStations.readlines():
				data = re.findall('"(.*?)" "(.*?)" "(.*?)" "(.*?)"', rawData, re.S)
				if data:
					(stationName, stationLink, stationLang, stationTotaleps) = data[0]
					if stationName != selectedName:
						writeTmp.write('"%s" "%s" "%s" "%s"\n' % (stationName, stationLink, stationLang, stationTotaleps))
			readStations.close()
			writeTmp.close()
			shutil.move(config.mediaportal.watchlistpath.value+"mp_tapetv_watchlist.tmp", config.mediaportal.watchlistpath.value+"mp_tapetv_watchlist")
			self.loadPlaylist()

class tapeTVListPlayer(SimplePlayer):

	def __init__(self, session, playList, playIdx=0, playAll=True, listTitle=None):
		SimplePlayer.__init__(self, session, playList, playIdx=playIdx, playAll=playAll, listTitle=listTitle, ltype='tapetv')

	def getVideo(self):
		title = self.playList[self.playIdx][self.title_inr]
		url = self.playList[self.playIdx][1]
		imgurl = self.playList[self.playIdx][2]
		tapetvLink(self.session).getLink(self.playStream, self.dataError, title, url, imgurl)

class tapetvLink:

	def __init__(self, session):
		self.session = session
		self._callback = None

	def getLink(self, cb_play, cb_err, title, url, imgurl):
		self._callback = cb_play
		self._errback = cb_err
		self.title = title
		self.imgurl = imgurl
		getPage(url, cookies=ck, headers={'Content-Type':'application/x-www-form-urlencoded'}).addCallback(self._getJSLink).addErrback(self._errback)

	def _getJSLink(self, data):
		raw = re.search('<script data-main="(.*?)"', data, re.S)
		videoid = re.search('data.video_data = {"id":"(.*?)"',data, re.S)
		if raw and videoid:
			getPage(raw.group(1), cookies=ck, headers={'Content-Type':'application/x-www-form-urlencoded'}).addCallback(self._getToken, videoid.group(1)).addErrback(self._errback)

	def _getToken(self, data, videoid):
		raw = re.search('\.authToken="(.*?)"', data, re.S)
		if raw:
			url = "http://streaming-url.tape.tv/v1/rtmp/%s" % videoid
			token = raw.group(1)
			getPage(url, cookies=ck, headers={'Authorization': 'Token ' + token, 'Referer': 'http://www.tape.tv/', 'Origin': 'http://www.tape.tv'}).addCallback(self._getVideoLink).addErrback(self._errback)

	def _getVideoLink(self, data):
		raw = re.search('"token":"(.*?)"', data, re.S)
		if raw:
			rtmp_url = "rtmpe://cp68509.edgefcs.net:1935/ondemand?ovpfv=2.1.6&auth=%s&aifp=v001" % raw.group(1)
			rtmp_app = "ondemand?ovpfv=2.1.6&auth=%s&aifp=v001" % raw.group(1)
			rtmp_swfVfy = "http://www.tape.tv/tapePlayer.swf"
			raw = re.findall('"http://video.tape.tv/play/(.*?)"', data, re.S)
			qualities = re.findall('"qualities":\["(.*?)"\],"', data, re.S)
			if raw and qualities:
				qualities = qualities[0].split('","')
				for getquality in range(int(config.mediaportal.tapetv_maxquali.value), len(myqualities)):
					for x in range(len(qualities)):
						if qualities[x] == myqualities[getquality][0]:
							break
						else:
							continue
						break
					else:
						continue
					break
				rtmp_playpath = "mp4:tapetv/play/%s" % raw[x]
				videourl = "%s app=%s swfVfy=%s playpath=%s" % (rtmp_url, rtmp_app, rtmp_swfVfy, rtmp_playpath)
				self._callback(self.title, videourl, imgurl=self.imgurl)