# -*- coding: utf-8 -*-
from imports import *
from twagenthelper import TwAgentHelper

class MTVdeLink:

	tw_agent_hlp = TwAgentHelper()

	def __init__(self, session):
		print "MTVdeLink:"
		self.session = session
		self._callback = None

	def getLink(self, cb_play, cb_err, title, artist, token, imgurl):
		self._callback = cb_play
		self._errback = cb_err
		self.title = title
		self.artist = artist
		self.imgurl = imgurl
		url = "http://intl.esperanto.mtvi.com/www/xml/media/mediaGen.jhtml?uri=mgid:uma:video:mtv.de:%s" % token
		getPage(url, headers={'Content-Type':'application/x-www-form-urlencoded'}, timeout=15).addCallback(self._parseData).addErrback(cb_err)

	def _parseData(self, data):
		print "_parseData:"
		rtmplink = re.findall('<src>(rtmp.*?)</src>', data)
		if rtmplink:
			urlpart = re.search('(^.*?)(_!.*?$)', rtmplink[-1])
			if urlpart:
				videourl = urlpart.group(1) + ' app=ondemand/mtviestor/ swfVfy=http://player.mtvnn.com/g2/g2player_2.1.4.swf playpath=mp4:%s' % urlpart.group(2)
		else:
			self._errback('MTVdeLink: Cannot get link!')
			videourl = None

		self._callback(self.title, videourl, imgurl=self.imgurl, artist=self.artist)