﻿# -*- coding: utf-8 -*-
from Plugins.Extensions.MediaPortal.plugin import _
from Plugins.Extensions.MediaPortal.resources.imports import *
from Plugins.Extensions.MediaPortal.resources.playrtmpmovie import PlayRtmpMovie

class RTLnowGenreScreen(MPScreen, ThumbsHelper):

	def __init__(self, session, portal, baseurl):
		self.portal = portal
		self.baseurl = baseurl
		self.plugin_path = mp_globals.pluginPath
		self.skin_path = mp_globals.pluginPath + mp_globals.skinsPath
		path = "%s/%s/defaultListWideScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + mp_globals.skinFallback + "/defaultListWideScreen.xml"
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()
		MPScreen.__init__(self, session)
		ThumbsHelper.__init__(self)

		self["actions"] = ActionMap(["MP_Actions"], {
			"0"		: self.closeAll,
			"5" : self.keyShowThumb,
			"ok"    : self.keyOK,
			"cancel": self.keyCancel,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft
		}, -1)

		self['title'] = Label("%s.de" % self.portal)
		self['ContentTitle'] = Label("Auswahl der Sendung")

		self.genreliste = []
		self.keyLocked = True
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		self.keyLocked = True
		url = "http://%s" % self.baseurl
		getPage(url, agent=std_headers, headers={'Content-Type':'application/x-www-form-urlencoded'}).addCallback(self.loadPageData).addErrback(self.dataError)

	def loadPageData(self, data):
		genre = re.findall('<div\sclass="seriennavi_(free|new)"\sstyle=""><a\shref="(.*?)".*?format\',\s\'free\'.*?</div>.*?<div\sstyle=""\sclass="seriennavi_link">.*?">(.*?)</a>.*?</div>', data, re.S)
		if genre:
			self.genreliste = []
			for free, url, title in genre:
				if not re.search('paytype=ppv', url, re.S):
					url = url.replace('http://%s/' % self.baseurl,'')
					if url[0] == '/':
						url = url[1:]
					url = "http://%s/" % self.baseurl + url
					title = title.strip()
					if not title == "RTL Classics":
						if not title == "Weitere Serien":
							if not title == "US-Serienhighlights":
								if not title == "NOW-Highlights":
									self.genreliste.append((title, url))
			# remove duplicates
			self.genreliste = list(set(self.genreliste))
			self.genreliste.sort(key=lambda t : t[0].lower())
			self.ml.setList(map(self._defaultlistleft, self.genreliste))
			self.keyLocked = False
			self.th_ThumbsQuery(self.genreliste, 0, 1, None, None, 'og:image"\scontent="(.*?)"', 1, 1, mode=1)
			self.showInfos()

	def showInfos(self):
		streamName = self['liste'].getCurrent()[0][0]
		self['name'].setText(streamName)
		url = self['liste'].getCurrent()[0][1]
		getPage(url, agent=std_headers, headers={'Content-Type':'application/x-www-form-urlencoded'}).addCallback(self.showInfos2).addErrback(self.dataError)

	def showInfos2(self, data):
		image = re.search('og:image"\scontent="(.*?)"', data, re.S)
		handlung = re.search('og:description"\scontent="(.*?)"', data, re.S)
		if handlung:
			streamHandlung = handlung.group(1)
			self['handlung'].setText(decodeHtml(streamHandlung))
		else:
			self['handlung'].setText("")
		if image:
			streamPic = image.group(1)
			CoverHelper(self['coverArt']).getCover(streamPic)

	def keyOK(self):
		if self.keyLocked:
			return
		Name = self['liste'].getCurrent()[0][0]
		Link = self['liste'].getCurrent()[0][1]
		if self.portal == "RTLNITRONOW":
			app = "nitronow"
		elif self.portal == "N-TVNOW":
			app = "ntvnow"
		else:
			app = self.portal.lower()
		self.session.open(RTLnowFilmeListeScreen, Link, Name, self.baseurl, self.portal, app)

class RTLnowFilmeListeScreen(MPScreen, ThumbsHelper):

	def __init__(self, session, Link, Name, baseurl, portal, app):
		self.baseurl = baseurl
		self.app = app
		self.portal = portal
		self.Link = Link
		self.Name = Name
		self.plugin_path = mp_globals.pluginPath
		self.skin_path = mp_globals.pluginPath + mp_globals.skinsPath
		path = "%s/%s/defaultListWideScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + mp_globals.skinFallback + "/defaultListWideScreen.xml"
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()
		MPScreen.__init__(self, session)
		ThumbsHelper.__init__(self)

		self["actions"] = ActionMap(["MP_Actions"], {
			"0"		: self.closeAll,
			"ok"    : self.keyOK,
			"cancel": self.keyCancel,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft
		}, -1)

		self['title'] = Label("%s.de" % self.portal)
		self['ContentTitle'] = Label("Auswahl: %s" % self.Name)


		self.keyLocked = True
		self.filmliste = []
		self.keckse = {}
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		getPage(self.Link, agent=std_headers, headers={'Content-Type':'application/x-www-form-urlencoded'}).addCallback(self.loadPageData).addErrback(self.dataError)

	def loadPageData(self, data):
		self.autoload = 1
		reiter_posts = []
		self.filmliste = []
		## suche nach reitern
		if re.match('.*?var reitercount =', data, re.S):
			reiter_count = re.findall('var reitercount = (.*?);', data, re.S)
			print "Reiteranzahl:", reiter_count[0]

			reiter = re.findall("currentreiter=.*?;show_top_and_movies_wrapper.(.*?),'(.*?)','(.*?)',(.*?),(.*?),(.*?),'','(.*?)'.*?><div class=\"l\"></div><div class=\"m\">(.*?)</div>", data, re.S)
			if reiter:
				for each in reiter:
					post = []
					reitername = each[7]
					print reitername
					post = "xajax=show_top_and_movies&xajaxr="+str(time()).replace('.','')
					post += "&xajaxargs[]="+each[0]
					post += "&xajaxargs[]="+each[1]
					post += "&xajaxargs[]="+each[2]
					post += "&xajaxargs[]="+each[3]
					post += "&xajaxargs[]="+each[4]
					post += "&xajaxargs[]="+each[5]
					post += "&xajaxargs[]="+each[6]

					reiter_posts.append((post, reitername))

				if len(reiter_posts) != 0:
					count_reiter = len(reiter_posts)
					print "Reiter gefunden:", count_reiter
					ds = defer.DeferredSemaphore(tokens=1)
					downloads = [ds.run(self.download,post).addCallback(self.check_pages,reitername).addErrback(self.dataError) for post,reitername in reiter_posts]
					finished = defer.DeferredList(downloads).addErrback(self.dataError)

	def check_pages(self, data, reitername):
		## suche nach pages
		ajax_posts = []
		print "Reitername:", reitername
		selects = re.compile('<select\s*?onchange.*?xajax_show_top_and_movies.*?\'(.*?)\'.*?\'(.*?)\'.*?\'(.*?)\'.*?\'(.*?)\'.*?\'(.*?)\'.*?>(.*?)</select>',re.S).search(data)
		if selects:
			tabSelects = "&xajaxargs[]="+selects.group(1)+"&xajaxargs[]="+selects.group(2)+"&xajaxargs[]="+selects.group(3)+"&xajaxargs[]="+selects.group(4)+"&xajaxargs[]="+selects.group(5)+"&xajax=show_top_and_movies&xajaxr="+str(time()).replace('.','')
			tabs = re.compile('<option.*?value=\'(\d)\'.*?>',re.S).findall(selects.group(6))
			for tab in tabs:
				ajax_posts.append(("xajaxargs[]="+tab+tabSelects))
		if len(ajax_posts) != 0:
			seitenanzahl = len(ajax_posts)
			print "Seitenanzahl fuer Reiter %s: %s" %  (reitername, seitenanzahl)
			ds = defer.DeferredSemaphore(tokens=1)
			downloads = [ds.run(self.download,item).addCallback(self.get_series_more_pages, reitername).addErrback(self.dataError) for item in ajax_posts]
			finished = defer.DeferredList(downloads).addErrback(self.dataError)
		else:
			## keine pages gefunden
			self.get_series_more_pages(data, reitername)

	def download(self, post):
		return getPage('http://%s/xajaxuri.php' % self.baseurl, method='POST', postdata=post, headers={'Content-Type':'application/x-www-form-urlencoded'})

	def get_series_more_pages(self, data, reitername):
		## suche nach folgen
		folgen = re.findall('id="title_basic_.*?[0-9]"><a\shref="(.*?)"\stitle=".*?\s-\s(.*?)">.*?(kostenlos|Nur\s22\s-\s6h|Nur\s23\s-\s6h)</a>', data)
		if folgen:
			for (url, title, sperre) in folgen:
				print title
				url = "http://%s" % self.baseurl + url.replace('amp;','')
				title = decodeHtml(title)
				lock = "free"
				if sperre == "Nur 22 - 6h":
					title = "gesperrt bis 22 Uhr: " + title
					lock = "22"
				if sperre == "Nur 23 - 6h":
					title = "gesperrt bis 23 Uhr: " + title
					lock = "23"
				title = "%s - %s" % (reitername, title)
				self.filmliste.append((title, url, lock))
			self.ml.setList(map(self._defaultlistleft, self.filmliste))
			self.keyLocked = False
			if self.autoload == 1:
				self.autoload = 0
				self.th_ThumbsQuery(self.filmliste, 0, 1, None, None, 'og:image"\scontent="(.*?)"', 1, 1, mode=1)
				self.showInfos()

	def showInfos(self):
		streamName = self['liste'].getCurrent()[0][0]
		self['name'].setText(streamName)
		url = self['liste'].getCurrent()[0][1]
		getPage(url, agent=std_headers, headers={'Content-Type':'application/x-www-form-urlencoded'}).addCallback(self.showInfos2).addErrback(self.dataError)

	def showInfos2(self, data):
		image = re.search('og:image"\scontent="(.*?)"', data, re.S)
		handlung = re.search('og:description"\scontent="(.*?)"', data, re.S)
		if handlung:
			streamHandlung = handlung.group(1)
		else:
			streamHandlung = ""
		self['handlung'].setText(decodeHtml(streamHandlung))
		if image:
			streamPic = image.group(1)
		else:
			streamPic = None
		CoverHelper(self['coverArt']).getCover(streamPic)

	def keyOK(self):
		if self.keyLocked:
			return
		self.streamName = self['liste'].getCurrent()[0][0]
		self.pageurl = self['liste'].getCurrent()[0][1]
		sperre = self['liste'].getCurrent()[0][2]
		if sperre == "22":
			message = self.session.open(MessageBoxExt, _("This video is currently blocked for Child Protection Laws and is only available from approximately 22 o'clock."), MessageBoxExt.TYPE_INFO, timeout=5)
			return
		if sperre == "23":
			message = self.session.open(MessageBoxExt, _("This video is currently blocked for Child Protection Laws and is only available from approximately 23 o'clock."), MessageBoxExt.TYPE_INFO, timeout=5)
			return
		print self.pageurl
		getPage(self.pageurl, agent=std_headers, cookies=self.keckse, headers={'Content-Type':'application/x-www-form-urlencoded'}).addCallback(self.get_xml).addErrback(self.dataError)

	def get_xml(self, data):
		print "xml data"
		self.stream = re.search("'playerdata': '(.*?)'", data, re.S)
		if self.stream:
			print self.stream.group(1).replace('amp;',''), self.keckse
			getPage(self.stream.group(1).replace('amp;',''), agent=std_headers, headers={'Content-Type':'application/x-www-form-urlencoded'}).addCallback(self.get_stream).addErrback(self.dataError)

	def get_stream(self, data):
		print "stream data"
		if '<metadata>' in data:
			id = re.search('<id>(.*?)</id>', data, re.S).group(1)
			url = 'http://rtl-now.rtl.de/hds/videos/%s/manifest-hds.f4m' % id
			getPage(url, agent=std_headers, headers={'Content-Type':'application/x-www-form-urlencoded'}).addCallback(self.get_stream2).addErrback(self.dataError)
			return
		rtmpe_data = re.search('<filename.*?><!\[CDATA\[rtmpe://.*?%s/(.*?)\]\]></filename>' % self.app, data, re.S|re.I)
		if not rtmpe_data:
			rtmpe_data = re.search('<filename.*?><!\[CDATA\[http://.*?videos/(.*?).f4m\?ts.*?\]\]></filename>', data, re.S|re.I)
		if rtmpe_data:
			m = re.search('<filename.*?fms-fra(.*?).rtl.de', data, re.S)
			if m:
				host = "rtmpe://fms-fra%s.rtl.de/%s/" % (m.group(1), self.app)
			else:
				host = "rtmpe://fms-fra%s.rtl.de/%s/" % ('32', self.app)
			playpath = rtmpe_data.group(1)
			if config.mediaportal.useRtmpDump.value:
				final = "%s' --swfVfy=1 --playpath=mp4:%s --app=%s/_definst_ --pageUrl=http://%s/ --tcUrl=%s --swfUrl=http://%s/includes/vodplayer.swf'" % (host, playpath, self.app, self.baseurl, host, self.baseurl)
				movieinfo = [final,self.streamName]
				self.session.open(PlayRtmpMovie, movieinfo, self.streamName, playCallback=self.playRtmpStream)
			else:
				final = "%s swfUrl=http://%s/includes/vodplayer.swf pageUrl=%s playpath=mp4:%s app=%s/_definst_ tcUrl=%s swfVfy=1" % (host, self.baseurl, self.pageurl, playpath, self.app, host)
				playlist = []
				playlist.append((self.streamName, final))
				self.session.open(SimplePlayer, playlist, showPlaylist=False, ltype='rtlnow')
		else:
			playlist = re.search('<filename.*?><!\[CDATA\[(http://.*?)\]\]></filename>', data, re.S|re.I)
			getPage(playlist.group(1), agent=std_headers, headers={'Content-Type':'application/x-www-form-urlencoded'}).addCallback(self.get_stream2).addErrback(self.dataError)

	def get_stream2(self, data):
		videourl = re.findall('media\shref="(.*?)"', data, re.S)
		url = videourl[-1].replace('hds','hls').replace('f4m','m3u8')
		if config.mediaportal.use_hls_proxy.value:
			self.session.open(SimplePlayer, [(self.streamName, url)], showPlaylist=False, ltype='rtlnow')
		else:
			message = self.session.open(MessageBoxExt, _("HLS-Player has to be enabled in MP-Setup for playback of this video."), MessageBoxExt.TYPE_INFO, timeout=5)

	def playRtmpStream(self, movietitle, moviepath, movie_img, cont_cb=None, exit_cb=None):
		self.playrtmp_cont_callback = cont_cb
		self.playrtmp_exit_callback = exit_cb
		self.session.openWithCallback(self.cb_Player, SimplePlayer, [(movietitle, moviepath, movie_img)], cover=False, showPlaylist=False, ltype='rtlnow-rtmp', useResume=False, bufferingOpt = 'rtmpbuffering')

	def cb_Player(self, retval=None):
		if retval == 'continue':
			self.playrtmp_cont_callback()
		else:
			self.playrtmp_exit_callback()