﻿# -*- coding: utf-8 -*-
###############################################################################################
#
#    MediaPortal for Dreambox OS
#
#    Coded by MediaPortal Team (c) 2013-2015
#
#  This plugin is open source but it is NOT free software.
#
#  This plugin may only be distributed to and executed on hardware which
#  is licensed by Dream Property GmbH. This includes commercial distribution.
#  In other words:
#  It's NOT allowed to distribute any parts of this plugin or its source code in ANY way
#  to hardware which is NOT licensed by Dream Property GmbH.
#  It's NOT allowed to execute this plugin and its source code or even parts of it in ANY way
#  on hardware which is NOT licensed by Dream Property GmbH.
#
#  This applies to the source code as a whole as well as to parts of it, unless
#  explicitely stated otherwise.
#
#  If you want to use or modify the code or parts of it,
#  you have to keep OUR license and inform us about the modifications, but it may NOT be
#  commercially distributed other than under the conditions noted above.
#
#  As an exception regarding modifcations, you are NOT permitted to remove
#  any copy protections implemented in this plugin or change them for means of disabling
#  or working around the copy protections, unless the change has been explicitly permitted
#  by the original authors. Also decompiling and modification of the closed source
#  parts is NOT permitted.
#
#  Advertising with this plugin is NOT allowed.
#  For other uses, permission from the authors is necessary.
#
###############################################################################################

from Plugins.Extensions.MediaPortal.plugin import _
from Plugins.Extensions.MediaPortal.resources.configlistext import ConfigListScreenExt
from Plugins.Extensions.MediaPortal.resources.imports import *

glob_agent = 'Mozilla/5.0 (Windows NT 6.1; WOW64; rv:35.0) Gecko/20100101 Firefox/35.0'
premium = False
keckse = {}

config.mediaportal.seriesever_userName = ConfigText(default="USERNAME", fixed_size=False)
config.mediaportal.seriesever_userPass = ConfigPassword(default="PASSWORD", fixed_size=False)

class serieseverMain(MPScreen):

	def __init__(self, session):
		self.plugin_path = mp_globals.pluginPath
		self.skin_path = mp_globals.pluginPath + mp_globals.skinsPath
		path = "%s/%s/defaultGenreScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + mp_globals.skinFallback + "/defaultGenreScreen.xml"
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()

		MPScreen.__init__(self, session)

		self["actions"] = ActionMap(["MP_Actions"], {
			"0": self.closeAll,
			"ok" : self.keyOK,
			"cancel": self.keyCancel,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft,
			"blue" : self.loginSetup
		}, -1)

		self['title'] = Label("Seriesever.com")
		self['ContentTitle'] = Label(_("Genre Selection"))
		self['F4'] = Label(_("Setup"))

		self.streamList = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.keyLocked = False
		self.onLayoutFinish.append(self.layoutFinished)

	def layoutFinished(self):
		self.keyLocked = True
		self.streamList.append(("New Added", "http://seriesever.com"))
		self.streamList.append(("Alle Serien", "http://seriesever.com"))
		self.streamList.append(("Watchlist", None))
		self.ml.setList(map(self._defaultlistcenter, self.streamList))
		self.keyLocked = False
		self.showInfos()
		self.login(False)

	def keyOK(self):
		exist = self['liste'].getCurrent()
		if self.keyLocked or exist == None:
			return
		auswahl = self['liste'].getCurrent()[0][0]
		url = self['liste'].getCurrent()[0][1]
		if auswahl == "Watchlist":
			self.session.open(serieseverWatchlist)
		else:
			self.session.open(serieseverParsing, auswahl, url)

	def login(self, msg=False):
		self.username = config.mediaportal.seriesever_userName.value
		self.password = config.mediaportal.seriesever_userPass.value
		if not self.username == "USERNAME" and not self.password == "PASSWORD":
			loginUrl = 'http://seriesever.com/service/login'
			loginData = {'username': self.username, 'password': self.password}
			getPage(loginUrl, method='POST', agent=glob_agent, postdata=urlencode(loginData), cookies=keckse, headers={'Referer': 'http://seriesever.com/', 'Content-Type': 'application/x-www-form-urlencoded', 'X-Requested-With': 'XMLHttpRequest'}).addCallback(self.loginCheck, msg).addErrback(self.dataError)
		else:
			self.setPremium(False)

	def loginCheck(self, data, msg):
		if re.search(self.username, data, re.S|re.I):
			url = "http://seriesever.com/premium.html"
			getPage(url, cookies=keckse, agent=glob_agent, headers={'Content-Type':'application/x-www-form-urlencoded', 'X-Requested-With': 'XMLHttpRequest'}).addCallback(self.checkPremium, msg).addErrback(self.dataError)
		else:
			self.setPremium(False)
			if msg:
				message = self.session.open(MessageBoxExt, _("Login failed!"), MessageBoxExt.TYPE_INFO, timeout=3)

	def checkPremium(self, data, msg):
		if re.search('<strong>Status.*?</strong>.*?Premium</p>', data, re.S|re.I):
			self.setPremium(True)
		else:
			self.setPremium(False)
			if msg:
				message = self.session.open(MessageBoxExt, _("You are not a Premium User!"), MessageBoxExt.TYPE_INFO, timeout=3)

	def setPremium(self, status):
		global premium
		premium = status
		if premium:
			self['title'].setText("Seriesever.com - Premium (1080p)")
		else:
			self['title'].setText("Seriesever.com")

	def loginSetup(self):
		if mp_globals.isDreamOS:
			self.session.openWithCallback(self.callBackSetup, serieseverSetupScreen, is_dialog=True)
		else:
			self.session.openWithCallback(self.callBackSetup, serieseverSetupScreen)

	def callBackSetup(self, answer):
		if answer:
			self.login(True)

	def keyCancel(self):
		url = "http://seriesever.com/service/logout.html"
		getPage(url, cookies=keckse, agent=glob_agent, headers={'Content-Type':'application/x-www-form-urlencoded', 'X-Requested-With': 'XMLHttpRequest'})
		self.close()

class serieseverParsing(MPScreen, ThumbsHelper):

	def __init__(self, session, genre, url):
		self.genre = genre
		self.url = url
		self.plugin_path = mp_globals.pluginPath
		self.skin_path = mp_globals.pluginPath + mp_globals.skinsPath
		path = "%s/%s/defaultListScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + mp_globals.skinFallback + "/defaultListScreen.xml"
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()
		MPScreen.__init__(self, session)
		ThumbsHelper.__init__(self)

		self["actions"] = ActionMap(["MP_Actions"], {
			"0": self.closeAll,
			"ok" : self.keyOK,
			"cancel": self.keyCancel,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft,
			"green"	: self.keyAdd
		}, -1)

		self['title'] = Label("Seriesever.com")
		self['ContentTitle'] = Label("%s" % self.genre)
		self['F2'] = Label(_("Add"))

		self.streamList = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.keyLocked = True
		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		self.streamList = []
		self.streamList.append(('Loading...', None))
		self.ml.setList(map(self._defaultlistcenter, self.streamList))
		self.streamList = []
		getPage(self.url, agent=glob_agent).addCallback(self.parseData).addErrback(self.dataError)

	def parseData(self, data):
		if self.genre == "Alle Serien":
			m = re.search('="collapse" href="#mc-seriens">(.*?)</ul>\s*</li>\s*</ul>\s*</li>\s*<li>', data, re.S)
			if m:
				for serie in re.finditer('<a data-toggle="collapse" href="#sc-.*?">(.*?)</a>.*?<li><a href="(.*?)staffel-', m.group(1), re.S):
					Title,Url = serie.groups()
					self.streamList.append((decodeHtml(Title), Url))

			if len(self.streamList) == 0:
				self.streamList.append(('Parsing Fehler !', None))

			self.ml.setList(map(self._defaultlistleft, self.streamList))
			self.ml.moveToIndex(0)
			self.keyLocked = False
		else:
			for serie in re.finditer('<img class="img" src="(http://seriesever.com/uploads/posters/.*?)".*?<a href="(http://seriesever.com/serien/.*?)".*?<a href="(http://seriesever.com/.*?)" title="(.*?)" class="seep">', data, re.S):
				Image,UrlSerie,UrlEpisode,Title = serie.groups()
				Image = Image.replace('thumb/','')
				self.streamList.append((decodeHtml(Title), UrlEpisode, Image, UrlSerie))

			if len(self.streamList) == 0:
				self.streamList.append((_('Parsing error!'), None))

			self.ml.setList(map(self._defaultlistleft, self.streamList))
			self.ml.moveToIndex(0)
			self.keyLocked = False
			self.showInfos()

	def keyOK(self):
		exist = self['liste'].getCurrent()
		if self.keyLocked or exist == None:
			return
		stream_name = self['liste'].getCurrent()[0][0]
		movie_url = self['liste'].getCurrent()[0][1]
		if self.genre == "Alle Serien":
			self.session.open(showStaffeln, stream_name, movie_url)
		else:
			self.session.open(showStreams, stream_name, movie_url)

	def showInfos(self):
		filmName = self['liste'].getCurrent()[0][0]
		self['name'].setText(filmName)
		if self.genre == "New Added":
			coverUrl = self['liste'].getCurrent()[0][2]
			CoverHelper(self['coverArt']).getCover(coverUrl)

	def keyAdd(self):
		exist = self['liste'].getCurrent()
		if self.keyLocked or exist == None:
			return
		if self.genre == "Alle Serien":
			movie_url = self['liste'].getCurrent()[0][1]
		else:
			movie_url = self['liste'].getCurrent()[0][3]
		stream_name = self['liste'].getCurrent()[0][0]
		fn = config.mediaportal.watchlistpath.value+"mp_se_watchlist"
		if not fileExists(fn):
			open(fn,"w").close()
		try:
			writePlaylist = open(fn, "a")
			writePlaylist.write('"%s" "%s"\n' % (stream_name, movie_url))
			writePlaylist.close()
			message = self.session.open(MessageBoxExt, _("Selection was added to the watchlist."), MessageBoxExt.TYPE_INFO, timeout=3)
		except:
			pass

class serieseverWatchlist(MPScreen, ThumbsHelper):

	def __init__(self, session):
		self.plugin_path = mp_globals.pluginPath
		self.skin_path = mp_globals.pluginPath + mp_globals.skinsPath
		path = "%s/%s/defaultListScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + mp_globals.skinFallback + "/defaultListScreen.xml"
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()
		MPScreen.__init__(self, session)
		ThumbsHelper.__init__(self)

		self["actions"] = ActionMap(["MP_Actions"], {
			"0": self.closeAll,
			"ok" : self.keyOK,
			"cancel": self.keyCancel,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft,
			"red" : self.keyDel
		}, -1)

		self['title'] = Label("Seriesever.com")
		self['ContentTitle'] = Label("Watchlist")
		self['F1'] = Label(_("Delete"))

		self.watchList = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.keyLocked = True
		self.onLayoutFinish.append(self.readWatchlist)

	def readWatchlist(self):
		self.keyLocked = True
		self.watchList = []
		self.wl_path = config.mediaportal.watchlistpath.value+"mp_se_watchlist"
		try:
			readStations = open(self.wl_path,"r")
			rawData = readStations.read()
			readStations.close()
		except:
			return

		for m in re.finditer('"(.*?)" "(.*?)"', rawData):
			(sName, sUrl) = m.groups()
			self.watchList.append((decodeHtml(sName), sUrl))
		self.watchList.sort()
		self.ml.setList(map(self._defaultlistleft, self.watchList))
		self.ml.moveToIndex(0)
		self.keyLocked = False
		self.showInfos()

	def keyOK(self):
		exist = self['liste'].getCurrent()
		if self.keyLocked or exist == None:
			return
		stream_name = self['liste'].getCurrent()[0][0]
		movie_url = self['liste'].getCurrent()[0][1]
		self.session.open(showStaffeln, stream_name, movie_url)

	def keyDel(self):
		exist = self['liste'].getCurrent()
		if self.keyLocked or exist == None:
			return

		i = self['liste'].getSelectedIndex()
		c = j = 0
		l = len(self.watchList)
		try:
			f1 = open(self.wl_path, 'w')
			while j < l:
				if j != i:
					(sName, sUrl) = self.watchList[j]
					f1.write('"%s" "%s"\n' % (sName, sUrl))
				j += 1
			f1.close()
			self.readWatchlist()
		except:
			pass

class showStaffeln(MPScreen):

	def __init__(self, session, stream_name, url):
		self.stream_name = stream_name
		self.url = url
		self.plugin_path = mp_globals.pluginPath
		self.skin_path = mp_globals.pluginPath + mp_globals.skinsPath
		path = "%s/%s/defaultGenreScreenCover.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + mp_globals.skinFallback + "/defaultGenreScreenCover.xml"
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()

		MPScreen.__init__(self, session)

		self["actions"] = ActionMap(["MP_Actions"], {
			"0": self.closeAll,
			"ok" : self.keyOK,
			"cancel": self.keyCancel
		}, -1)

		self['title'] = Label("Seriesever.com")
		self['ContentTitle'] = Label("Staffeln / Episode")
		self['name'] = Label(self.stream_name)

		self.staffeln = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.keyLocked = True
		self.coverUrl = None
		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		self.staffeln = []
		self.staffeln.append(('Loading...', None))
		self.ml.setList(map(self._defaultlistcenter, self.staffeln))
		self.staffeln = []
		getPage(self.url, agent=glob_agent).addCallback(self.parseData).addErrback(self.dataError)

	def parseData(self, data):
		cover = re.findall('<a class="cover" href=".*?" title=".*?"><img src="(http://seriesever.com/uploads/posters/.*?)"', data, re.S)
		if cover:
			self.coverUrl = cover[0].replace('thumb/','')
			CoverHelper(self['coverArt']).getCover(self.coverUrl)

		staffeln_raw = re.findall('<meta itemprop="numberOfEpisodes" content=".*?"/>.*?<a class="seep" href="(.*?)" title="(.*?)\sStaffel\s(\d+)\sEpisode.(\d+)" itemprop="url"><span itemprop="name">', data, re.S)
		if staffeln_raw:
			for Url,Title,Staffel,Episode in staffeln_raw:
				if int(Staffel) < 10:
					Staffel = "S0%s" % str(Staffel)
				else:
					Staffel = "S%s" % str(Staffel)
				if int(Episode) < 10:
					Episode = "E0%s" % str(Episode)
				else:
					Episode = "E%s" % str(Episode)
				Title = "%s%s" % (Staffel,Episode)
				self.staffeln.append((Title, Url))
			if len(self.staffeln) == 0:
				self.staffeln.append(('Parsing Fehler !', None))
			self.ml.setList(map(self._defaultlistcenter, self.staffeln))
			self.ml.moveToIndex(0)
			self.keyLocked = False
		else:
			self.staffeln.append(('Für diese Serie wurde noch keine Episoden veröffentlicht.', None))
			self.ml.setList(map(self._defaultlistcenter, self.staffeln))
			self.ml.moveToIndex(0)

	def keyOK(self):
		exist = self['liste'].getCurrent()
		if self.keyLocked or exist == None:
			return
		staffel_auswahl = self['liste'].getCurrent()[0][0]
		staffel_url = self['liste'].getCurrent()[0][1]
		self.session.open(showStreams, self.stream_name+" - "+staffel_auswahl, staffel_url)

class showStreams(MPScreen):

	def __init__(self, session, stream_name, url):
		self.stream_name = stream_name
		self.url = url
		self.plugin_path = mp_globals.pluginPath
		self.skin_path = mp_globals.pluginPath + mp_globals.skinsPath
		path = "%s/%s/defaultGenreScreenCover.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + mp_globals.skinFallback + "/defaultGenreScreenCover.xml"
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()

		MPScreen.__init__(self, session)

		self["actions"] = ActionMap(["MP_Actions"], {
			"0": self.closeAll,
			"ok" : self.keyOK,
			"cancel" : self.keyCancel
		}, -1)

		self['title'] = Label("Seriesever.com")
		self['ContentTitle'] = Label(_("Stream Selection"))
		self['name'] = Label(self.stream_name)

		self.streamList = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.keyLocked = True
		self.coverUrl = None
		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		CoverHelper(self['coverArt']).getCover(self.coverUrl)
		self.streamList = []
		self.streamList.append(('Loading...', None))
		self.ml.setList(map(self._defaultlistcenter, self.streamList))
		self.streamList = []
		getPage(self.url, agent=glob_agent).addCallback(self.getVideoID).addErrback(self.dataError)

	def getVideoID(self, data):
		cover = re.findall('<link rel="image_src" href="(.*?)"', data, re.S)
		if cover:
			self.coverUrl = cover[0]
			CoverHelper(self['coverArt']).getCover(self.coverUrl)
		url = "http://seriesever.com/service/get_video_part"
		videoID = re.findall('var\svideo_id\s{0,2}=\s"(.*?)"', data)
		videoReso = re.findall('<li><a href="#" class="changePart" data-part="(.*?)">', data, re.S)
		if videoID:
			self.videoID = videoID[0]
			self.videoReso = videoReso[0]
			print self.videoID, self.videoReso
			if "720p" in self.videoReso:
				post_data = urllib.urlencode({'page': '0', 'part_name': '720p', 'video_id': self.videoID})
				getPage(url, method='POST', postdata=post_data, agent=glob_agent, headers={'Content-Type':'application/x-www-form-urlencoded', 'X-Requested-With': 'XMLHttpRequest'}).addCallback(self.parseData, "720p").addErrback(self.dataError)
			if "1080p" in self.videoReso:
				post_data = urllib.urlencode({'page': '0', 'part_name': '1080p', 'video_id': self.videoID})
				if premium:
					getPage(url, method='POST', cookies=keckse, postdata=post_data, agent=glob_agent, headers={'Content-Type':'application/x-www-form-urlencoded', 'X-Requested-With': 'XMLHttpRequest'}).addCallback(self.parseData, "1080p").addErrback(self.dataError)
				else:
					getPage(url, method='POST', postdata=post_data, agent=glob_agent, headers={'Content-Type':'application/x-www-form-urlencoded', 'X-Requested-With': 'XMLHttpRequest'}).addCallback(self.parseData, "1080p").addErrback(self.dataError)
			if "en-sub" in self.videoReso:
				post_data = urllib.urlencode({'page': '0', 'part_name': 'en-sub', 'video_id': self.videoID})
				getPage(url, method='POST', postdata=post_data, agent=glob_agent, headers={'Content-Type':'application/x-www-form-urlencoded', 'X-Requested-With': 'XMLHttpRequest'}).addCallback(self.parseData, "en-sub").addErrback(self.dataError)
			if "de-sub" in self.videoReso:
				post_data = urllib.urlencode({'page': '0', 'part_name': 'de-sub', 'video_id': self.videoID})
				getPage(url, method='POST', postdata=post_data, agent=glob_agent, headers={'Content-Type':'application/x-www-form-urlencoded', 'X-Requested-With': 'XMLHttpRequest'}).addCallback(self.parseData, "de-sub").addErrback(self.dataError)
		else:
			self.streamList.append(('No VideoID found.', None))
			self.ml.setList(map(self._defaultlistcenter, self.streamList))

	def parseData(self, data, video_reso):
		parts = re.findall('"part_count":(\d+),"', data)
		if parts:
			parts = parts[0]
			if parts > 0:
				for i in range(0,int(parts)):
					self.streamList.append(('Stream '+str(i+1)+' - '+video_reso, str(i)))
			else:
				self.streamList.append(('Keine Streams in '+video_reso+'vorhanden !', None))
			self.ml.setList(map(self._defaultlistcenter, self.streamList))
			self.ml.moveToIndex(0)
			self.keyLocked = False
		else:
			self.streamList.append(('Fehler auf der Webseite !', None))
			self.ml.setList(map(self._defaultlistcenter, self.streamList))
			self.ml.moveToIndex(0)

	def keyOK(self):
		exist = self['liste'].getCurrent()
		if self.keyLocked or exist == None:
			return
		streamName = self['liste'].getCurrent()[0][0]
		streamID = self['liste'].getCurrent()[0][1]
		print streamName, streamID
		url = "http://seriesever.com/service/get_video_part"
		if re.search('en-sub', streamName):
			post_data = urllib.urlencode({'page': streamID, 'part_name': 'en-sub', 'video_id': self.videoID})
			getPage(url, method='POST', agent=glob_agent, postdata=post_data, headers={'Content-Type':'application/x-www-form-urlencoded', 'X-Requested-With': 'XMLHttpRequest'}).addCallback(self.getStreamData).addErrback(self.dataError)
		if re.search('de-sub', streamName):
			post_data = urllib.urlencode({'page': streamID, 'part_name': 'de-sub', 'video_id': self.videoID})
			getPage(url, method='POST', agent=glob_agent, postdata=post_data, headers={'Content-Type':'application/x-www-form-urlencoded', 'X-Requested-With': 'XMLHttpRequest'}).addCallback(self.getStreamData).addErrback(self.dataError)
		if premium:
			post_data = urllib.urlencode({'page': streamID, 'part_name': '1080p', 'video_id': self.videoID})
			getPage(url, method='POST', agent=glob_agent, postdata=post_data, cookies=keckse, headers={'Content-Type':'application/x-www-form-urlencoded', 'X-Requested-With': 'XMLHttpRequest'}).addCallback(self.getStreamData).addErrback(self.dataError)
		else:
			post_data = urllib.urlencode({'page': streamID, 'part_name': '720p', 'video_id': self.videoID})
			getPage(url, method='POST', agent=glob_agent, postdata=post_data, headers={'Content-Type':'application/x-www-form-urlencoded', 'X-Requested-With': 'XMLHttpRequest'}).addCallback(self.getStreamData).addErrback(self.dataError)

	def getStreamData(self, data):
		if re.search('stream2k.tv', data):
			url = re.findall('code":".iframe src=."(.*?)" width', data)
			if url:
				url = urllib.unquote(url[0].replace('\\',''))
				getPage(url, agent=glob_agent).addCallback(self.getStream, url).addErrback(self.dataError)
			else:
				self.session.open(MessageBoxExt, _("Stream not found, try another Stream Hoster."), MessageBoxExt.TYPE_INFO, timeout=5)
		elif re.search('vkpass.com', data):
			url = re.findall('code":".iframe src=."(.*?)" width', data)
			if url:
				url = urllib.unquote(url[0].replace('\\',''))
				headers_data = {'Content-Type':'application/x-www-form-urlencoded',
								'Cookie': 'lang=DE; 09ffa5fd85da835056d6f324eaf0927f=OK',
								'Referer': self.url
								}
				getPage(url, agent=glob_agent, headers=headers_data).addCallback(self.getStream, url).addErrback(self.dataError)

		elif re.search('picasaweb.google.com', data):
			url = re.findall('src=."(.*?)"', data)
			if url:
				url = urllib.unquote(url[0].replace('\\',''))
				getPage(url, agent=glob_agent).addCallback(self.getStream, url).addErrback(self.dataError)
			else:
				self.session.open(MessageBoxExt, _("Stream not found, try another Stream Hoster."), MessageBoxExt.TYPE_INFO, timeout=5)

		else:
			code = re.findall('"code":"(.*?)"', data)
			if code:
				code = code[0]
				url = "http://se2.seriesever.net/vk_video/video.php?action=get&url=%s" % urllib.quote(code)
				getPage(url, agent=glob_agent).addCallback(self.getStream, url).addErrback(self.dataError)
			else:
				self.session.open(MessageBoxExt, _("Stream not found, try another Stream Hoster."), MessageBoxExt.TYPE_INFO, timeout=5)

	def getStream(self, data, url):
		if re.search('http://stream2k.tv', url, re.S):
			streams = re.findall('"file":"(.*?)"', data, re.S)
			if streams:
				stream_url = streams[0].replace('\\','')
				mp_globals.player_agent = glob_agent
				self.session.open(SimplePlayer, [(self.stream_name, stream_url, self.coverUrl)], cover=True, showPlaylist=False, ltype='seriesever')
			else:
				self.session.open(MessageBoxExt, _("Stream not found, try another Stream Hoster."), MessageBoxExt.TYPE_INFO, timeout=5)
		elif re.search('vkpass.com', url, re.S):
			streams = re.findall('{file:"(.*?)",', data, re.S)
			if streams:
				stream_url = streams[0].replace('\\','')
				mp_globals.player_agent = glob_agent
				self.session.open(SimplePlayer, [(self.stream_name, stream_url, self.coverUrl)], cover=True, showPlaylist=False, ltype='seriesever')
			else:
				self.session.open(MessageBoxExt, _("Stream not found, try another Stream Hoster."), MessageBoxExt.TYPE_INFO, timeout=5)
		elif re.search('picasaweb.google.com', url, re.S):
			streams = re.findall('"url":"(https://redirector.googlevideo.com.*?)"', data, re.S)
			if streams:
				stream_url = streams[-1].replace('\\','')
				mp_globals.player_agent = glob_agent
				self.session.open(SimplePlayer, [(self.stream_name, stream_url, self.coverUrl)], cover=True, showPlaylist=False, ltype='seriesever')
		else:
			stream_raw = re.findall('"(.*?\/[0-9].mp4)"', data, re.S)
			if stream_raw:
				stream_url = stream_raw[-1].replace('\\','')
				mp_globals.player_agent = glob_agent
				self.session.open(SimplePlayer, [(self.stream_name, stream_url, self.coverUrl)], cover=True, showPlaylist=False, ltype='seriesever')
			else:
				self.session.open(MessageBoxExt, _("Stream not found, try another Stream Hoster."), MessageBoxExt.TYPE_INFO, timeout=5)

class serieseverSetupScreen(Screen, ConfigListScreenExt):

	def __init__(self, session):

		self.plugin_path = mp_globals.pluginPath
		self.skin_path = mp_globals.pluginPath + mp_globals.skinsPath
		path = "%s/%s/PluginUserDefault.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + mp_globals.skinFallback + "/PluginUserDefault.xml"
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()

		Screen.__init__(self, session)
		self['title'] = Label("Seriesever.com " + _("Setup"))
		self.setTitle("Seriesever.com " + _("Setup"))

		self.list = []
		ConfigListScreenExt.__init__(self, self.list)

		self.list.append(getConfigListEntry(_("Username:"), config.mediaportal.seriesever_userName))
		self.list.append(getConfigListEntry(_("Password:"), config.mediaportal.seriesever_userPass))
		self["config"].setList(self.list)

		self["setupActions"] = ActionMap(["MP_Actions"],
		{
			"ok":		self.saveConfig,
			"cancel":	self.exit
		}, -1)

	def saveConfig(self):
		for x in self["config"].list:
			x[1].save()
		configfile.save()
		self.close(True)

	def exit(self):
		self.close(False)