﻿# -*- coding: utf-8 -*-
from Plugins.Extensions.MediaPortal.plugin import _
from Plugins.Extensions.MediaPortal.resources.imports import *

class deluxemusicGenreScreen(MPScreen):

	def __init__(self, session):

		self.plugin_path = mp_globals.pluginPath
		self.skin_path =  mp_globals.pluginPath + mp_globals.skinsPath

		path = "%s/%s/defaultGenreScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + mp_globals.skinFallback + "/defaultGenreScreen.xml"

		with open(path, "r") as f:
			self.skin = f.read()
			f.close()

		MPScreen.__init__(self, session)

		self["actions"]  = ActionMap(["MP_Actions"], {
			"0"		: self.closeAll,
			"ok"    : self.keyOK,
			"cancel": self.keyCancel
		}, -1)

		self.lastservice = session.nav.getCurrentlyPlayingServiceReference()
		self.playing = False

		self.keyLocked = True
		self['title'] = Label("Deluxemusic.tv")
		self['ContentTitle'] = Label("Genre:")

		self.genreliste = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		self.genreliste = [('Deluxemusic Live',"http://deluxemusic.tv.cms.ipercast.net/?ContentId=349")]

		self.ml.setList(map(self._defaultlistcenter, self.genreliste))
		self.keyLocked = False

	def keyOK(self):
		if self.keyLocked:
			return
		deluxemusicName = self['liste'].getCurrent()[0][0]
		deluxemusicUrl = self['liste'].getCurrent()[0][1]

		print deluxemusicName, deluxemusicUrl
		getPage(deluxemusicUrl, headers={'Content-Type':'application/x-www-form-urlencoded'}).addCallback(self.loadPageData).addErrback(self.dataError)

	def loadPageData(self, data):
		url = re.findall('file: "(.*?)"', data, re.S)
		if url:
			getPage(url[0], headers={'Content-Type':'application/x-www-form-urlencoded'}).addCallback(self.getStream).addErrback(self.dataError)

	def getStream(self, data):
		rtmp_infos = re.findall('<location>(.*?)</location.*?<meta rel="streamer">(.*?)<', data, re.S)
		if rtmp_infos:
			if len(rtmp_infos[0]) == 2:
				(playpath, rtmp) = rtmp_infos[0]
				stream_url = "%s%s" % (rtmp, playpath)
				playlist = []
				playlist.append(("Deluxemusic.tv", stream_url))
				self.session.open(SimplePlayer, playlist, showPlaylist=False)