﻿# -*- coding: utf-8 -*-

from Plugins.Extensions.MediaPortal.plugin import _
from Plugins.Extensions.MediaPortal.resources.imports import *
import Queue
import threading
from Plugins.Extensions.MediaPortal.resources.youtubeplayer import YoutubePlayer
from Components.ProgressBar import ProgressBar

if fileExists('/usr/lib/enigma2/python/Plugins/Extensions/TMDb/plugin.pyo'):
	from Plugins.Extensions.TMDb.plugin import *
	TMDbPresent = True
elif fileExists('/usr/lib/enigma2/python/Plugins/Extensions/IMDb/plugin.pyo'):
	TMDbPresent = False
	IMDbPresent = True
	from Plugins.Extensions.IMDb.plugin import *
else:
	IMDbPresent = False
	TMDbPresent = False

IS_Version = "STREAMIT v1.15"

IS_siteEncoding = 'utf-8'

"""
	Tastenfunktionen in der Filmliste:
		Bouquet +/-				: Seitenweise blättern in 1 Schritten Up/Down
		'1', '4', '7',
		'3', 6', '9'			: blättern in 2er, 5er, 10er Schritten Down/Up
		Grün/Gelb				: Sortierung [A-Z] bzw. [IMDB]
		INFO					: anzeige der IMDB-Bewertung

	Stream Auswahl:
		Rot/Blau				: Die Beschreibung Seitenweise scrollen

"""

def streamitGenreListEntry(entry):
	return [entry,
		(eListboxPythonMultiContent.TYPE_TEXT, 20, 0, 860, mp_globals.fontsize + 2 * mp_globals.sizefactor, 0, RT_HALIGN_CENTER | RT_VALIGN_CENTER, entry[0])
		]
class showstreamitGenre(MPScreen):

	def __init__(self, session, mode):
		self.mode = mode
		self.plugin_path = mp_globals.pluginPath
		self.skin_path =  mp_globals.pluginPath + mp_globals.skinsPath

		path = "%s/%s/defaultGenreScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + mp_globals.skinFallback + "/defaultGenreScreen.xml"
		print path
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()

		MPScreen.__init__(self, session)

		self["actions"] = ActionMap(["OkCancelActions", "ShortcutActions", "WizardActions", "ColorActions", "SetupActions", "NumberActions", "MenuActions", "EPGSelectActions"], {
			"ok"    : self.keyOK,
			"0": self.closeAll,
			"cancel": self.keyCancel
		}, -1)

		self['title'] = Label(IS_Version)
		self['ContentTitle'] = Label("M e n ü")
		self['name'] = Label(_("Genre Selection"))
		self['F1'] = Label(_("Exit"))

		self.param_search = ""
		self.keyLocked = True
		self.genreListe = []
		self.chooseMenuList = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self.chooseMenuList.l.setFont(0, gFont('mediaportal', mp_globals.fontsize))
		self.chooseMenuList.l.setItemHeight(mp_globals.fontsize + 2 * mp_globals.sizefactor)
		self['liste'] = self.chooseMenuList

		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		print "ISteam.ws:"
		genreListe = []
		if self.mode == "porn":
			Genre = [
				("All", "http://streamit.ws/c/porn/page/")
				]
		else:
			Genre = [
				("Kino", "http://streamit.ws/c/ckino/page/"),
				("Neue Filme", "http://streamit.ws/c/filme/page/"),
				("HD Filme", "http://streamit.ws/tag/hd/page/"),
				("Suche...", "http://streamit.ws/?s=%s"),
				("Abenteuer", "http://streamit.ws/c/filme/abenteuer/page/"),
				("Action", "http://streamit.ws/c/filme/action/page/"),
				("Animation", "http://streamit.ws/c/filme/animation/page/"),
				("Anime", "http://streamit.ws/c/filme/anime/page/"),
				("Crime", "http://streamit.ws/c/filme/crime/page/"),
				("Dokumentation", "http://streamit.ws/c/filme/dokumentation/page/"),
				("Drama", "http://streamit.ws/c/filme/drama/page/"),
				("Family", "http://streamit.ws/c/filme/family/page/"),
				("Fantasy", "http://streamit.ws/c/filme/fantasy/page/"),
				("History", "http://streamit.ws/c/filme/history/page/"),
				("Horror", "http://streamit.ws/c/filme/horror/page/"),
				("Komödie", "http://streamit.ws/c/filme/komodie/page/"),
				("Mystery", "http://streamit.ws/c/filme/mystery/page/"),
				("Romance", "http://streamit.ws/c/filme/romance/page/"),
				("SciFi", "http://streamit.ws/c/filme/sci-fi/page/"),
				("Sport", "http://streamit.ws/c/filme/sport/page/"),
				("Thriller", "http://streamit.ws/c/filme/thriller/page/"),
				("War", "http://streamit.ws/c/filme/war/page/"),
				("Western", "http://streamit.ws/c/filme/western/page/")]

		for (Name,Url) in Genre:
			self.genreListe.append((Name,Url))

		self.chooseMenuList.setList(map(streamitGenreListEntry, self.genreListe))
		self.keyLocked = False


	def cb_Search(self, callback = None, entry = None):
		if callback != None:
			self.param_search = callback.strip()
			words = re.split('[^a-zA-Z0-9äÄöÖüÜß]+', self.param_search)
			s = ""
			j = len(words)
			i = 0
			if not j:
				return

			for word in words:
				i += 1
				if word != '':
					s += urllib.quote(word)
				if i < (j-1):
					s += '+'

			genreName = 'Videosuche: ' + self.param_search
			genreLink = self['liste'].getCurrent()[0][1] % s
			print genreLink
			self.session.open(streamitFilmListeScreen, genreLink, genreName)

	def keyOK(self):
		if self.keyLocked:
			return
		genreName = self['liste'].getCurrent()[0][0]
		genreLink = self['liste'].getCurrent()[0][1]
		print genreLink
		if 'Suche...' in genreName:
			self.session.openWithCallback(self.cb_Search, VirtualKeyBoardExt, title = (_("Enter search criteria")), text = self.param_search, is_dialog=True)
		else:
			self.session.open(streamitFilmListeScreen, genreLink, genreName)

def streamitFilmListEntry(entry):
	return [entry,
		(eListboxPythonMultiContent.TYPE_TEXT, 20, 0, 650, mp_globals.fontsize + 2 * mp_globals.sizefactor, 0, RT_HALIGN_LEFT | RT_VALIGN_CENTER, entry[0]),
		(eListboxPythonMultiContent.TYPE_TEXT, 660, 0, 160, mp_globals.fontsize + 2 * mp_globals.sizefactor, 0, RT_HALIGN_LEFT | RT_VALIGN_CENTER, entry[3])
		]
class streamitFilmListeScreen(MPScreen, ThumbsHelper):

	def __init__(self, session, genreLink, genreName):
		self.genreLink = genreLink
		self.genreName = genreName

		self.plugin_path = mp_globals.pluginPath
		self.skin_path =  mp_globals.pluginPath + mp_globals.skinsPath

		path = "%s/%s/defaultListScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + mp_globals.skinFallback + "/defaultListScreen.xml"

		print path
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()

		widgets_files = ('cover_widgets.xml',)
		self.skin = self.skin.replace('</screen>', '')
		for wf in widgets_files:
			path = "%s/%s/%s" % (self.skin_path, config.mediaportal.skin.value, wf)
			if not fileExists(path):
				path = self.skin_path + mp_globals.skinFallback + "/%s" % wf

			f = open(path, "r")
			for widget in f:
				self.skin += widget
			f.close()
		self.skin += '</screen>'

		MPScreen.__init__(self, session)
		ThumbsHelper.__init__(self)

		self["hdpic"] = Pixmap()
		self['rating10'] = ProgressBar()
		self['rating0'] = Pixmap()
		self["hdpic"].hide()

		self["actions"]  = ActionMap(["OkCancelActions", "ShortcutActions", "ColorActions", "SetupActions", "NumberActions", "MenuActions", "EPGSelectActions","DirectionActions"], {
			"ok"    : self.keyOK,
			"cancel": self.keyCancel,
			"5" : self.keyShowThumb,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft,
			"upUp" : self.key_repeatedUp,
			"rightUp" : self.key_repeatedUp,
			"leftUp" : self.key_repeatedUp,
			"downUp" : self.key_repeatedUp,
			"upRepeated" : self.keyUpRepeated,
			"downRepeated" : self.keyDownRepeated,
			"rightRepeated" : self.keyRightRepeated,
			"leftRepeated" : self.keyLeftRepeated,
			"nextBouquet" : self.keyPageUp,
			"prevBouquet" : self.keyPageDown,
			"1" : self.key_1,
			"3" : self.key_3,
			"4" : self.key_4,
			"6" : self.key_6,
			"7" : self.key_7,
			"9" : self.key_9,
			"0": self.closeAll,
			"yellow" : self.keySort,
			"red" :  self.keyTxtPageUp,
			"blue" :  self.keyTxtPageDown,
			"info" :  self.keyTMDbInfo
		}, -1)

		self.sortParStr = ["", "?orderby=modified&order=DESC", "?orderby=title&order=ASC"]
		self.genreTitle = "Filme in Genre "
		self.sortOrderStr = [" - Sort. Neueste Filme", " - Sort. Neueste Filme & Updates", " - Sortierung A-Z"]
		self.sortOrderStrGenre = ""
		self['title'] = Label(IS_Version)

		self['Page'] = Label(_("Page:"))
		self['F1'] = Label(_("Text-"))
		self['F3'] = Label(_("Sorting"))
		self['F4'] = Label(_("Text+"))

		self.tw_agent_hlp = TwAgentHelper(redir_agent=True)
		self.timerStart = False
		self.seekTimerRun = False
		self.eventL = threading.Event()
		self.eventH = threading.Event()
		self.eventP = threading.Event()
		self.filmQ = Queue.Queue(0)
		self.hanQ = Queue.Queue(0)
		self.picQ = Queue.Queue(0)
		self.updateP = 0
		self.keyLocked = True
		self.filmListe = []
		self.page = 0
		self.pages = 0;
		self.neueFilme = re.search('Neue Filme',self.genreName)
		self.sucheFilme = re.search('Videosuche',self.genreName)
		self.pornFilme = re.search('/porn',self.genreLink)
		if 'HD Filme' in self.genreName:
			self.streamTag = 'streamhd'
		else:
			self.streamTag = 'stream'
		self.setGenreStrTitle()

		self.chooseMenuList = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self.chooseMenuList.l.setFont(0, gFont('mediaportal', mp_globals.fontsize))
		self.chooseMenuList.l.setItemHeight(mp_globals.fontsize + 2 * mp_globals.sizefactor)
		self['liste'] = self.chooseMenuList

		self.onLayoutFinish.append(self.loadPage)

	def setGenreStrTitle(self):
		if not self.neueFilme and not self.sucheFilme:
			self.sortOrderStrGenre = self.sortOrderStr[mp_globals.streamit_sortOrder]
		else:
			self.sortOrderStrGenre = ""
		self['ContentTitle'].setText("%s%s%s" % (self.genreTitle,self.genreName,self.sortOrderStrGenre))

	def loadPage(self):
		print "loadPage:"
		if not self.sucheFilme:
			url = "%s%d%s" % (self.genreLink, self.page, self.sortParStr[mp_globals.streamit_sortOrder])
		else:
			url = self.genreLink

		if self.page:
			self['page'].setText("%d / %d" % (self.page,self.pages))

		self.filmQ.put(url)
		print "eventL ",self.eventL.is_set()
		if not self.eventL.is_set():
			self.eventL.set()
			self.loadPageQueued()
		else:
			self['name'].setText(_('Please wait...'))
			self['handlung'].setText("")
			self['coverArt'].hide()

		print "eventL ",self.eventL.is_set()

	def loadPageQueued(self):
		print "loadPageQueued:"
		self['name'].setText(_('Please wait...'))
		self['handlung'].setText("")
		self['coverArt'].hide()

		while not self.filmQ.empty():
			url = self.filmQ.get_nowait()
		print url
		self.tw_agent_hlp.getWebPage(url).addCallback(self.loadPageData).addErrback(self.dataError)

	def dataError(self, error):
		self.eventL.clear()
		print "dataError:"
		printl(error,self,"E")
		self.filmListe.append((_("No movies found!"),"","","", 0, False))
		self.chooseMenuList.setList(map(streamitFilmListEntry,	self.filmListe))

	def loadPageData(self, data):
		print "loadPageData:",len(data)

		self.filmListe = []
		if not self.pornFilme:
			l = len(data)
			a = 0
			while a < l:
				mg = re.search('<div id="divA">(.*?)</div>\s+</li>', data[a:], re.S)
				if mg:
					a += mg.end()
					m = re.search('<div class="voting".*?style="width:(\d+).*?<a href="(.*?)".*?title="(.*?)">.*?<img.*?src="(.*?)"', mg.group(1), re.S)
					if m:
						rating,url,name,imageurl = m.groups()
						if '/vrwr55.png' in mg.group(1):
							hd = True
						else:
							hd = False

						imdb = "IMDb: %.1f / 10" % (float(rating) / 10)
						self.filmListe.append((decodeHtml(name), url, imageurl, imdb, rating, hd))
				else:
					a = l
		else:
			print "Parse porn movies"
			filme = re.findall('<div class="cover">.*?<a href="(.*?)".*?title="(.*?)".*?data-src="(.*?)"', data, re.S)

			if filme:
				for	(url,name,imageurl) in filme:
					#print	"Url: ", url, "Name: ", name, "ImgUrl: ", imageurl
					self.filmListe.append((decodeHtml(name), url, imageurl, "", 0, False))

		if self.filmListe:
			print "Movies found !"
			if not self.pages:
				m = re.findall('<a class=\'page-numbers\'.*?>(.*?)</', data, re.S)
				if m:
					self.pages = int(m[-1])
				else:
					self.pages = 1

				self.page = 1
				print "Page: %d / %d" % (self.page,self.pages)
				self['page'].setText("%d / %d" % (self.page,self.pages))

			self.chooseMenuList.setList(map(streamitFilmListEntry,	self.filmListe))
			self.keyLocked = False
			self.th_ThumbsQuery(self.filmListe, 0, 1, 2, None, None, self.page, self.pages)
			self.loadPicQueued()
		else:
			print "No movies found !"
			self.filmListe.append((_("No movies found!"),"","","", 0, False))
			self.chooseMenuList.setList(map(streamitFilmListEntry,	self.filmListe))
			if self.filmQ.empty():
				self.eventL.clear()
			else:
				self.loadPageQueued()

	def loadPicQueued(self):
		print "loadPicQueued:"
		self.picQ.put(None)
		if not self.eventP.is_set():
			self.eventP.set()
			self.loadPic()
		print "eventP: ",self.eventP.is_set()

	def loadPic(self):
		print "loadPic:"

		if self.picQ.empty():
			self.eventP.clear()
			print "picQ is empty"
			return

		if self.eventH.is_set() or self.updateP:
			print "Pict. or descr. update in progress"
			print "eventH: ",self.eventH.is_set()
			print "eventP: ",self.eventP.is_set()
			print "updateP: ",self.updateP
			return

		while not self.picQ.empty():
			self.picQ.get_nowait()

		streamName = self['liste'].getCurrent()[0][0]
		self['name'].setText(streamName)
		streamPic = self['liste'].getCurrent()[0][2]
		streamUrl = self['liste'].getCurrent()[0][1]
		self.getHandlung(streamUrl)
		self.updateP = 1
		CoverHelper(self['coverArt'], self.showCoverExit).getCover(streamPic)
		rate = self['liste'].getCurrent()[0][4]
		hd = self['liste'].getCurrent()[0][5]
		if hd:
			self['hdpic'].show()
		else:
			self['hdpic'].hide()
		rating = int(rate)
		if rating > 100:
			rating = 100
		self['rating10'].setValue(rating)

	def dataErrorP(self, error):
		print "dataError:"
		printl(error,self,"E")
		self.ShowCoverNone()

	def getHandlung(self, url):
		print "getHandlung:"
		if url == None:
			print "No Infos found !"
			self['handlung'].setText(_("No information found."))
			return

		self.hanQ.put(url)
		if not self.eventH.is_set():
			self.eventH.set()
			self.getHandlungQeued()
		print "eventH: ",self.eventH.is_set()

	def getHandlungQeued(self):
		while not self.hanQ.empty():
			url = self.hanQ.get_nowait()
		#print url
		self.tw_agent_hlp.getWebPage(url).addCallback(self.setHandlung).addErrback(self.dataErrorH)

	def dataErrorH(self, error):
		self.eventH.clear()
		print "dataErrorH:"
		printl(error,self,"E")
		self['handlung'].setText(_("No information found."))

	def setHandlung(self, data):
		print "setHandlung:"

		m = re.findall('meta property="og:description".*?=\'(.*?)\' />', data)
		if m:
			self['handlung'].setText(decodeHtml(re.sub(r"\s+", " ", m[0])))
		else:
			print "No Infos found !"
			self['handlung'].setText(_("No information found."))

		if not self.hanQ.empty():
			self.getHandlungQeued()
		else:
			self.eventH.clear()
			self.loadPic()
		print "eventH: ",self.eventH.is_set()
		print "eventL: ",self.eventL.is_set()

	def showCoverExit(self):
		self.updateP = 0;
		if not self.filmQ.empty():
			self.loadPageQueued()
		else:
			self.eventL.clear()
			self.loadPic()

	def keyOK(self):
		if self.keyLocked or self.eventL.is_set():
			return

		streamLink = self['liste'].getCurrent()[0][1]
		streamName = self['liste'].getCurrent()[0][0]
		imageLink = self['liste'].getCurrent()[0][2]
		self.session.open(streamitStreams, streamLink, streamName, imageLink, self.streamTag)

	def keyUpRepeated(self):
		#print "keyUpRepeated"
		if self.keyLocked:
			return
		self['coverArt'].hide()
		self['liste'].up()

	def keyDownRepeated(self):
		#print "keyDownRepeated"
		if self.keyLocked:
			return
		self['coverArt'].hide()
		self['liste'].down()

	def key_repeatedUp(self):
		#print "key_repeatedUp"
		if self.keyLocked:
			return
		self.loadPicQueued()

	def keyLeftRepeated(self):
		if self.keyLocked:
			return
		self['coverArt'].hide()
		self['liste'].pageUp()

	def keyRightRepeated(self):
		if self.keyLocked:
			return
		self['coverArt'].hide()
		self['liste'].pageDown()

	def keyPageDown(self):
		#print "keyPageDown()"
		if self.seekTimerRun:
			self.seekTimerRun = False
		self.keyPageDownFast(1)

	def keyPageUp(self):
		#print "keyPageUp()"
		if self.seekTimerRun:
			self.seekTimerRun = False
		self.keyPageUpFast(1)

	def keyPageUpFast(self,step):
		if self.keyLocked:
			return
		#print "keyPageUpFast: ",step
		oldpage = self.page
		if (self.page + step) <= self.pages:
			self.page += step
		else:
			self.page = 1
		#print "Page %d/%d" % (self.page,self.pages)
		if oldpage != self.page:
			self.loadPage()

	def keyPageDownFast(self,step):
		if self.keyLocked:
			return
		print "keyPageDownFast: ",step
		oldpage = self.page
		if (self.page - step) >= 1:
			self.page -= step
		else:
			self.page = self.pages
		#print "Page %d/%d" % (self.page,self.pages)
		if oldpage != self.page:
			self.loadPage()

	def key_1(self):
		#print "keyPageDownFast(2)"
		self.keyPageDownFast(2)

	def key_4(self):
		#print "keyPageDownFast(5)"
		self.keyPageDownFast(5)

	def key_7(self):
		#print "keyPageDownFast(10)"
		self.keyPageDownFast(10)

	def key_3(self):
		#print "keyPageUpFast(2)"
		self.keyPageUpFast(2)

	def key_6(self):
		#print "keyPageUpFast(5)"
		self.keyPageUpFast(5)

	def key_9(self):
		#print "keyPageUpFast(10)"
		self.keyPageUpFast(10)

	def keySort(self):
		if (self.keyLocked):
			return
		if not self.neueFilme:
			if mp_globals.streamit_sortOrder < 2:
				mp_globals.streamit_sortOrder += 1
			else:
				mp_globals.streamit_sortOrder = 0
			self.setGenreStrTitle()
			self.loadPage()

	def keyTMDbInfo(self):
		if not self.keyLocked and TMDbPresent:
			title = self['liste'].getCurrent()[0][0]
			self.session.open(TMDbMain, title)
		elif not self.keyLocked and IMDbPresent:
			title = self['liste'].getCurrent()[0][0]
			self.session.open(IMDB, title)

def streamitStreamListEntry(entry):
	if config.mediaportal.premiumize_use.value and re.search(mp_globals.premium_hosters, entry[0], re.S|re.I):
		premiumFarbe = int(config.mediaportal.premium_color.value, 0)
		return [entry,
			(eListboxPythonMultiContent.TYPE_TEXT, 20, 0, 860, mp_globals.fontsize + 2 * mp_globals.sizefactor, 0, RT_HALIGN_CENTER | RT_VALIGN_CENTER, entry[0]+entry[2]+entry[3], premiumFarbe)
			]
	else:
		return [entry,
			(eListboxPythonMultiContent.TYPE_TEXT, 20, 0, 860, mp_globals.fontsize + 2 * mp_globals.sizefactor, 0, RT_HALIGN_CENTER | RT_VALIGN_CENTER, entry[0]+entry[2]+entry[3])
			]

class streamitStreams(MPScreen, ConfigListScreen):

	def __init__(self, session, filmUrl, filmName, imageLink, streamTag):
		self.filmUrl = filmUrl
		self.filmName = filmName
		self.imageUrl = imageLink
		self.stream_tag = streamTag

		self.plugin_path = mp_globals.pluginPath
		self.skin_path =  mp_globals.pluginPath + mp_globals.skinsPath

		path = "%s/%s/defaultListScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + mp_globals.skinFallback + "/defaultListScreen.xml"

		print path
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()

		MPScreen.__init__(self, session)

		self["actions"]  = ActionMap(["OkCancelActions", "ShortcutActions", "EPGSelectActions", "WizardActions", "ColorActions", "NumberActions", "MenuActions", "MoviePlayerActions", "InfobarSeekActions"], {
			"red" 		: self.keyTxtPageUp,
			"blue" 		: self.keyTxtPageDown,
			"green" 	: self.keyTrailer,
			"ok"    	: self.keyOK,
			"info" 		: self.keyTMDbInfo,
			"0"			: self.closeAll,
			"cancel"	: self.keyCancel
		}, -1)

		self['title'] = Label(IS_Version)
		self['ContentTitle'] = Label(_("Stream Selection"))

		self['name'] = Label(filmName)
		self['F1'] = Label(_("Text-"))
		self['F4'] = Label(_("Text+"))

		self.trailerId = None
		self.tw_agent_hlp = TwAgentHelper(redir_agent=True)
		self.streamListe = []
		self.streamMenuList = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self.streamMenuList.l.setFont(0, gFont('mediaportal', mp_globals.fontsize))
		self.streamMenuList.l.setItemHeight(mp_globals.fontsize + 2 * mp_globals.sizefactor)
		self['liste'] = self.streamMenuList
		self.keyLocked = True
		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		print "loadPage:"
		streamUrl = self.filmUrl
		#print "FilmUrl: %s" % self.filmUrl
		#print "FilmName: %s" % self.filmName
		self.streamListe.append((_('Please wait...'),"","",""))
		self.streamMenuList.setList(map(streamitStreamListEntry, self.streamListe))
		self.tw_agent_hlp.getWebPage(streamUrl).addCallback(self.parseData).addErrback(self.dataError)

	def parseData(self, data):
		print "parseData:"
		m = re.search('<div id="streamhd">(.*?)</center></div>\n</div>', data, re.S)
		if m:
			streamshd = re.findall('<a href="(.*?)".*?value="(.*?)"', m.group(1).replace('\n', ''))
		else:
			streamshd = None

		m = re.search('<div id="stream">(.*?)</center></div>\n</div>', data, re.S)
		if not m:
			m = re.search('<strong><h2>Hoster:</h2></strong>(.*?)</div>',data, re.S)
		if m:
			streams = re.findall('<a href="(.*?)".*?value="(.*?)"', m.group(1).replace('\n', ''))
		else:
			streams = None

		m = re.search('href="http://www.youtube.com/(.*?)\?', data)
		if m:
			s = m.group(1).split('/')
			try:
				self.trailerId = m.group(1).split('/')[-1]
			except:
				pass
			else:
				self['F2'].setText('Trailer')

		mdesc = re.search('(Bild: ).*?<B>(.*?)</B>.*?(Ton: ).*?<B>(.*?)</B>',data, re.S)
		if mdesc:
			desc = mdesc.group(1) + mdesc.group(2) + '   ' + mdesc.group(3) + mdesc.group(4) + '   '
		else:
			desc = ''

		mdesc = re.search('<b>(Jahr:)</b>.*?">(.*?)</.*?<b>(Länge:)</b>.*?">(.*?)</', data, re.S)
		if mdesc:
			desc += mdesc.group(1) + mdesc.group(2) + '  ' + mdesc.group(3) + mdesc.group(4) + '\n\n'
		elif desc:
			desc += '\n'

		mdesc = re.search('category tag">.*?</table>(.*?)<br><br>',data, re.S)
		if mdesc:
			print "Descr. found"
			desc += re.sub('<.*?>', '', mdesc.group(1).replace('\n',''), re.S).replace('&nbsp;','').strip()
		else:
			desc += "Keine weiteren Info's !"

		self.streamListe = []
		if streamshd:
			print "HD Streams found"
			for (isUrl,isStream) in streamshd:
				if isSupportedHoster(isStream, True):
					streamPart = ''
					isUrl = isUrl.replace('\n','')
					isUrl = isUrl.replace('\r','')
					print isUrl
					print isStream,streamPart
					self.streamListe.append((isStream,isUrl,streamPart,' (HD)'))
				else:
					print "No supported hoster:"
					print isStream
					print isUrl

		if streams:
			print "SD Streams found"
			for (isUrl,isStream) in streams:
				if isSupportedHoster(isStream, True):
					streamPart = ''
					isUrl = isUrl.replace('\n','')
					isUrl = isUrl.replace('\r','')
					print isUrl
					print isStream,streamPart
					if not [1 for item in self.streamListe if item[1] == isUrl]:
						self.streamListe.append((isStream,isUrl,streamPart,''))
				else:
					print "No supported hoster:"
					print isStream
					print isUrl

		if self.streamListe:
			self.keyLocked = False
		else:
			print "No Streams found"
			self.streamListe.append(("No streams found!","","",""))

		self.streamMenuList.setList(map(streamitStreamListEntry, self.streamListe))
		self['handlung'].setText(decodeHtml(desc))
		print "imageUrl: ",self.imageUrl
		CoverHelper(self['coverArt']).getCover(self.imageUrl)

	def dataError(self, error):
		print "dataError:"
		printl(error,self,"E")
		self.streamListe.append(("Data error!","","",""))
		self.streamMenuList.setList(map(streamitStreamListEntry, self.streamListe))

	def got_link(self, stream_url):
		print "got_link:"
		if stream_url:
			title = self.filmName + self['liste'].getCurrent()[0][2]
			self.session.open(SimplePlayer, [(title, stream_url, self.imageUrl)], cover=True, showPlaylist=False, ltype='streamit')

	def keyTrailer(self):
		if self.trailerId:
			self.session.open(
				YoutubePlayer,
				[(self.filmName+' - Trailer', self.trailerId, self.imageUrl)],
				playAll = False,
				showPlaylist=False,
				showCover=True
				)

	def keyTMDbInfo(self):
		if TMDbPresent:
			self.session.open(TMDbMain, self.filmName)
		elif IMDbPresent:
			self.session.open(IMDB, self.filmName)

	def keyOK(self):
		if self.keyLocked:
			return
		streamLink = self['liste'].getCurrent()[0][1]
		print streamLink
		get_stream_link(self.session).check_link(streamLink, self.got_link)
