﻿# -*- coding: utf-8 -*-

from Plugins.Extensions.MediaPortal.plugin import _
from Plugins.Extensions.MediaPortal.resources.imports import *
import Queue
import threading
from Plugins.Extensions.MediaPortal.resources.menuhelper import MenuHelper
from Plugins.Extensions.MediaPortal.resources.youtubeplayer import YoutubePlayer

if fileExists('/usr/lib/enigma2/python/Plugins/Extensions/TMDb/plugin.pyo'):
	from Plugins.Extensions.TMDb.plugin import *
	TMDbPresent = True
elif fileExists('/usr/lib/enigma2/python/Plugins/Extensions/IMDb/plugin.pyo'):
	TMDbPresent = False
	IMDbPresent = True
	from Plugins.Extensions.IMDb.plugin import *
else:
	IMDbPresent = False
	TMDbPresent = False

SKTO_Version = "Silverkino.to v0.93"

SKTO_siteEncoding = 'utf-8'

"""
Sondertastenbelegung:

Genre Auswahl:
	KeyCancel		: Menu Up / Exit
	KeyOK			: Menu Down / Select

Doku Auswahl:
	Bouquet +/-				: Seitenweise blättern in 1er Schritten Up/Down
	'1', '4', '7',
	'3', 6', '9'			: blättern in 2er, 5er, 10er Schritten Down/Up
	Rot/Blau				: Die Beschreibung Seitenweise scrollen

Stream Auswahl:
	Rot/Blau				: Die Beschreibung Seitenweise scrollen
"""
def SKTO_menuListentry(entry):
	return [entry,
		(eListboxPythonMultiContent.TYPE_TEXT, 20, 0, 860, mp_globals.fontsize + 2 * mp_globals.sizefactor, 0, RT_HALIGN_CENTER | RT_VALIGN_CENTER, entry[0])
		]

class show_SKTO_Genre(MenuHelper):

	def __init__(self, session):
		baseUrl = "http://silverkino.to"
		MenuHelper.__init__(self, session, 0, None, baseUrl, "", SKTO_menuListentry)

		self['title'] = Label(SKTO_Version)
		self['ContentTitle'] = Label("Genres")
		self.param_qr = ''

		self.onLayoutFinish.append(self.mh_initMenu)

	def mh_parseCategorys(self, data):
		print 'mh_parseCategorys:'
		menu = []
		for m in re.finditer('class="head">(.*?):</', data):
			menu.append((0, '/?let=', m.group(1)))

		menu.append((0, '', 'Filme'))
		m = re.search('<div id="dropmenu1"(.*?)</div>', data, re.S)
		for me in re.finditer('href="http://silverkino.to(.*?)">(.*?)</a', m.group(1)):
			u, n = me.groups()
			menu.append((1, u, n))

		menu.append((0, '', 'Serien'))
		menu.append((1, '', 'A-Z'))
		for c in (list(map(chr, range(ord('A'), ord('Z')+1))) + list(map(chr, range(ord('0'), ord('9')+1)))):
			menu.append((2, '/movies.php?cat=4&let=%s' % c, c))

		m = re.search('<div id="dropmenu4"(.*?)</div>', data, re.S)
		for me in re.finditer('href="http://silverkino.to(.*?)">(.*?)</a', m.group(1)):
			u, n = me.groups()
			menu.append((1, u, n))

		menu.append((0, '/search.php?', 'Suche...'))

		self.mh_genMenu2(menu)

	def mh_callGenreListScreen(self):
		if re.search('Suche...', self.mh_genreTitle):
			self.paraQuery()
		else:
			genreurl = self.mh_baseUrl+self.mh_genreUrl[self.mh_menuLevel]
			print 'GenreURL:',genreurl
			self.session.open(SKTO_FilmListeScreen, self.mh_baseUrl+'/?let=', genreurl, self.mh_genreTitle)

	def paraQuery(self):
		self.param_qr = ''
		self.session.openWithCallback(self.cb_paraQuery, VirtualKeyBoardExt, title = (_("Enter search criteria")), text = self.param_qr, is_dialog=True)

	def cb_paraQuery(self, callback = None, entry = None):
		if callback != None:
			self.param_qr = callback.strip()
			if self.param_qr:
				search_form={
					'src' : self.param_qr,
					'what' : '3',
					'where' : '1',
					'start_date' : '1900',
					'end_date' : str(datetime.datetime.now().year),
					'start_rating' : '1',
					'end_rating' : '10',
					'button' : 'Suche'
					}
				genreurl = self.mh_baseUrl+self.mh_genreUrl[self.mh_menuLevel]
				self.session.open(SKTO_FilmListeScreen, self.mh_baseUrl+'/?let=', genreurl, self.mh_genreTitle, searchForm=search_form)

def SKTO_FilmListEntry(entry):
	return [entry,
		(eListboxPythonMultiContent.TYPE_TEXT, 20, 0, 860, mp_globals.fontsize + 2 * mp_globals.sizefactor, 0, RT_HALIGN_LEFT | RT_VALIGN_CENTER, entry[0])
		]

class SKTO_FilmListeScreen(MPScreen, ThumbsHelper):
	baseUrl = 'http://silverkino.to/'

	def __init__(self, session, genreBaseURL, genreLink, genreName, searchForm=None):
		self.genreLink = genreLink
		self.genreName = genreName
		self.searchForm = searchForm

		self.plugin_path = mp_globals.pluginPath
		self.skin_path =  mp_globals.pluginPath + mp_globals.skinsPath
		path = "%s/%s/defaultListScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + mp_globals.skinFallback + "/defaultListScreen.xml"
		print path
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()
		MPScreen.__init__(self, session)
		ThumbsHelper.__init__(self)

		self["actions"]  = ActionMap(["OkCancelActions", "ShortcutActions", "ColorActions", "SetupActions", "NumberActions", "MenuActions", "EPGSelectActions","DirectionActions"], {
			"ok"    : self.keyOK,
			"cancel": self.keyCancel,
			"5" : self.keyShowThumb,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft,
			"upUp" : self.key_repeatedUp,
			"rightUp" : self.key_repeatedUp,
			"leftUp" : self.key_repeatedUp,
			"downUp" : self.key_repeatedUp,
			"upRepeated" : self.keyUpRepeated,
			"downRepeated" : self.keyDownRepeated,
			"rightRepeated" : self.keyRightRepeated,
			"leftRepeated" : self.keyLeftRepeated,
			"nextBouquet" : self.keyPageUp,
			"prevBouquet" : self.keyPageDown,
			"1" : self.key_1,
			"3" : self.key_3,
			"4" : self.key_4,
			"6" : self.key_6,
			"7" : self.key_7,
			"9" : self.key_9,
			"0"	: self.closeAll,
			"yellow" : self.keySort,
			"blue" :  self.keyTxtPageDown,
			"red" :  self.keyTxtPageUp,
			"info" :  self.keyTMDbInfo
		}, -1)

		self.sortOrderStr = [("(Newest)", "&sort=id"), ("(Most Viewed)", "&sort=views"), ("(IMDb)", "&sort=imdb_rating"), ("(Most Discussed)", "&sort=comments")]

		self.searchMovies = searchForm != None
		self['title'] = Label(SKTO_Version)
		self['F1'] = Label(_("Text-"))
		if self.searchMovies or not 'let=' in self.genreLink:
			self['F3'] = Label(_("Sorting"))
		self['F4'] = Label(_("Text+"))
		self['Page'] = Label(_("Page:"))

		self.filmQ = Queue.Queue(0)
		self.hanQ = Queue.Queue(0)
		self.picQ = Queue.Queue(0)
		self.updateP = 0
		self.eventL = threading.Event()
		self.eventP = threading.Event()
		self.keyLocked = True
		self.dokusListe = []
		self.page = 0
		self.pages = 0;
		self.newMovies = genreBaseURL == genreLink

		self.setGenreStrTitle()

		self.chooseMenuList = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self.chooseMenuList.l.setFont(0, gFont('mediaportal', mp_globals.fontsize))
		self.chooseMenuList.l.setItemHeight(mp_globals.fontsize + 2 * mp_globals.sizefactor)
		self['liste'] = self.chooseMenuList

		self.onLayoutFinish.append(self.loadPage)

	def setGenreStrTitle(self):
		if self.searchMovies or 'let=' in self.genreLink:
			self['ContentTitle'].setText(self.genreName)
		else:
			self['ContentTitle'].setText("%s %s" % (self.genreName, self.sortOrderStr[mp_globals.skto_sortOrder][0]))

	def loadPage(self):
		print "loadPage:"
		if self.page:
			url = '%s&pag=%d' % (self.genreLink, (self.page - 1) * 16)
		else:
			url = self.genreLink + '&pag=0'

		if not 'let=' in self.genreLink and not self.searchMovies:
			url += '&%s' % self.sortOrderStr[mp_globals.skto_sortOrder][1]

		if self.page:
			self['page'].setText("%d / %d" % (self.page,self.pages))
		self.filmQ.put(url)
		if not self.eventL.is_set():
			self.eventL.set()
			self.loadPageQueued()
		print "eventL ",self.eventL.is_set()

	def loadPageQueued(self):
		print "loadPageQueued:"
		self['name'].setText(_('Please wait...'))
		while not self.filmQ.empty():
			url = self.filmQ.get_nowait()
		print url
		if not self.searchMovies:
			twAgentGetPage(url).addCallback(self.loadPageData).addErrback(self.dataError)
		else:
			twAgentGetPage(url, method='POST', postdata=urlencode(self.searchForm), headers={'Content-Type':'application/x-www-form-urlencoded'}).addCallback(self.loadPageData).addErrback(self.dataError)

	def dataError(self, error):
		self.eventL.clear()
		print "dataError:"
		printl(error,self,"E")
		self.dokusListe.append((_("No movies / series found!"),"","",""))
		self.chooseMenuList.setList(map(SKTO_FilmListEntry, self.dokusListe))

	def loadPageData(self, data):
		print "loadPageData:",len(data)
		self.dokusListe = []
		if self.newMovies:
			m = re.search('class="head">%s:</span>(.*?)</a>\s+</div>' % self.genreName, data, re.S)
		else:
			m = re.search('id="movie_list">(.*?)id="paging">', data, re.S)
		if m:
			for me in re.finditer('href="(.*?)".+?_info">(.*?)<br />.+?Views: (.*?)<br />.+?Länge: (.*?)<br />.+?IMDB rating: (.*?)<br />.+?Upload\w*: (.*?) </div>.+?<img src="(.*?)"', m.group(1), re.S):
				url, name, views, laenge, imdb, uploaded, img = me.groups()
				infos = (views, laenge.replace('min', ' Min.'), imdb, uploaded)
				name = re.sub(' ( +)', ' ', name.strip())
				self.dokusListe.append((decodeHtml(name), self.baseUrl+url, self.baseUrl+img, infos))

			if not self.pages:
				m = re.search('id="paging">.+pag=(\d+).*?">>></a>', data)
				try:
					pages = int(m.group(1)) / 16 + 1
				except:
					pages = 1
				self.pages = min(pages,999)
			if not self.page:
				self.page = 1
			print "Page: %d / %d" % (self.page,self.pages)

		if len(self.dokusListe):
			self['page'].setText("%d / %d" % (self.page,self.pages))
			self.chooseMenuList.setList(map(SKTO_FilmListEntry, self.dokusListe))
			self.th_ThumbsQuery(self.dokusListe, 0, 1, 2, None, None, self.page, self.pages)
			self.loadPicQueued()
		else:
			print "No videos found !"
			print data
			self.dokusListe.append((_("No movies / series found!"),"","",""))
			self.chooseMenuList.setList(map(SKTO_FilmListEntry, self.dokusListe))
			if self.filmQ.empty():
				self.eventL.clear()
			else:
				self.loadPageQueued()

	def loadPic(self):
		print "loadPic:"
		if self.picQ.empty():
			self.eventP.clear()
			print "picQ is empty"
			return
		if self.updateP:
			print "Pict. or descr. update in progress"
			print "eventP: ",self.eventP.is_set()
			print "updateP: ",self.updateP
			return
		while not self.picQ.empty():
			self.picQ.get_nowait()
		streamName = self['liste'].getCurrent()[0][0]
		self['name'].setText(streamName)
		streamPic = self['liste'].getCurrent()[0][2]
		#print "streamName: ",streamName
		#print "streamPic: ",streamPic
		#print "streamUrl: ",streamUrl
		self.showInfos()
		self.updateP = 1
		CoverHelper(self['coverArt'], self.ShowCoverFileExit).getCover(streamPic)

	def showInfos(self):
		print "showInfos:"
		infos = self['liste'].getCurrent()[0][3]
		text = 'Views:\t%s\nLänge:\t%s\nIMDb:\t%s\nUploaded:\t%s' % (infos[0], infos[1], infos[2], infos[3])
		self['handlung'].setText(text)

	def ShowCoverFileExit(self):
		print "showCoverExitFile:"
		self.updateP = 0;
		self.keyLocked	= False
		if not self.filmQ.empty():
			self.loadPageQueued()
		else:
			self.eventL.clear()
			self.loadPic()

	def loadPicQueued(self):
		print "loadPicQueued:"
		self.picQ.put(None)
		if not self.eventP.is_set():
			self.eventP.set()
		self.loadPic()
		print "eventP: ",self.eventP.is_set()

	def keyOK(self):
		if (self.keyLocked|self.eventL.is_set()):
			return

		streamLink = self['liste'].getCurrent()[0][1]
		streamName = self['liste'].getCurrent()[0][0]
		imageLink = self['liste'].getCurrent()[0][2]
		self.session.open(SKTO_Streams, streamLink, streamName, imageLink)

	def keyUpRepeated(self):
		#print "keyUpRepeated"
		if self.keyLocked:
			return
		self['liste'].up()

	def keyDownRepeated(self):
		#print "keyDownRepeated"
		if self.keyLocked:
			return
		self['liste'].down()

	def key_repeatedUp(self):
		#print "key_repeatedUp"
		if self.keyLocked:
			return
		self.loadPicQueued()

	def keyLeftRepeated(self):
		if self.keyLocked:
			return
		self['liste'].pageUp()

	def keyRightRepeated(self):
		if self.keyLocked:
			return
		self['liste'].pageDown()

	def keyPageDown(self):
		#print "keyPageDown()"
		self.keyPageDownFast(1)

	def keyPageUp(self):
		#print "keyPageUp()"
		self.keyPageUpFast(1)

	def keyPageUpFast(self,step):
		if self.keyLocked:
			return
		#print "keyPageUpFast: ",step
		oldpage = self.page
		if (self.page + step) <= self.pages:
			self.page += step
		else:
			self.page = 1
		#print "Page %d/%d" % (self.page,self.pages)
		if oldpage != self.page:
			self.loadPage()

	def keyPageDownFast(self,step):
		if self.keyLocked:
			return
		print "keyPageDownFast: ",step
		oldpage = self.page
		if (self.page - step) >= 1:
			self.page -= step
		else:
			self.page = self.pages
		#print "Page %d/%d" % (self.page,self.pages)
		if oldpage != self.page:
			self.loadPage()

	def key_1(self):
		#print "keyPageDownFast(2)"
		self.keyPageDownFast(2)

	def key_4(self):
		#print "keyPageDownFast(5)"
		self.keyPageDownFast(5)

	def key_7(self):
		#print "keyPageDownFast(10)"
		self.keyPageDownFast(10)

	def key_3(self):
		#print "keyPageUpFast(2)"
		self.keyPageUpFast(2)

	def key_6(self):
		#print "keyPageUpFast(5)"
		self.keyPageUpFast(5)

	def key_9(self):
		#print "keyPageUpFast(10)"
		self.keyPageUpFast(10)

	def keySort(self):
		if self.keyLocked or 'let=' in self.genreLink or self.searchMovies:
			return
		if mp_globals.skto_sortOrder < (len(self.sortOrderStr) - 1):
			mp_globals.skto_sortOrder += 1
		else:
			mp_globals.skto_sortOrder = 0
		self.setGenreStrTitle()
		self.loadPage()

	def keyTMDbInfo(self):
		if not self.keyLocked and TMDbPresent:
			title = self['liste'].getCurrent()[0][0]
			self.session.open(TMDbMain, title)
		elif not self.keyLocked and IMDbPresent:
			title = self['liste'].getCurrent()[0][0]
			self.session.open(IMDB, title)

def SKTO_StreamListEntry(entry):
	if config.mediaportal.premiumize_use.value and re.search(mp_globals.premium_hosters, entry[0], re.S|re.I):
		premiumFarbe = int(config.mediaportal.premium_color.value, 0)
		return [entry,
			(eListboxPythonMultiContent.TYPE_TEXT, 20, 0, 860, mp_globals.fontsize + 2 * mp_globals.sizefactor, 0, RT_HALIGN_CENTER | RT_VALIGN_CENTER, entry[0], premiumFarbe)
			]
	else:
		return [entry,
			(eListboxPythonMultiContent.TYPE_TEXT, 20, 0, 860, mp_globals.fontsize + 2 * mp_globals.sizefactor, 0, RT_HALIGN_CENTER | RT_VALIGN_CENTER, entry[0])
			]

class SKTO_Streams(MPScreen, ConfigListScreen):
	baseUrl = 'http://silverkino.to/'

	def __init__(self, session, filmUrl, filmName, imageLink):
		self.filmUrl = filmUrl
		self.filmName = filmName
		self.imageUrl = imageLink

		self.plugin_path = mp_globals.pluginPath
		self.skin_path =  mp_globals.pluginPath + mp_globals.skinsPath

		path = "%s/%s/defaultListScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + mp_globals.skinFallback + "/defaultListScreen.xml"

		print path
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()

		MPScreen.__init__(self, session)

		self["actions"]  = ActionMap(["OkCancelActions", "ShortcutActions", "EPGSelectActions", "WizardActions", "ColorActions", "NumberActions", "MenuActions", "MoviePlayerActions", "InfobarSeekActions"], {
			"red" 		: self.keyTxtPageUp,
			"blue" 		: self.keyTxtPageDown,
			"green" 	: self.keyTrailer,
			"ok"    	: self.keyOK,
			"info" 		: self.keyTMDbInfo,
			"0"			: self.closeAll,
			"cancel"	: self.keyCancel
		}, -1)

		self['title'] = Label(SKTO_Version)
		self['ContentTitle'] = Label(_("Stream Selection"))

		self['F1'] = Label(_("Text-"))
		self['F4'] = Label(_("Text+"))

		self.trailerId = None
		self.tw_agent_hlp = TwAgentHelper(redir_agent=True)
		self.streamListe = []
		self.streamMenuList = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self.streamMenuList.l.setFont(0, gFont('mediaportal', mp_globals.fontsize))
		self.streamMenuList.l.setItemHeight(mp_globals.fontsize + 2 * mp_globals.sizefactor)
		self['liste'] = self.streamMenuList
		self.keyLocked = True
		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		print "loadPage:"
		streamUrl = self.filmUrl
		#print "FilmUrl: %s" % self.filmUrl
		#print "FilmName: %s" % self.filmName
		self.tw_agent_hlp.getWebPage(streamUrl).addCallback(self.parseData).addErrback(self.dataError)

	def parseData(self, data):
		print "parseData:"
		m = re.search('="og:title"\s+content="(.*?)"', data)
		if m:
			self.filmName = decodeHtml(m.group(1))
			self.filmName = re.sub(' ( +)', ' ', self.filmName)
		self['name'].setText(self.filmName)

		m = re.search('<strong>Länge:\s*</strong><br />(.*?)</',data, re.S)
		if m:
			infos = 'Länge:\t%s' % m.group(1).strip().replace('Minuten', 'Min.')
		else:
			infos = 'Länge:\tN/A'

		m = re.search('<strong>Qualität:\s*</strong><br />(.*?)</',data, re.S)
		if m:
			infos += '\tQualität:\t%s\n' % m.group(1).strip()
		else:
			infos += '\tQualität:\tN/A\n'

		m = re.search('<strong>Voice over:\s*</strong><br />(.*?)</',data, re.S)
		if m:
			infos += 'Sprache:\t%s' % m.group(1).strip()
		else:
			infos += 'Sprache:\tN/A'

		m = re.search('<strong>Imdb rating:\s*</strong><br />(.*?)</',data, re.S)
		if m:
			infos += '\tIMDb:\t%s\n' % m.group(1).strip()
		else:
			infos += '\tIMDb:\tN/A\n'

		m = re.search('<strong>Views:\s*</strong><br />(.*?)</',data, re.S)
		if m:
			infos += 'Views:\t%s' % m.group(1).strip()
		else:
			infos += 'Views:\tN/A'

		m = re.search('<strong>Upload datum:\s*</strong><br />(.*?)</',data, re.S)
		if m:
			infos += '\tUploaded:\t%s\n' % m.group(1).strip()
		else:
			infos += '\tUploaded:\tN/A\n'

		m = re.search('="og:description"\s+content="(.*?)"',data)
		if m:
			infos += decodeHtml(m.group(1))

		m = re.search('//www.youtube.*?com/(embed|v|p)/(.*?)(\?|" |&amp)', data)
		if m:
			self.trailerId = m.group(2)
			self['F2'].setText('Trailer')

		self.streamListe = []
		for m in re.finditer('class="link_share">.*?title="(.*?)">(.*?)</a.*?<a href="(watch.php.*?)"', data, re.S):
			(hoster1,hoster2,url) = m.groups()
			if hoster1:
				hoster = hoster1
			else:
				hoster = hoster2
			if isSupportedHoster(hoster, True):
				mh = re.search('( - \w+)', hoster)
				if mh:
					ep = mh.group(1)
				else:
					ep = ''
				self.streamListe.append((hoster,self.baseUrl+url,ep))

		if self.streamListe:
			self.keyLocked = False
		else:
			print "No Streams found"
			self.streamListe.append(("No streams found!","",""))

		self.streamMenuList.setList(map(SKTO_StreamListEntry, self.streamListe))
		self['handlung'].setText(infos)
		print "imageUrl: ",self.imageUrl
		CoverHelper(self['coverArt']).getCover(self.imageUrl)

	def dataError(self, error):
		print "dataError:"
		printl(error,self,"E")
		self.streamListe.append(("Read error !",""))
		self.streamMenuList.setList(map(SKTO_StreamListEntry, self.streamListe))

	def got_link(self, stream_url):
		print "got_link:"
		if not stream_url:
			message = self.session.open(MessageBoxExt, _("No supported streams found!"), MessageBoxExt.TYPE_INFO, timeout=3)
		else:
			title = self.filmName + self['liste'].getCurrent()[0][2]
			self.session.open(SimplePlayer, [(title, stream_url, self.imageUrl)], cover=True, showPlaylist=False, ltype='silverkino')

	def keyTrailer(self):
		if self.trailerId:
			self.session.open(
				YoutubePlayer,
				[(self.filmName+' - Trailer', self.trailerId, self.imageUrl)],
				playAll = False,
				showPlaylist=False,
				showCover=True
				)

	def keyTMDbInfo(self):
		if TMDbPresent:
			self.session.open(TMDbMain, self.filmName)
		elif IMDbPresent:
			self.session.open(IMDB, self.filmName)

	def keyOK(self):
		if self.keyLocked:
			return
		streamLink = self['liste'].getCurrent()[0][1]
		print streamLink
		self.tw_agent_hlp.getRedirectedUrl(streamLink).addCallback(self.getRedirected).addErrback(self.streamError)

	def getRedirected(self, streamLink):
		print 'getRedirected:',streamLink
		if 'silverkino.to' in streamLink:
			self.tw_agent_hlp.getWebPage(streamLink).addCallback(self.getLink).addErrback(self.streamError)
		else:
			print 'streamLink:',streamLink
			get_stream_link(self.session).check_link(streamLink, self.got_link)

	def getLink(self, data):
		print 'getLink:'
		streamLink = None
		if "og:video:url" in data:
			m = re.search('"og:video:url"\s+content="(.*?)"', data)
			if m:
				streamLink = m.group(1)
		elif "<iframe src=" in data:
			m = re.search('<iframe src="(.*?)"', data)
			if m:
				streamLink = m.group(1)

		if streamLink and not 'silverkino.to' in streamLink:
			print 'streamLink:',streamLink
			get_stream_link(self.session).check_link(streamLink, self.got_link)
		else:
			print 'No video url found!'
			print data
			self.got_link(None)

	def streamError(self, error):
		print "streamError:"
		printl(error,self,"E")
		self.got_link(None)