﻿# -*- coding: utf-8 -*-

from Plugins.Extensions.MediaPortal.plugin import _
from Plugins.Extensions.MediaPortal.resources.imports import *
import Queue
import threading
from Plugins.Extensions.MediaPortal.resources.menuhelper import MenuHelper

if fileExists('/usr/lib/enigma2/python/Plugins/Extensions/TMDb/plugin.pyo'):
	from Plugins.Extensions.TMDb.plugin import *
	TMDbPresent = True
elif fileExists('/usr/lib/enigma2/python/Plugins/Extensions/IMDb/plugin.pyo'):
	TMDbPresent = False
	IMDbPresent = True
	from Plugins.Extensions.IMDb.plugin import *
else:
	IMDbPresent = False
	TMDbPresent = False

C24TV_Version = "Cine24.tv v0.94"

C24TV_siteEncoding = 'utf-8'

"""
Sondertastenbelegung:

Genre Auswahl:
	KeyCancel		: Menu Up / Exit
	KeyOK			: Menu Down / Select

Doku Auswahl:
	Bouquet +/-				: Seitenweise blättern in 1er Schritten Up/Down
	'1', '4', '7',
	'3', 6', '9'			: blättern in 2er, 5er, 10er Schritten Down/Up
	Rot/Blau				: Die Beschreibung Seitenweise scrollen

Stream Auswahl:
	Rot/Blau				: Die Beschreibung Seitenweise scrollen
"""

search_form = {}

def C24TV_menuListentry(entry):
	return [entry,
		(eListboxPythonMultiContent.TYPE_TEXT, 20, 0, 860, mp_globals.fontsize + 2 * mp_globals.sizefactor, 0, RT_HALIGN_CENTER | RT_VALIGN_CENTER, entry[0])
		]

class show_C24TV_Genre(MenuHelper):

	def __init__(self, session):
		baseUrl = "http://www.cine24.tv"
		MenuHelper.__init__(self, session, 0, None, baseUrl, "", C24TV_menuListentry)

		self['title'] = Label(C24TV_Version)
		self['ContentTitle'] = Label("Genres")
		self.param_qr = ''

		self.onLayoutFinish.append(self.mh_initMenu)

	def mh_initMenu(self):
		self.mh_buildMenu(self.mh_baseUrl + '/search/genre')

	def mh_parseCategorys(self, data):
		print 'mh_parseCategorys:'
		menu = []
		genreUrl = ''
		menu.append((0, '', 'Aktuelle Filme'))
		menu.append((0, '', 'Filme'))
		m = re.search('<li><a href="#">Filme</a>(.*?)<li><a href="#">', data, re.S)
		for me in re.finditer('href="http://www.cine24.tv(.*?)">(.*?)</a', m.group(1)):
			u, n = me.groups()
			if not 'genre' in n.lower():
				menu.append((1, u, decodeHtml(n)))
		menu.append((1, '/movies/request', 'Filmwünsche'))

		menu.append((0, '', 'Serien'))
		m = re.search('<li><a href="#">Serien</a>(.*?)<li><a href="#">', data, re.S)
		for me in re.finditer('href="http://www.cine24.tv(.*?)">(.*?)</a', m.group(1)):
			u, n = me.groups()
			if not 'genre' in n.lower():
				menu.append((1, u, decodeHtml(n)))
		menu.append((1, '/tvshows/request', 'Serienwünsche'))

		menu.append((0, '', 'A-Z'))
		for c in (list(map(chr, range(ord('A'), ord('Z')+1))) + list(map(chr, range(ord('0'), ord('9')+1)))):
			menu.append((1, '/search/alpha/%s' % c, c))

		menu.append((0, '', 'Genres'))
		for m in re.finditer('<li style=.*?<a href="http://www.cine24.tv(.*?)">(.*?)</a> </li>', data):
			u, n = m.groups()
			menu.append((1, u, decodeHtml(n)))

		menu.append((0, '/search', 'Suche...'))
		self.mh_genMenu2(menu)

	def mh_callGenreListScreen(self):
		search_form.clear()
		if re.search('Suche...', self.mh_genreTitle):
			self.paraQuery()
		else:
			genreurl = self.mh_baseUrl+self.mh_genreUrl[self.mh_menuLevel]
			print 'GenreURL:',genreurl
			self.session.open(C24TV_FilmListeScreen, self.mh_baseUrl, genreurl, self.mh_genreTitle)

	def paraQuery(self):
		self.param_qr = ''
		self.session.openWithCallback(self.cb_paraQuery, VirtualKeyBoardExt, title = (_("Enter search criteria")), text = self.param_qr, is_dialog=True)

	def cb_paraQuery(self, callback = None, entry = None):
		if callback != None:
			self.param_qr = callback.strip()
			if self.param_qr:
				search_form['text'] = self.param_qr
				search_form['t1'] = 'title'
				genreurl = self.mh_baseUrl+self.mh_genreUrl[self.mh_menuLevel]
				self.session.open(C24TV_FilmListeScreen, self.mh_baseUrl, genreurl, self.mh_genreTitle)

def C24TV_FilmListEntry(entry):
	return [entry,
		(eListboxPythonMultiContent.TYPE_TEXT, 20, 0, 860, mp_globals.fontsize + 2 * mp_globals.sizefactor, 0, RT_HALIGN_LEFT | RT_VALIGN_CENTER, entry[0])
		]

class C24TV_FilmListeScreen(MPScreen, ThumbsHelper):

	def __init__(self, session, genreBaseURL, genreLink, genreName):
		self.genreLink = genreLink
		self.genreName = genreName

		self.plugin_path = mp_globals.pluginPath
		self.skin_path =  mp_globals.pluginPath + mp_globals.skinsPath
		path = "%s/%s/defaultListScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + mp_globals.skinFallback + "/defaultListScreen.xml"
		print path
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()
		MPScreen.__init__(self, session)
		ThumbsHelper.__init__(self)

		self["actions"]  = ActionMap(["OkCancelActions", "ShortcutActions", "ColorActions", "SetupActions", "NumberActions", "MenuActions", "EPGSelectActions","DirectionActions"], {
			"ok"    : self.keyOK,
			"cancel": self.keyCancel,
			"5" : self.keyShowThumb,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft,
			"upUp" : self.key_repeatedUp,
			"rightUp" : self.key_repeatedUp,
			"leftUp" : self.key_repeatedUp,
			"downUp" : self.key_repeatedUp,
			"upRepeated" : self.keyUpRepeated,
			"downRepeated" : self.keyDownRepeated,
			"rightRepeated" : self.keyRightRepeated,
			"leftRepeated" : self.keyLeftRepeated,
			"nextBouquet" : self.keyPageUp,
			"prevBouquet" : self.keyPageDown,
			"1" : self.key_1,
			"3" : self.key_3,
			"4" : self.key_4,
			"6" : self.key_6,
			"7" : self.key_7,
			"9" : self.key_9,
			"0"	: self.closeAll,
			"blue" :  self.keyTxtPageDown,
			"red" :  self.keyTxtPageUp,
			"info" :  self.keyTMDbInfo
		}, -1)

		self['title'] = Label(C24TV_Version)
		self['F1'] = Label(_("Text-"))
		self['F4'] = Label(_("Text+"))
		self['Page'] = Label(_("Page:"))

		self.filmQ = Queue.Queue(0)
		self.hanQ = Queue.Queue(0)
		self.picQ = Queue.Queue(0)
		self.updateP = 0
		self.eventL = threading.Event()
		self.eventP = threading.Event()
		self.keyLocked = True
		self.dokusListe = []
		self.page = 0
		self.pages = 0;
		self.newMovies = genreBaseURL == genreLink

		self.setGenreStrTitle()

		self.chooseMenuList = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self.chooseMenuList.l.setFont(0, gFont('mediaportal', mp_globals.fontsize))
		self.chooseMenuList.l.setItemHeight(mp_globals.fontsize + 2 * mp_globals.sizefactor)
		self['liste'] = self.chooseMenuList

		self.onLayoutFinish.append(self.loadPage)

	def setGenreStrTitle(self):
		self['ContentTitle'].setText(self.genreName)

	def loadPage(self):
		print "loadPage:"
		if self.page:
			search_form['page'] = self.page
			self['page'].setText("%d / %d" % (self.page,self.pages))
		self.filmQ.put(self.genreLink)
		if not self.eventL.is_set():
			self.eventL.set()
			self.loadPageQueued()
		print "eventL ",self.eventL.is_set()

	def loadPageQueued(self):
		print "loadPageQueued:"
		self['name'].setText(_('Please wait...'))
		while not self.filmQ.empty():
			url = self.filmQ.get_nowait()
		print url
		print 'form:',search_form
		if not search_form:
			twAgentGetPage(url).addCallback(self.loadPageData).addErrback(self.dataError)
		else:
			twAgentGetPage(url, method='POST', postdata=urlencode(search_form), headers={'Content-Type':'application/x-www-form-urlencoded'}).addCallback(self.loadPageData).addErrback(self.dataError)

	def dataError(self, error):
		self.eventL.clear()
		print "dataError:"
		printl(error,self,"E")
		self.dokusListe.append((_("No movies / series found!"),"","",""))
		self.chooseMenuList.setList(map(C24TV_FilmListEntry, self.dokusListe))

	def loadPageData(self, data):
		print "loadPageData:",len(data)
		self.dokusListe = []
		i = data.find('<td valign="top" width="100%"')
		if i > 0:
			l = len(data)
			a = i
			while a < l:
				mg = re.search('<td height="180" width="9"> </td>(.*?)<strong>Genre:</', data[a:], re.S)
				if mg:
					a += mg.end()
					me = re.search('alt="" /></a>.*?href="(.*?)".*?title="(.*?)".*?<img src="(.*?)"', mg.group(1), re.S)
					if me:
						url, name, img = me.groups()
					else:
						continue

					me = re.search('<strong>Premiere:</.*?style=.*?">(.*?)</', mg.group(1), re.S)
					if me:
						prem = me.group(1)
					else: prem = 'N/A'

					me = re.search('<strong>L&auml;nge:</.*?"nowrap">(.*?)<', mg.group(1), re.S)
					if me:
						laenge = me.group(1)
					else: laenge = 'N/A'

					me = re.search('<strong>Sprache:</.*? alt="(.*?)"', mg.group(1), re.S)
					if me:
						sprache = me.group(1)
					else:
						me = re.search('<strong>(Filmwunsch)</', mg.group(1), re.S)
						if me:
							sprache = me.group(1)
						else: sprache = 'N/A'

					me = re.search('<strong>Ansichten:</.*?nowrap">(.*?)<', mg.group(1), re.S)
					if me:
						views = me.group(1)
					else: views = 'N/A'

					me = re.search('<strong>Rating:</.*?<b>(.*?)</', mg.group(1), re.S)
					if me:
						rating = me.group(1)
					else: rating = 'N/A'

					infos = (prem, laenge, sprache, views, rating)
					self.dokusListe.append((decodeHtml(name), url, img, infos))
				else:
					break

			p = re.findall("onclick='(.*?)Page\((.*?)\)'\s*>(\d+)<", data[i:])
			try:
				if p[-1][0] == 'featured':
					search_form['t1'] = 'featuredpage'
				else:
					tp = p[-1][1].split(',')
					search_form['t1'] = tp[0].replace('"','')
					if len(tp) == 3:
						search_form['text'] = tp[2].replace('"','')
				pages = int(p[-1][2])
			except:
				if not self.pages: pages = 1
			if pages > self.pages: self.pages = min(pages,999)

			if not self.page:
				self.page = 1
		print "Page: %d / %d" % (self.page,self.pages)

		if len(self.dokusListe):
			self['page'].setText("%d / %d" % (self.page,self.pages))
			self.chooseMenuList.setList(map(C24TV_FilmListEntry, self.dokusListe))
			self.th_ThumbsQuery(self.dokusListe, 0, 1, 2, None, None, self.page, self.pages)
			self.loadPicQueued()
		else:
			print "No videos found !"
			print data
			self.dokusListe.append((_("No movies / series found!"),"","",""))
			self.chooseMenuList.setList(map(C24TV_FilmListEntry, self.dokusListe))
			if self.filmQ.empty():
				self.eventL.clear()
			else:
				self.loadPageQueued()

	def loadPic(self):
		print "loadPic:"
		if self.picQ.empty():
			self.eventP.clear()
			print "picQ is empty"
			return
		if self.updateP:
			print "Pict. or descr. update in progress"
			print "eventP: ",self.eventP.is_set()
			print "updateP: ",self.updateP
			return
		while not self.picQ.empty():
			self.picQ.get_nowait()
		streamName = self['liste'].getCurrent()[0][0]
		self['name'].setText(streamName)
		streamPic = self['liste'].getCurrent()[0][2]
		self.showInfos()
		self.updateP = 1
		CoverHelper(self['coverArt'], self.ShowCoverFileExit).getCover(streamPic)

	def showInfos(self):
		print "showInfos:"
		prem, laenge, sprache, views, rating = self['liste'].getCurrent()[0][3]
		infos = 'Premiere:\t%s\n' % prem
		if not 'Filmwunsch' in sprache:
			infos += 'Sprache:\t%s\tViews:\t%s\n' % (sprache, views)
		else:
			infos += '%s\t\tViews:\t%s\n' % (sprache, views)
		infos += 'Länge:\t%s\tRating:\t%s' % (laenge, rating)
		self['handlung'].setText(infos)

	def ShowCoverFileExit(self):
		print "showCoverExitFile:"
		self.updateP = 0;
		self.keyLocked	= False
		if not self.filmQ.empty():
			self.loadPageQueued()
		else:
			self.eventL.clear()
			self.loadPic()

	def loadPicQueued(self):
		print "loadPicQueued:"
		self.picQ.put(None)
		if not self.eventP.is_set():
			self.eventP.set()
		self.loadPic()
		print "eventP: ",self.eventP.is_set()

	def keyOK(self):
		if (self.keyLocked|self.eventL.is_set()):
			return

		streamLink = self['liste'].getCurrent()[0][1]
		streamName = self['liste'].getCurrent()[0][0]
		imageLink = self['liste'].getCurrent()[0][2]
		self.session.open(C24TV_Streams, streamLink, streamName, imageLink)

	def keyUpRepeated(self):
		#print "keyUpRepeated"
		if self.keyLocked:
			return
		self['liste'].up()

	def keyDownRepeated(self):
		#print "keyDownRepeated"
		if self.keyLocked:
			return
		self['liste'].down()

	def key_repeatedUp(self):
		#print "key_repeatedUp"
		if self.keyLocked:
			return
		self.loadPicQueued()

	def keyLeftRepeated(self):
		if self.keyLocked:
			return
		self['liste'].pageUp()

	def keyRightRepeated(self):
		if self.keyLocked:
			return
		self['liste'].pageDown()

	def keyPageDown(self):
		#print "keyPageDown()"
		self.keyPageDownFast(1)

	def keyPageUp(self):
		#print "keyPageUp()"
		self.keyPageUpFast(1)

	def keyPageUpFast(self,step):
		if self.keyLocked:
			return
		#print "keyPageUpFast: ",step
		oldpage = self.page
		if (self.page + step) <= self.pages:
			self.page += step
		else:
			self.page = 1
		#print "Page %d/%d" % (self.page,self.pages)
		if oldpage != self.page:
			self.loadPage()

	def keyPageDownFast(self,step):
		if self.keyLocked:
			return
		print "keyPageDownFast: ",step
		oldpage = self.page
		if (self.page - step) >= 1:
			self.page -= step
		else:
			self.page = self.pages
		#print "Page %d/%d" % (self.page,self.pages)
		if oldpage != self.page:
			self.loadPage()

	def key_1(self):
		#print "keyPageDownFast(2)"
		self.keyPageDownFast(2)

	def key_4(self):
		#print "keyPageDownFast(5)"
		self.keyPageDownFast(5)

	def key_7(self):
		#print "keyPageDownFast(10)"
		self.keyPageDownFast(10)

	def key_3(self):
		#print "keyPageUpFast(2)"
		self.keyPageUpFast(2)

	def key_6(self):
		#print "keyPageUpFast(5)"
		self.keyPageUpFast(5)

	def key_9(self):
		#print "keyPageUpFast(10)"
		self.keyPageUpFast(10)

	def keyTMDbInfo(self):
		if not self.keyLocked and TMDbPresent:
			title = self['liste'].getCurrent()[0][0]
			self.session.open(TMDbMain, title)
		elif not self.keyLocked and IMDbPresent:
			title = self['liste'].getCurrent()[0][0]
			self.session.open(IMDB, title)

def C24TV_StreamListEntry(entry):
	if config.mediaportal.premiumize_use.value and re.search(mp_globals.premium_hosters, entry[0], re.S|re.I):
		premiumFarbe = int(config.mediaportal.premium_color.value, 0)
		return [entry,
			(eListboxPythonMultiContent.TYPE_TEXT, 20, 0, 860, mp_globals.fontsize + 2 * mp_globals.sizefactor, 0, RT_HALIGN_CENTER | RT_VALIGN_CENTER, entry[0], premiumFarbe)
			]
	else:
		return [entry,
			(eListboxPythonMultiContent.TYPE_TEXT, 20, 0, 860, mp_globals.fontsize + 2 * mp_globals.sizefactor, 0, RT_HALIGN_CENTER | RT_VALIGN_CENTER, entry[0])
			]

class C24TV_Streams(MPScreen):

	def __init__(self, session, filmUrl, filmName, imageLink):
		self.filmUrl = filmUrl
		self.filmName = filmName
		self.imageUrl = imageLink

		self.plugin_path = mp_globals.pluginPath
		self.skin_path =  mp_globals.pluginPath + mp_globals.skinsPath

		path = "%s/%s/defaultListScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + mp_globals.skinFallback + "/defaultListScreen.xml"

		print path
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()

		MPScreen.__init__(self, session)

		self["actions"]  = ActionMap(["OkCancelActions", "ShortcutActions", "EPGSelectActions", "WizardActions", "ColorActions", "NumberActions", "MenuActions", "MoviePlayerActions", "InfobarSeekActions"], {
			"red" 		: self.keyTxtPageUp,
			"blue" 		: self.keyTxtPageDown,
			"ok"    	: self.keyOK,
			"info" 		: self.keyTMDbInfo,
			"0"			: self.closeAll,
			"cancel"	: self.keyCancel
		}, -1)

		self['title'] = Label(C24TV_Version)
		self['ContentTitle'] = Label(_("Stream Selection"))

		self['F1'] = Label(_("Text-"))
		self['F4'] = Label(_("Text+"))

		self.streamListe = []
		self.streamMenuList = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self.streamMenuList.l.setFont(0, gFont('mediaportal', mp_globals.fontsize))
		self.streamMenuList.l.setItemHeight(mp_globals.fontsize + 2 * mp_globals.sizefactor)
		self['liste'] = self.streamMenuList
		self.keyLocked = True
		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		print "loadPage:"
		self['name'].setText(_('Please wait...'))
		streamUrl = self.filmUrl
		twAgentGetPage(streamUrl).addCallback(self.parseData).addErrback(self.dataError)

	def parseData(self, data):
		print "parseData:"
		m = re.search('<i> <b>(.*?)</b></i>',data, re.S)
		if m:
			infos = decodeHtml(m.group(1).strip())
		else:
			infos = ''

		self.streamListe = []
		n = 1
		for m in re.finditer('class="atest" target="_blank"   href="(.*?)"> <b>.*?!(.*?)</b>', data, re.S):
			url, ep = m.groups()
			try:
				hoster = url.split('/')[2]
			except:
				hoster = ''
			if not hoster: continue
			if isSupportedHoster(hoster, True):
				if ep.strip(): hoster = '#%d %s - %s' % (n, hoster, ep)
				self.streamListe.append((hoster,url,ep.strip()))
				n += 1

		if self.streamListe:
			self.keyLocked = False
		else:
			print "No Streams found"
			self.streamListe.append(("No streams found!","",""))
			m = re.search('class="m1">(.*?)</a>', data)
			if m:
				self.streamListe.append((m.group(1),"",""))

		self.streamMenuList.setList(map(C24TV_StreamListEntry, self.streamListe))
		self['name'].setText(self.filmName)
		self['handlung'].setText(infos)
		print "imageUrl: ",self.imageUrl
		CoverHelper(self['coverArt']).getCover(self.imageUrl)

	def dataError(self, error):
		print "dataError:"
		printl(error,self,"E")
		self.streamListe.append(("Read error !",""))
		self.streamMenuList.setList(map(C24TV_StreamListEntry, self.streamListe))

	def got_link(self, stream_url):
		print "got_link:"
		if not stream_url:
			message = self.session.open(MessageBoxExt, _("No supported streams found!"), MessageBoxExt.TYPE_INFO, timeout=3)
		else:
			ep = self['liste'].getCurrent()[0][2]
			if ep and self.filmName[-1] == '-':
				ep = ' %s' % self['liste'].getCurrent()[0][2]
			elif ep:
				ep = ' - %s' % self['liste'].getCurrent()[0][2]
			else:
				ep = ''
			title = self.filmName + ep
			self.session.open(SimplePlayer, [(title, stream_url, self.imageUrl)], cover=True, showPlaylist=False, ltype='cine24.tv')

	def keyTMDbInfo(self):
		if TMDbPresent:
			self.session.open(TMDbMain, self.filmName)
		elif IMDbPresent:
			self.session.open(IMDB, self.filmName)

	def keyOK(self):
		if self.keyLocked: return
		self.getLink(self['liste'].getCurrent()[0][1])

	def getLink(self, link):
		print 'getLink:'
		if link:
			print 'streamLink:',link
			get_stream_link(self.session).check_link(link, self.got_link)
		else:
			print 'No video url found!'
			print data
			self.got_link(None)

	def streamError(self, error):
		print "streamError:"
		printl(error,self,"E")
		self.got_link(None)