﻿# -*- coding: utf-8 -*-
from Plugins.Extensions.MediaPortal.plugin import _
from Plugins.Extensions.MediaPortal.resources.imports import *

def teleGenreListEntry(entry):
	return [entry,
		(eListboxPythonMultiContent.TYPE_TEXT, 20, 0, 860, mp_globals.fontsize + 2 * mp_globals.sizefactor, 0, RT_HALIGN_CENTER | RT_VALIGN_CENTER, entry[0])
		]

class teleGenreScreen(MPScreen):

	def __init__(self, session):

		self.plugin_path = mp_globals.pluginPath
		self.skin_path =  mp_globals.pluginPath + mp_globals.skinsPath
		path = "%s/%s/defaultGenreScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + mp_globals.skinFallback + "/defaultGenreScreen.xml"
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()
		MPScreen.__init__(self, session)

		self["actions"]  = ActionMap(["MP_Actions"], {
			"ok"    : self.keyOK,
			"0" : self.closeAll,
			"cancel": self.keyCancel
		}, -1)

		self.keyLocked = True
		self['title'] = Label("teledunet.com")
		self['ContentTitle'] = Label("Channels:")
		self['name'] = Label("Channels:")
		self.genreliste = []
		self.chooseMenuList = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self.chooseMenuList.l.setFont(0, gFont('mediaportal', mp_globals.fontsize))
		self.chooseMenuList.l.setItemHeight(mp_globals.fontsize + 2 * mp_globals.sizefactor)
		self['liste'] = self.chooseMenuList

		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		url = "http://www.teledunet.com/mobile/"
		getPage(url, headers={'Referer': 'http://www.teledunet.com/mosaic.php','Content-Type':'application/x-www-form-urlencoded'}).addCallback(self.loadPageData).addErrback(self.dataError)

	def loadPageData(self, data):
		print "get channels"
		aut = re.search('\'?id0=(.*?)\';', data,re.S)
		if aut:
			print aut.group(1)
			channels = re.findall('#000000;">(.*?)<.*?value="(.*?)"', data, re.S)
			if channels:
				for (channelname, value) in channels:
					self.genreliste.append((channelname, value, aut.group(1)))
			self.chooseMenuList.setList(map(teleGenreListEntry, self.genreliste))
			self.keyLocked = False

	def keyOK(self):
		if self.keyLocked:
			return
		channelname = self['liste'].getCurrent()[0][0]
		playpath = channelname.replace(' ','_').lower()
		rtmp_url = self['liste'].getCurrent()[0][1]
		aut = self['liste'].getCurrent()[0][2]
		swf_URL = '"http://www.teledunet.com/mobile/player.swf?id0=%s&channel=%s"' % (aut,playpath)
		final = "%s swfUrl=%s pageUrl=http://www.teledunet.com/mobile/ playpath=%s app=teledunet" % (rtmp_url, swf_URL, playpath)
		playlist = []
		playlist.append((channelname, final))
		self.session.open(SimplePlayer, playlist, showPlaylist=False, ltype='teledunet')