﻿# -*- coding: utf-8 -*-
from Plugins.Extensions.MediaPortal.plugin import _
from Plugins.Extensions.MediaPortal.resources.imports import *

class newtopiaGenreScreen(MPScreen):

	def __init__(self, session):
		self.plugin_path = mp_globals.pluginPath
		self.skin_path =  mp_globals.pluginPath + mp_globals.skinsPath
		path = "%s/%s/defaultGenreScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + mp_globals.skinFallback + "/defaultGenreScreen.xml"
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()
		MPScreen.__init__(self, session)

		self["actions"]  = ActionMap(["OkCancelActions", "ShortcutActions", "WizardActions", "ColorActions", "SetupActions", "NumberActions", "MenuActions", "EPGSelectActions"], {
			"ok"    : self.keyOK,
			"0" : self.closeAll,
			"cancel": self.keyCancel
		}, -1)

		self.keyLocked = True
		self['title'] = Label("Newtopia.de")
		self['ContentTitle'] = Label(_("Selection"))

		self.genreliste = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		url = "https://token.newtopia.de/api/2/GetLongLivedAuthToken/?callback=&authToken=&_="
		getPage(url).addCallback(self.getToken).addErrback(self.dataError)

	def getToken(self, data):
		token = re.search('authToken":"(.*?)"', data).groups()
		self.genreliste = []
		self.genreliste.append(('Livestream 1',"https://token.newtopia.de/api/2/GetToken/?callback=&authToken=%s&streamKey=stream_live_1&platform=web&_=" % token[0]))
		#self.genreliste.append(('Livestream 2',"https://token.newtopia.de/api/2/GetToken/?callback=&authToken=%s&streamKey=stream_live_2&platform=web&_=" % token[0]))
		#self.genreliste.append(('Livestream 3',"https://token.newtopia.de/api/2/GetToken/?callback=&authToken=%s&streamKey=stream_live_3&platform=web&_=" % token[0]))
		#self.genreliste.append(('Livestream 4',"https://token.newtopia.de/api/2/GetToken/?callback=&authToken=%s&streamKey=stream_live_4&platform=web&_=" % token[0]))
		self.ml.setList(map(self._defaultlistcenter, self.genreliste))
		self.keyLocked = False

	def keyOK(self):
		if self.keyLocked:
			return
		newtopiaUrl = self['liste'].getCurrent()[0][1]
		getPage(newtopiaUrl).addCallback(self.getUrl).addErrback(self.dataError)

	def getUrl(self, data):
		url = re.findall('"url":"(.*?)"', data)
		if url:
			url = url[0]
			print url
			getPage(url).addCallback(self.getMu8).addErrback(self.dataError)

	def getMu8(self, data):
		streams = re.findall('RESOLUTION=.*?(http://.*?)\n', data, re.S)
		if streams:
			newtopiaName = self['liste'].getCurrent()[0][0]
			stream_url = streams[-1]
			self.session.open(SimplePlayer, [(newtopiaName, stream_url)], showPlaylist=False, ltype='newtopia')