﻿# -*- coding: utf-8 -*-
from Plugins.Extensions.MediaPortal.plugin import _
from Plugins.Extensions.MediaPortal.resources.imports import *

def bildEntry(entry):
	return [entry,
		(eListboxPythonMultiContent.TYPE_TEXT, 20, 0, 860, mp_globals.fontsize + 2 * mp_globals.sizefactor, 0, RT_HALIGN_CENTER | RT_VALIGN_CENTER, entry[0])
		]

def bildEntry1(entry):
	return [entry,
		(eListboxPythonMultiContent.TYPE_TEXT, 20, 0, 860, mp_globals.fontsize + 2 * mp_globals.sizefactor, 0, RT_HALIGN_LEFT | RT_VALIGN_CENTER, entry[0]+" - "+entry[3])
		]

class bildFirstScreen(MPScreen):

	def __init__(self, session):
		self.plugin_path = mp_globals.pluginPath
		self.skin_path =  mp_globals.pluginPath + mp_globals.skinsPath
		path = "%s/%s/defaultGenreScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + mp_globals.skinFallback + "/defaultGenreScreen.xml"
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()
		MPScreen.__init__(self, session)

		self["actions"] = ActionMap(["MP_Actions"], {
			"0" : self.closeAll,
			"ok"	: self.keyOK,
			"cancel": self.keyCancel,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft
		}, -1)

		self['title'] = Label("Bild.de")
		self['ContentTitle'] = Label("Genre:")
		self['name'] = Label(_("Please wait..."))
		self.keyLocked = True
		self.chooseMenuList = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self.chooseMenuList.l.setFont(0, gFont('mediaportal', mp_globals.fontsize))
		self.chooseMenuList.l.setItemHeight(mp_globals.fontsize + 2 * mp_globals.sizefactor)
		self['liste'] = self.chooseMenuList

		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		self.filmliste = []
		url = "http://www.bild.de/video/startseite/bildchannel-home/video-home-15713248.bild.html"
		getPage(url, headers={'Content-Type':'application/x-www-form-urlencoded'}).addCallback(self.parseData).addErrback(self.dataError)

	def parseData(self, data):
		raw = re.findall('<h2>Top-Videos</h2>(.*?)</ol>', data, re.S)
		if raw:
			categorys = re.findall('<li><a href="(.*?)">(.*?)</a></li>', raw[0], re.S)
			self.filmliste = []
			for (bildUrl, bildTitle) in categorys:
				self.filmliste.append((decodeHtml(bildTitle), bildUrl))
			self.chooseMenuList.setList(map(bildEntry, self.filmliste))
			self.keyLocked = False
			self.showInfos()

	def getTriesEntry(self):
		return config.ParentalControl.retries.setuppin

	def pincheckok(self, pincode):
		bildName = self['liste'].getCurrent()[0][0]
		Link = self['liste'].getCurrent()[0][1]
		bildLink = "http://www.bild.de" + Link
		if pincode:
			self.session.open(bildSecondScreen, bildLink, bildName)

	def showInfos(self):
		title = self['liste'].getCurrent()[0][0]
		self['name'].setText(title)

	def keyOK(self):
		bildName = self['liste'].getCurrent()[0][0]
		Link = self['liste'].getCurrent()[0][1]
		bildLink = "http://www.bild.de" + Link
		if bildName == "Wissen":
			self.session.open(bildWissenScreen)
		elif bildName == "Regional":
			self.session.open(bildRegionalScreen)
		elif bildName == "Erotik":
			if config.mediaportal.pornpin.value:
				self.session.openWithCallback(self.pincheckok, PinInputExt, pinList = [(config.mediaportal.pincode.value)], triesEntry = self.getTriesEntry(), title = _("Please enter the correct pin code"), windowTitle = _("Enter pin code"))
			else:
				self.session.open(bildSecondScreen, bildLink, bildName)
		else:
			self.session.open(bildSecondScreen, bildLink, bildName)

class bildRegionalScreen(MPScreen):

	def __init__(self, session):
		self.plugin_path = mp_globals.pluginPath
		self.skin_path =  mp_globals.pluginPath + mp_globals.skinsPath
		path = "%s/%s/defaultGenreScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + mp_globals.skinFallback + "/defaultGenreScreen.xml"
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()
		MPScreen.__init__(self, session)

		self["actions"] = ActionMap(["MP_Actions"], {
			"0" : self.closeAll,
			"ok"	: self.keyOK,
			"cancel": self.keyCancel
		}, -1)

		self['title'] = Label("Bild.de")
		self['ContentTitle'] = Label("Genre:")
		self.keyLocked = True

		self.filmliste = []
		self.chooseMenuList = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self.chooseMenuList.l.setFont(0, gFont('mediaportal', mp_globals.fontsize))
		self.chooseMenuList.l.setItemHeight(mp_globals.fontsize + 2 * mp_globals.sizefactor)
		self['liste'] = self.chooseMenuList

		self.onLayoutFinish.append(self.layoutFinished)

	def layoutFinished(self):
		self.filmliste.append(("Berlin", "berlin-regional/berlin-15717736"))
		self.filmliste.append(("Bremen", "bremen-regional/bremen-15717790"))
		self.filmliste.append(("Dresden", "dresden-regional/dresden-15717824"))
		self.filmliste.append(("Düsseldorf", "duesseldorf-regional/duesseldorf-15717846"))
		self.filmliste.append(("Frankfurt", "frankfurt-regional/frankfurt-15717874"))
		self.filmliste.append(("Hamburg", "hamburg-regional/hamburg-15717766"))
		self.filmliste.append(("Hannover", "hannover-regional/hannover-15717900"))
		self.filmliste.append(("Köln", "koeln-regional/koeln-15717928"))
		self.filmliste.append(("Leipzig", "leipzig-regional/leipzig-15717952"))
		self.filmliste.append(("München", "muenchen-regional/muenchen-15717974"))
		self.filmliste.append(("Ruhrgebiet", "ruhrgebiet-regional/ruhrgebiet-16989232"))
		self.filmliste.append(("Stuttgart", "stuttgart-regional/stuttgart-15718002"))

		self.chooseMenuList.setList(map(bildEntry, self.filmliste))

	def keyOK(self):
		bildName = self['liste'].getCurrent()[0][0]
		bildLink = "http://www.bild.de/video/clip/" + self['liste'].getCurrent()[0][1] + ".bild.html"
		self.session.open(bildSecondScreen, bildLink, bildName)

class bildWissenScreen(MPScreen):

	def __init__(self, session):
		self.plugin_path = mp_globals.pluginPath
		self.skin_path =  mp_globals.pluginPath + mp_globals.skinsPath
		path = "%s/%s/defaultGenreScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + mp_globals.skinFallback + "/defaultGenreScreen.xml"
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()
		MPScreen.__init__(self, session)

		self["actions"] = ActionMap(["MP_Actions"], {
			"0" : self.closeAll,
			"ok" : self.keyOK,
			"cancel": self.keyCancel
		}, -1)

		self['title'] = Label("Bild.de")
		self['ContentTitle'] = Label("Genre:")
		self.keyLocked = True

		self.filmliste = []
		self.chooseMenuList = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self.chooseMenuList.l.setFont(0, gFont('mediaportal', mp_globals.fontsize))
		self.chooseMenuList.l.setItemHeight(mp_globals.fontsize + 2 * mp_globals.sizefactor)
		self['liste'] = self.chooseMenuList

		self.onLayoutFinish.append(self.layoutFinished)

	def layoutFinished(self):
		self.filmliste.append(("Übersicht", "/wissen-uebersicht-20423868"))
		self.filmliste.append(("Medizin", "-medizin/wissen-medizin-20424074"))
		self.filmliste.append(("Technik", "-technik/wissen-technik-20424140"))
		self.filmliste.append(("Panorama", "-panorama/wissen-panorama-20424026"))
		self.filmliste.append(("Natur", "-natur/wissen-natur-20424092"))
		self.filmliste.append(("Geschichte", "-geschichte/wissen-geschichte-20424050"))
		self.chooseMenuList.setList(map(bildEntry, self.filmliste))

	def keyOK(self):
		bildName = self['liste'].getCurrent()[0][0]
		bildLink = "http://www.bild.de/video/clip/bild-de-wissen" + self['liste'].getCurrent()[0][1] + ".bild.html"
		self.session.open(bildSecondScreen, bildLink, bildName)

class bildSecondScreen(MPScreen, ThumbsHelper):

	def __init__(self, session, bildLink, bildName):
		self.bildLink = bildLink
		self.bildName = bildName
		self.plugin_path = mp_globals.pluginPath
		self.skin_path =  mp_globals.pluginPath + mp_globals.skinsPath
		path = "%s/%s/defaultListWideScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + mp_globals.skinFallback + "/defaultListWideScreen.xml"
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()
		MPScreen.__init__(self, session)
		ThumbsHelper.__init__(self)

		self["actions"] = ActionMap(["MP_Actions"], {
			"0" : self.closeAll,
			"5" : self.keyShowThumb,
			"ok" : self.keyOK,
			"cancel" : self.keyCancel,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft,
			"nextBouquet" : self.keyPageUp,
			"prevBouquet" : self.keyPageDown
		}, -1)

		self['title'] = Label("Bild.de")
		self['ContentTitle'] = Label("Genre: %s" % self.bildName)
		self['name'] = Label(_("Please wait..."))

		self['Page'] = Label(_("Page:"))

		self.keyLocked = True
		self.chooseMenuList = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self.chooseMenuList.l.setFont(0, gFont('mediaportal', mp_globals.fontsize))
		self.chooseMenuList.l.setItemHeight(mp_globals.fontsize + 2 * mp_globals.sizefactor)
		self['liste'] = self.chooseMenuList
		self.page = 0
		self.lastpage = 0
		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		self.filmliste = []
		url = self.bildLink
		getPage(url, headers={'Content-Type':'application/x-www-form-urlencoded'}).addCallback(self.parseData).addErrback(self.dataError)

	def parseData(self, data):
		lastpage = re.search('<li\sclass="pagLast">.*?page=(.*),isVideoStartseite', data)
		if lastpage:
			self.lastpage = int(lastpage.group(1))+1
			self['page'].setText("%s / %s" % (str(self.page+1), str(self.lastpage)))
		else:
			parse = re.search('class="pag">(.*)weiter</a>', data, re.S)
			if parse:
				lastpage = re.findall('>([\d]+)</a></li>', parse.group(1), re.S)
				if lastpage:
					self.lastpage = int(lastpage[-1])
					self['page'].setText("%s / %s" % (str(self.page+1), str(self.lastpage)))
			else:
				self.lastpage = 0
				self['page'].setText("%s / 1" % str(self.page+1))

		raw = re.search('(Aktuellste|Neueste|Alle)\sVideos</h2>(.*)</section></div></div>', data, re.S).groups()
		if raw:
			seasons = re.findall('class="active">.*?data-ajax-href="(.*?)page=.*?,(.*?)"', raw[1], re.S)
			if seasons:
				vid_id1 = seasons[0][0]
				vid_id2 = seasons[0][1]
				nexturl = "http://www.bild.de/" + vid_id1 + "page=" + str(self.page) + "," + vid_id2
				getPage(nexturl, headers={'Content-Type':'application/x-www-form-urlencoded'}).addCallback(self.parseData2).addErrback(self.dataError)
			else:
				self.parseData2(raw[1])

	def parseData2(self, data):
		categorys =  re.findall('class="hentry.*?<a\shref="([^#].*?)".*?src="(.*?)".*?class="kicker">(.*?)<.*?class="headline">(.*?)</h3>', data, re.S)
		for (bildUrl, bildImage, bildTitle, handlung) in categorys:
			handlung = handlung.replace('</span><span>',' ').replace('<span>','').replace('</span>','')
			self.filmliste.append((decodeHtml(bildTitle), bildUrl, bildImage, handlung))
		self.chooseMenuList.setList(map(bildEntry1, self.filmliste))
		self.chooseMenuList.moveToIndex(0)
		self.keyLocked = False
		self.th_ThumbsQuery(self.filmliste, 0, 1, 2, None, None, self.page+1, self.lastpage, mode=1, pagefix=-1)
		self.showInfos()

	def showInfos(self):
		title = self['liste'].getCurrent()[0][0]
		coverUrl = self['liste'].getCurrent()[0][2]
		handlung = self['liste'].getCurrent()[0][3]
		self['name'].setText(title + " - "+ handlung)
		CoverHelper(self['coverArt']).getCover(coverUrl)

	def keyPageDown(self):
		print "PageDown"
		if self.keyLocked:
			return
		if not self.page < 1:
			self.page -= 1
			self.loadPage()

	def keyPageUp(self):
		print "PageUP"
		if self.keyLocked:
			return
		if self.page+1 < self.lastpage:
			self.page += 1
			self.loadPage()

	def keyOK(self):
		if self.keyLocked:
			return
		bildLink = self['liste'].getCurrent()[0][1]
		self.bildLink = "http://www.bild.de" + bildLink
		self.bildName = self['liste'].getCurrent()[0][0] + " - " + self['liste'].getCurrent()[0][3]
		getPage(self.bildLink, headers={'Content-Type':'application/x-www-form-urlencoded'}).addCallback(self.parseVideoData).addErrback(self.dataError)

	def parseVideoData(self, data):
		xmllink = re.search('longdesc="(.*?)"', data, re.S)
		if xmllink:
			getxml = "http://www.bild.de" + xmllink.group(1)
			getPage(getxml, headers={'Content-Type':'application/x-www-form-urlencoded'}).addCallback(self.playVideo).addErrback(self.dataError)

	def playVideo(self, data):
		streamlink = re.search('<video\ssrc="(.*?)"', data, re.S)
		if streamlink:
			if re.match('.*?\/ondemand\/', streamlink.group(1)):
				host = streamlink.group(1).split('ondemand/')[0]
				playpath = streamlink.group(1).split('ondemand/')[1]
				final = "%sondemand/ playpath=mp4:%s swfVfy=1" % (host, playpath)
			else:
				final = streamlink.group(1)
			print "Final: " + final
			self.session.open(SimplePlayer, [(self.bildName, final)], showPlaylist=False, ltype='Bild.de')