﻿# -*- coding: utf-8 -*-

from Plugins.Extensions.MediaPortal.plugin import _
from Plugins.Extensions.MediaPortal.resources.imports import *
import Queue
import threading
from Plugins.Extensions.MediaPortal.resources.menuhelper import MenuHelper
from Plugins.Extensions.MediaPortal.resources.mv_client_v12 import Client, mvClient
from Components.ProgressBar import ProgressBar

if fileExists('/usr/lib/enigma2/python/Plugins/Extensions/TMDb/plugin.pyo'):
	from Plugins.Extensions.TMDb.plugin import *
	TMDbPresent = True
elif fileExists('/usr/lib/enigma2/python/Plugins/Extensions/IMDb/plugin.pyo'):
	TMDbPresent = False
	IMDbPresent = True
	from Plugins.Extensions.IMDb.plugin import *
else:
	IMDbPresent = False
	TMDbPresent = False

MV2_Version = "MyVideo.de v1.02"

MV2_siteEncoding = 'utf-8'

MV_LOGO = 'http://archiv.kabeleins.de/polopoly_fs/powered-by-myvideo-1332321701-1.60959!/httpImage/powered-by-myvideo.png_gen/derivatives/FORMAT_218_123/powered-by-myvideo.png'

def MV2_menuListentry(entry):
	return [entry,
		(eListboxPythonMultiContent.TYPE_TEXT, 50, 0, 830, 25, 0, RT_HALIGN_LEFT | RT_VALIGN_CENTER, entry[0])
		]

class searchHelper:

	def __init__(self):
		self.lastSearchNum = -1
		self.searchKey = None
		self["suchtitel"] = Label(_("Search char."))
		self["suchhinweis"] = Label(_("A-Z search"))
		self["suche"] = Label("")
		self["suche"].hide()
		self["suchtitel"].hide()

		self.numericalTextInput = NumericalTextInput()
		self.numericalTextInput.setUseableChars(u'1234567890ABCDEFGHIJKLMNOPQRSTUVWXYZ')
		if mp_globals.isDreamOS:
			self.numericalTextInput.timer_conn = self.numericalTextInput.timer.timeout.connect(self.doSearch)
		else:
			self.numericalTextInput.timer.callback.append(self.doSearch)

		self["search_actions"] = NumberActionMap(["NumberActions", "InputAsciiActions"], {
			"1": self.showSearchkey,
			"2": self.showSearchkey,
			"3": self.showSearchkey,
			"4": self.showSearchkey,
			"5": self.showSearchkey,
			"6": self.showSearchkey,
			"7": self.showSearchkey,
			"8": self.showSearchkey,
			"9": self.showSearchkey
		}, -1)

	def showSearchkey(self, num):
		pass

	def doSearch(self):
		pass

class show_MV2_Genre(MenuHelper, searchHelper):

	LISTALL = 0

	def __init__(self, session, genre_title=_('Selection'), request_data=None, series_nm=None, connect=True, ga_action=''):
		self.genre_title = genre_title
		self.request_data = request_data
		self.series_nm = series_nm
		self.connect = connect
		self.menuData = {}
		self.metadata = {}
		self.page = self.pages = 0
		self.ga_action = ga_action
		self.param_qr = ''

		if request_data:
			self.widget = request_data.get('widget',{})
			self.listAll = request_data.get('listAll',0)
		else:
			self.widget = {}
			self.listAll = 0

		if self.listAll:
			self.maxSize = 200
		else:
			self.maxSize = 50

		if self.widget and self.widget.get('type', '') == 'alphanumeric':
			self.filterData = {
				u'filterData': [
						{
							u'searchWord':"",
							u'searchType':self.widget.get('searchType',0)
						}
					]
				}
		else:
			self.filterData = {}

		if config.mediaportal.skin.value == 'original':
			widgets_files = ('search_widgets.xml', 'cover_widgets_wide.xml')
		else:
			widgets_files = ('search_widgets.xml',)

		MenuHelper.__init__(self, session, 0, None, None, "", MV2_menuListentry, skin_name='defaultListWideScreen.xml', widgets_files=widgets_files)

		searchHelper.__init__(self)
		if not self.widget and not self.listAll:
			self["suchhinweis"].hide()

		if config.mediaportal.skin.value == 'original':
			self["length"] = Label("")
			self['rating5'] = ProgressBar()
			self['rating0'] = Pixmap()

		self["mv_actions"] = ActionMap(['MP_Actions'], {
			"blue" :  self.keyTxtPageDown,
			"yellow" :  self.keyTxtPageUp,
			"nextBouquet" : self.keyPageUp,
			"prevBouquet" : self.keyPageDown
		}, -1)

		self['title'] = Label(MV2_Version)
		self['ContentTitle'] = Label(self.genre_title)
		self['handlung'] = ScrollLabel("")
		self['F3'] = Label('Text-')
		self['F4'] = Label('Text+')
		self['Page'] = Label(_("Page:"))
		self.mh_On_setGenreStrTitle.append((self.showInfos,()))
		self.onLayoutFinish.append(self.mh_initMenu)

		if connect: self.onClose.append(mvClient.stopSessionTimer)

	def mh_initMenu(self):
		self.d_print("mh_initMenu:")

		self.mh_menuListe = []
		self.mh_menuListe.append((_('Please wait...'),None))
		self.mh_chooseMenuList.setList(map(self.mh_menuListentry, self.mh_menuListe))
		if self.connect:
			menu=[]
			mvClient.connect(self.session).addCallback(self.cbConnect, menu)
		elif self.request_data and self.request_data['type'] in ('group_videos', 'videolist'):
			self.getGroupVideos(self.request_data, self.filterData)
		elif self.request_data and self.request_data['type'].startswith('group') or self.request_data['type'] == 'video_charts':
			self.getGroups(self.request_data, self.filterData)
		elif self.request_data and self.request_data['type'] == 'playlist':
			self.getVideolist(self.request_data)

	def cbConnect(self, result, menu):
		print 'cbConnect:'
		self.connect = False
		d = mvClient.requestNavigation()
		d.addCallback(self.getMenus, menu).addErrback(self.dataError)

	def getMenus(self, jsonData, menu):
		d = self.parseMenuGroups(jsonData, menu)
		d.addCallback(self.mh_genMenu2).addErrback(self.mh_dataError)

	def extendMenu(self, list, menu):
		print 'extendMenu:'
		return menu + list

	def appendToMenu(self, menu, entry):
		print 'appendToMenu:'
		return menu.append(entry)

	def parseMenuGroups(self, jsonData, menu):
		print 'parseMenuGroups:'
		for entry in jsonData["resultList"]["subNavEntries"]:
			title0 = entry["title"]
			id0 = entry['id']
			self.menuData[title0] = {}
			menu.append((0, (self.menuData[title0], ''), str(title0)))

			for entry2 in entry.get("subNavEntries"):
				title1 = entry2['title']
				id1 = entry2['id']
				type1 = entry2['type']

				self.menuData[title0][title1] = {}
				self.menuData[title0][title1]['id'] = id1
				self.menuData[title0][title1]['type'] = type1
				self.menuData[title0][title1]['searchOrder'] = entry2.get('searchOrder', 0)
				self.menuData[title0][title1]['searchOrderArray'] = entry2.get('searchOrderArray', '')
				self.menuData[title0][title1]['searchFilter'] = entry2.get('searchFilter', '')
				if 'Alle Serien,' in entry2.get('listTitle', '') or title1 == 'Sender':
					listAll = self.menuData[title0][title1]['listAll'] = self.LISTALL
				else:
					listAll = 0

				self.ga_action = self.getTrackingInfo(entry2, 'ga_action')
				menu.append((1, (self.menuData[title0][title1], ''), str(title1)))

				for filt_entry in entry2.get("filter",""):
					title = filt_entry.get('title', '')
					id = filt_entry.get('id', filt_entry.get('ids', [0])[0])
					widget = filt_entry.get('widget', '')
					if not title or not id:
						if widget:
							self.menuData[title0][title1]['widget'] = widget
						continue

					self.menuData[title0][title1][title] = {}
					self.menuData[title0][title1][title]['listAll'] = listAll
					type = filt_entry['type']
					self.menuData[title0][title1][title]['id'] = id
					self.menuData[title0][title1][title]['type'] = type
					self.menuData[title0][title1][title]['searchOrder'] = filt_entry.get('searchOrder', self.menuData[title0][title1]['searchOrder'])
					self.menuData[title0][title1][title]['searchFilter'] = filt_entry.get('searchFilter', self.menuData[title0][title1]['searchFilter'])
					#self.menuData[title0][title1][title]['icon'] = str(filt_entry.get("icon",""))
					menu.append((2, (self.menuData[title0][title1][title], ''), str(title)))

		menu.append((0, ({}, ''), 'Suche...'))
		return self.deferredData(menu)

	def getTrackingInfo(self, entry, t_id):
		for infos in entry.get('tracking', ()):
			id = infos.get('mv_analytics','')
			if not id: continue
			return infos['param'].get(t_id, '')

		return ''

	def deferredData(self, data):
		d = defer.Deferred()
		d.callback(data)
		return d

	def parseGroupPlaylist(self, jsonData, lev, menu):
		print 'parseGroupPlaylist:'
		metadata = jsonData.get("metadata", {})
		resultId = metadata.get("resultId", 0)
		resultSize = metadata.get("resultSize", 0)
		resultCount = metadata.get("resultCount", 0)
		resultOffset = metadata.get("resultOffset", 0)
		resultType = metadata.get("resultType", "")
		if resultCount == 0:
			msg = jsonData.get("returnMessageScreen", [""])[0]
			if msg:
				self.session.open(MessageBox, str(msg), type=MessageBox.TYPE_INFO)

			return []

		type = jsonData['type']
		for entry in jsonData.get("resultList", {}):
			menudata = {}
			menudata['id'] = entry["id"]
			menudata['playListID'] = entry.get("playListID",0)
			menudata['image'] = str(entry["preview"])
			menudata['type'] = str(type)
			menudata['length'] = entry.get("length","")
			menudata['rate'] = entry.get("rate","")
			title = entry["title"]
			if type not in ('group_playlists', 'playlist', 'videolist'):
				print 'wrong type:',type
				continue
			menu.append((lev, (menudata, ''), str(title)))

		if (resultOffset+resultSize) < resultCount and self.listAll:
			d = mvClient.requestGroupPlaylists(self.request_data, self.filterData, resultSize, resultOffset+resultSize)
			d.addCallback(self.parseGroupPlaylist, lev, menu).addErrback(self.dataError)
			return d
		else:
			self.metadata.update(metadata)
			self.getLastPage()
			return menu

	def getVideolist(self, request_data):
		print 'getVideolist:'
		d = mvClient.requestVideodetailsPlaylist(request_data)
		d.addCallback(self.parseVideolist)
		d.addCallback(self.mh_genMenu2).addErrback(self.mh_dataError)

	def parseVideolist(self, jsonData):
		print 'parseVideolist:'
		try:
			jsonData = jsonData["resultList"]["videolist"]["init"]
		except:
			return None

		clip_type = 4
		menu = None
		while clip_type and not menu:
			clip_type -= 1
			menu = self.parseVideoDetails(jsonData, clip_type)

		if not menu:
			clip_type = 6
			menu = self.parseVideoDetails(jsonData, clip_type)

		if clip_type == 3:
			epi_type = _('Full length episodes')
		elif clip_type == 2:
			epi_type = _('Only Clips')
		else:
			epi_type = ''

		self['ContentTitle'].setText(self.genre_title + ' (%s)' % epi_type)
		return menu

	def parseVideoDetails(self, jsonData, clip_type):
		print 'parseVideoDetails:'
		menu = []
		for entry in jsonData["resultList"]:
			clipType = entry["clipType"]
			if clipType == clip_type:
				menudata = {}
				menudata['id'] = entry["id"]
				menudata['playListID'] = entry.get("playListID",0)
				menudata['image'] = str(entry["preview"])
				menudata['playListID'] = entry.get("playListID",0)
				menudata['type'] = 'video'
				menudata['length'] = entry.get("length","")
				menudata['rate'] = entry.get("rate","")
				desc = entry["description"]
				title = entry["title"]
				menu.append((0, (menudata, str(desc)), str(title)))

		return menu

	def getGroups(self, request_data, filter_data={}):
		d = mvClient.requestGroupPlaylists(request_data, filter_data).addCallback(self.parseGroupPlaylist, 0, [])
		d.addCallback(self.mh_genMenu2).addErrback(self.mh_dataError)

	def getCharts(self, request_data):
		d = mvClient.requestHome(request_data).addCallback(self.parseGroupPlaylist, 0, [])
		d.addCallback(self.mh_genMenu2).addErrback(self.mh_dataError)

	def getGroupVideos(self, request_data, filter_data={}):
		print 'getGroupVideos:'
		d = mvClient.requestGroupVideos(request_data, filter_data, sz=self.maxSize).addCallback(self.parseGroupPlaylist, 0, [])
		d.addCallback(self.mh_genMenu2).addErrback(self.mh_dataError)

	def searchGroupVideos(self, searchFilter):
		print 'searchGroupVideos:'
		self.mh_menuListe = []
		self.mh_menuListe.append((_('Please wait...'),None))
		self.mh_chooseMenuList.setList(map(self.mh_menuListentry, self.mh_menuListe))
		self.request_data = {
			'id': 75355,
			'type': 'group_video_search',
			'searchOrder': 0,
			'searchFilter': searchFilter
			}
		d = mvClient.requestGroupVideoSearch(searchFilter, sz=self.maxSize).addCallback(self.parseGroupPlaylist, 0, [])
		d.addCallback(self.mh_genMenu2).addErrback(self.mh_dataError)

	def getSeries(self, request_data):
		d = mvClient.requestGroupPlaylists(request_data, sz=self.maxSize)
		d.addCallback(self.parseGroupPlaylist, 0, [])
		d.addCallback(self.mh_genMenu2).addErrback(self.mh_dataError)

	def mh_callGenreListScreen(self):
		request_data = self.mh_genreUrl[self.mh_menuLevel][0]
		if re.search('Suche...', self.mh_genreTitle):
			self.paraQuery()
		elif not request_data['type'].endswith('_charts') and request_data['type'].startswith('video'):
			self.session.open(
				MyvideoPlayer,
				self.mh_menuListe,
				self['liste'].getSelectedIndex(),
				playAll = True,
				listTitle = self.genre_title,
				useResume = 'Musik' not in self.ga_action
				)
		else:
			self.session.open(show_MV2_Genre, self.mh_genreTitle, request_data, self['liste'].getCurrent()[0][0], False, self.ga_action)

	def showInfos(self):
		infos = self.mh_genreUrl[self.mh_menuLevel]
		if infos and len(infos) > 1:
			self['handlung'].setText(self.mh_genreUrl[self.mh_menuLevel][1])
			ImageUrl = self.mh_genreUrl[self.mh_menuLevel][0].get('image', MV_LOGO)
			length = self.mh_genreUrl[self.mh_menuLevel][0].get('length', "-:--")
			if config.mediaportal.skin.value == 'original':
				self['length'].setText(str(length))
				rate = self.mh_genreUrl[self.mh_menuLevel][0].get('rate', 0.0)
				rating = int(100 * round(float(rate) / 5, 2))
				if rating > 100:
					rating = 100
				self['rating5'].setValue(rating)

			CoverHelper(self['coverArt']).getCover(ImageUrl)

		if self.page:
			self['page'].setText("%d / %d" % (self.page,self.pages))

	def getLastPage(self):
		if self.metadata:
			resultSize = self.metadata.get("resultSize", 0)
			resultCount = self.metadata.get("resultCount", 0)
			pages = resultCount // resultSize
			if resultCount % resultSize:
				pages += 1
			self.pages = min(999, pages)
		else:
			self.pages = 1

		self.page = max(self.page, 1)

	def showSearchkey(self, num):
		print 'showSearchkey:'
		if self.mh_keyLocked:
			return
		if self.widget or self.listAll:
			self.keyNumberGlobal(num, self.mh_menuListe)
			self.searchKey = self.numericalTextInput.mapping[num][self.numericalTextInput.pos]
			self['suche'].setText(str(self.searchKey))
			if self.lastSearchNum == -1:
				self['suche'].show()
				self["suchtitel"].show()
			self.lastSearchNum = num

	def doSearch(self):
		self.lastSearchNum = -1
		self['suche'].hide()
		self["suchtitel"].hide()
		if self.widget and not self.listAll:
			self.mh_keyLocked = True
			self.filterData['filterData'][0]['searchWord'] = self.searchKey
			self.metadata.clear()
			self.page = self.pages = 0
			self.mh_initMenu()

	def paraQuery(self):
		self.param_qr = ''
		self.session.openWithCallback(self.cb_paraQuery, VirtualKeyBoardExt, title = (_("Enter search criteria")), text = self.param_qr, is_dialog=True)

	def cb_paraQuery(self, callback = None, entry = None):
		if callback != None:
			self.param_qr = callback.strip()
			if len(self.param_qr) > 0:
				self.param_qr = urllib.quote(self.param_qr)
				searchFilter = [
						{
						u'searchWord':self.param_qr,
						u'searchType':1
						},
						{
						u'searchWord':'Y',
						u'searchType':18
						}
					]
				self.searchGroupVideos(searchFilter)

	def keyPageUp(self):
		if self.mh_keyLocked:
			return
		oldpage = self.page
		if not self.page or not self.pages:
			return
		if (self.page + 1) <= self.pages:
			self.page += 1
			resultOffset = self.metadata.get("resultOffset", 0)
			resultSize = self.metadata.get("resultSize", 0)
			resultOffset += resultSize

		if oldpage != self.page:
			self.loadNextPageData(resultOffset)

	def keyPageDown(self):
		if self.mh_keyLocked:
			return
		oldpage = self.page
		if not self.page or not self.pages:
			return
		if (self.page - 1) > 0:
			resultOffset = self.metadata.get("resultOffset", 0)
			resultSize = self.metadata.get("resultSize", 0)
			resultOffset -= resultSize
			self.page -= 1

		if oldpage != self.page:
			self.loadNextPageData(resultOffset)

	def loadNextPageData(self, offset):
		print 'loadNextPageData:'
		resultCount = self.metadata.get("resultCount", 0)
		resultSize = self.metadata.get("resultSize", 0)

		if offset < resultCount:
			self.mh_keyLocked = True
			self.mh_menuListe = [(_('Please wait...'),None)]
			self.mh_chooseMenuList.setList(map(self.mh_menuListentry, self.mh_menuListe))
			d = mvClient.requestGroupPlaylists(self.request_data, self.filterData, resultSize, offset)
			d.addCallback(self.parseGroupPlaylist, 0, [])
			d.addCallback(self.mh_genMenu2).addErrback(self.mh_dataError)

class MyvideoPlayer(SimplePlayer):

	def __init__(self, session, playList, playIdx=0, playAll=False, listTitle=None, useResume=True):
		print "MyvideoPlayer:"
		SimplePlayer.__init__(self, session, playList, playIdx=playIdx, playAll=playAll, listTitle=listTitle, ltype='myvideo2.de', cover=False)

	def getVideo(self):
		title = self.playList[self.playIdx][0]
		request_data = self.playList[self.playIdx][1][0]
		if request_data.get('playListID', 0) > 0:
			d = mvClient.requestVideodetailsPlaylist(request_data)
		else:
			d = mvClient.requestVideodetails(request_data)
		d.addCallback(mvClient.getVideodetailsPlaylist)
		d.addCallback(self.getVideodetails, title, request_data).addErrback(self.dataError)

	def getVideodetails(self, url, title, request_data):
		print 'getVideodetails:'
		d = mvClient.requestM3U8(url)
		d.addCallback(self.openPlayer, title, request_data).addErrback(self.dataError)

	def openPlayer(self, vurl, title, request_data):
		print 'openPlayer:'
		img = request_data.get('image', MV_LOGO)
		self.playStream(title, str(vurl), imgurl=img)