﻿# -*- coding: utf-8 -*-
from Plugins.Extensions.MediaPortal.plugin import _
from Plugins.Extensions.MediaPortal.resources.imports import *

config.mediaportal.watchmovies_country = ConfigText(default="DE", fixed_size=False)
config.mediaportal.watchmovies_sort = ConfigText(default="id", fixed_size=False)
keckse = {}

def watchmoviesStreamsEntry(entry):
	if config.mediaportal.premiumize_use.value and re.search(mp_globals.premium_hosters, entry[0], re.S|re.I):
		premiumFarbe = int(config.mediaportal.premiumize_color.value, 0)
		return [entry,
			(eListboxPythonMultiContent.TYPE_TEXT, 20, 0, 860, 25, 0, RT_HALIGN_CENTER | RT_VALIGN_CENTER, entry[0], premiumFarbe)
			]
	else:
		return [entry,
			(eListboxPythonMultiContent.TYPE_TEXT, 20, 0, 860, 25, 0, RT_HALIGN_CENTER | RT_VALIGN_CENTER, entry[0])
			]

def watchmoviesListEntry(entry):
		return [entry,
			(eListboxPythonMultiContent.TYPE_TEXT, 20, 0, 860, 25, 0, RT_HALIGN_CENTER | RT_VALIGN_CENTER, entry[0])
			]

def watchmoviesFilmListEntry(entry):
	if entry[3]:
		png = "/usr/lib/enigma2/python/Plugins/Extensions/MediaPortal/images/watched.png"
		watched = LoadPixmap(png)
		return [entry,
			(eListboxPythonMultiContent.TYPE_PIXMAP_ALPHATEST, 20, 3, 100, 22, watched),
			(eListboxPythonMultiContent.TYPE_TEXT, 60, 0, 700, 25, 0, RT_HALIGN_LEFT | RT_VALIGN_CENTER, entry[0])
			]
	else:
		return [entry,
			(eListboxPythonMultiContent.TYPE_TEXT, 60, 0, 700, 25, 0, RT_HALIGN_LEFT | RT_VALIGN_CENTER, entry[0])
			]

def load_watched_liste(watchfile):
	watched_liste = []
	if not fileExists(config.mediaportal.watchlistpath.value+watchfile):
		open(config.mediaportal.watchlistpath.value+watchfile,"w").close()
	if fileExists(config.mediaportal.watchlistpath.value+watchfile):
		leer = os.path.getsize(config.mediaportal.watchlistpath.value+watchfile)
		if not leer == 0:
			updates_read = open(config.mediaportal.watchlistpath.value+watchfile , "r")
			for lines in sorted(updates_read.readlines()):
				line = re.findall('"(.*?)"', lines)
				if line:
					watched_liste.append("%s" % (line[0]))
			updates_read.close()
	return(watched_liste)

class watchmoviesMenueScreen(MPScreen):

	def __init__(self, session):
		self.plugin_path = mp_globals.pluginPath
		self.skin_path = mp_globals.pluginPath + "/skins"
		path = "%s/%s/defaultGenreScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + "/original/defaultGenreScreen.xml"
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()
		MPScreen.__init__(self, session)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok" : self.keyOK,
			"0" : self.closeAll,
			"cancel" : self.keyCancel,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft,
			"blue"	: self.keyCountry
		}, -1)

		self.country = config.mediaportal.watchmovies_country.value
		self['title'] = Label("watchmovies.to")
		self['ContentTitle'] = Label("Genre:")
		self['F4'] = Label(self.country)
		self.keyLocked = True
		self.suchString = ''

		self.genreliste = []
		self.chooseMenuList = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self.chooseMenuList.l.setFont(0, gFont('mediaportal', 23))
		self.chooseMenuList.l.setItemHeight(25)
		self['liste'] = self.chooseMenuList

		self.onLayoutFinish.append(self.genreData)

	def genreData(self):
		self.genreliste.append(("Movies Cinema", "http://watchmovies.to/cinema-movies"))
		self.genreliste.append(("Movies Genre", ""))
		self.genreliste.append(("Movies A-Z", ""))
		self.genreliste.append(("Movies Sort List", "http://watchmovies.to/movies"))

		self.genreliste.append(("TV-Shows Featured", "http://watchmovies.to/featured-tv-shows"))
		self.genreliste.append(("TV-Shows Genre", ""))
		self.genreliste.append(("TV-Shows A-Z", ""))
		self.genreliste.append(("TV-Shows Sort List", "http://watchmovies.to/tv-shows"))
		self.genreliste.append(("Watchlist","dump"))

		self.genreliste.insert(0, ("--- Search ---", "callSuchen"))
		self.chooseMenuList.setList(map(watchmoviesListEntry, self.genreliste))
		self.chooseMenuList.moveToIndex(0)
		self.keyLocked = False

	def keyOK(self):
		if self.keyLocked:
			return
		global keckse
		if self.country == "DE":
			keckse = {'category_show_filter': '0', 'lang_selection': '12', 'lang_selection_bkp': '12', 'lang_selection_checkstate': '1'}
		else:
			keckse = {'category_show_filter': '0', 'lang_selection': '13', 'lang_selection_bkp': '13', 'lang_selection_checkstate': '1'}

		Name = self['liste'].getCurrent()[0][0]
		if Name == "--- Search ---":
			self.suchen()
		elif Name == "Watchlist":
			self.session.open(wmWatchlist)
		elif re.match('.*?A-Z', Name):
			self.session.open(watchmoviesAZScreen, Name)
		elif re.match('.*?Genre', Name):
			self.session.open(watchmoviesGenreScreen, Name)
		else:
			Link = self['liste'].getCurrent()[0][1]
			self.session.open(watchmoviesFilmScreen, Link, Name)

	def SuchenCallback(self, callback = None, entry = None):
		if callback is not None and len(callback):
			self.suchString = callback.replace(' ', '+')
			Name = "--- Search ---"
			Link = 'http://watchmovies.to/search/title=%s' % (self.suchString)
			self.session.open(watchmoviesFilmScreen, Link, Name)

	def keyCountry(self):
		if self.country == "DE":
			self.country = "ENG"
		elif self.country == "ENG":
			self.country = "DE"
		config.mediaportal.watchmovies_country.value = self.country
		config.mediaportal.watchmovies_country.save()
		configfile.save()
		self['F4'].setText(self.country)

class watchmoviesGenreScreen(MPScreen):

	def __init__(self, session, Name):
		self.Name = Name
		self.plugin_path = mp_globals.pluginPath
		self.skin_path = mp_globals.pluginPath + "/skins"
		path = "%s/%s/defaultGenreScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + "/original/defaultGenreScreen.xml"
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()
		MPScreen.__init__(self, session)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok" : self.keyOK,
			"0" : self.closeAll,
			"cancel" : self.keyCancel
		}, -1)

		self.country = config.mediaportal.watchmovies_country.value
		self['title'] = Label("watchmovies.to / Filter: %s" % self.country)
		if re.match('Movies', self.Name):
			self['ContentTitle'] = Label("Movies Genre")
		else:
			self['ContentTitle'] = Label("TV-Shows Genre")
		self.keyLocked = True
		self.suchString = ''

		self.genreliste = []
		self.chooseMenuList = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self.chooseMenuList.l.setFont(0, gFont('mediaportal', 23))
		self.chooseMenuList.l.setItemHeight(25)
		self['liste'] = self.chooseMenuList

		self.onLayoutFinish.append(self.layoutFinished)

	def layoutFinished(self):
		self.keyLocked = True
		url = "http://watchmovies.to/"
		getPage(url, cookies=ck, headers={'Content-Type':'application/x-www-form-urlencoded'}).addCallback(self.genreData).addErrback(self.dataError)

	def genreData(self, data):
		preparse = re.findall('menu_genre">(.*?)</ul>', data, re.S|re.I)
		if preparse:
			Cats = re.findall('href=".*?">(.*?)<', preparse[0], re.S)
			if Cats:
				for Cat in Cats:
					self.genreliste.append((Cat, True))

		self.chooseMenuList.setList(map(watchmoviesListEntry, self.genreliste))
		self.chooseMenuList.moveToIndex(0)
		self.keyLocked = False

	def keyOK(self):
		if self.keyLocked:
			return
		Name = self['liste'].getCurrent()[0][0]
		if re.match('Movies', self.Name):
			Link = "http://watchmovies.to/movies/genre=%s" % Name
		else:
			Link = "http://watchmovies.to/tv-shows/genre=%s" % Name
		Title = "%s Selection: %s" % (self.Name.split(' ', 1)[0], Name)
		self.session.open(watchmoviesFilmScreen, Link, Title)

class watchmoviesAZScreen(MPScreen):

	def __init__(self, session, Name):
		self.Name = Name
		self.plugin_path = mp_globals.pluginPath
		self.skin_path = mp_globals.pluginPath + "/skins"
		path = "%s/%s/defaultGenreScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + "/original/defaultGenreScreen.xml"
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()
		MPScreen.__init__(self, session)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok" : self.keyOK,
			"0" : self.closeAll,
			"cancel" : self.keyCancel
		}, -1)

		self.country = config.mediaportal.watchmovies_country.value
		self['title'] = Label("watchmovies.to / Filter: %s" % self.country)
		if re.match('Movies', self.Name):
			self['ContentTitle'] = Label("Movies A-Z")
		else:
			self['ContentTitle'] = Label("TV-Shows A-Z")
		self.keyLocked = True
		self.suchString = ''

		self.genreliste = []
		self.chooseMenuList = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self.chooseMenuList.l.setFont(0, gFont('mediaportal', 23))
		self.chooseMenuList.l.setItemHeight(25)
		self['liste'] = self.chooseMenuList

		self.onLayoutFinish.append(self.genreData)

	def genreData(self):
		abc = ["0-9","A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z"]

		for letter in abc:
			self.genreliste.append((letter, True))
		self.chooseMenuList.setList(map(watchmoviesListEntry, self.genreliste))
		self.keyLocked = False

	def keyOK(self):
		if self.keyLocked:
			return
		abc = self['liste'].getCurrent()[0][0]
		if not abc == "0-9":
			abc = abc.lower()
		if re.match('Movies', self.Name):
			Link = "http://watchmovies.to/movies/letter=%s" % abc
		else:
			Link = "http://watchmovies.to/tv-shows/letter=%s" % abc
		Title = "%s Selection: %s" % (self.Name.split(' ', 1)[0], abc.upper())
		self.session.open(watchmoviesFilmScreen, Link, Title)

class watchmoviesFilmScreen(MPScreen, ThumbsHelper):

	def __init__(self, session, Link, Name):
		self.Link = Link
		self.Name = Name
		self.plugin_path = mp_globals.pluginPath
		self.skin_path = mp_globals.pluginPath + "/skins"
		path = "%s/%s/defaultListWideScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + "/original/defaultListWideScreen.xml"
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()
		MPScreen.__init__(self, session)
		ThumbsHelper.__init__(self)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok" : self.keyOK,
			"0" : self.closeAll,
			"cancel" : self.keyCancel,
			"5" : self.keyShowThumb,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft,
			"nextBouquet" : self.keyPageUp,
			"prevBouquet" : self.keyPageDown,
			"yellow" : self.keySort,
			"green" : self.keyAdd,
			"blue" : self.keyPageNumber
		}, -1)

		self.sort = config.mediaportal.watchmovies_sort.value
		if self.Name == 'Movies Cinema' or self.Name == 'TV-Shows Featured':
			self.sort = ''
		else:
			self.sort = config.mediaportal.watchmovies_sort.value

		self.country = config.mediaportal.watchmovies_country.value
		self['title'] = Label("watchmovies.to / Filter: %s" % self.country)
		self['ContentTitle'] = Label("%s" % self.Name)
		self['F2'] = Label(_("Add to Watchlist"))
		self['F3'] = Label(self.sort.title())
		self['F4'] = Label(_("Page"))

		self['Page'] = Label(_("Page:"))
		self.keyLocked = True
		self.page = 1
		self.lastpage = 1
		self.filmliste = []
		self.chooseMenuList = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self.chooseMenuList.l.setFont(0, gFont('mediaportal', 23))
		self.chooseMenuList.l.setItemHeight(25)
		self['liste'] = self.chooseMenuList

		self.deferreds = []
		self.ds = defer.DeferredSemaphore(tokens=1)

		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		self.keyLocked = True
		self['name'].setText(_('Please wait...'))

		if self.sort == 'title':
			self.sorturl = "/sort=%s/order=asc" % self.sort
		else:
			self.sorturl = "/sort=%s" % self.sort

		self.filmliste = []
		if self.Name == "Movies Cinema" or self.Name == "TV-Shows Featured":
			url = self.Link
		elif self.Name == "--- Search ---":
			self['F3'].setText('')
			url = "%s/page-%s" % (self.Link, str(self.page))
		else:
			url = "%s%s/page-%s" % (self.Link, self.sorturl, str(self.page))
		print url
		getPage(url, cookies=keckse, headers={'Content-Type':'application/x-www-form-urlencoded'}).addCallback(self.loadData).addErrback(self.dataError)

	def loadData(self, data):
		self.watched_liste = load_watched_liste("mp_wm_watched")
		lastpparse = re.search('First</a>(.*?)</div>', data, re.S)
		if lastpparse:
			lastp = re.findall('page-(\d+)">Last', lastpparse.group(1), re.S)
			if lastp:
				self.lastpage = int(lastp[0])-1
			else:
				self.lastpage = 1
		else:
			self.lastpage = 1
		self['page'].setText(str(self.page) + ' / ' + str(self.lastpage))
		if self.Name == 'Movies Cinema' or self.Name == 'TV-Shows Featured':
			Movies = re.findall('class="cover".*?<a\shref="(.*?)"\stitle="(.*?)".*?<img\ssrc="(.*?)"', data, re.S)
		else:
			Movies = re.findall('<li\sid="entry_.*?<a\shref="(.*?)"\stitle="(.*?)".*?\.to(.*?)[\)|"]', data, re.S)
		if Movies:
			for (Url, Title, Image) in Movies:
				Image = "http://watchmovies.to/%s" % Image
				if decodeHtml(Title) in self.watched_liste:
					self.filmliste.append((decodeHtml(Title), Url, Image, True))
				else:
					self.filmliste.append((decodeHtml(Title), Url, Image, False))
		if len(self.filmliste) == 0:
			self.filmliste.append((_("No videos found!"), None, None, False))
		self.chooseMenuList.setList(map(watchmoviesFilmListEntry, self.filmliste))
		self.chooseMenuList.moveToIndex(0)
		self.keyLocked = False
		self.th_ThumbsQuery(self.filmliste, 0, 1, 2, None, None, self.page, self.lastpage)
		self.showInfos()

	def showInfos(self):
		if self['liste'].getCurrent()[0][1] != None:
			for items in self.deferreds:
				items.cancel()
			self.deferreds = []
			title = self['liste'].getCurrent()[0][0]
			url = self['liste'].getCurrent()[0][1]
			self['name'].setText(title)
			d = self.ds.run(getPage, url, cookies=keckse, agent=std_headers, headers={'Content-Type':'application/x-www-form-urlencoded'}).addCallback(self.loadPageInfos).addErrback(self.errCancelDeferreds).addErrback(self.dataError)
			self.deferreds.append(d)
		else:
			self['name'].setText('')

	def errCancelDeferreds(self, error):
		myerror = error.getErrorMessage()
		if myerror:
			raise error
		else:
			pass

	def loadPageInfos(self, data):
		pic = self['liste'].getCurrent()[0][2]
		CoverHelper(self['coverArt']).getCover(pic)
		handlung = re.findall('box infos">(.*?)<hr', data, re.S|re.I)
		if handlung:
			Handlung = decodeHtml(handlung[0].strip().replace("\n","").replace("<br />",""))
			self['handlung'].setText(Handlung)
		else:
			self['handlung'].setText("No Description found.")

	def keyOK(self):
		if self.keyLocked:
			return
		Link = self['liste'].getCurrent()[0][1]
		if Link == None:
			return
		Title = self['liste'].getCurrent()[0][0]
		Cover = self['liste'].getCurrent()[0][2]
		if re.match('.*?tv-shows', Link):
			self.session.open(watchmoviesSerienScreen, Link, Title, Cover)
		else:
			self.session.open(StreamAuswahl, Title ,Link, Cover)

	def keyAdd(self):
		exist = self['liste'].getCurrent()
		if self.keyLocked or exist == None:
			return
		muTitle = self['liste'].getCurrent()[0][0]
		muID = self['liste'].getCurrent()[0][1]
		muCover = self['liste'].getCurrent()[0][2]
		muWatched = self['liste'].getCurrent()[0][3]

		if not fileExists(config.mediaportal.watchlistpath.value+"mp_wm_watchlist"):
			open(config.mediaportal.watchlistpath.value+"mp_wm_watchlist","w").close()
		if fileExists(config.mediaportal.watchlistpath.value+"mp_wm_watchlist"):
			writePlaylist = open(config.mediaportal.watchlistpath.value+"mp_wm_watchlist","a")
			writePlaylist.write('"%s" "%s" "%s" "%s"\n' % (muTitle, muID, muCover, muWatched))
			writePlaylist.close()
			message = self.session.open(MessageBox, _("Selection was added to the watchlist."), MessageBox.TYPE_INFO, timeout=3)

	def keySort(self):
		if self.keyLocked or self.sort == '':
			return
		if self.sort == "title":
			self.sort = "year"
			config.mediaportal.watchmovies_sort.value = "year"
		elif self.sort == "year":
			self.sort = "hits"
			config.mediaportal.watchmovies_sort.value = "hits"
		elif self.sort == "hits":
			self.sort = "imdb"
			config.mediaportal.watchmovies_sort.value = "imdb"
		elif self.sort == "imdb":
			self.sort = "rating"
			config.mediaportal.watchmovies_sort.value = "rating"
		elif self.sort == "rating":
			self.sort = "id"
			config.mediaportal.watchmovies_sort.value = "id"
		elif self.sort == "id":
			self.sort = "title"
			config.mediaportal.watchmovies_sort.value = "title"

		config.mediaportal.watchmovies_sort.save()
		configfile.save()
		self['F3'].setText(self.sort.title())
		self.loadPage()

class watchmoviesSerienScreen(MPScreen, ThumbsHelper):

	def __init__(self, session, Link, Name, Cover):
		self.Link = Link
		self.Name = Name
		self.Cover = Cover
		self.plugin_path = mp_globals.pluginPath
		self.skin_path = mp_globals.pluginPath + "/skins"
		path = "%s/%s/defaultListWideScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + "/original/defaultListWideScreen.xml"
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()
		MPScreen.__init__(self, session)
		ThumbsHelper.__init__(self)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok" : self.keyOK,
			"0" : self.closeAll,
			"cancel" : self.keyCancel,
			"5" : self.keyShowThumb,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft,
			"nextBouquet" : self.keyPageUp,
			"prevBouquet" : self.keyPageDown
		}, -1)

		self.country = config.mediaportal.watchmovies_country.value
		self['title'] = Label("watchmovies.to / Filter: %s" % self.country)
		self['ContentTitle'] = Label("Genre: TV-Show %s" % self.Name)

		self['Page'] = Label(_("Page:"))
		self['page'] = Label("1 / 1")
		self.keyLocked = True
		self.page = 1
		self.lastpage = 1

		self.filmliste = []
		self.chooseMenuList = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self.chooseMenuList.l.setFont(0, gFont('mediaportal', 23))
		self.chooseMenuList.l.setItemHeight(25)
		self['liste'] = self.chooseMenuList

		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		self.keyLocked = True
		self['name'].setText(_('Please wait...'))
		self.filmliste = []
		print self.Link
		getPage(self.Link, cookies=keckse, headers={'Content-Type':'application/x-www-form-urlencoded'}).addCallback(self.loadData).addErrback(self.dataError)

	def loadData(self, data):
		self.watched_liste = load_watched_liste("mp_wm_watched")
		preparse = re.findall('seasonoverviewlist.*?option>(.*?)</select>', data, re.S|re.I)
		if preparse:
			Movies = re.findall('value="(.*?)"\s>(.*?)<', preparse[0], re.S)
			if Movies:
				for (Url, Title) in Movies:
					if decodeHtml(Title) in self.watched_liste:
						self.filmliste.append((decodeHtml(Title), Url, self.Cover, True))
					else:
						self.filmliste.append((decodeHtml(Title), Url, self.Cover, False))
		if len(self.filmliste) == 0:
			self.filmliste.append((_("No videos found!"), None, None, False))
		self.chooseMenuList.setList(map(watchmoviesFilmListEntry, self.filmliste))
		self.chooseMenuList.moveToIndex(0)
		self.keyLocked = False
		self.th_ThumbsQuery(self.filmliste, 0, 1, 2, None, None, self.page, self.lastpage, mode=1)
		self.showInfos()

	def showInfos(self):
		if self['liste'].getCurrent()[0][1] != None:
			title = self['liste'].getCurrent()[0][0]
			pic = self['liste'].getCurrent()[0][2]
			self['name'].setText(title)
			CoverHelper(self['coverArt']).getCover(pic)
		else:
			self['name'].setText('')

	def keyOK(self):
		if self.keyLocked:
			return
		Link = self['liste'].getCurrent()[0][0]
		if Link == None:
			return
		Title = self['liste'].getCurrent()[0][1]
		Cover = self['liste'].getCurrent()[0][2]
		self.session.open(StreamAuswahl, Link, Title, Cover)

class wmWatchlist(MPScreen):

	def __init__(self, session):
		self.plugin_path = mp_globals.pluginPath
		self.skin_path = mp_globals.pluginPath + "/skins"
		path = "%s/%s/defaultGenreScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + "/original/defaultGenreScreen.xml"
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()
		MPScreen.__init__(self, session)

		self["actions"] = ActionMap(["MP_Actions"], {
			"0": self.closeAll,
			"ok" : self.keyOK,
			"cancel": self.keyCancel,
			"red" : self.keyDel
		}, -1)

		self['title'] = Label("watchmovies.to")
		self['ContentTitle'] = Label("Watchlist")
		self['F1'] = Label(_("Delete"))

		self.streamList = []
		self.streamMenuList = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self.streamMenuList.l.setFont(0, gFont('mediaportal', 23))
		self.streamMenuList.l.setItemHeight(25)
		self['liste'] = self.streamMenuList

		self.keyLocked = True
		self.onLayoutFinish.append(self.loadPlaylist)

	def loadPlaylist(self):
		self.watched_liste = load_watched_liste("mp_wm_watched")
		self.streamList = []
		if fileExists(config.mediaportal.watchlistpath.value+"mp_wm_watchlist"):
			readStations = open(config.mediaportal.watchlistpath.value+"mp_wm_watchlist","r")
			for rawData in readStations.readlines():
				data = re.findall('"(.*?)" "(.*?)" "(.*?)" "(.*?)"', rawData, re.S)
				if data:
					(Title, Url, Lang, null) = data[0]
					if decodeHtml(Title) in self.watched_liste:
						self.streamList.append((decodeHtml(Title), Url, Lang, True))
					else:
						self.streamList.append((decodeHtml(Title), Url, Lang, False))
			print "Load Watchlist.."
			self.streamList.sort()
			self.streamMenuList.setList(map(watchmoviesFilmListEntry, self.streamList))
			readStations.close()
			self.keyLocked = False

	def keyOK(self):
		exist = self['liste'].getCurrent()
		if self.keyLocked or exist == None:
			return
		Title = self['liste'].getCurrent()[0][0]
		Link = self['liste'].getCurrent()[0][1]
		Cover = self['liste'].getCurrent()[0][2]
		print Title, Link
		if re.match('.*?tv-shows', Link):
			self.session.open(watchmoviesSerienScreen, Link, Title, Cover)
		else:
			self.session.open(StreamAuswahl, Title ,Link, Cover)

	def keyDel(self):
		exist = self['liste'].getCurrent()
		if self.keyLocked or exist == None:
			return
		selectedName = self['liste'].getCurrent()[0][0]
		writeTmp = open(config.mediaportal.watchlistpath.value+"mp_wm_watchlist.tmp","w")
		if fileExists(config.mediaportal.watchlistpath.value+"mp_wm_watchlist"):
			readStations = open(config.mediaportal.watchlistpath.value+"mp_wm_watchlist","r")
			for rawData in readStations.readlines():
				data = re.findall('"(.*?)" "(.*?)" "(.*?)" "(.*?)"', rawData, re.S)
				if data:
					(stationName, stationLink, stationLang, stationTotaleps) = data[0]
					if stationName != selectedName:
						writeTmp.write('"%s" "%s" "%s" "%s"\n' % (stationName, stationLink, stationLang, stationTotaleps))
			readStations.close()
			writeTmp.close()
			shutil.move(config.mediaportal.watchlistpath.value+"mp_wm_watchlist.tmp", config.mediaportal.watchlistpath.value+"mp_wm_watchlist")
			self.loadPlaylist()

class StreamAuswahl(MPScreen):

	def __init__(self, session, Title, Link, Cover):
		self.Link = Link
		self.Title = Title
		self.Cover = Cover
		self.plugin_path = mp_globals.pluginPath
		self.skin_path = mp_globals.pluginPath + "/skins"
		path = "%s/%s/defaultListScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + "/original/defaultListScreen.xml"
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()
		MPScreen.__init__(self, session)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok"	: self.keyOK,
			"0" : self.closeAll,
			"cancel": self.keyCancel
		}, -1)

		self['title'] = Label("watchmovies.to")
		self['ContentTitle'] = Label("%s" %self.Title)


		self.filmliste = []
		self.keyLocked = True
		self.chooseMenuList = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self.chooseMenuList.l.setFont(0, gFont('mediaportal', 23))
		self.chooseMenuList.l.setItemHeight(25)
		self['liste'] = self.chooseMenuList
		CoverHelper(self['coverArt']).getCover(self.Cover)
		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		self['name'].setText(_('Please wait...'))
		self.keyLocked = True
		getPage(self.Link, cookies=keckse, headers={'Content-Type':'application/x-www-form-urlencoded'}).addCallback(self.loadPageData).addErrback(self.dataError)

	def loadPageData(self, data):
		mirror = re.findall('mirrorList\[(\d+)]\[i\]\s=\s(\d+);', data, re.S)
		if mirror:
			hosterindex = re.findall('event,\d+,\d+,(\d+),this\).*?>\s(.*?)</a>', data, re.S)
			if hosterindex:
				for (hosterNr2, hostername) in hosterindex:
					for (hosterNr1, steamId ) in mirror:
						if hosterNr1 == hosterNr2:
							stream = "http://watchmovies.to/ajax/mirror/id=%s&hoster=%s" % (steamId, hosterNr1)
							if isSupportedHoster(hostername, True):
								self.filmliste.append((hostername, stream))
		if len(self.filmliste) == 0:
			self.filmliste.append((_('No supported streams found!'), None))
		self.chooseMenuList.setList(map(watchmoviesStreamsEntry, self.filmliste))
		self['name'].setText('')
		self.keyLocked = False

	def keyOK(self):
		if self.keyLocked:
			return
		if not fileExists(config.mediaportal.watchlistpath.value+"mp_wm_watched"):
			open(config.mediaportal.watchlistpath.value+"mp_wm_watched","w").close()

		self.update_liste = []
		leer = os.path.getsize(config.mediaportal.watchlistpath.value+"mp_wm_watched")
		if not leer == 0:
			self.updates_read = open(config.mediaportal.watchlistpath.value+"mp_wm_watched" , "r")
			for lines in sorted(self.updates_read.readlines()):
				line = re.findall('"(.*?)"', lines)
				if line:
					print line[0]
					self.update_liste.append("%s" % (line[0]))
			self.updates_read.close()

			updates_read2 = open(config.mediaportal.watchlistpath.value+"mp_wm_watched" , "a")
			check = ("%s" % self.Title)
			if not check in self.update_liste:
				print "[watchmovie] update add: %s" % (self.Title)
				updates_read2.write('"%s"\n' % (self.Title))
				updates_read2.close()
			else:
				print "[watchmovie] dupe %s" % (self.Title)
		else:
			updates_read3 = open(config.mediaportal.watchlistpath.value+"mp_wm_watched" , "a")
			print "[watchmovie] update add: %s" % (self.Title)
			updates_read3.write('"%s"\n' % (self.Title))
			updates_read3.close()

		url = self['liste'].getCurrent()[0][1]
		getPage(url, cookies=keckse, headers={'Content-Type':'application/x-www-form-urlencoded'}).addCallback(self.getHosterLink).addErrback(self.dataError)

	def getHosterLink(self, data):
		streams = re.findall('="(http://.*?)"', data, re.S)
		if streams:
			get_stream_link(self.session).check_link(streams[0], self.got_link)

	def got_link(self, stream_url):
		if stream_url == None:
			message = self.session.open(MessageBox, _("Stream not found, try another Stream Hoster."), MessageBox.TYPE_INFO, timeout=3)
		else:
			self.session.open(SimplePlayer, [(self.Title, stream_url, self.Cover)], showPlaylist=False, ltype='watchmovies', cover=True)