﻿# -*- coding: utf-8 -*-
###############################################################################################
#
#    MediaPortal for Dreambox OS
#
#    Coded by MediaPortal Team (c) 2013-2015
#
#  This plugin is open source but it is NOT free software.
#
#  This plugin may only be distributed to and executed on hardware which
#  is licensed by Dream Property GmbH. This includes commercial distribution.
#  In other words:
#  It's NOT allowed to distribute any parts of this plugin or its source code in ANY way
#  to hardware which is NOT licensed by Dream Property GmbH.
#  It's NOT allowed to execute this plugin and its source code or even parts of it in ANY way
#  on hardware which is NOT licensed by Dream Property GmbH.
#
#  This applies to the source code as a whole as well as to parts of it, unless
#  explicitely stated otherwise.
#
#  If you want to use or modify the code or parts of it,
#  you have to keep OUR license and inform us about the modifications, but it may NOT be
#  commercially distributed other than under the conditions noted above.
#
#  As an exception regarding modifcations, you are NOT permitted to remove
#  any copy protections implemented in this plugin or change them for means of disabling
#  or working around the copy protections, unless the change has been explicitly permitted
#  by the original authors. Also decompiling and modification of the closed source
#  parts is NOT permitted.
#
#  Advertising with this plugin is NOT allowed.
#  For other uses, permission from the authors is necessary.
#
###############################################################################################

from Plugins.Extensions.MediaPortal.plugin import _
from Plugins.Extensions.MediaPortal.resources.imports import *

def seListEntry(entry):
	return [entry,
		(eListboxPythonMultiContent.TYPE_TEXT, 20, 0, 860, 25, 0, RT_HALIGN_CENTER | RT_VALIGN_CENTER, entry[0])
		]

def seListEntry2(entry):
	return [entry,
		(eListboxPythonMultiContent.TYPE_TEXT, 20, 0, 860, 25, 0, RT_HALIGN_LEFT | RT_VALIGN_CENTER, entry[0])
		]

def seStreamListEntry(entry):
	if config.mediaportal.premiumize_use.value:
		premiumFarbe = int(config.mediaportal.premiumize_color.value, 0)
		if re.search(mp_globals.premium_hosters, entry[0], re.S|re.I):
			return [entry,
				(eListboxPythonMultiContent.TYPE_TEXT, 20, 0, 860, 25, 0, RT_HALIGN_CENTER | RT_VALIGN_CENTER, entry[0], premiumFarbe)
				]
		else:
			return [entry,
				(eListboxPythonMultiContent.TYPE_TEXT, 20, 0, 860, 25, 0, RT_HALIGN_CENTER | RT_VALIGN_CENTER, entry[0])
				]
	else:
		return [entry,
			(eListboxPythonMultiContent.TYPE_TEXT, 20, 0, 860, 25, 0, RT_HALIGN_CENTER | RT_VALIGN_CENTER, entry[0])
			]

glob_agent = 'Mozilla/5.0 (Windows NT 6.1; rv:32.0) Gecko/20100101 Firefox/32.0'

class serieseverMain(MPScreen):

	def __init__(self, session):
		self.plugin_path = mp_globals.pluginPath
		self.skin_path =  mp_globals.pluginPath + "/skins"
		path = "%s/%s/defaultGenreScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + "/original/defaultGenreScreen.xml"
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()

		MPScreen.__init__(self, session)

		self["actions"] = ActionMap(["MP_Actions"], {
			"0": self.closeAll,
			"ok" : self.keyOK,
			"cancel": self.keyCancel
		}, -1)

		self['title'] = Label("Seriesever.com")
		self['ContentTitle'] = Label("Genre Auswahl:")

		self.streamList = []
		self.streamMenuList = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self.streamMenuList.l.setFont(0, gFont('mediaportal', 23))
		self.streamMenuList.l.setItemHeight(25)
		self['liste'] = self.streamMenuList

		self.keyLocked = False
		self.onLayoutFinish.append(self.layoutFinished)

	def layoutFinished(self):
		self.keyLocked = True
		self.streamList.append(("Watchlist", None))
		self.streamList.append(("New Added", "http://seriesever.com/page/"))
		self.streamList.append(("Most Viewed", "http://seriesever.com/most-viewed/page/"))
		self.streamList.append(("Most Commented", "http://seriesever.com/most-commented/page/"))
		self.streamList.append(("Most Rated", "http://seriesever.com/category/action/page/"))
		self.streamList.append(("Action", "http://seriesever.com/most-rated/page/"))
		self.streamList.append(("Adventure", "http://seriesever.com/category/adventure/page/"))
		self.streamList.append(("Animation", "http://seriesever.com/category/animation/page/"))
		self.streamList.append(("Biography", "http://seriesever.com/category/biography/page/"))
		self.streamList.append(("Comedy", "http://seriesever.com/category/comedy/page/"))
		self.streamList.append(("Drama", "http://seriesever.com/category/drama/page/"))
		self.streamList.append(("Familie", "http://seriesever.com/category/familie/page/"))
		self.streamList.append(("Fantasy", "http://seriesever.com/category/fantasy/page/"))
		self.streamList.append(("History", "http://seriesever.com/category/history/page/"))
		self.streamList.append(("Horror", "http://seriesever.com/category/horror/page/"))
		self.streamList.append(("Mystery", "http://seriesever.com/category/mystery/page/"))
		self.streamList.append(("Romantik", "http://seriesever.com/category/romance/page/"))
		self.streamList.append(("Sci-Fi", "http://seriesever.com/category/sci-fi/page/"))
		self.streamList.append(("Thriller", "http://seriesever.com/category/thriller/page/"))
		self.streamMenuList.setList(map(seListEntry, self.streamList))
		self.keyLocked = False

	def keyOK(self):
		exist = self['liste'].getCurrent()
		if self.keyLocked or exist == None:
			return
		auswahl = self['liste'].getCurrent()[0][0]
		url = self['liste'].getCurrent()[0][1]
		print auswahl, url
		if auswahl == "Watchlist":
			self.session.open(serieseverWatchlist)
		else:
			self.session.open(serieseverParsing, auswahl, url)

class serieseverParsing(MPScreen, ThumbsHelper):

	def __init__(self, session, genre, url):
		self.genre = genre
		self.url = url
		self.plugin_path = mp_globals.pluginPath
		self.skin_path =  mp_globals.pluginPath + "/skins"
		path = "%s/%s/defaultListScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + "/original/defaultListScreen.xml"
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()
		MPScreen.__init__(self, session)
		ThumbsHelper.__init__(self)

		self["actions"] = ActionMap(["MP_Actions"], {
			"0": self.closeAll,
			"5" : self.keyShowThumb,
			"ok" : self.keyOK,
			"cancel": self.keyCancel,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft,
			"nextBouquet" : self.keyPageUp,
			"prevBouquet" : self.keyPageDown,
			"green"	: self.keyAdd
		}, -1)

		self['title'] = Label("Seriesever.com")
		self['ContentTitle'] = Label("%s" % self.genre)
		self['F2'] = Label(_("Add"))
		self['Page'] = Label(_("Page:"))

		self.page = 1
		self.lastpage = 1
		self.streamList = []
		self.streamMenuList = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self.streamMenuList.l.setFont(0, gFont('mediaportal', 23))
		self.streamMenuList.l.setItemHeight(25)
		self['liste'] = self.streamMenuList

		self.keyLocked = True
		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		self.streamList = []
		url = self.url+str(self.page)
		getPage(url, headers={'Content-Type':'application/x-www-form-urlencoded'}).addCallback(self.parseData).addErrback(self.dataError)

	def parseData(self, data):
		self.getLastPage(data, "<span class='pages'>Seite.*?von\s(\d+)</span>")
		last = re.findall("<span class='pages'>Seite.*?von\s(\d+)</span>", data, re.S)
		if last:
			self.lastpage = int(last[0])
			self['page'].setText(str(self.page) + ' / ' + str(self.lastpage))

		serien = re.findall('<span class="q-hd">.*?<img src="(http://seriesever.com/wp-content/uploads/.*?)".*?<div class="movief"><a href="(.*?)">(.*?)</a></div>', data, re.S|re.I)
		if serien:
			for (Image, Url, Title) in serien:
				self.streamList.append((decodeHtml(Title), Url, Image))
			self.streamMenuList.setList(map(seListEntry2, self.streamList))
			self.streamMenuList.moveToIndex(0)
			self.keyLocked = False
			self.th_ThumbsQuery(self.streamList, 0, 1, 2, None, None, self.page, self.lastpage)
			self.showInfos()

	def showInfos(self):
		filmName = self['liste'].getCurrent()[0][0]
		self['name'].setText(filmName)
		coverUrl = self['liste'].getCurrent()[0][2]
		CoverHelper(self['coverArt']).getCover(coverUrl)

	def keyOK(self):
		exist = self['liste'].getCurrent()
		if self.keyLocked or exist == None:
			return
		stream_name = self['liste'].getCurrent()[0][0]
		movie_url = self['liste'].getCurrent()[0][1]
		cover = self['liste'].getCurrent()[0][2]
		self.session.open(showStaffeln, stream_name, movie_url, cover)

	def keyAdd(self):
		exist = self['liste'].getCurrent()
		if self.keyLocked or exist == None:
			return
		stream_name = self['liste'].getCurrent()[0][0]
		movie_url = self['liste'].getCurrent()[0][1]
		cover_url = self['liste'].getCurrent()[0][2]
		fn = config.mediaportal.watchlistpath.value+"mp_se_watchlist"
		if not fileExists(fn):
			print "Erstelle SeriesEver Watchlist."
			open(fn,"w").close()
		try:
			writePlaylist = open(fn, "a")
			writePlaylist.write('"%s" "%s" "%s"\n' % (stream_name, movie_url, cover_url))
			writePlaylist.close()
			message = self.session.open(MessageBox, _("Selection was added to the watchlist."), MessageBox.TYPE_INFO, timeout=3)
		except:
			pass

class serieseverWatchlist(MPScreen, ThumbsHelper):

	def __init__(self, session):
		self.plugin_path = mp_globals.pluginPath
		self.skin_path =  mp_globals.pluginPath + "/skins"
		path = "%s/%s/defaultListScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + "/original/defaultListScreen.xml"
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()
		MPScreen.__init__(self, session)
		ThumbsHelper.__init__(self)

		self["actions"] = ActionMap(["MP_Actions"], {
			"0": self.closeAll,
			"ok" : self.keyOK,
			"cancel": self.keyCancel,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft,
			"red" : self.keyDel
		}, -1)

		self['title'] = Label("Seriesever.com")
		self['ContentTitle'] = Label("Watchlist")
		self['F1'] = Label(_("Delete"))

		self.watchList = []
		self.streamMenuList = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self.streamMenuList.l.setFont(0, gFont('mediaportal', 23))
		self.streamMenuList.l.setItemHeight(25)
		self['liste'] = self.streamMenuList

		self.keyLocked = True
		self.onLayoutFinish.append(self.readWatchlist)

	def readWatchlist(self):
		self.keyLocked = True
		self.watchList = []
		self.wl_path = config.mediaportal.watchlistpath.value+"mp_se_watchlist"
		try:
			readStations = open(self.wl_path,"r")
			rawData = readStations.read()
			readStations.close()
		except:
			return

		for m in re.finditer('"(.*?)" "(.*?)" "(.*?)"', rawData):
			(sName, sUrl, sCover) = m.groups()
			self.watchList.append((decodeHtml(sName), sUrl, sCover))
		self.watchList.sort()
		self.streamMenuList.setList(map(seListEntry2, self.watchList))
		self.streamMenuList.moveToIndex(0)
		self.keyLocked = False
		self.showInfos()

	def showInfos(self):
		exist = self['liste'].getCurrent()
		if self.keyLocked or exist == None:
			return
		filmName = self['liste'].getCurrent()[0][0]
		self['name'].setText(filmName)
		coverUrl = self['liste'].getCurrent()[0][2]
		CoverHelper(self['coverArt']).getCover(coverUrl)

	def keyOK(self):
		exist = self['liste'].getCurrent()
		if self.keyLocked or exist == None:
			return
		stream_name = self['liste'].getCurrent()[0][0]
		movie_url = self['liste'].getCurrent()[0][1]
		cover = self['liste'].getCurrent()[0][2]
		self.session.open(showStaffeln, stream_name, movie_url, cover)

	def keyDel(self):
		exist = self['liste'].getCurrent()
		if self.keyLocked or exist == None:
			return

		i = self['liste'].getSelectedIndex()
		c = j = 0
		l = len(self.watchList)
		try:
			f1 = open(self.wl_path, 'w')
			while j < l:
				if j != i:
					(sName, sUrl, sCover) = self.watchList[j]
					f1.write('"%s" "%s" "%s"\n' % (sName, sUrl, sCover))
				j += 1
			f1.close()
			self.readWatchlist()
		except:
			pass

class showStaffeln(MPScreen):

	def __init__(self, session, stream_name, url, cover):
		self.stream_name = stream_name
		self.url = url
		self.cover = cover
		self.plugin_path = mp_globals.pluginPath
		self.skin_path =  mp_globals.pluginPath + "/skins"
		path = "%s/%s/defaultGenreScreenCover.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + "/original/defaultGenreScreenCover.xml"
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()

		MPScreen.__init__(self, session)

		self["actions"]  = ActionMap(["MP_Actions"], {
			"0": self.closeAll,
			"ok" : self.keyOK,
			"cancel": self.keyCancel
		}, -1)

		self['title'] = Label("Seriesever.com")
		self['ContentTitle'] = Label("Staffeln:")

		self.staffeln = []
		self.streamMenuList = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self.streamMenuList.l.setFont(0, gFont('mediaportal', 23))
		self.streamMenuList.l.setItemHeight(25)
		self['liste'] = self.streamMenuList

		self.keyLocked = True
		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		self.staffeln = []
		getPage(self.url, headers={'Content-Type':'application/x-www-form-urlencoded'}).addCallback(self.parseData).addErrback(self.dataError)

	def parseData(self, data):
		self.staffeln = []
		staffeln_raw = re.findall('Staffeln:(.*?)>Add a comment<', data)
		if staffeln_raw:
			staffelnlist = re.findall('<span> (\d+)</span>', staffeln_raw[0])
			if staffelnlist:
				for staffel in staffelnlist:
					surl = self.url + staffel+ "/"
					self.staffeln.append((staffel, surl))
			self.streamMenuList.setList(map(seListEntry, self.staffeln))
			CoverHelper(self['coverArt']).getCover(self.cover)
			self.keyLocked = False

	def keyOK(self):
		exist = self['liste'].getCurrent()
		if self.keyLocked or exist == None:
			return
		staffel_auswahl = self['liste'].getCurrent()[0][0]
		staffel_url = self['liste'].getCurrent()[0][1]
		print staffel_auswahl, staffel_url
		stream_name = "%s Staffel %s" % (self.stream_name, staffel_auswahl)
		self.session.open(showEpisoden, stream_name, staffel_url, self.cover)

class showEpisoden(MPScreen):

	def __init__(self, session, stream_name, url, cover):
		self.stream_name = stream_name
		self.url = url
		self.cover = cover
		self.plugin_path = mp_globals.pluginPath
		self.skin_path =  mp_globals.pluginPath + "/skins"
		path = "%s/%s/defaultGenreScreenCover.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + "/original/defaultGenreScreenCover.xml"
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()

		MPScreen.__init__(self, session)

		self["actions"]  = ActionMap(["MP_Actions"], {
			"0": self.closeAll,
			"ok" : self.keyOK,
			"cancel": self.keyCancel
		}, -1)

		self['title'] = Label("Seriesever.com")
		self['ContentTitle'] = Label("Episoden:")

		self.episoden = []
		self.streamMenuList = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self.streamMenuList.l.setFont(0, gFont('mediaportal', 23))
		self.streamMenuList.l.setItemHeight(25)
		self['liste'] = self.streamMenuList

		self.keyLocked = True
		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		self.episoden = []
		print self.url
		getPage(self.url, headers={'Content-Type':'application/x-www-form-urlencoded'}).addCallback(self.parseData).addErrback(self.dataError)

	def parseData(self, data):
		self.data = data
		self.episoden = []
		episoden_raw = re.findall('<p><strong>Episode (.*?)</strong>.*?<em>(.*?)</em>', data, re.S|re.I)
		if episoden_raw:
			print "yes"
			for zahl,title in episoden_raw:
				print zahl,title
				self.episoden.append(("Episode "+zahl, title))
			self.streamMenuList.setList(map(seListEntry, self.episoden))
			CoverHelper(self['coverArt']).getCover(self.cover)
			self.keyLocked = False
		else:
			print "no"

	def keyOK(self):
		exist = self['liste'].getCurrent()
		if self.keyLocked or exist == None:
			return
		episode_zahl = self['liste'].getCurrent()[0][0]
		episode_title = self['liste'].getCurrent()[0][1]
		print episode_zahl, episode_title
		vd = re.search('var videoscript_domain = "(.*?)"', self.data, re.S|re.I)
		s = re.search('<strong>'+episode_zahl+'</strong>.*?video_load\(\'(.*?)\'', self.data, re.S|re.I)
		streams = []
		if s and vd:
			stream1 = 'http://%s/vk_video/video.php?action=get&url=%s' % (vd.group(1), s.group(1))
			print "Main Stream: ", stream1
			streams.append(("1 - Main Stream", stream1))
		s = re.search('<strong>'+episode_zahl+'</strong>.*?metadataUrl=(.*?)"', self.data, re.S|re.I)
		if not s:
			s = re.search('<strong>'+episode_zahl+'</strong>.*?<p><iframe.*?src="(.*?)"', self.data, re.S|re.I)
		if s:
			stream2 = urllib.unquote(s.group(1))
			print "Alternative Stream: ", stream2
			if re.search('http://|https://', stream2, re.I):
				streams.append(("2 - Alternative Stream", stream2))

		stream_name =  "%s %s" % (self.stream_name, episode_zahl)
		self.session.open(showStreams, stream_name, streams, self.cover)

class showStreams(MPScreen):

	def __init__(self, session, stream_name, streams, cover):
		self.stream_name = stream_name
		self.streams = streams
		self.cover = cover
		self.plugin_path = mp_globals.pluginPath
		self.skin_path =  mp_globals.pluginPath + "/skins"
		path = "%s/%s/defaultGenreScreenCover.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + "/original/defaultGenreScreenCover.xml"
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()

		MPScreen.__init__(self, session)

		self["actions"]  = ActionMap(["MP_Actions"], {
			"0": self.closeAll,
			"ok" : self.keyOK,
			"cancel": self.keyCancel
		}, -1)

		self['title'] = Label("Seriesever.com")
		self['ContentTitle'] = Label("Streams:")

		self.episoden = []
		self.streamMenuList = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self.streamMenuList.l.setFont(0, gFont('mediaportal', 23))
		self.streamMenuList.l.setItemHeight(25)
		self['liste'] = self.streamMenuList

		self.keyLocked = True
		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		self.streamMenuList.setList(map(seListEntry, self.streams))
		CoverHelper(self['coverArt']).getCover(self.cover)
		self.keyLocked = False

	def keyOK(self):
		exist = self['liste'].getCurrent()
		if self.keyLocked or exist == None:
			return
		self.streamname = self['liste'].getCurrent()[0][0]
		stream = self['liste'].getCurrent()[0][1]
		print stream
		if self.streamname.startswith("2") and not 'videoPlayerMetadata' in stream:
			getPage(stream, agent=glob_agent).addCallback(self.getMetadataUrl).addErrback(self.dataError)
		else:
			getPage(stream, agent=glob_agent).addCallback(self.parseData).addErrback(self.dataError)

	def getMetadataUrl(self, data):
		print data
		m = re.search('metadataUrl.*?(http://.*?)&quot;', data)
		if m:
			url = urllib.unquote(m.group(1))
			getPage(url, agent=glob_agent).addCallback(self.parseData).addErrback(self.dataError)
		else:
			self.session.open(MessageBox, _("Stream not found, try another Stream Hoster."), MessageBox.TYPE_INFO, timeout=5)

	def parseData(self, data):
		print data
		try:
			if self.streamname.startswith("1"):
				stream_url = re.findall('"(.*?\/[0-9].mp4)"', data, re.S)
				stream_url = self._getVideoUrl(stream_url, 1).replace('\\', '')
			else:
				i = data.find('"videos":')
				stream_url = re.findall('"url":"(.*?)"', data[i:])
				stream_url = decodeHtml(self._getVideoUrl(stream_url, 2))
		except:
			self.session.open(MessageBox, _("Stream not found, try another Stream Hoster."), MessageBox.TYPE_INFO, timeout=5)
		else:
			print stream_url
			mp_globals.player_agent = glob_agent
			self.session.open(SimplePlayer, [(self.stream_name, stream_url, self.cover)], cover=True, showPlaylist=False, ltype='seriesever')

	def _getVideoUrl(self, ulist, qofs):
		q = int(config.mediaportal.videoquali_others.value) + qofs
		return ulist[min(q, len(ulist) - 1)]
