﻿# -*- coding: utf-8 -*-
from Plugins.Extensions.MediaPortal.plugin import _
from Plugins.Extensions.MediaPortal.resources.imports import *

def awListEntry(entry):
	return [entry,
		(eListboxPythonMultiContent.TYPE_TEXT, 20, 0, 860, 25, 0, RT_HALIGN_CENTER | RT_VALIGN_CENTER, entry[0])
		]

def awListEntry2(entry):
	return [entry,
		(eListboxPythonMultiContent.TYPE_TEXT, 20, 0, 860, 25, 0, RT_HALIGN_LEFT | RT_VALIGN_CENTER, entry[0])
		]

def awListEntry3(entry):
	return [entry,
		(eListboxPythonMultiContent.TYPE_TEXT, 20, 0, 100, 25, 0, RT_HALIGN_LEFT | RT_VALIGN_CENTER, entry[0]),
		(eListboxPythonMultiContent.TYPE_TEXT, 100, 0, 730, 25, 0, RT_HALIGN_LEFT | RT_VALIGN_CENTER, entry[1])
		]

def awStreamListEntry(entry):
	if config.mediaportal.premiumize_use.value:
		premiumFarbe = int(config.mediaportal.premiumize_color.value, 0)
		if re.search(mp_globals.premium_hosters, entry[0], re.S|re.I):
			return [entry,
				(eListboxPythonMultiContent.TYPE_TEXT, 20, 0, 860, 25, 0, RT_HALIGN_CENTER | RT_VALIGN_CENTER, entry[0], premiumFarbe)
				]
		else:
			return [entry,
				(eListboxPythonMultiContent.TYPE_TEXT, 20, 0, 860, 25, 0, RT_HALIGN_CENTER | RT_VALIGN_CENTER, entry[0])
				]
	else:
		return [entry,
			(eListboxPythonMultiContent.TYPE_TEXT, 20, 0, 860, 25, 0, RT_HALIGN_CENTER | RT_VALIGN_CENTER, entry[0])
			]

class animeWorldMAin(MPScreen, ThumbsHelper):

	def __init__(self, session):
		self.plugin_path = mp_globals.pluginPath
		self.skin_path =  mp_globals.pluginPath + "/skins"
		path = "%s/%s/defaultListScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + "/original/defaultListScreen.xml"
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()
		MPScreen.__init__(self, session)
		ThumbsHelper.__init__(self)

		self["actions"] = ActionMap(["MP_Actions"], {
			"0": self.closeAll,
			"5" : self.keyShowThumb,
			"ok" : self.keyOK,
			"cancel": self.keyCancel,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft,
			"nextBouquet" : self.keyPageUp,
			"prevBouquet" : self.keyPageDown
		}, -1)

		self['title'] = Label("anime-world24.net")
		self['ContentTitle'] = Label("Animeliste A-Z:")


		self.streamList = []
		self.streamMenuList = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self.streamMenuList.l.setFont(0, gFont('mediaportal', 23))
		self.streamMenuList.l.setItemHeight(25)
		self['liste'] = self.streamMenuList

		self.keyLocked = True
		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		self.streamList = []
		url = "http://anime-world24.net/animeliste"
		getPage(url, headers={'Content-Type':'application/x-www-form-urlencoded'}).addCallback(self.parseData).addErrback(self.dataError)

	def parseData(self, data):
		movies = re.findall('onmouseout="hidePreview\(\'(images/anime.*?)\'\)">.*?<td><a href="(.*?)">(.*?)</a></td>', data, re.S)
		if movies:
			for (Image, Url, Title) in movies:
				Url = "http://anime-world24.net/" + Url
				Image = "http://anime-world24.net/" + Image
				self.streamList.append((decodeHtml(Title), Url, Image))
			self.streamMenuList.setList(map(awListEntry2, self.streamList))
			self.streamMenuList.moveToIndex(0)
			self.keyLocked = False
			self.th_ThumbsQuery(self.streamList, 0, 1, 2, None, None, 1, 1)
			self.showInfos()

	def showInfos(self):
		filmName = self['liste'].getCurrent()[0][0]
		self['name'].setText(filmName)
		coverUrl = self['liste'].getCurrent()[0][2]
		CoverHelper(self['coverArt']).getCover(coverUrl)

	def keyOK(self):
		exist = self['liste'].getCurrent()
		if self.keyLocked or exist == None:
			return
		stream_name = self['liste'].getCurrent()[0][0]
		movie_url = self['liste'].getCurrent()[0][1]
		cover = self['liste'].getCurrent()[0][2]
		self.session.open(animeWorldFolgen, stream_name, movie_url, cover)

class animeWorldFolgen(MPScreen):

	def __init__(self, session, stream_name, url, cover):
		self.stream_name = stream_name
		self.url = url
		self.cover = cover
		self.plugin_path = mp_globals.pluginPath
		self.skin_path =  mp_globals.pluginPath + "/skins"
		path = "%s/%s/defaultGenreScreenCover.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + "/original/defaultGenreScreenCover.xml"
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()

		MPScreen.__init__(self, session)

		self["actions"]  = ActionMap(["MP_Actions"], {
			"0": self.closeAll,
			"ok" : self.keyOK,
			"cancel": self.keyCancel
		}, -1)

		self['title'] = Label("anime-world24.net")
		self['ContentTitle'] = Label("Folgen:")
		self['name'] = Label("%s" % self.stream_name)


		self.streamList = []
		self.streamMenuList = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self.streamMenuList.l.setFont(0, gFont('mediaportal', 23))
		self.streamMenuList.l.setItemHeight(25)
		self['liste'] = self.streamMenuList

		self.keyLocked = True
		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		self.streamList = []
		getPage(self.url, headers={'Content-Type':'application/x-www-form-urlencoded'}).addCallback(self.parseData).addErrback(self.dataError)

	def parseData(self, data):
		self.streamList = []
		folgen = re.findall('<td class="textcenter"><a href=".*?">(\d+)</a></td>.*?<td><a href="(.*?)">(.*?)</a></td>', data, re.S)
		if folgen:
			for (sFolge, sUrl, sTitle) in folgen:
				sUrl = "http://anime-world24.net/"+sUrl
				self.streamList.append((sFolge, decodeHtml(sTitle), sUrl))
			self.streamMenuList.setList(map(awListEntry3, self.streamList))
			CoverHelper(self['coverArt']).getCover(self.cover)
			self.keyLocked = False

	def keyOK(self):
		exist = self['liste'].getCurrent()
		if self.keyLocked or exist == None:
			return
		self.sFolge = self['liste'].getCurrent()[0][0]
		self.sTitle = self['liste'].getCurrent()[0][1]
		sUrl = self['liste'].getCurrent()[0][2]
		print self.sFolge, self.sTitle, sUrl
		getPage(sUrl, headers={'Content-Type':'application/x-www-form-urlencoded'}).addCallback(self.streamData).addErrback(self.dataError)

	def streamData(self, data):
		string = 'title: "Folge %s".*?file: "(.*?)"' % self.sFolge
		stream_url = re.findall(string, data, re.S)
		if stream_url:
			stream_url = stream_url[0]
			self.session.open(SimplePlayer, [(self.sFolge+" "+self.sTitle, stream_url, self.cover)], showPlaylist=False, ltype='animeworld', cover=True)
		else:
			print "Parsing Fehler.."