﻿# -*- coding: utf-8 -*-
###############################################################################################
#
#    MediaPortal for Dreambox OS
#
#    Coded by MediaPortal Team (c) 2013-2014
#
#  This plugin is open source but it is NOT free software.
#
#  This plugin may only be distributed to and executed on hardware which
#  is licensed by Dream Property GmbH. This includes commercial distribution.
#  In other words:
#  It's NOT allowed to distribute any parts of this plugin or its source code in ANY way
#  to hardware which is NOT licensed by Dream Property GmbH.
#  It's NOT allowed to execute this plugin and its source code or even parts of it in ANY way
#  on hardware which is NOT licensed by Dream Property GmbH.
#
#  This applies to the source code as a whole as well as to parts of it, unless
#  explicitely stated otherwise.
#
#  If you want to use or modify the code or parts of it,
#  you have to keep OUR license and inform us about the modifications, but it may NOT be
#  commercially distributed other than under the conditions noted above.
#
#  As an exception regarding modifcations, you are NOT permitted to remove
#  any copy protections implemented in this plugin or change them for means of disabling
#  or working around the copy protections, unless the change has been explicitly permitted
#  by the original authors. Also decompiling and modification of the closed source
#  parts is NOT permitted.
#
#  Advertising with this plugin is NOT allowed.
#  For other uses, permission from the authors is necessary.
#
###############################################################################################

from Plugins.Extensions.MediaPortal.plugin import _
from Plugins.Extensions.MediaPortal.resources.imports import *

config.mediaportal.alluc_country = ConfigText(default="DE", fixed_size=False)
keckse = {}

def allucListEntry(entry):
	return [entry,
		(eListboxPythonMultiContent.TYPE_TEXT, 20, 0, 860, 25, 0, RT_HALIGN_CENTER | RT_VALIGN_CENTER, entry[0])
		]

def auWatchedSerieEntry(entry):
	if entry[3]:
		png = "/usr/lib/enigma2/python/Plugins/Extensions/MediaPortal/images/watched.png"
		watched = LoadPixmap(png)
		return [entry,
			(eListboxPythonMultiContent.TYPE_PIXMAP_ALPHATEST, 20, 3, 100, 22, watched),
			(eListboxPythonMultiContent.TYPE_TEXT, 60, 0, 700, 25, 0, RT_HALIGN_LEFT | RT_VALIGN_CENTER, entry[0])
			]
	else:
		return [entry,
			(eListboxPythonMultiContent.TYPE_TEXT, 60, 0, 700, 25, 0, RT_HALIGN_LEFT | RT_VALIGN_CENTER, entry[0])
			]

def auWatchedListEntry(entry):
	langpng = "/usr/lib/enigma2/python/Plugins/Extensions/MediaPortal/images/%s.png" % entry[2]
	if not fileExists(langpng):
		langpng = "/usr/lib/enigma2/python/Plugins/Extensions/MediaPortal/images/15.png"
	flag = LoadPixmap(langpng)
	if entry[3]:
		watchpng = "/usr/lib/enigma2/python/Plugins/Extensions/MediaPortal/images/watched.png"
		watched = LoadPixmap(watchpng)
		return [entry,
			(eListboxPythonMultiContent.TYPE_PIXMAP_ALPHATEST, 20, 5, 16, 11, flag),
			(eListboxPythonMultiContent.TYPE_PIXMAP_ALPHATEST, 50, 3, 100, 22, watched),
			(eListboxPythonMultiContent.TYPE_TEXT, 100, 0, 750, 25, 0, RT_HALIGN_LEFT | RT_VALIGN_CENTER, entry[0]),
			]
	else:
		return [entry,
			(eListboxPythonMultiContent.TYPE_PIXMAP_ALPHATEST, 20, 5, 16, 11, flag),
			(eListboxPythonMultiContent.TYPE_TEXT, 100, 0, 750, 25, 0, RT_HALIGN_LEFT | RT_VALIGN_CENTER, entry[0]),
			]

def allucFilmListEntry(entry):
	return [entry,
		(eListboxPythonMultiContent.TYPE_TEXT, 20, 0, 860, 25, 0, RT_HALIGN_LEFT | RT_VALIGN_CENTER, entry[0])
		]

def allucHostersEntry(entry):
	if config.mediaportal.premiumize_use.value and re.search(mp_globals.premium_hosters, entry[0], re.S|re.I):
		premiumFarbe = int(config.mediaportal.premiumize_color.value, 0)
		return [entry,
			(eListboxPythonMultiContent.TYPE_TEXT, 20, 0, 860, 25, 0, RT_HALIGN_CENTER | RT_VALIGN_CENTER, entry[0]+"  Links: "+entry[1], premiumFarbe)
			]
	else:
		return [entry,
			(eListboxPythonMultiContent.TYPE_TEXT, 20, 0, 860, 25, 0, RT_HALIGN_CENTER | RT_VALIGN_CENTER, entry[0]+"  Links: "+entry[1])
			]

def allucSubHostersEntry(entry):
		return [entry,
			(eListboxPythonMultiContent.TYPE_TEXT, 20, 0, 500, 25, 0, RT_HALIGN_LEFT | RT_VALIGN_CENTER, entry[1]),
			(eListboxPythonMultiContent.TYPE_TEXT, 550, 0, 130, 25, 0, RT_HALIGN_LEFT | RT_VALIGN_CENTER, "Rate: "+entry[3]),
			(eListboxPythonMultiContent.TYPE_TEXT, 680, 0, 200, 25, 0, RT_HALIGN_LEFT | RT_VALIGN_CENTER, "Hits: "+entry[4])
			]

def load_watched_liste(watchfile):
	watched_liste = []
	if not fileExists(config.mediaportal.watchlistpath.value+watchfile):
		open(config.mediaportal.watchlistpath.value+watchfile,"w").close()
	if fileExists(config.mediaportal.watchlistpath.value+watchfile):
		leer = os.path.getsize(config.mediaportal.watchlistpath.value+watchfile)
		if not leer == 0:
			updates_read = open(config.mediaportal.watchlistpath.value+watchfile , "r")
			for lines in sorted(updates_read.readlines()):
				line = re.findall('"(.*?)"', lines)
				if line:
					watched_liste.append("%s" % (line[0]))
			updates_read.close()
	return(watched_liste)

class allucMenueScreen(MPScreen):

	def __init__(self, session, mode=False):
		if mode == "porn":
			self.allucPorn = True
		else:
			self.allucPorn = False
		self.plugin_path = mp_globals.pluginPath
		self.skin_path = mp_globals.pluginPath + "/skins"
		path = "%s/%s/defaultGenreScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + "/original/defaultGenreScreen.xml"
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()
		MPScreen.__init__(self, session)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok" : self.keyOK,
			"0" : self.closeAll,
			"cancel" : self.keyCancel,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft,
			"blue"	: self.keyCountry
		}, -1)

		self.country = config.mediaportal.alluc_country.value
		self['title'] = Label("alluc.to")
		self['ContentTitle'] = Label("Genre:")
		self['F4'] = Label(self.country)
		self.keyLocked = True
		self.suchString = ''

		self.genreliste = []
		self.chooseMenuList = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self.chooseMenuList.l.setFont(0, gFont('mediaportal', 23))
		self.chooseMenuList.l.setItemHeight(25)
		self['liste'] = self.chooseMenuList

		self.onLayoutFinish.append(self.genreData)

	def genreData(self):
		if self.allucPorn:
			self.genreliste.append(("Latest Updates", "http://dir.alluc.to/xxx.html?mode=updated"))
			self.genreliste.append(("Most Popular", "http://dir.alluc.to/xxx.html"))
			self.genreliste.append(("Genres (XXX)", ""))
			self.genreliste.append(("A-Z", "http://dir.alluc.to/xxx.html"))
		else:
			self.genreliste.append(("Movies most popular", "http://dir.alluc.to/movies.html"))
			self.genreliste.append(("Movies Genre", ""))
			self.genreliste.append(("Movies updated", "http://dir.alluc.to/movies.html?mode=updated"))
			self.genreliste.append(("Movies A-Z", "http://dir.alluc.to/movies.html"))
			self.genreliste.append(("Cartoons most popular", "http://dir.alluc.to/cartoons.html"))
			self.genreliste.append(("Cartoons A-Z", "http://dir.alluc.to/cartoons.html"))
			self.genreliste.append(("Anime most popular", "http://dir.alluc.to/anime.html"))
			self.genreliste.append(("Anime A-Z", "http://dir.alluc.to/anime.html"))
			self.genreliste.append(("Documentaries most popular", "http://dir.alluc.to/documentaries.html"))
			self.genreliste.append(("Documentaries A-Z", "http://dir.alluc.to/documentaries.html"))
			self.genreliste.append(("TV-Shows most popular", "http://dir.alluc.to/tv-shows.html"))
			self.genreliste.append(("TV-Shows A-Z", "http://dir.alluc.to/tv-shows.html"))
			self.genreliste.append(("Watchlist","dump"))
		self.genreliste.insert(0, ("--- Search ---", "callSuchen"))
		self.chooseMenuList.setList(map(allucListEntry, self.genreliste))
		self.chooseMenuList.moveToIndex(0)
		self.keyLocked = False

	def keyOK(self):
		if self.keyLocked:
			return
		if self.country == "DE":
			self.Lang = '?lang=de'
		elif self.country == "ENG":
			self.Lang = '?lang=en'
		elif self.country == "DE/ENG":
			self.Lang = ''
		Name = self['liste'].getCurrent()[0][0]
		Link = self['liste'].getCurrent()[0][1]
		if Name == "--- Search ---":
			self.suchen()
		elif Name == "Watchlist":
			self.session.open(auWatchlist)
		elif re.search('A-Z', Name):
			Link = '%s%s' % (Link, self.Lang)
			self.session.open(allucAZScreen, Name, Link, self.Lang)
		elif re.search('Genre', Name, re.S|re.I):
			self.session.open(allucGenreScreen, Name, self.Lang)
		else:
			if re.search('update', Name, re.S|re.I):
				Link = '%s&%s' % (Link, self.Lang)
			else:
				Link = '%s?%s' % (Link, self.Lang)
			self.session.open(allucFilmScreen, Link, Name, self.Lang)

	def SuchenCallback(self, callback = None, entry = None):
		if callback is not None and len(callback):
			self.suchString = callback.replace(' ', '+')
			Name = "--- Search ---"
			if not self.allucPorn:
				Link = 'http://dir.alluc.to/search.html?sword=%s&sort=a' % self.suchString
			else:
				Link = "http://dir.alluc.to/xxx.html?mode=search&filter=&sort=&sword=%s&searchmode=" % self.suchString
			self.session.open(allucFilmScreen, Link, Name, self.Lang)

	def keyCountry(self):
		if self.country == "DE/ENG":
			self.country = "DE"
		elif self.country == "DE":
			self.country = "ENG"
		elif self.country == "ENG":
			self.country = "DE/ENG"
		config.mediaportal.alluc_country.value = self.country
		config.mediaportal.alluc_country.save()
		configfile.save()
		self['F4'].setText(self.country)

class allucGenreScreen(MPScreen):

	def __init__(self, session, Name, Lang):
		self.Name = Name
		self.Lang = Lang
		self.plugin_path = mp_globals.pluginPath
		self.skin_path = mp_globals.pluginPath + "/skins"
		path = "%s/%s/defaultGenreScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + "/original/defaultGenreScreen.xml"
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()
		MPScreen.__init__(self, session)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok" : self.keyOK,
			"0" : self.closeAll,
			"cancel" : self.keyCancel
		}, -1)

		self.country = config.mediaportal.alluc_country.value
		self['title'] = Label("alluc.to / Filter: %s" % self.country)
		self['ContentTitle'] = Label("%s" % self.Name)
		self['F4'] = Label(self.country)
		self.keyLocked = True
		self.suchString = ''

		self.genreliste = []
		self.chooseMenuList = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self.chooseMenuList.l.setFont(0, gFont('mediaportal', 23))
		self.chooseMenuList.l.setItemHeight(25)
		self['liste'] = self.chooseMenuList

		self.onLayoutFinish.append(self.layoutFinished)

	def layoutFinished(self):
		self.keyLocked = True
		if re.search('XXX', self.Name):
			url = "http://dir.alluc.to/adult/genres.html%s" % self.Lang
		else:
			url = "http://dir.alluc.to/movies/genres.html%s" % self.Lang
		print url
		getPage(url, cookies=keckse, headers={'Content-Type':'application/x-www-form-urlencoded'}).addCallback(self.genreData).addErrback(self.dataError)

	def genreData(self, data):
		preparse = re.search('select_genre(.*?)select_year', data, re.S|re.I)
		if preparse:
			Cats = re.findall('value="(.*?)\|.*?>(.*?)<', preparse.group(1))
			if Cats:
				for CatID, Cat in Cats:
					self.genreliste.append((Cat, CatID))
		self.chooseMenuList.setList(map(allucListEntry, self.genreliste))
		self.chooseMenuList.moveToIndex(0)
		self.keyLocked = False

	def keyOK(self):
		if self.keyLocked:
			return
		Cat = self['liste'].getCurrent()[0][0]
		CatID = self['liste'].getCurrent()[0][1]
		Link = "http://dir.alluc.to/movies/%s/%s.html%s" % (Cat, CatID, self.Lang)
		Title = "%s Selection: %s" % (self.Name.split(' ', 1)[0], Cat)
		self.session.open(allucFilmScreen, Link, Title, self.Lang)

class allucAZScreen(MPScreen):

	def __init__(self, session, Name, Url, Lang):
		self.Name = Name
		self.Url = Url
		self.Lang = Lang
		self.plugin_path = mp_globals.pluginPath
		self.skin_path = mp_globals.pluginPath + "/skins"
		path = "%s/%s/defaultGenreScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + "/original/defaultGenreScreen.xml"
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()

		MPScreen.__init__(self, session)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok" : self.keyOK,
			"0" : self.closeAll,
			"cancel" : self.keyCancel
		}, -1)

		self.country = config.mediaportal.alluc_country.value
		self['title'] = Label("alluc.to / Filter: %s" % self.country)
		self['ContentTitle'] = Label("%s" % self.Name)
		self['F2'] = Label(_("Add to Watchlist"))
		self.keyLocked = True
		self.suchString = ''

		self.genreliste = []
		self.chooseMenuList = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self.chooseMenuList.l.setFont(0, gFont('mediaportal', 23))
		self.chooseMenuList.l.setItemHeight(25)
		self['liste'] = self.chooseMenuList

		self.onLayoutFinish.append(self.genreData)

	def genreData(self):
		abc = ["#","A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z"]
		for letter in abc:
			self.genreliste.append((letter, True))
		self.chooseMenuList.setList(map(allucListEntry, self.genreliste))
		self.keyLocked = False

	def keyOK(self):
		if self.keyLocked:
			return
		abc = self['liste'].getCurrent()[0][0]
		Title = "%s Selection: %s" % (self.Name.split(' ', 1)[0], abc)
		if abc == "#":
			abc = '%23'
		if re.match('.*?\?', self.Url):
			Link = "%s&mode=showall&letter=%s" % (self.Url, abc)
		else:
			Link = "%s?mode=showall&letter=%s" % (self.Url, abc)
		self.session.open(allucFilmScreen, Link, Title, self.Lang)

class allucFilmScreen(MPScreen, ThumbsHelper):

	def __init__(self, session, Link, Name, Lang="2" ):
		self.Link = Link.replace(' ', '%20')
		self.Name = Name
		self.Lang = Lang
		self.plugin_path = mp_globals.pluginPath
		self.skin_path = mp_globals.pluginPath + "/skins"
		path = "%s/%s/defaultListWideScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + "/original/defaultListWideScreen.xml"
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()
		MPScreen.__init__(self, session)
		ThumbsHelper.__init__(self)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok" : self.keyOK,
			"0" : self.closeAll,
			"cancel" : self.keyCancel,
			"5" : self.keyShowThumb,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft,
			"nextBouquet" : self.keyPageUp,
			"prevBouquet" : self.keyPageDown,
			"green" : self.keyAdd,
			"blue" : self.keyPageNumber
		}, -1)

		self.country = config.mediaportal.alluc_country.value
		self['title'] = Label("alluc.to / Filter: %s" % self.country)
		self['ContentTitle'] = Label("%s" % self.Name)
		self['F2'] = Label(_("Add to Watchlist"))
		self['F4'] = Label(_("Page"))

		self.keyLocked = True
		self.page = 1
		self.lastpage = 1
		self.filmliste = []
		self.Cover = ''
		self.chooseMenuList = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self.chooseMenuList.l.setFont(0, gFont('mediaportal', 23))
		self.chooseMenuList.l.setItemHeight(25)
		self['liste'] = self.chooseMenuList

		self.deferreds = []
		self.ds = defer.DeferredSemaphore(tokens=1)

		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		self.keyLocked = True
		self['name'].setText(_('Please wait...'))
		self.filmliste = []
		if re.search("Search", self.Name):
			if self.page > 1:
				Url = "%s&page=%s" % (self.Link, self.page)
			else:
				Url = self.Link
		else:
			Url = self.Link
		getPage(Url, cookies=keckse, headers={'Content-Type':'application/x-www-form-urlencoded'}).addCallback(self.loadPageData).addErrback(self.dataError)

	def loadPageData(self, data):
		self.watched_liste = load_watched_liste("mp_au_watched")
		if re.search('Search', self.Name):
			self['Page'].setText(_("Page:"))
			self.getLastPage(data, 'class="catnavigator"\sclass="page"(.*?)</div>', '.*>\[(\d+)\]<')
			preparse = re.search('catmenubox(.*?)<div class="footer">', data, re.S|re.I)
			if preparse:
				Movies = re.findall('class="newlinks"\shref="(.*?)"\stitle="watch\s(.*?)\sonline".*?<div class(.*?)newlinkscaption', preparse.group(1), re.S)
				if Movies:
					for Url, Title, Lang in Movies:
						if re.search('alt="german"', Lang):
							Lang = '1'
						else:
							Lang = '2'
						Title = Title.strip()
						Type = re.findall('^(.*?)/.*?', Url)
						if Type:
							Title = '%s - %s' % (Type[0].capitalize(), Title)
						Url = 'http://dir.alluc.to/%s' % Url
						if decodeHtml(Title) in self.watched_liste:
							self.filmliste.append((decodeHtml(Title), Url, Lang, True))
						else:
							self.filmliste.append((decodeHtml(Title), Url, Lang, False))
		else:
			preparse = re.search('catcontent(.*?)footerbox', data, re.S|re.I)
			if preparse:
				Movies = re.findall('class="linklist2">\s+<a\shref="(.*?)"\stitle="watch\s(.*?)\sonline', preparse.group(1), re.S)
				if Movies:
					for Url, Title in Movies:
						if not re.match('.*?\?mode=', Url):
							Url = 'http://dir.alluc.to/%s' % Url
							Title = decodeHtml(Title)
							if self.Lang == '?lang=de':
								Lang = '1'
							elif self.Lang == '?lang=en':
								Lang = '2'
							else:
								Lang = '15'
							if Title in self.watched_liste:
								self.filmliste.append((Title, Url, Lang, True))
							else:
								self.filmliste.append((Title, Url, Lang, False))
		if len(self.filmliste) == 0:
			self.filmliste.append((_("No videos found!"), None, '', False))
		self.chooseMenuList.setList(map(auWatchedListEntry, self.filmliste))
		self.chooseMenuList.moveToIndex(0)
		self['name'].setText('')
		self.keyLocked = False
		self.th_ThumbsQuery(self.filmliste, 0, 1, None,None, 'og:image"\scontent="(.*?)"', self.page, self.lastpage)
		self.showInfos()

	def showInfos(self):
		for items in self.deferreds:
			items.cancel()
		self.deferreds = []
		if self['liste'].getCurrent()[0][1] != None:
			Title = self['liste'].getCurrent()[0][0]
			Url = self['liste'].getCurrent()[0][1]
			self['name'].setText(Title)
			d = self.ds.run(getPage, Url, cookies=keckse, agent=std_headers, headers={'Content-Type':'application/x-www-form-urlencoded'}).addCallback(self.loadPageInfos).addErrback(self.errCancelDeferreds).addErrback(self.dataError)
			self.deferreds.append(d)

	def errCancelDeferreds(self, error):
		myerror = error.getErrorMessage()
		if myerror:
			raise error
		else:
			pass

	def loadPageInfos(self, data):
		Info = re.findall('og:image"\scontent="(.*?)".*?og:description" content="(.*?)"', data, re.S)
		if Info:
			if re.match('.*?alluc.jpg', Info[0][0]):
				self.Cover = None
			else:
				self.Cover = Info[0][0]
			if re.match('.*?alluc.to', Info[0][1]):
				Handlung = 'There is no description for this movie yet'
			else:
				Handlung = decodeHtml(Info[0][1].strip())
		else:
			Handlung = 'No Description found.'
			self.Cover = None
		self['handlung'].setText(Handlung)
		CoverHelper(self['coverArt']).getCover(self.Cover)

	def keyOK(self):
		if self.keyLocked:
			return
		Link = self['liste'].getCurrent()[0][1]
		if Link == None:
			return
		Title = self['liste'].getCurrent()[0][0]
		if re.match('.*?/movies/', Link) or re.match('.*?/documentaries/', Link) or re.match('.*?/adult/', Link):
			self.session.open(StreamAuswahl, Title ,Link, self.Cover)
		else:
			self.session.open(allucSerienScreen, Link, Title, self.Cover)

	def keyAdd(self):
		exist = self['liste'].getCurrent()
		if self.keyLocked or exist == None:
			return
		muTitle = self['liste'].getCurrent()[0][0]
		muID = self['liste'].getCurrent()[0][1]
		muCover = self['liste'].getCurrent()[0][2]

		if not fileExists(config.mediaportal.watchlistpath.value+"mp_au_watchlist"):
			open(config.mediaportal.watchlistpath.value+"mp_au_watchlist","w").close()
		if fileExists(config.mediaportal.watchlistpath.value+"mp_au_watchlist"):
			writePlaylist = open(config.mediaportal.watchlistpath.value+"mp_au_watchlist","a")
			writePlaylist.write('"%s" "%s" "%s" "0"\n' % (muTitle, muID, muCover))
			writePlaylist.close()
			message = self.session.open(MessageBox, _("Selection was added to the watchlist."), MessageBox.TYPE_INFO, timeout=3)

class allucSerienScreen(MPScreen):

	def __init__(self, session, Link, Name, Cover):
		self.Link = Link
		self.Name = Name
		self.Cover = Cover
		self.plugin_path = mp_globals.pluginPath
		self.skin_path = mp_globals.pluginPath + "/skins"
		path = "%s/%s/defaultListWideScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + "/original/defaultListWideScreen.xml"
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()
		MPScreen.__init__(self, session)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok" : self.keyOK,
			"0" : self.closeAll,
			"cancel" : self.keyCancel,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft
		}, -1)

		self.country = config.mediaportal.alluc_country.value
		self['title'] = Label("alluc.to / Filter: %s" % self.country)
		self['ContentTitle'] = Label("TV-Show %s" % self.Name)

		self['Page'] = Label(_("Page:"))
		self['page'] = Label("1 / 1")
		self.keyLocked = True

		self.filmliste = []
		self.chooseMenuList = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self.chooseMenuList.l.setFont(0, gFont('mediaportal', 23))
		self.chooseMenuList.l.setItemHeight(25)
		self['liste'] = self.chooseMenuList

		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		self.keyLocked = True
		self['name'].setText(_('Please wait...'))
		getPage(self.Link, cookies=keckse, headers={'Content-Type':'application/x-www-form-urlencoded'}).addCallback(self.loadData).addErrback(self.dataError)

	def loadData(self, data):
		self.watched_liste = load_watched_liste("mp_au_watched")
		preparse = re.search('catcontent(.*?)footerbox', data, re.S|re.I)
		if preparse:
			Movies = re.findall('href="(.*?/watch.*?/season-(\d+)/episode-(\d+)/.*?)"\stitle', preparse.group(1))
			if Movies:
				for (Url, Season, Episode) in Movies:
					Title = "%s Season %s Episode %s" % (self.Name, Season, Episode)
					Url = 'http://dir.alluc.to/%s' % Url
					if decodeHtml(Title) in self.watched_liste:
						self.filmliste.append((decodeHtml(Title), Url, self.Cover, True))
					else:
						self.filmliste.append((decodeHtml(Title), Url, self.Cover, False))

		if len(self.filmliste) == 0:
			self.filmliste.append(("No series found.", '', None, False))

		self.chooseMenuList.setList(map(auWatchedSerieEntry, self.filmliste))
		self.chooseMenuList.moveToIndex(0)
		self.keyLocked = False
		self.showInfos()

	def showInfos(self):
		if self['liste'].getCurrent()[0][1] != None:
			title = self['liste'].getCurrent()[0][0]
			pic = self['liste'].getCurrent()[0][2]
			self['name'].setText(title)
			CoverHelper(self['coverArt']).getCover(pic)
		else:
			self['name'].setText('')

	def keyOK(self):
		if self.keyLocked:
			return
		Link = self['liste'].getCurrent()[0][0]
		if Link == None:
			return
		Title = self['liste'].getCurrent()[0][1]
		Cover = self['liste'].getCurrent()[0][2]
		self.session.open(StreamAuswahl, Link, Title, Cover)

class auWatchlist(MPScreen):

	def __init__(self, session):
		self.plugin_path = mp_globals.pluginPath
		self.skin_path = mp_globals.pluginPath + "/skins"
		path = "%s/%s/defaultGenreScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + "/original/defaultGenreScreen.xml"
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()
		MPScreen.__init__(self, session)

		self["actions"] = ActionMap(["MP_Actions"], {
			"0": self.closeAll,
			"ok" : self.keyOK,
			"cancel": self.keyCancel,
			"red" : self.keyDel
		}, -1)

		self['title'] = Label("alluc.com")
		self['ContentTitle'] = Label("Watchlist")
		self['F1'] = Label(_("Delete"))

		self.streamList = []
		self.streamMenuList = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self.streamMenuList.l.setFont(0, gFont('mediaportal', 23))
		self.streamMenuList.l.setItemHeight(25)
		self['liste'] = self.streamMenuList

		self.keyLocked = True
		self.onLayoutFinish.append(self.loadPlaylist)

	def loadPlaylist(self):
		self.watched_liste = load_watched_liste("mp_au_watched")
		self.streamList = []
		if fileExists(config.mediaportal.watchlistpath.value+"mp_au_watchlist"):
			readStations = open(config.mediaportal.watchlistpath.value+"mp_au_watchlist","r")
			for rawData in readStations.readlines():
				data = re.findall('"(.*?)" "(.*?)" "(.*?)" "(.*?)"', rawData, re.S)
				if data:
					(Title, Url, Lang, null) = data[0]
					if decodeHtml(Title) in self.watched_liste:
						self.streamList.append((decodeHtml(Title), Url, Lang, True))
					else:
						self.streamList.append((decodeHtml(Title), Url, Lang, False))
			print "Load Watchlist.."
			self.streamList.sort()
			self.streamMenuList.setList(map(auWatchedListEntry, self.streamList))
			readStations.close()
			self.keyLocked = False

	def keyOK(self):
		exist = self['liste'].getCurrent()
		if self.keyLocked or exist == None:
			return
		Title = self['liste'].getCurrent()[0][0]
		Link = self['liste'].getCurrent()[0][1]
		print Title, Link
		if re.match('.*?/movies/', Link) or re.match('.*?/documentaries/', Link):
			self.session.open(StreamAuswahl, Title ,Link, None)
		else:
			self.session.open(allucSerienScreen, Link, Title, None)

	def keyDel(self):
		exist = self['liste'].getCurrent()
		if self.keyLocked or exist == None:
			return
		selectedName = self['liste'].getCurrent()[0][0]
		writeTmp = open(config.mediaportal.watchlistpath.value+"mp_au_watchlist.tmp","w")
		if fileExists(config.mediaportal.watchlistpath.value+"mp_au_watchlist"):
			readStations = open(config.mediaportal.watchlistpath.value+"mp_au_watchlist","r")
			for rawData in readStations.readlines():
				data = re.findall('"(.*?)" "(.*?)" "(.*?)" "(.*?)"', rawData, re.S)
				if data:
					(stationName, stationLink, stationLang, stationTotaleps) = data[0]
					if stationName != selectedName:
						writeTmp.write('"%s" "%s" "%s" "%s"\n' % (stationName, stationLink, stationLang, stationTotaleps))
			readStations.close()
			writeTmp.close()
			shutil.move(config.mediaportal.watchlistpath.value+"mp_au_watchlist.tmp", config.mediaportal.watchlistpath.value+"mp_au_watchlist")
			self.loadPlaylist()

class StreamAuswahl(MPScreen):

	def __init__(self, session, Title, Link, Cover):
		self.Link = Link
		self.Title = Title
		self.Cover = Cover
		self.plugin_path = mp_globals.pluginPath
		self.skin_path = mp_globals.pluginPath + "/skins"

		path = "%s/%s/defaultListScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + "/original/defaultListScreen.xml"

		with open(path, "r") as f:
			self.skin = f.read()
			f.close()
		MPScreen.__init__(self, session)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok"	: self.keyOK,
			"0" : self.closeAll,
			"cancel": self.keyCancel
		}, -1)

		self['title'] = Label("alluc.to / Filter: %s" % config.mediaportal.alluc_country.value)
		self['ContentTitle'] = Label("Hosterlist %s" %self.Title)


		self.filmliste = []
		self.keyLocked = True
		self.chooseMenuList = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self.chooseMenuList.l.setFont(0, gFont('mediaportal', 23))
		self.chooseMenuList.l.setItemHeight(25)
		self['liste'] = self.chooseMenuList
		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		self['name'].setText(_('Please wait...'))
		self.keyLocked = True
		getPage(self.Link, cookies=keckse, headers={'Content-Type':'application/x-www-form-urlencoded'}).addCallback(self.loadPageData).addErrback(self.dataError)

	def loadPageData(self, data):
		parse = re.search('Direct\sLinks(.*?)id="comments"', data, re.S)
		if parse:
			parts = re.split('grouphosterlabel', parse.group(1) )
			for hosterpart in parts[1:]:
				hoster = re.search('".*?(\w+)\s\((\d+)\)', hosterpart, re.S)
				if hoster:
					hostername = hoster.group(1).strip()
					streamcount = hoster.group(2)
					if hostername == 'Played':
						hostername = 'Played.to'
					if isSupportedHoster(hostername, True):
						self.filmliste.append((hostername, streamcount, hosterpart))
		if len(self.filmliste) == 0:
			self.filmliste.append(('No supported Hoster found!', '0', ''))
		self.chooseMenuList.setList(map(allucHostersEntry, self.filmliste))
		self['name'].setText('')
		self.keyLocked = False

	def keyOK(self):
		if self.keyLocked:
			return
		hoster = self['liste'].getCurrent()[0][0]
		data = self['liste'].getCurrent()[0][2]
		if data == None:
			return
		self.session.open(SubStreamAuswahl, self.Title, hoster, data)

class SubStreamAuswahl(MPScreen):

	def __init__(self, session, Title, Hoster, Data):
		self.Title = Title
		self.Hoster = Hoster
		self.Data = Data
		self.plugin_path = mp_globals.pluginPath
		self.skin_path = mp_globals.pluginPath + "/skins"

		path = "%s/%s/defaultListScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + "/original/defaultListScreen.xml"

		with open(path, "r") as f:
			self.skin = f.read()
			f.close()
		MPScreen.__init__(self, session)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok"	: self.keyOK,
			"0" : self.closeAll,
			"cancel": self.keyCancel
		}, -1)

		self['title'] = Label("alluc.to / Filter: %s" % config.mediaportal.alluc_country.value)
		self['ContentTitle'] = Label("Streamlist %s" %self.Title)

		self.keyLocked = True
		self.tw_agent_hlp = TwAgentHelper()
		self.filmliste = []
		self.chooseMenuList = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self.chooseMenuList.l.setFont(0, gFont('mediaportal', 23))
		self.chooseMenuList.l.setItemHeight(25)
		self['liste'] = self.chooseMenuList
		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		streamparts = re.split('collinkname', self.Data )
		for streampart in streamparts[1:]:
			hits = re.findall('class="openlink.*?>(.*?)<.*?openlink.*?href="(.*?)".*?ratingscore.*?>(.*?)<.*?Hits">(.*?)<', streampart, re.S)
			if hits:
				url = "http://dir.alluc.to/%s" % hits[0][1]
				self.filmliste.append((self.Hoster, hits[0][0].strip(), url, hits[0][2].strip(), hits[0][3].strip()))
		if len(self.filmliste) == 0:
			self.filmliste.append((None, _('No supported streams found!'), '', '', ''))
		self.chooseMenuList.setList(map(allucSubHostersEntry, self.filmliste))
		self.keyLocked = False

	def keyOK(self):
		if self.keyLocked:
			return
		url = self['liste'].getCurrent()[0][2]
		self['name'].setText(_("Please wait..."))
		if url == None:
			return

		if not fileExists(config.mediaportal.watchlistpath.value+"mp_au_watched"):
			open(config.mediaportal.watchlistpath.value+"mp_au_watched","w").close()

		self.update_liste = []
		leer = os.path.getsize(config.mediaportal.watchlistpath.value+"mp_au_watched")
		if not leer == 0:
			self.updates_read = open(config.mediaportal.watchlistpath.value+"mp_au_watched" , "r")
			for lines in sorted(self.updates_read.readlines()):
				line = re.findall('"(.*?)"', lines)
				if line:
					print line[0]
					self.update_liste.append("%s" % (line[0]))
			self.updates_read.close()

			updates_read2 = open(config.mediaportal.watchlistpath.value+"mp_au_watched" , "a")
			check = ("%s" % self.Title)
			if not check in self.update_liste:
				print "[alluc] update add: %s" % (self.Title)
				updates_read2.write('"%s"\n' % (self.Title))
				updates_read2.close()
			else:
				print "[alluc] dupe %s" % (self.Title)
		else:
			updates_read3 = open(config.mediaportal.watchlistpath.value+"mp_au_watched" , "a")
			print "[alluc] update add: %s" % (self.Title)
			updates_read3.write('"%s"\n' % (self.Title))
			updates_read3.close()

		print 'Redirect Play', url
		user_agent = 'Mozilla/4.0 (compatible; MSIE 5.5; Windows NT)'
		self.tw_agent_hlp.headers.addRawHeader('User-Agent', user_agent)
		self.tw_agent_hlp.getRedirectedUrl(url).addCallback(self.get_redirect).addErrback(self.dataError)
		self['name'].setText("%s" % self.Title)

	def get_redirect(self, url):
		get_stream_link(self.session).check_link(url, self.got_link)

	def got_link(self, stream_url):
		if stream_url == None:
			message = self.session.open(MessageBox, _("Stream not found, try another Stream Hoster."), MessageBox.TYPE_INFO, timeout=3)
		else:
			self.session.open(SimplePlayer, [(self.Title, stream_url)], showPlaylist=False, ltype='alluc')