﻿# -*- coding: utf-8 -*-
from Plugins.Extensions.MediaPortal.plugin import _
from Plugins.Extensions.MediaPortal.resources.imports import *
from Plugins.Extensions.MediaPortal.resources.youtubeplayer import YoutubePlayer

def Entry(entry):
	return [entry,
		(eListboxPythonMultiContent.TYPE_TEXT, 20, 0, 860, 25, 0, RT_HALIGN_CENTER | RT_VALIGN_CENTER, entry[0])
		]

def Entry1(entry):
	return [entry,
		(eListboxPythonMultiContent.TYPE_TEXT, 20, 0, 860, 25, 0, RT_HALIGN_LEFT | RT_VALIGN_CENTER, entry[0])
		]

class dokumonsterGenreScreen(MPScreen):

	def __init__(self, session):
		self.plugin_path = mp_globals.pluginPath
		self.skin_path =  mp_globals.pluginPath + "/skins"
		path = "%s/%s/defaultGenreScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + "/original/defaultGenreScreen.xml"
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()
		MPScreen.__init__(self, session)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok" : self.keyOK,
			"0" : self.closeAll,
			"cancel": self.keyCancel
		}, -1)

		self['title'] = Label("Dokumonster.de")
		self['ContentTitle'] = Label("Genre:")
		self.keyLocked = True

		self.genreliste = []
		self.chooseMenuList = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self.chooseMenuList.l.setFont(0, gFont('mediaportal', 23))
		self.chooseMenuList.l.setItemHeight(25)
		self['liste'] = self.chooseMenuList

		self.onLayoutFinish.append(self.layoutFinished)

	def layoutFinished(self):
		api = "http://dokumonster.de/api/0.1/get_items?limit=9999&online=true"
		base = "http://www.dokumonster.de"
#		self.genreliste.append(("Kategorien", base))
		self.genreliste.append(("Reihen", base))
		self.genreliste.append(("Themen", base))
		self.genreliste.append(("Suche", None))
		self.genreliste.append(("Neueste", api+"&sort=date&sortorder=desc&page="))
		self.genreliste.append(("Top Dokus", api+"&sort=fire&sortorder=desc&page="))
		for c in xrange(26):
			self.genreliste.append(("Dokus mit "+chr(ord('A') + c), api+"&sort=title&sortorder=asc&initial="+chr(ord('a') + c)+"&page="))
		self.chooseMenuList.setList(map(Entry, self.genreliste))

	def keyOK(self):
		Name = self['liste'].getCurrent()[0][0]
		Link = self['liste'].getCurrent()[0][1]
		if Name == "Themen" or Name == "Reihen" or Name == "Kategorien":
			self.session.open(GenreParsingScreen, Link, Name)
		elif Name == "Suche":
			self.session.openWithCallback(self.searchCallback, VirtualKeyBoardExt, title = (_("Enter search criteria")), text = "", is_dialog=True)
		else:
			self.session.open(DokuApiParsingScreen, Link, Name)

	def searchCallback(self, callbackStr):
		if callbackStr is not None:
			Name = "Suche"
			Link = "http://dokumonster.de/suche/?q=%s" % callbackStr.replace(' ','+')
			self.session.open(DokuParsingScreen, Link, Name)

class DokuApiParsingScreen(MPScreen, ThumbsHelper):

	def __init__(self, session, Link, Name):
		self.Link = Link
		self.Name = Name
		self.plugin_path = mp_globals.pluginPath
		self.skin_path =  mp_globals.pluginPath + "/skins"
		path = "%s/%s/defaultListWideScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + "/original/defaultListWideScreen.xml"
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()
		MPScreen.__init__(self, session)
		ThumbsHelper.__init__(self)

		self["actions"]  = ActionMap(["MP_Actions"], {
			"0" : self.closeAll,
			"5" : self.keyShowThumb,
			"ok" : self.keyOK,
			"cancel" : self.keyCancel,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft,
			"nextBouquet" : self.keyPageUp,
			"prevBouquet" : self.keyPageDown
		}, -1)

		self['title'] = Label("Dokumonster.de")
		self['ContentTitle'] = Label("Genre: %s" % self.Name)
		self['name'] = Label(_("Please wait..."))

		self['Page'] = Label(_("Page:"))

		self.filmliste = []
		self.chooseMenuList = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self.chooseMenuList.l.setFont(0, gFont('mediaportal', 23))
		self.chooseMenuList.l.setItemHeight(25)
		self['liste'] = self.chooseMenuList
		self.page = 2
		self.lastpage = 1

		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		self.keyLocked = True
		self.filmliste = []
		URL = self.Link + str(self.page)
		getPage(URL, headers={'Content-Type':'application/x-www-form-urlencoded'}).addCallback(self.pageData).addErrback(self.dataError)

	def pageData(self, data):
		lastp = re.search('totalcount":"(.*?)"', data, re.S)
		if lastp.group(1) != "0":
			lastp = round((float(lastp.group(1)) / 50) + 0.5)
			self.lastpage = int(lastp)
			self['page'].setText(str(self.page-1) + ' / ' + str(self.lastpage))
		else:
			self.lastpage = 999
			self['page'].setText(str(self.page-1))
		parse = re.findall('title":"(.*?)","link":"(.*?)","thumb":"(.*?)","description":"(.*?)","', data, re.S)
		for (Title, Link, Pic, Handlung) in parse:
			Title = Title.replace('\/','/')
			Link = Link.replace('\/','/')
			Pic = Pic.replace('\/','/')
			Handlung = Handlung.replace('\\"','"').replace('\/','/')
			self.filmliste.append((decodeHtml(Title), Link, Pic, decodeHtml(Handlung)))
		self.chooseMenuList.setList(map(Entry1, self.filmliste))
		self.chooseMenuList.moveToIndex(0)
		self.keyLocked = False
		self.th_ThumbsQuery(self.filmliste, 0, 1, 2, None, None, self.page-1, self.lastpage, mode=1, pagefix=+1)
		self.showInfos()

	def showInfos(self):
		title = self['liste'].getCurrent()[0][0]
		pic = self['liste'].getCurrent()[0][2]
		handlung = self['liste'].getCurrent()[0][3]
		self['handlung'].setText(handlung)
		self['name'].setText(title)
		CoverHelper(self['coverArt']).getCover(pic)

	def keyPageDown(self):
		print "PageDown"
		if self.keyLocked:
			return
		if not self.page < 3:
			self.page -= 1
			self.loadPage()

	def keyPageUp(self):
		print "PageUP"
		if self.keyLocked:
			return
		if self.page-1 < self.lastpage:
			self.page += 1
			self.loadPage()

	def keyOK(self):
		if self.keyLocked:
			return
		Link = self['liste'].getCurrent()[0][1]
		getPage(Link, headers={'Content-Type':'application/x-www-form-urlencoded'}).addCallback(self.getVideoPage).addErrback(self.dataError)

	def getVideoPage(self, data):
		title = self['liste'].getCurrent()[0][0]
		if re.search('.*?src="http://www.youtube.com/embed/videoseries.*?"', data):
			playlistPage = re.findall('Quelle:\s<a href="(.*?)"', data, re.S)
			Link = playlistPage[0]
			Name = title
			self.session.open(PlaylistParsingScreen, Link, Name)
		else:
			videoPage = re.findall('"http://www.youtube.com/(v|embed)/(.*?)\?.*?"', data, re.S)
			if videoPage:
				title = self['liste'].getCurrent()[0][0]
				self.session.open(YoutubePlayer,[(title, videoPage[0][1], None)],playAll= False,showPlaylist=False,showCover=False)

class GenreParsingScreen(MPScreen):

	def __init__(self, session, Link, Name):
		self.Link = Link
		self.Name = Name
		self.plugin_path = mp_globals.pluginPath
		self.skin_path =  mp_globals.pluginPath + "/skins"
		path = "%s/%s/defaultGenreScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + "/original/defaultGenreScreen.xml"
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()
		MPScreen.__init__(self, session)

		self["actions"]  = ActionMap(["MP_Actions"], {
			"0" : self.closeAll,
			"ok" : self.keyOK,
			"cancel" : self.keyCancel,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft
		}, -1)

		self['title'] = Label("Dokumonster.de")
		self['ContentTitle'] = Label("Genre: %s" % self.Name)
		self['name'] = Label(_("Please wait..."))

		self.keyLocked = True
		self.chooseMenuList = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self.chooseMenuList.l.setFont(0, gFont('mediaportal', 23))
		self.chooseMenuList.l.setItemHeight(25)
		self['liste'] = self.chooseMenuList

		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		self.filmliste = []
		getPage(self.Link, headers={'Content-Type':'application/x-www-form-urlencoded'}).addCallback(self.parseData).addErrback(self.dataError)

	def parseData(self, data):
		if self.Name == "Reihen":
			raw = re.findall('<h2>top reihen</h2>(.*?)<h2>themen</h2>', data, re.S)
			if raw:
				parse = re.findall('<li>.*?href="(.*?)".*?>(.*?)</a></li>', raw[0], re.S)
				for (Url, Title) in parse:
					self.filmliste.append((decodeHtml(Title), Url))
				self.chooseMenuList.setList(map(Entry1, self.filmliste))
				self.keyLocked = False
				self.showInfos()
#		elif self.Name == "Kategorien":
#			raw = re.findall('<h1>kategorien</h1>(.*?)href="mailto:dokumonster@gmail.com', data, re.S)
#			if raw:
#				parse = re.findall('<a href="(.*?)".*?>(.*?)</a>', raw[0], re.S)
#				for (Url, Title) in parse:
#					Title = Title.title()
#					self.filmliste.append((decodeHtml(Title), Url))
#				self.chooseMenuList.setList(map(Entry1, self.filmliste))
#				self.keyLocked = False
#				self.showInfos()
		elif self.Name == "Themen":
			raw = re.findall('<h2>themen</h2>(.*?)id="anmelden">', data, re.S)
			if raw:
				parse = re.findall('href="(.*?)".*?class="smallfullcurve">(.*?)</a></div>.*?<small>(.*?)</small>', raw[0], re.S)
				for (Url, Title, Dokus) in parse:
					Title = Title.title()
					self.filmliste.append((decodeHtml(Title), Url, Dokus))
				self.chooseMenuList.setList(map(Entry1, self.filmliste))
				self.keyLocked = False
				self.showInfos()

	def showInfos(self):
		title = self['liste'].getCurrent()[0][0]
		self['name'].setText(title)

	def keyOK(self):
		Name = self['liste'].getCurrent()[0][0]
		Link = self['liste'].getCurrent()[0][1]
		self.session.open(DokuParsingScreen, Link, Name)

class DokuParsingScreen(MPScreen, ThumbsHelper):

	def __init__(self, session, Link, Name):
		self.Link = Link
		self.Name = Name
		self.plugin_path = mp_globals.pluginPath
		self.skin_path =  mp_globals.pluginPath + "/skins"
		path = "%s/%s/defaultListScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + "/original/defaultListScreen.xml"
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()
		MPScreen.__init__(self, session)
		ThumbsHelper.__init__(self)

		self["actions"]  = ActionMap(["MP_Actions"], {
			"0" : self.closeAll,
			"5" : self.keyShowThumb,
			"ok" : self.keyOK,
			"cancel" : self.keyCancel,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft,
			"nextBouquet" : self.keyPageUp,
			"prevBouquet" : self.keyPageDown
		}, -1)

		self['title'] = Label("Dokumonster.de")
		self['ContentTitle'] = Label("Genre: %s" % self.Name)
		self['name'] = Label(_("Please wait..."))

		self['Page'] = Label(_("Page:"))

		self.filmliste = []
		self.chooseMenuList = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self.chooseMenuList.l.setFont(0, gFont('mediaportal', 23))
		self.chooseMenuList.l.setItemHeight(25)
		self['liste'] = self.chooseMenuList
		self.page = 1

		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		self.filmliste = []
		if self.Name == "Suche":
			URL = self.Link
		else:
			URL = self.Link + str(self.page)
		self.keyLocked = True
		getPage(URL, headers={'Content-Type':'application/x-www-form-urlencoded'}).addCallback(self.pageData).addErrback(self.dataError)

	def pageData(self, data):
		raw = re.findall('<ul\sclass="liste_mini">(.*?)</ul>', data, re.S)
		if raw:
			parse = re.findall('class="first item ">.*?src="(.*?)".*?href="(.*?)".*?class="item-title">(.*?)<', raw[0], re.S)
			for (Pic, Link, Title) in parse:
				self.filmliste.append((decodeHtml(Title), Link, Pic))
			self.chooseMenuList.setList(map(Entry1, self.filmliste))
			self.chooseMenuList.moveToIndex(0)
			self.keyLocked = False
			self.th_ThumbsQuery(self.filmliste, 0, 1, 2, None, None, self.page, mode=1)
			self.showInfos()

	def showInfos(self):
		self['page'].setText(str(self.page))
		title = self['liste'].getCurrent()[0][0]
		Link =  self['liste'].getCurrent()[0][1]
		Pic = self['liste'].getCurrent()[0][2]
		self['name'].setText(title)
		CoverHelper(self['coverArt']).getCover(Pic)
		getPage(Link, headers={'Content-Type':'application/x-www-form-urlencoded'}).addCallback(self.handlungData).addErrback(self.dataError)

	def handlungData(self, data):
		handlung = re.findall('id="description".*?">(.*?)<small', data, re.S)
		handlung = stripAllTags(handlung[0]).strip()
		if handlung:
			self['handlung'].setText(decodeHtml(handlung))
		else:
			self['handlung'].setText(_("No information found."))

	def keyPageDown(self):
		print "PageDown"
		if self.keyLocked:
			return
		if not self.page < 1:
			self.page -= 1
			self.loadPage()

	def keyPageUp(self):
		print "PageUp"
		if self.keyLocked:
			return
		self.page += 1
		self.loadPage()

	def keyOK(self):
		if self.keyLocked:
			return
		Link = self['liste'].getCurrent()[0][1]
		getPage(Link, headers={'Content-Type':'application/x-www-form-urlencoded'}).addCallback(self.getVideoPage).addErrback(self.dataError)

	def getVideoPage(self, data):
		title = self['liste'].getCurrent()[0][0]
		if re.search('.*?src="http://www.youtube.com/embed/videoseries.*?"', data):
			playlistPage = re.findall('Quelle:\s<a href="(.*?)"', data, re.S)
			Link = playlistPage[0]
			Name = title
			self.session.open(PlaylistParsingScreen, Link, Name)
		else:
			videoPage = re.findall('"http://www.youtube.com/(v|embed)/(.*?)\?.*?"', data, re.S)
			if videoPage:
				title = self['liste'].getCurrent()[0][0]
				self.session.open(YoutubePlayer,[(title, videoPage[0][1], None)],playAll= False,showPlaylist=False,showCover=False)

class PlaylistParsingScreen(MPScreen):

	def __init__(self, session, Link, Name):
		self.Link = Link
		self.Name = Name
		self.plugin_path = mp_globals.pluginPath
		self.skin_path =  mp_globals.pluginPath + "/skins"
		path = "%s/%s/defaultListScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + "/original/defaultListScreen.xml"
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()
		MPScreen.__init__(self, session)

		self["actions"]  = ActionMap(["MP_Actions"], {
			"0" : self.closeAll,
			"ok" : self.keyOK,
			"cancel" : self.keyCancel,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft
		}, -1)

		self['title'] = Label("Dokumonster.de")
		self['ContentTitle'] = Label("Playlist:  %s" % self.Name)
		self['name'] = Label(_("Please wait..."))

		self['Page'] = Label("Page: 1/1")
		self.keyLocked = True

		self.chooseMenuList = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self.chooseMenuList.l.setFont(0, gFont('mediaportal', 23))
		self.chooseMenuList.l.setItemHeight(25)
		self['liste'] = self.chooseMenuList

		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		self.filmliste = []
		getPage(self.Link, headers={'Content-Type':'application/x-www-form-urlencoded'}).addCallback(self.parseData).addErrback(self.dataError)

	def parseData(self, data):
		getVideos = re.findall('itemprop="name".*?content="(.*?)">.*?thumbnailUrl"\shref="(.*?)">.*?href="(.*?)&amp;list.*?video-time">(.*?)</span>.*?video-description\syt-ui-ellipsis\syt-ui-ellipsis-2">(.*?)</p>', data, re.S)
		for (Title, Pic, vidLink, Duration, Handlung) in getVideos:
			Title = Title.title()
			vidLink = "http://www.youtube.com" + vidLink
			self.filmliste.append((decodeHtml(Title), Pic, vidLink, Duration, Handlung))
		self.chooseMenuList.setList(map(Entry1, self.filmliste))
		self.keyLocked = False
		self.showInfos()

	def showInfos(self):
		title = self['liste'].getCurrent()[0][0]
		Pic = self['liste'].getCurrent()[0][1]
		handlung = self['liste'].getCurrent()[0][4]
		handlung = handlung.strip()
		self['handlung'].setText(decodeHtml(handlung))
		self['name'].setText(title)
		CoverHelper(self['coverArt']).getCover(Pic)

	def keyOK(self):
		if self.keyLocked:
			return
		Link = self['liste'].getCurrent()[0][2]
		getPage(Link, headers={'Content-Type':'application/x-www-form-urlencoded'}).addCallback(self.getVideoPage).addErrback(self.dataError)

	def getVideoPage(self, data):
		title = self['liste'].getCurrent()[0][0]
		videoPage = re.findall('"http://www.youtube.com/(v|embed)/(.*?)\?.*?"', data, re.S)
		if videoPage:
			title = self['liste'].getCurrent()[0][0]
			self.session.open(YoutubePlayer,[(title, videoPage[0][1], None)],playAll= False,showPlaylist=False,showCover=False)