# -*- coding: utf-8 -*-
from Screens.Screen import Screen
from Components.ActionMap import ActionMap
from Components.Label import Label
from Components.Pixmap import Pixmap
from Components.MenuList import MenuList
from Components.Ipkg import IpkgComponent as OpkgComponent
from Components.About import about
from twisted.web.client import getPage

from Plugins.Plugin import PluginDescriptor
from Tools.HardwareInfo import HardwareInfo
from enigma import eTimer, quitMainloop

from os import path as os_path, system as os_system

def checkForUgly():
	for x in ["/etc/MultiQuickButton", "/usr/lib/enigma2/python/Plugins/Extensions/Quickbutton"]:
		if os_path.exists(x):
			if x == "/etc/MultiQuickButton":
				return "Multiquickbutton plugin"
			elif x == "/usr/lib/enigma2/python/Plugins/Extensions/Quickbutton":
				return "Quickbutton plugin"
		return None


g3wskin = """<screen name="g3w" position="center,center" size="500,140" title="Gemini3 Wizard">
		<widget name="text" position="75,10" size="420,53" font="Regular;22" />
		<widget name="InfoPixmap" pixmap="skin_default/icons/input_question.png" position="10,10" size="53,53" alphatest="on" />
		<widget name="ErrPixmap" pixmap="skin_default/icons/input_error.png" position="10,10" size="53,53" alphatest="on" />
		<widget name="list" position="10,80" size="480,50" />
		</screen>"""


#-------------------------------------------------------------------------------------------------

class g3wizard(Screen):
	def __init__(self, session):
		self.skin = g3wskin
		Screen.__init__(self, session)
		
		self.__mainlist = [ (_("yes"), True), (_("no"), False) ]
		
		self["text"] = Label("")
		self["list"] = MenuList(self.__mainlist)
		self["InfoPixmap"] = Pixmap()
		self["ErrPixmap"] = Pixmap()
		
		self["actions"] = ActionMap(["MsgBoxActions", "DirectionActions"], 
		{
			"cancel": self.cancel,
			"ok": self.ok
		}, -1)
		
		self.timer = eTimer()
		self.timer_conn = self.timer.timeout.connect(self.timerTick)
		
		self.opkg = OpkgComponent()
		self.opkg.addCallback(self.opkgCallback)
		self.opkg.cmd_dataAvail_conn = self.opkg.cmd.dataAvail.connect(self.__cmdData)

		self.__currEnigma=None
		self.__arch=False
		self.__feedname="gemini33"
		self.__status=0
		self.timeout=0
		
		self.onLayoutFinish.append(self.__LayoutFinish)
		
	def cancel(self):
		self.opkg.stop()
		del self.opkg
		del self.timer
		self.close()
		
	def __LayoutFinish(self):
		try:
			file = open("/etc/apt/apt.conf", 'r')
			lines = file.readlines()
			file.close()
			for x in lines:
				entry = x.strip().split(' ')
				if len(entry)==2:
					if entry[1].find("mipsel"):
						self.__arch="mipsel"
						self.__feedname="gemini33"
						break
		except:
			self.__arch=False
			
		ugly = checkForUgly()
		if ugly:
			self.setIconAndText(True,_("Gemini3 Wizard Installation stoped\nPlease remove '%s' first!") % ugly)
		else:
			if self.__arch==False:
				self.setIconAndText(True,"Processortyp not found")
			else:
				self.setIconAndText(False,_("Install") + " Gemini plugin?")
			
	def setIconAndText(self,error,text):
		self["text"].setText(text)
		if error:
			self["list"].hide()
			self["InfoPixmap"].hide()
			self["ErrPixmap"].show()
			self.timeout=7
			self.timer.start(1000)
		else:
			self["InfoPixmap"].show()
			self["ErrPixmap"].hide()

	def timerTick(self):
		self.timeout -= 1
		self.setTitle("Gemini3 Wizard (" + str(self.timeout) + ")")
		if self.timeout == 0:
			self.timer.stop()
			self.cancel()
		
	def __setFeed(self):
		def _createFeedConf(type):
			if os_path.exists("/etc/apt/sources.list.d/%s-%s-feed.list" %(self.__feedname,type))==False:
				wfile = open("/etc/apt/sources.list.d/%s-%s-feed.list" %(self.__feedname,type), 'w')
				wfile.write("deb http://download.blue-panel.com/%s/%s ./\n" % (self.__feedname,type))
				wfile.close()

		try:
			_createFeedConf(self.__arch)
			_createFeedConf(HardwareInfo().get_device_name())
			_createFeedConf('all')
			_createFeedConf('allcodes')
			return True
		except:
			return False
		
	def ok(self):
		if self.opkg.isRunning() or self.timeout>0:
			return

		val = self["list"].getCurrent()
		if val:
			if val[1]==True:
				if self.__status==0:
					self.setIconAndText(False,_("Please wait...") + "\n" + _("check networkstatus"))
					self["list"].setList([])
					getPage(url="http://download.blue-panel.com/info@ihad.tv.key").addCallback(self.__checkNetworkCB).addErrback(self.__LoadingFailed)
				elif self.__status==3:
					quitMainloop(2)
				return
			else:
				self.cancel()
		
	def __checkNetworkCB(self,data):
		if data is not None:
			wfile = open("/tmp/gemini33.key", 'w')
			wfile.write(str(data))
			wfile.close()
			cmd = "apt-key add /tmp/gemini33.key"
			print "[%s] %s" %(__name__,cmd)
			os_system(cmd)
			if self.__setFeed():
				self.setIconAndText(False,_("Please wait...") + "\n" + _("Package list update"))
				self.opkg.startCmd(OpkgComponent.CMD_UPDATE)
			else:
				self.setIconAndText(True,"error <create feeds>")
		else:
			self.setIconAndText(True,"error <network>")
		
	def __LoadingFailed(self,data):
		self.setIconAndText(True,data.getErrorMessage())
		
	def timeoutCallback(self):
		self.close()
		
	def __cmdData(self, data):
		
		#------------------------org Routine--aus---Components.Ipkg----------------
		if self.opkg.cache is None:
			self.opkg.cache = data
		else:
			self.opkg.cache += data

		if '\n' in data:
			splitcache = self.opkg.cache.split('\n')
			if self.opkg.cache[-1] == '\n':
				iteration = splitcache
				self.opkg.cache = None
			else:
				iteration = splitcache[:-1]
				self.opkg.cache = splitcache[-1]
			for mydata in iteration:
				if mydata != '':
					self.opkg.parseLine(mydata)
					if self.opkg.currentCommand == OpkgComponent.CMD_INSTALL:#neu grab
						#print "___",mydata,"___"
						if mydata.find("it is not installable")>0:
							self.opkgCallback(OpkgComponent.EVENT_ERROR, "Cannot satisfy dependencies for geminiplugin!")
						if mydata.startswith("Conf geminiplugin"):
							self.opkg.stop()
							self.opkgCallback(OpkgComponent.EVENT_DONE, "OK")
		
	def opkgCallback(self, event, param):
		#print "__________________________________",event, param, self.__status
		if event == OpkgComponent.EVENT_ERROR:
			self.setIconAndText(True,param)
		elif event == OpkgComponent.EVENT_DONE:
			if self.opkg.currentCommand == OpkgComponent.CMD_UPDATE:
				self.setIconAndText(False,_("Please wait...") + "\n" + _("check dependencies"))
				self.__status=2
				self.opkg.setCurrentCommand(OpkgComponent.CMD_INSTALL)
				self.opkg.runCmd("install geminiplugin --noaction")
			elif self.opkg.currentCommand == OpkgComponent.CMD_INSTALL:
				if self.__status==2 and param=="OK":
					self.setIconAndText(False,_("Please wait...") + "\n" + _("Install") + " Gemini plugin...")
					self.__status=3
					self.opkg.runCmd("install geminiplugin")
				elif self.__status==3:
					self.setIconAndText(False,_("Restart") + " Dreambox?")
					self["list"].setList(self.__mainlist)

#-----------------------------------------------------------------------------------

def main(session, **kwargs):
	session.open(g3wizard)

def Plugins(**kwargs):
	return PluginDescriptor(name=_("Gemini3 Wizard"), description=_("the Gemini3 plugin Wizard"), where = [PluginDescriptor.WHERE_PLUGINMENU, PluginDescriptor.WHERE_EXTENSIONSMENU], icon="gp3wizard.png", fnc=main)
