# -*- coding: utf-8 -*-
from imports import *
import mp_globals

class VirtualKeyBoardExtInputHelpDialog(NumericalTextInputHelpDialog):
	skin = """
		<screen name="VirtualKeyBoardExtInputHelpDialog" position="257,470" zPosition="100" size="394,124" backgroundColor="#202020" flags="wfNoBorder">
			<eLabel position="0,0" size="392,122" backgroundColor="#c0c0c0" zPosition="-1" />
			<widget name="key1" position="2,2" size="130,30" font="mediaportal;18" halign="center" valign="center" />
			<widget name="key2" position="132,2" size="130,30" font="mediaportal;18" halign="center" valign="center" />
			<widget name="key3" position="262,2" size="130,30" font="mediaportal;18" halign="center" valign="center" />
			<widget name="key4" position="2,32" size="130,30" font="mediaportal;18" halign="center" valign="center" />
			<widget name="key5" position="132,32" size="130,30" font="mediaportal;18" halign="center" valign="center" />
			<widget name="key6" position="262,32" size="130,30" font="mediaportal;18" halign="center" valign="center" />
			<widget name="key7" position="2,62" size="130,30" font="mediaportal;18" halign="center" valign="center" />
			<widget name="key8" position="132,62" size="130,30" font="mediaportal;18" halign="center" valign="center" />
			<widget name="key9" position="262,62" size="130,30" font="mediaportal;18" halign="center" valign="center" />
			<widget name="help1" position="2,92" size="130,30" font="mediaportal;18" halign="center" valign="center" />
			<widget name="key0" position="132,92" size="130,30" font="mediaportal;14" halign="center" valign="center" />
			<widget name="help2" position="262,92" size="130,30" font="mediaportal;18" halign="center" valign="center" />
		</screen>"""

	def __init__(self, session, textinput):
		NumericalTextInputHelpDialog.__init__(self, session, textinput)

class VirtualKeyBoardExt(VirtualKeyBoard, NumericalTextInput):
	skin = """
		<screen name="VirtualKeyBoardExt" position="center,center" size="900,550" zPosition="99" title="Virtual KeyBoard">
			<ePixmap pixmap="skin_default/vkey_text.png" position="10,60" zPosition="-4" size="880,40" scale="1" alphatest="on" />
			<widget source="country" render="Pixmap" position="830,10" size="60,40" alphatest="on" borderWidth="2" borderColor="yellow" >
					<convert type="ValueToPixmap">LanguageCode</convert>
			</widget>
			<widget name="header" position="10,22" size="815,28" font="mediaportal;24" transparent="1" noWrap="1" />
			<widget name="text" position="12,59" size="876,40" font="mediaportal;32" transparent="1" noWrap="1" halign="right" />
			<widget name="list" position="60,115" size="780,225" selectionDisabled="1" transparent="1" />
			<widget name="captcha" position="540,350" size="300,200" transparent="1" alphatest="on" />
		</screen>"""

	def __init__(self, session, title="", text="", captcha=None, is_dialog=False):
		VirtualKeyBoard.__init__(self, session, title, text)
		NumericalTextInput.__init__(self, nextFunc=self.nextFunc)
		self.configText = None

		self['captcha'] = Pixmap()

		self.captcha = captcha
		self.timer = eTimer()
		if mp_globals.is7080hd:
			self.timer_conn = self.timer.timeout.connect(self.timeout)
		else:
			self.timer.callback.append(self.timeout)
		self.configText = ConfigText("", False)
		if text:
			self.configText.text = text
			self.configText.marked_pos = len(text)
		self["config_actions"] = NumberActionMap(["SetupActions", "InputAsciiActions", "KeyboardInputActions"],
		{
			"1": self.keyNumberGlobal,
			"2": self.keyNumberGlobal,
			"3": self.keyNumberGlobal,
			"4": self.keyNumberGlobal,
			"5": self.keyNumberGlobal,
			"6": self.keyNumberGlobal,
			"7": self.keyNumberGlobal,
			"8": self.keyNumberGlobal,
			"9": self.keyNumberGlobal,
			"0": self.keyNumberGlobal
		}, -1)
		self.selectedKey = self.getKeyIndex(u"OK")

		self.onLayoutFinish.append(self.__onLayoutFinish)
		self.onClose.append(self.__onClose)

	def __onLayoutFinish(self):
		self.setTitle("MediaPortal KeyBoard")
		if self.configText:
			self.configText.help_window = self.session.instantiateDialog(VirtualKeyBoardExtInputHelpDialog, self)
			self.configText.help_window.show()
		if self.captcha == None:
			self['captcha'].hide()
		else:
			if fileExists(self.captcha):
				self['captcha'].instance.setPixmap(gPixmapPtr())
				self.scale = AVSwitch().getFramebufferScale()
				self.picload = ePicLoad()
				size = self['captcha'].instance.size()
				self.picload.setPara((size.width(), size.height(), self.scale[0], self.scale[1], False, 1, "#FF000000"))
				if mp_globals.is7080hd:
					if self.picload.startDecode(self.captcha, False) == 0:
						ptr = self.picload.getData()
						if ptr != None:
							self['captcha'].instance.setPixmap(ptr)
							self['captcha'].show()
							del self.picload
				else:
					if self.picload.startDecode(self.captcha, 0, 0, False) == 0:
						ptr = self.picload.getData()
						if ptr != None:
							self['captcha'].instance.setPixmap(ptr)
							self['captcha'].show()
							del self.picload

	def __onClose(self):
		if self.configText and self.configText.help_window:
			self.session.deleteDialog(self.configText.help_window)
			self.configText.help_window = None

	def getKeyIndex(self, key):
		index = 0
		for x in self.keys_list:
			for k in x:
				if k == key:
					return index
				index += 1
		return index

	def buildVirtualKeyBoard(self, selectedKey=0):
		VirtualKeyBoard.buildVirtualKeyBoard(self, selectedKey=self.selectedKey)

	def timeout(self):
		self.handleKey(KEY_TIMEOUT)
		self["text"].setMarkedPos(-1)

	def handleKey(self, key):
		if self.configText:
			self.configText.handleKey(key)
			if key in KEY_NUMBERS:
				self.timer.start(1000, 1)

	def keyNumberGlobal(self, number):
		self.handleKey(KEY_0 + number)
		self.getKey(number)
		self.text = self.configText.getText()
		self["text"].setText(self.configText.getText())
		self["text"].setMarkedPos(self.configText.marked_pos)

	def backClicked(self):
		self["text"].setMarkedPos(-1)
		self.text = self["text"].getText()[:-1]
		self["text"].setText(self.text)
		if self.configText:
			self.configText.text = self.text
			self.configText.marked_pos = len(self.text)

	def okClicked(self):
		VirtualKeyBoard.okClicked(self)
		self["text"].setMarkedPos(-1)
		if self.configText:
			self.text = self["text"].getText()
			self.configText.text = self.text
			self.configText.marked_pos = len(self.text)

	def nextFunc(self):
		self["text"].setMarkedPos(-1)