﻿# -*- coding: utf-8 -*-
from Plugins.Extensions.MediaPortal.plugin import _
from Plugins.Extensions.MediaPortal.resources.imports import *
from Plugins.Extensions.MediaPortal.resources.captcha import *

ck = {}

def oasetvGenreListEntry(entry):
	return [entry,
		(eListboxPythonMultiContent.TYPE_TEXT, 20, 0, 860, 25, 0, RT_HALIGN_CENTER | RT_VALIGN_CENTER, entry[0])
		]

class oasetvGenreScreen(MPScreen):

	def __init__(self, session):
		self.plugin_path = mp_globals.pluginPath
		self.skin_path =  mp_globals.pluginPath + "/skins"
		path = "%s/%s/defaultGenreScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + "/original/defaultGenreScreen.xml"
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()
		MPScreen.__init__(self, session)

		self["actions"]  = ActionMap(["MP_Actions"], {
			"ok"    : self.keyOK,
			"0": self.closeAll,
			"cancel": self.keyCancel
		}, -1)

		self['title'] = Label("Stream-Oase.tv")
		self['ContentTitle'] = Label("Genre:")

		self.genreliste = []
		self.chooseMenuList = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self.chooseMenuList.l.setFont(0, gFont('mediaportal', 23))
		self.chooseMenuList.l.setItemHeight(25)
		self['liste'] = self.chooseMenuList

		self.onLayoutFinish.append(self.layoutFinished)

	def layoutFinished(self):
		self.genreliste.append(("Neuesten", "http://stream-oase.tv/index.php/hd-oase/video/latest?start="))
		self.genreliste.append(("Search", "http://stream-oase.tv/index.php/component/allvideoshare/search"))
		self.genreliste.append(("Action", "http://stream-oase.tv/index.php/hd-oase/category/action?start="))
		self.genreliste.append(("Abenteuer", "http://stream-oase.tv/index.php/hd-oase/category/abenteuer?start="))
		self.genreliste.append(("Drama", "http://stream-oase.tv/index.php/hd-oase/category/drama?start="))
		self.genreliste.append(("Krieg", "http://stream-oase.tv/index.php/hd-oase/category/krieg?start="))
		self.genreliste.append(("Thriller", "http://stream-oase.tv/index.php/hd-oase/category/thriller?start="))
		self.genreliste.append(("Horror", "http://stream-oase.tv/index.php/hd-oase/category/horror?start="))
		self.genreliste.append(("Komödie", "http://stream-oase.tv/index.php/hd-oase/category/komoedie?start="))
		self.genreliste.append(("Zeichentrick", "http://stream-oase.tv/index.php/hd-oase/category/zeichentrick?start="))
		self.genreliste.append(("Sci-fi", "http://stream-oase.tv/index.php/hd-oase/category/sci-fi?start="))
		self.genreliste.append(("Dokus", "http://stream-oase.tv/index.php/hd-oase/category/doku-s?start="))
		self.genreliste.append(("Western", "http://stream-oase.tv/index.php/hd-oase/category/western?start="))
		self.genreliste.append(("Fantasy", "http://stream-oase.tv/index.php/hd-oase/category/fantasyxy?start="))
		self.chooseMenuList.setList(map(oasetvGenreListEntry, self.genreliste))

	def keyOK(self):
		streamName = self['liste'].getCurrent()[0][0]
		streamGenreLink = self['liste'].getCurrent()[0][1]
		print streamName, streamGenreLink
		if streamName == "Search":
			self.session.openWithCallback(self.searchCallback, VirtualKeyBoardExt, title = (_("Enter search criteria")), text = "", is_dialog=True)
		else:
			self.session.open(oasetvFilmListeScreen, streamGenreLink, streamName)

	def searchCallback(self, callbackStr):
		if callbackStr is not None:
			self.session.open(oasetvFilmListeScreen, callbackStr, "Suche Auswahl: ")

def oaseFilmListEntry(entry):
	return [entry,
		(eListboxPythonMultiContent.TYPE_TEXT, 20, 0, 860, 25, 0, RT_HALIGN_LEFT | RT_VALIGN_CENTER, entry[0])
		]

class oasetvFilmListeScreen(MPScreen, ThumbsHelper):

	def __init__(self, session, streamGenreLink, streamName):
		self.streamGenreLink = streamGenreLink
		self.streamName = streamName
		self.plugin_path = mp_globals.pluginPath
		self.skin_path =  mp_globals.pluginPath + "/skins"
		path = "%s/%s/defaultListScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + "/original/defaultListScreen.xml"
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()
		MPScreen.__init__(self, session)
		ThumbsHelper.__init__(self)

		self["actions"]  = ActionMap(["MP_Actions"], {
			"ok"    : self.keyOK,
			"0": self.closeAll,
			"cancel": self.keyCancel,
			"5" : self.keyShowThumb,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft,
			"nextBouquet" : self.keyPageUp,
			"prevBouquet" : self.keyPageDown
		}, -1)

		self['title'] = Label("Stream-Oase.tv")
		if self.streamName == 'Suche Auswahl: ':
			self['ContentTitle'] = Label("%s: %s" % (self.streamName,self.streamGenreLink))
		else:
			self['ContentTitle'] = Label("Film Auswahl: %s" % self.streamName)

		self['Page'] = Label(_("Page:"))
		self['page'] = Label("1")

		self.keyLocked = True
		self.filmliste = []
		self.keckse = {}
		self.page = 0
		self.lastpage = 1
		self.chooseMenuList = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self.chooseMenuList.l.setFont(0, gFont('mediaportal', 23))
		self.chooseMenuList.l.setItemHeight(25)
		self['liste'] = self.chooseMenuList

		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		if self.streamName == 'Suche Auswahl: ':
			url = "http://stream-oase.tv/index.php/component/allvideoshare/search"
			info = urlencode({'avssearch': self.streamGenreLink, 'search_btn': 'Go'})
			getPage(url, agent=std_headers, method='POST', postdata=info, headers={'Content-Type':'application/x-www-form-urlencoded'}).addCallback(self.loadPageData).addErrback(self.dataError)
		else:
			url = "%s%s" % (self.streamGenreLink, str(self.page*49))
			getPage(url, agent=std_headers, headers={'Content-Type':'application/x-www-form-urlencoded'}).addCallback(self.loadPageData).addErrback(self.dataError)

	def loadPageData(self, data):
		print "daten bekommen"
		if re.match('.*?title="Ende">Ende<', data, re.S):
			totalpages = re.findall('\?start=(\d*?)" title', data, re.S)
			if totalpages:
				self.lastpage = (int(totalpages[-1]) / 49) + 1
				if int(self.page) == 0:
					print self.lastpage
					pagenr = "1 / %s" % self.lastpage
					self['page'].setText(pagenr)
				else:
					print self.lastpage
					pagenr = "%s / %s" % (int(self.page) + 1, self.lastpage)
					self['page'].setText(pagenr)
			else:
				totalpages = 999
		else:
			totalpages = re.findall('\?start=(\d*?)" title', data, re.S)
			if totalpages:
				self.lastpage = (int(totalpages[-1]) / 49) + 2
				print self.lastpage
			else:
				totalpages = re.findall('\?start=(\d*?)"', data, re.S)
				if totalpages:
					self.lastpage = (int(totalpages[-1]) / 49) + 1
					print self.lastpage
			if int(self.page) == 0:
				pagenr = "1 / %s" % self.lastpage
				self['page'].setText(str(pagenr))
			else:
				pagenr = "%s / %s" % (int(self.page) + 1, self.lastpage)
				self['page'].setText(str(pagenr))
		self.filmliste = []
		try:
			raw = re.findall('<div id="system-message-container">(.*?)<div style="clear:both"></div>', data, re.S)
			if self.streamName == 'Suche Auswahl: ':
				#filme = re.findall('<div class="avs_thumb" style="width:86px;">.*?href="(/index.php/component/allvideoshare/.*?)">.*?class="image" src="(.*?)" width="\d+" height="\d+" title="Click to View : (.*?)"', data, re.S)
				filmeparts = re.findall('<div class="avs_thumb" style="width:86px;">.*?href="(.*?Click to View : .*?)"', raw[0], re.S)
				if not filmeparts: raise Exception('No filmeparts found')
				for filmepart in filmeparts:
					part = re.search('^(/index.php/component/allvideoshare/.*?)">.*?class="image" src="(.*?)" width="\d+" height="\d+" title="Click to View : (.*?)$', filmepart, re.S)
					url = "http://stream-oase.tv" + part.group(1)
					image = part.group(2)
					title = part.group(3)
					self.filmliste.append((decodeHtml(title), url, image))
			else:
				#filme = re.findall('<a ondragstart="return false;" href="(/index.php/hd-oase/.*?)".*?<img ondragstart="return false;" class="image" src="(.*?)".*?title="Click to View : (.*?)"', raw[0], re.S)
				filmeparts = re.findall('<a ondragstart="return false;" href="(.*?Click to View : .*?)"', raw[0], re.S)
				if not filmeparts: raise Exception('No filmeparts found')
				for filmepart in filmeparts:
					part = re.search('^(/index.php/hd-oase/.*?)".*?<img ondragstart="return false;" class="image" src="(.*?)".*?title="Click to View : (.*?)$', filmepart, re.S)
					url = "http://stream-oase.tv" + part.group(1)
					image = part.group(2)
					title = part.group(3)
					self.filmliste.append((decodeHtml(title), url, image))
		except:
			self.filmliste.append((_("No movies found!"), '', ''))
		self.chooseMenuList.setList(map(oaseFilmListEntry, self.filmliste))
		self.keyLocked = False
		self.th_ThumbsQuery(self.filmliste,0,1,2,None,None, int(self.page)+1, self.lastpage, pagefix=-1)
		self.showInfos()

	def showInfos(self):
		streamName = self['liste'].getCurrent()[0][0]
		streamFilmLink = self['liste'].getCurrent()[0][1]
		self['name'].setText(streamName)
		streamPic = self['liste'].getCurrent()[0][2]
		getPage(streamFilmLink, agent=std_headers, headers={'Content-Type':'application/x-www-form-urlencoded'}).addCallback(self.loadPageInfos).addErrback(self.dataError)
		CoverHelper(self['coverArt']).getCover(streamPic)

	def loadPageInfos(self, data):
		try:
			handlung = re.search('</script></p>\r\n<p style="text-align: center;">(.*?)<div class="avs_video_comments">', data, re.S)
			handlung = re.findall('<p>(.\w.*?)</p>', handlung.group(1), re.S)
			if not handlung: raise Exception('No infos found')
			self['handlung'].setText(decodeHtml(handlung[-1]))
		except:
			self['handlung'].setText(_("No information found."))

	def keyOK(self):
		if self.keyLocked:
			return
		streamLink = self['liste'].getCurrent()[0][1]
		print streamLink
		self.keyLocked = True
		getPage(streamLink, agent=std_headers, headers={'Content-Type':'application/x-www-form-urlencoded'}).addCallback(self.findStream).addErrback(self.dataError)

	def findStream(self, data):
		stream_list = []
		stream_name = self['liste'].getCurrent()[0][0]
		streamPic = self['liste'].getCurrent()[0][2]
		try:
			parse = re.search('"sp-maincol"(.*?)"sp-bottom"', data, re.S)
			streams = re.findall('<IFRAME SRC="(http://(?!(stream-oase.tv|images\.|s7\.|www\.moviemaze))(.*?)\/.*?)[\'|"|\&|<]', parse.group(1), re.S|re.I)
			if not streams: raise Exception('No streamhoster found')
			for (stream, dummy, hostername) in streams:
				if isSupportedHoster(hostername, True):
					hostername = hostername.replace('www.','').replace('embed.','').replace('play.','')
					stream_list.append((hostername, stream))
			stream_list = list(set(stream_list))
		except:
			stream_list.append((_("No supported streams found!"), ''))
		self.keyLocked = False
		self.session.open(oasetvCDListeScreen, stream_list, stream_name, streamPic)

def oasetvCDListEntry(entry):
	return [entry,
		(eListboxPythonMultiContent.TYPE_TEXT, 20, 0, 860, 25, 0, RT_HALIGN_CENTER | RT_VALIGN_CENTER, entry[0])
		]

class oasetvCDListeScreen(MPScreen):

	def __init__(self, session, parts, stream_name, image_url):
		self.streamParts = parts
		self.stream_name = stream_name
		self.imageUrl = image_url
		self.plugin_path = mp_globals.pluginPath
		self.skin_path =  mp_globals.pluginPath + "/skins"
		path = "%s/%s/defaultListScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + "/original/defaultListScreen.xml"
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()
		MPScreen.__init__(self, session)

		self["actions"]  = ActionMap(["MP_Actions"], {
			"ok" : self.keyOK,
			"0" : self.closeAll,
			"cancel" : self.keyCancel
		}, -1)

		self['title'] = Label("Stream-Oase.tv")
		self['ContentTitle'] = Label("Stream Auswahl: %s" % self.stream_name)

		self['name'] = Label(_("Selection:"))

		self.keyLocked = False
		self.keckse = {}
		self.filmliste = []
		self.chooseMenuList = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self.chooseMenuList.l.setFont(0, gFont('mediaportal', 23))
		self.chooseMenuList.l.setItemHeight(25)
		self['liste'] = self.chooseMenuList

		self.onLayoutFinish.append(self.layoutFinished)

	def layoutFinished(self):
		for (name,url) in self.streamParts:
			print name, url
			self.filmliste.append((name, url))
		self.chooseMenuList.setList(map(oasetvCDListEntry, self.filmliste))
		CoverHelper(self['coverArt']).getCover(self.imageUrl)

	def keyOK(self):
		if self.keyLocked:
			return
		streamLink = self['liste'].getCurrent()[0][1]
		get_stream_link(self.session).check_link(streamLink, self.got_link)

	def got_link(self, stream_url):
		print "got_link:", stream_url
		if stream_url == None:
			message = self.session.open(MessageBox, _("Stream not found, try another Stream Hoster."), MessageBox.TYPE_INFO, timeout=3)
		else:
			if re.search('no_cover', self.imageUrl):
				cover = None
			else:
				cover = self.imageUrl
			self.session.open(SimplePlayer, [(self.stream_name, stream_url, cover)], showPlaylist=False, ltype='streamoase', cover=True)