#!/bin/sh

case $1 in

grabosd) 
	if [ -z $2 ]; then
		grab -o -d -p /tmp/screenosd_$(date +%Y.%m.%d@%H.%M.%S).png
	else
		grab -o -d -p $2/screenosd_$(date +%Y.%m.%d@%H.%M.%S).png
	fi
	;;
grabvid) 
	if [ -z $2 ]; then
		grab -v -p /tmp/screenvid_$(date +%Y.%m.%d@%H.%M.%S).png
	else
		grab -v -p $2/screenvid_$(date +%Y.%m.%d@%H.%M.%S).png
	fi
	;;
graball) 
	if [ -z $2 ]; then
		grab -p /tmp/screenall_$(date +%Y.%m.%d@%H.%M.%S).png
	else
		grab -p $2/screenall_$(date +%Y.%m.%d@%H.%M.%S).png
	fi
	;;
loge2) 
	if [ -z $2 ]; then
		journalctl -f -u enigma2 > /tmp/e2debug_$(date +%Y.%m.%d@%H.%M).log 2>&1
	else
		journalctl -f -u enigma2 > $2/e2debug_$(date +%Y.%m.%d@%H.%M).log 2>&1
	fi
	;;
debinstall) 
	if [ -z $2 ]; then
		dpkg -i /tmp/*.deb
	else
		dpkg -i $2/*.deb
	fi
	;;
powerstate)
	STATE=`wget http://127.0.0.1/web/powerstate -q -O - | grep true | cut -b 15-18`
	if [ "$STATE" == "true" ]; then
		echo "box is in standby"
	else
		echo "box is awake"
	fi
	;;
upgrade)
	echo "Update check, please wait..."
	CHECKU=`apt-get update -qq && apt-get -s dist-upgrade --allow-unauthenticated | awk '/^Inst/ { print $2 }'`
	OUTPUT=$CHECKU
	if [ "$OUTPUT" == "" ]; then
		echo "No Updates available."
		exit
	else
		echo "Updates available."
		apt-get dist-upgrade --allow-unauthenticated
	fi
	;;
esac
exit 0
