#
# PiconMapper
#
# Coded by dre (c) 2013
# Support: www.dreambox-tools.info
# E-Mail: dre@dreambox-tools.info
#
# This plugin is open source but it is NOT free software.
#
# This plugin may only be distributed to and executed on hardware which
# is licensed by Dream Multimedia GmbH.
# In other words:
# It's NOT allowed to distribute any parts of this plugin or its source code in ANY way
# to hardware which is NOT licensed by Dream Multimedia GmbH.
# It's NOT allowed to execute this plugin and its source code or even parts of it in ANY way
# on hardware which is NOT licensed by Dream Multimedia GmbH.
#
# If you want to use or modify the code or parts of it,
# you have to keep MY license and inform me about the modifications by mail.

from Components.ActionMap import ActionMap, HelpableActionMap
from Components.ConfigList import ConfigListScreen, ConfigList
from Components.Label import Label
from Components.MenuList import MenuList
from Components.MultiContent import MultiContentEntryText, MultiContentEntryPixmapAlphaBlend
from Components.Pixmap import Pixmap
from Components.config import getConfigListEntry, config, ConfigSubsection, ConfigSelection, ConfigOnOff, ConfigText, NoSave, ConfigNumber, ConfigSubList
from Screens.HelpMenu import HelpableScreen
from Screens.InputBox import InputBox
from Screens.MessageBox import MessageBox
from Screens.Screen import Screen
from ServiceReference import ServiceReference
from Tools.Directories import fileExists, SCOPE_SKIN_IMAGE, SCOPE_CURRENT_SKIN, resolveFilename
from Tools.HardwareInfo import HardwareInfo
from enigma import eListboxPythonMultiContent, gFont, loadPNG, eServiceCenter, eServiceReference, RT_HALIGN_RIGHT, eEnv
import os
import xml.etree.cElementTree

config.plugins.piconmapper = ConfigSubsection()
config.plugins.piconmapper.activate = ConfigOnOff(default = False)

def buildServiceRefString(service):
	sRef = service.toString()
	if sRef is "":
		return sRef

	# strip all after last http (e.g. partnerbox-services)
	pos = sRef.rfind("http")
	if pos != -1:
		sRef = sRef[:pos]

	pos = sRef.rfind(':')
	if pos == -1:
		return ""

	sRef = sRef[:pos].rstrip(':').replace(':','_')
	return sRef

class PiconMenuList(MenuList):
	def __init__(self, list, selection = 0):
		MenuList.__init__(self, list, False, eListboxPythonMultiContent)
		self.l.setFont(0, gFont("Regular", 22))
		self.l.setFont(1, gFont("Regular", 18))
		self.l.setItemHeight(60)
		self.selection = selection
		
	def postWidgetCreate(self, instance):
		MenuList.postWidgetCreate(self, instance)
		self.moveToIndex(self.selection)
		
	def setSelectedIndex(self, index):
		self.moveToIndex(index)
		
def PiconViewerListEntry(channel, localsref, satsref):
	res = [ (channel, localsref, satsref) ]

	if localsref is None:
		picon = resolveFilename(SCOPE_CURRENT_SKIN, "picon_default.png")
	else:
		for path in (eEnv.resolve('${datadir}/enigma2/picon/'),'/media/cf/picon/','/media/usb/picon/','/data/picon/'):
			picon = path + localsref + ".png"
			if fileExists(picon):
				break
			else:
				picon = resolveFilename(SCOPE_CURRENT_SKIN, "picon_default.png")
				if not fileExists(picon):
					picon = resolveFilename(SCOPE_SKIN_IMAGE, "skin_default/picon_default.png")
	
	res.append(MultiContentEntryPixmapAlphaBlend(pos=(0,0), size=(100,60), png=loadPNG(picon)))
	res.append(MultiContentEntryText(pos=(110,0), size=(140,20), font=1, text=_("Channel:")))	
	res.append(MultiContentEntryText(pos=(110,20), size=(140,20), font=1, text=_("Local:")))
	res.append(MultiContentEntryText(pos=(110,40), size=(140,20), font=1, text=_("Sat:")))
	
	res.append(MultiContentEntryText(pos=(250,0), size=(320,20), font=1, text=channel, flags=RT_HALIGN_RIGHT))
	res.append(MultiContentEntryText(pos=(250,20), size=(320,20), font=1, text=localsref, flags=RT_HALIGN_RIGHT)) 	
	res.append(MultiContentEntryText(pos=(250,40), size=(320,20), font=1, text=satsref, flags=RT_HALIGN_RIGHT))
	
	return res

def PiconMenuListEntry(channelname, serviceref, lamedbserviceref):
	res = [ (channelname, serviceref, lamedbserviceref) ]
	
	res.append(MultiContentEntryText(pos=(0,0), size=(500,25), font=1, text=channelname))
	
	return res

class PiconMapperConfigScreen(Screen, HelpableScreen, ConfigListScreen):
	skin = """
		<screen position="center,center" size="600,220" title="PiconMapper - Config">
			<widget name="config" position="0,0" size="600,180" scrollbarMode="showOnDemand" />
			<widget name="ButtonGreentext" position="20,180" size="350,40" valign="center" halign="left" zPosition="10" font="Regular;18" transparent="1" />
			<widget name="ButtonGreen" pixmap="skin_default/buttons/button_green.png" position="0,190" zPosition="10" size="16,16" transparent="1" alphatest="on" />
		</screen>
		"""
		
	def __init__(self,session):
		self.skin = PiconMapperConfigScreen.skin
		self.session = session
		Screen.__init__(self, session)
		HelpableScreen.__init__(self)
		
		self["OkCancelActions"] = HelpableActionMap(self, "OkCancelActions",
		{
			"cancel":	(self.close, _("Close")),
		}, -1)
		
		self["ColorActions"] = HelpableActionMap(self, "ColorActions",
		{
			"green":	(self.saveSelection, _("Select")),
		}, -1)
		
		self["ButtonGreen"] = Pixmap()
		self["ButtonGreentext"] = Label(_("Save settings"))
		
		self.list = []

		ConfigListScreen.__init__(self, self.list)

		self.createConfig()

		
	def saveSelection(self):
		for x in self["config"].list:
			x[1].save()
			
		self.close()

	def createConfig(self, configElement=""):
	
		self.list = []
				
		self.list.append(getConfigListEntry(_("Activate Picon Mapper:"), config.plugins.piconmapper.activate))

		self["config"].setList(self.list)

class PiconMapperScreen(Screen, HelpableScreen):
	skin = """
		<screen position="center,center" size="500,460" title="PiconMapper">
			<widget name="description" position="0,0" size="250,25" font="Regular;18" transparent="1" />
			<widget name="unmappedsref" position="250,0" size="250,25" font="Regular;18" transparent="1" />
			<widget name="menulist" position="0,25" size="500,360" scrollbarMode="showOnDemand" />
			<widget name="instruction" position="0,385" size="500,40" font="Regular;18" transparent="1" />
			<widget name="ButtonYellowtext" position="50,433" size="300,20" valign="center" halign="left" zPosition="10" font="Regular;18" transparent="1" />
			<widget name="ButtonYellow" pixmap="skin_default/buttons/button_yellow.png" position="10,435" zPosition="10" size="16,16" transparent="1" alphatest="on" />
		</screen>
		"""
		
	def __init__(self, session, serviceList):
		self.skin = PiconMapperScreen.skin
		self.session = session
		Screen.__init__(self, session)
		HelpableScreen.__init__(self)
		
		self.serviceList = serviceList
		self.serviceIterator = iter(self.serviceList)
		self.serviceCounter = 0
		self.searchName = ""
		self.preparationRunning = False
		
		self["OkCancelActions"] = HelpableActionMap(self, "OkCancelActions",
		{
			"ok":		(self.addMapping, _("Add mapping")),
			"cancel":	(self.closeOrSkip, _("Close")),
		}, -1)
		
		self["DirectionActions"] = HelpableActionMap(self, "DirectionActions",
		{
			"up":		(self.up, _("Move one up")),
			"left":		(self.left, _("Move page up")),
			"right":	(self.right, _("Move page down")),
			"down":		(self.down, _("Move one down")),
		}, -1)
		
		self["ColorActions"] = HelpableActionMap(self, "ColorActions",
		{
			"yellow": 	(self.searchChannel, _("Manual search")),
		}, -1)
		
		self["ButtonYellow"] = Pixmap()
		self["ButtonYellowtext"] = Label(_("Manually enter (part of) channel name"))
		self["description"] = Label(_("Channel:"))
		self["unmappedsref"] = Label()
		self["menulist"] = PiconMenuList([])
		self["instruction"] = Label(_("Select entry and press OK to add mapping"))

		self.PiconEntryList = []
		
		self.getChannelData()
		
		self.onShown.append(self.buildScreen)

	def searchChannel(self):
		self.session.openWithCallback(self.setChannelData, InputBox, title = _("Enter search string"))
		
	def setChannelData(self, searchName):
		self.searchName = searchName
		self.buildScreen()

	def closeOrSkip(self):
		if self.serviceCounter == len(self.serviceList):
			self.close()
		else:
			info = self.session.openWithCallback(self.checkAnswer,MessageBox,_("Continue mapping with next channel?"), MessageBox.TYPE_YESNO)
			info.setTitle(_("PiconMapper"))

	def checkAnswer(self, ret):
		if not ret:
			self.close()
	
	def left(self):
		self["menulist"].pageUp()
	
	def right(self):
		self["menulist"].pageDown()
		
	def up(self):
		self["menulist"].up()

	def down(self):
		self["menulist"].down()
		
	def getNextService(self):
		name = ""
		sRef = ""
		try:
			service = self.serviceIterator.next()
			self.isPartnerbox = False
				
			if service.getPath():
				self.isPartnerbox = True
				
			eServiceCenterInstance = eServiceCenter.getInstance()
			info = eServiceCenterInstance.info(service)
			sRef = buildServiceRefString(service)
				
			name = info.getName(service) or ServiceReference(service).getServiceName() or ""
			name = name.replace('\xc2\x86', '').replace('\xc2\x87', '')
			
			print "[PiconMapper] current channel: ", name
		
			if self.isPartnerbox:
				pos = name.rfind("(")
				name = name[:pos-1]
				
			self.serviceCounter += 1
					
		except StopIteration:
			print "[PiconMapper] no more items"
			pass
			
		return name, sRef

	def getChannelData(self):
		# read all entries from sref2name and store it in a dictionary
		self.channelnamedict = {}
		
		self.preparationRunning = True
		
		if fileExists("/usr/share/enigma2/sref2name"):
			lamefile = file("/usr/share/enigma2/sref2name","r")
			
			for line in lamefile.readlines():
				linesplit = line.split(":::")
				linesplit[1] = linesplit[1].strip("\n").strip("\r")
				self.channelnamedict[linesplit[0]] = linesplit[1]

			
			lamefile.close()
			
			self.channelname, self.unmappedsref = self.getNextService()
		
	def buildScreen(self):
		while self.preparationRunning == False:
			pass
		else:
			self.PiconEntryList = []
		
			self.index = 0
		
			if self.channelname != "" and self.unmappedsref != "":
				#search channel in channelnamedict and add it to the list		
				for ref, name in self.channelnamedict.iteritems():
					self.matchFound = False	
					if self.searchName == "":
						if name.replace('\xc2\x86', '').replace('\xc2\x87', '').upper() == self.channelname.replace('\xc2\x86', '').replace('\xc2\x87', '').upper():
							refarray = ref.split(":")
							self.matchFound = True
					elif self.searchName != "":
						#if name.replace('\xc2\x86', '').replace('\xc2\x87', '').upper().startswith(self.searchName.upper()):
						if self.searchName.upper() in name.replace('\xc2\x86', '').replace('\xc2\x87', '').upper():
							refarray = ref.split(":")
							self.matchFound = True
				
					if self.matchFound:
						unmappedarray = self.unmappedsref.split("_")
				
						for i in range(len(refarray)):
							while(refarray[i].startswith("0")):
								refarray[i] = refarray[i][1:]
				
						mappedsref = unmappedarray[0] + "_" + unmappedarray[1] + "_" + unmappedarray[2] + "_" + refarray[0] + "_" + refarray[2] + "_" + refarray[3] + "_" + refarray[1] + "_0_0_0"

						satposition = float(int(refarray[1][:2],16)) / 10
						name = name.replace('\xc2\x86', '').replace('\xc2\x87', '')
						name = name + " (%.1f)" %(satposition)
				
						self.PiconEntryList.append(PiconMenuListEntry(name, self.unmappedsref, mappedsref))

			self["menulist"].setList(self.PiconEntryList)
			self["menulist"].setSelectedIndex(self.index)

			if not self.unmappedsref is None:
				if self.channelname != "":
					servicename = self.channelname
				else:
					servicename = "N/V"

			if self.searchName != "":
				self["unmappedsref"].setText(self.searchName)
			else:
				self["unmappedsref"].setText(servicename)
		
	def addMapping(self):
		if not fileExists("/usr/share/enigma2/piconmapper.xml"):
			os.system("touch /usr/share/enigma2/piconmapper.xml")
			os.system("echo '<piconmappings></piconmappings>' > /usr/share/enigma2/piconmapper.xml")
		
		if len(self.PiconEntryList) > 0:
			if self.channelname == "":
				self.channelname = "N/V"
			self.updatePiconMapping(self.channelname, self.unmappedsref, self.PiconEntryList[self["menulist"].getSelectedIndex()][0][2])
		
	def updatePiconMapping(self, channel, sref, mappedsref):
		srefmapped = False
			
		piconmapper = file("/usr/share/enigma2/piconmapper.xml", "r")
			
		piconmapperdom = xml.etree.cElementTree.parse(piconmapper)
			
		xmldata = piconmapperdom.getroot()
			
		for x in xmldata.findall('piconmapping'):
			if x.get('localsref') == sref and x.get('satsref') == mappedsref:
				srefmapped = True
						
		if srefmapped == False:
			child = xml.etree.cElementTree.Element('piconmapping')
			xmldata.append(child)
			child.attrib['satsref'] = mappedsref
			child.attrib['localsref'] = sref
			child.attrib['channel'] = channel
			piconmapperdom.write("/usr/share/enigma2/piconmapper.xml")
				
		piconmapper.close()
			
		info = self.session.open(MessageBox,_("Picon mapping was updated."), MessageBox.TYPE_INFO, timeout=5)
		info.setTitle(_("PiconMapper"))
		if len(self.serviceList) == 1:
			self.close(0)

class PiconMappingViewerScreen(Screen, HelpableScreen):
	skin = """
		<screen position="center,center" size="600,435" title="PiconMapper - Viewer">
			<widget name="menulist" position="0,0" size="600,360" scrollbarMode="showOnDemand" />
			<widget name="ButtonRedtext" position="50,405" size="300,20" valign="center" halign="left" zPosition="10" font="Regular;18" transparent="1" />
			<widget name="ButtonRed" pixmap="skin_default/buttons/button_red.png" position="10,405" zPosition="10" size="16,16" transparent="1" alphatest="on" />
			<widget name="ButtonMenutext" position="50,375" size="200,20" valign="center" halign="left" zPosition="10" font="Regular;18" transparent="1" />
			<widget name="ButtonMenu" pixmap="skin_default/buttons/key_menu.png" position="10,375" zPosition="10" size="40,20" transparent="1" alphatest="on" />
		</screen>
		"""

	def __init__(self, session, args=0):
		self.skin = PiconMappingViewerScreen.skin
		self.session = session
		Screen.__init__(self, session)
		HelpableScreen.__init__(self)
		
		self["OkCancelActions"] = HelpableActionMap(self, "OkCancelActions",
		{
			"ok":		(self.deleteMapping, _("Delete selected mapping")),
			"cancel":	(self.close, _("Close")),
		}, -1)

		self["MenuActions"] = HelpableActionMap(self, "MenuActions",
		{
			"menu":		(self.openConfig, _("Show config")),
		}, -1)
		
		self["DirectionActions"] = HelpableActionMap(self, "DirectionActions",
		{
			"up":		(self.up, _("Move one up")),
			"left":		(self.left, _("Move page up")),
			"right":	(self.right, _("Move page down")),
			"down":		(self.down, _("Move one down")),
		}, -1)

		self["ColorActions"] = HelpableActionMap(self, "ColorActions",
		{
			"red":	(self.deleteMapping, _("Delete selected mapping")),
		}, -1)		
		
		self["ButtonMenu"] = Pixmap()
		self["ButtonMenutext"] = Label(_("Open config"))
		
		self["ButtonRed"] = Pixmap()
		self["ButtonRedtext"] = Label(_("Delete selected mapping"))
		
		self["menulist"] = PiconMenuList([])
		
		self.PiconEntryList = []
		
		self.onShown.append(self.buildScreen)

	def openConfig(self):
		self.session.open(PiconMapperConfigScreen)
					
	def left(self):
		self["menulist"].pageUp()
	
	def right(self):
		self["menulist"].pageDown()
		
	def up(self):
		self["menulist"].up()

	def down(self):
		self["menulist"].down()
		
	def buildScreen(self):
	
		self.PiconMappingList = []
	
		if fileExists("/usr/share/enigma2/piconmapper.xml"):
			
			piconmapper = file("/usr/share/enigma2/piconmapper.xml", "r")
			
			piconmapperdom = xml.etree.cElementTree.parse(piconmapper)
			
			xmldata = piconmapperdom.getroot()
			
			piconmapper.close()
			
			for x in xmldata.findall('piconmapping'):
				localsref = x.get('localsref')
				satsref = x.get('satsref')
				channel = x.get('channel')

				self.PiconMappingList.append(PiconViewerListEntry(channel, localsref, satsref))

		self["menulist"].setList(self.PiconMappingList)	
		
	def deleteMapping(self):
		self.index = self["menulist"].getSelectedIndex()
		
		if fileExists("/usr/share/enigma2/piconmapper.xml"):
		
			piconmapper = file("/usr/share/enigma2/piconmapper.xml", "r")
			
			piconmapperdom = xml.etree.cElementTree.parse(piconmapper)
			
			xmldata = piconmapperdom.getroot()
		
			writeUpdate = False
		
			for x in xmldata.findall('piconmapping'):
				if x.get('localsref') == self.PiconMappingList[self.index][0][1] and x.get('satsref') == self.PiconMappingList[self.index][0][2]:
					xmldata.remove(x)
					writeUpdate = True
					info = self.session.open(MessageBox,_("Picon mapping was deleted."), MessageBox.TYPE_INFO, timeout=	5)
					info.setTitle(_("PiconMapper"))
		
			if writeUpdate == True:
				piconmapperdom.write("/usr/share/enigma2/piconmapper.xml")
		
			piconmapper.close()
			self.buildScreen()
