// helpers

function MerlinSetting(xml, cssclass){
	this.merlinsettingdescription = getNodeContent(xml, 'e2merlinsettingdescription');
	this.merlinsettingconfig = getNodeContent(xml, 'e2merlinsettingconfig');
	this.merlinsettingdefaultvalue = getNodeContent(xml, 'e2merlinsettingdefaultvalue');
	this.merlinsettingvalues = getNodeContent(xml, 'e2merlinsettingvalues');
	this.merlinsettingcategory = getNodeContent(xml, 'e2merlinsettingcategory');
	//this.merlinsettingvalue = getNodeContent(xml, 'e2merlinsettingvalue');

	this.getColor = function(){
		return this.color;
	};

	this.getMerlinSettingDescription = function(){
		return this.merlinsettingdescription;
	};
	
	this.getMerlinSettingConfig = function(){
		return this.merlinsettingconfig;
	};

	this.getMerlinSettingDefaultValue = function(){
		return this.merlinsettingdefaultvalue;
	};

	this.getMerlinSettingValues = function(){
		var array = this.merlinsettingvalues;
		return array;
	};
	
	this.getMerlinSettingCategory = function(){
		return this.merlinsettingcategory;
	};
	
	if( typeof( cssclass ) == undefined ){
		cssclass = 'odd';
	}

	this.json = {
			'e2merlinsettingdescription' : this.getMerlinSettingDescription(),
			'e2merlinsettingconfig' : this.getMerlinSettingConfig(),
			'e2merlinsettingdefaultvalue' : this.getMerlinSettingDefaultValue(),
			'e2merlinsettingvalues' : this.getMerlinSettingValues(),
			'e2merlinsettingcategory' : this.getMerlinSettingCategory(),
			//'e2merlinsettingvalue' : this.getMerlinSettingValue(),
			'cssclass' : cssclass,
	};

	this.toJSON = function(){
		return this.json;
	};
}

function MerlinSettingsList(xml){
	this.xmlitems = getNamedChildren(xml, "e2merlinsettings", "e2merlinsetting"); //, "e2merlinsettingvalues");
	this.settingslist = [];

	this.getArray = function(){
		if(this.settingslist.length === 0){
			var cssclass = 'even';
			var len = this.xmlitems.length;
			for(var i=0; i<len; i++){
				cssclass = cssclass == 'even' ? 'odd' : 'even';
				var merlinsetting = new MerlinSetting(this.xmlitems.item(i), cssclass).toJSON();
				this.settingslist.push(merlinsetting);
			}
		}

		return this.settingslist;
	};
}

function ChannellistSetting(xml, cssclass){
	this.merlinsettingdescription = getNodeContent(xml, 'e2merlinsettingdescription');
	this.merlinsettingconfig = getNodeContent(xml, 'e2merlinsettingconfig');
	this.merlinsettingdefaultvalue = getNodeContent(xml, 'e2merlinsettingdefaultvalue');
	this.merlinsettingvalues = getNodeContent(xml, 'e2merlinsettingvalues');
	this.merlinsettingcategory = getNodeContent(xml, 'e2merlinsettingcategory');
	//this.merlinsettingvalue = getNodeContent(xml, 'e2merlinsettingvalue');

	this.getColor = function(){
		return this.color;
	};

	this.getMerlinSettingDescription = function(){
		return this.merlinsettingdescription;
	};
	
	this.getMerlinSettingConfig = function(){
		return this.merlinsettingconfig;
	};

	this.getMerlinSettingDefaultValue = function(){
		return this.merlinsettingdefaultvalue;
	};

	this.getMerlinSettingValues = function(){
		var array = this.merlinsettingvalues;
		return array;
	};

	this.getMerlinSettingCategory = function(){
		return this.merlinsettingcategory;
	};
	
	if( typeof( cssclass ) == undefined ){
		cssclass = 'odd';
	}

	this.json = {
			'e2merlinsettingdescription' : this.getMerlinSettingDescription(),
			'e2merlinsettingconfig' : this.getMerlinSettingConfig(),
			'e2merlinsettingdefaultvalue' : this.getMerlinSettingDefaultValue(),
			'e2merlinsettingvalues' : this.getMerlinSettingValues(),
			'e2merlinsettingcategory' : this.getMerlinSettingCategory(),
			//'e2merlinsettingvalue' : this.getMerlinSettingValue(),
			'cssclass' : cssclass,
	};

	this.toJSON = function(){
		return this.json;
	};
}

function ChannellistSettingsList(xml){
	this.xmlitems = getNamedChildren(xml, "e2merlinsettings", "e2merlinsetting"); //, "e2merlinsettingvalues");
	this.settingslist = [];

	this.getArray = function(){
		if(this.settingslist.length === 0){
			var cssclass = 'even';
			var len = this.xmlitems.length;
			for(var i=0; i<len; i++){
				cssclass = cssclass == 'even' ? 'odd' : 'even';
				var merlinsetting = new MerlinSetting(this.xmlitems.item(i), cssclass).toJSON();
				this.settingslist.push(merlinsetting);
			}
		}

		return this.settingslist;
	};
}

function DMMSetting(xml, cssclass){
	this.merlinsettingdescription = getNodeContent(xml, 'e2merlinsettingdescription');
	this.merlinsettingconfig = getNodeContent(xml, 'e2merlinsettingconfig');
	this.merlinsettingdefaultvalue = getNodeContent(xml, 'e2merlinsettingdefaultvalue');
	this.merlinsettingvalues = getNodeContent(xml, 'e2merlinsettingvalues');
	this.merlinsettingcategory = getNodeContent(xml, 'e2merlinsettingcategory');

	this.getColor = function(){
		return this.color;
	};

	this.getMerlinSettingDescription = function(){
		return this.merlinsettingdescription;
	};
	
	this.getMerlinSettingConfig = function(){
		return this.merlinsettingconfig;
	};

	this.getMerlinSettingDefaultValue = function(){
		return this.merlinsettingdefaultvalue;
	};

	this.getMerlinSettingValues = function(){
		var array = this.merlinsettingvalues;
		return array;
	};

	this.getMerlinSettingCategory = function(){
		return this.merlinsettingcategory;
	};
	
	if( typeof( cssclass ) == undefined ){
		cssclass = 'odd';
	}

	this.json = {
			'e2merlinsettingdescription' : this.getMerlinSettingDescription(),
			'e2merlinsettingconfig' : this.getMerlinSettingConfig(),
			'e2merlinsettingdefaultvalue' : this.getMerlinSettingDefaultValue(),
			'e2merlinsettingvalues' : this.getMerlinSettingValues(),
			'e2merlinsettingcategory' : this.getMerlinSettingCategory(),
			//'e2merlinsettingvalue' : this.getMerlinSettingValue(),
			'cssclass' : cssclass,
	};

	this.toJSON = function(){
		return this.json;
	};
}

function DMMSettingsList(xml){
	this.xmlitems = getNamedChildren(xml, "e2merlinsettings", "e2merlinsetting"); //, "e2merlinsettingvalues");
	this.settingslist = [];

	this.getArray = function(){
		if(this.settingslist.length === 0){
			var cssclass = 'even';
			var len = this.xmlitems.length;
			for(var i=0; i<len; i++){
				cssclass = cssclass == 'even' ? 'odd' : 'even';
				var dmmsetting = new DMMSetting(this.xmlitems.item(i), cssclass).toJSON();
				this.settingslist.push(dmmsetting);
			}
		}

		return this.settingslist;
	};
}

function PiconMapping(xml, cssclass){
	this.channel = getNodeContent(xml, 'e2channel');
	this.localsref = getNodeContent(xml, 'e2localsref');
	this.satsref = getNodeContent(xml, 'e2satsref');

	this.getColor = function(){
		return this.color;
	};
	
	this.getChannel = function(){
		return this.channel;
	}

	this.getLocalSref = function(){
		return this.localsref;
	};
	
	this.getSatSref = function(){
		return this.satsref;
	};
	
	if( typeof( cssclass ) == undefined ){
		cssclass = 'odd';
	}

	this.json = {
			'e2channel' : this.getChannel(),
			'e2localsref' : this.getLocalSref(),
			'e2satsref' : this.getSatSref(),
			'cssclass' : cssclass,
	};

	this.toJSON = function(){
		return this.json;
	};
}

function PiconMappingList(xml){
	this.xmlitems = getNamedChildren(xml, "e2piconmappings", "e2piconmapping"); //, "e2merlinsettingvalues");
	this.settingslist = [];

	this.getArray = function(){
		if(this.settingslist.length === 0){
			var cssclass = 'even';
			var len = this.xmlitems.length;
			for(var i=0; i<len; i++){
				cssclass = cssclass == 'even' ? 'odd' : 'even';
				var piconmapping = new PiconMapping(this.xmlitems.item(i), cssclass).toJSON();
				this.settingslist.push(piconmapping);
			}
		}

		return this.settingslist;
	};
}


function MerlinMemoryInfo(xml, cssclass){
	this.memdevicename = getNodeContent(xml, 'e2memdevicename');
	this.memmountpoint = getNodeContent(xml, 'e2memmountpoint');
	this.memusedspace = getNodeContent(xml, 'e2memusedspace');
	this.memtotalspace = getNodeContent(xml, 'e2memtotalspace');
	this.percused = getNodeContent(xml, 'e2percused');
	
	this.getMemDeviceName = function(){
		return this.memdevicename;
	};
	
	this.getMemMountPoint = function(){
		return this.memmountpoint;
	};
	
	this.getMemUsedSpace = function(){
		return this.memusedspace;
	};
	
	this.getMemTotalSpace = function(){
		return this.memtotalspace;
	};
	
	this.getPercUsed = function(){
		return this.percused;
	};
	
	if( typeof( cssclass ) == undefined ){
		cssclass = 'odd';
	}
	
	this.json = {
		'e2memdevicename' : this.getMemDeviceName(),
		'e2memmountpoint' : this.getMemMountPoint(),
		'e2memusedspace' : this.getMemUsedSpace(),
		'e2memtotalspace' : this.getMemTotalSpace(),
		'e2percused' : this.getPercUsed(),
		'cssclass' : cssclass,
	};
	
	this.toJSON = function(){
		return this.json;
	};
}

function MerlinMemDevicesList(xml){
	this.xmlitems = getNamedChildren(xml, "e2memdevices", "e2memdevice");
	this.memdeviceslist = [];
	
	this.getArray = function(){
		if(this.memdeviceslist.length === 0){
			var cssclass = 'even';
			var len = this.xmlitems.length;
			for(var i=0; i<len; i++){
				cssclass = cssclass == 'even' ? 'odd' : 'even';
				var memdevice = new MerlinMemoryInfo(this.xmlitems.item(i), cssclass).toJSON();
				this.memdeviceslist.push(memdevice);
			}
		}
		return this.memdeviceslist;
	};
}