#
#  ServiceEventReference - Source
#
#  Coded by Dr.Best (c) 2010
#  Support: www.dreambox-tools.info
#
#  This plugin is licensed under the Creative Commons 
#  Attribution-NonCommercial-ShareAlike 3.0 Unported 
#  License. To view a copy of this license, visit
#  http://creativecommons.org/licenses/by-nc-sa/3.0/ or send a letter to Creative
#  Commons, 559 Nathan Abbott Way, Stanford, California 94305, USA.
#
#  Alternatively, this plugin may be distributed and executed on hardware which
#  is licensed by Dream Multimedia GmbH.

#  This plugin is NOT free software. It is open source, you are allowed to
#  modify it (if you keep the license), but it may not be commercially 
#  distributed other than under the conditions noted above.
#
from Components.Element import cached
from Source import Source

class ServiceEventReference(Source, object):
	def __init__(self):
		Source.__init__(self)
		self.service = None 
		self.currentRunningService = None

	@cached
	def getCurrentSelectedService(self):
		return self.service

	@cached
	def getCurrentRunningService(self):
		return self.currentRunningService

	def newServices(self, ref, ref2):
		self.currentRunningService = ref2
		if not self.service or not ref or self.service != ref:
			self.service = ref
			self.changed((self.CHANGED_ALL,))
