from GUIComponent import GUIComponent
from Tools.FuzzyDate import FuzzyTime
from ServiceReference import ServiceReference
from Components.MultiContent import MultiContentEntryText, MultiContentEntryProgress
from Components.config import config

from enigma import eListboxPythonMultiContent, eListbox, gFont, iServiceInformation, \
	RT_HALIGN_LEFT, RT_HALIGN_RIGHT, eServiceReference, eServiceCenter


# Dr.Best: folder in movielist
from Tools.LoadPixmap import LoadPixmap
from Tools.Directories import SCOPE_CURRENT_SKIN, resolveFilename, fileExists
import os

from skin import parseColor

# Dr.Best: recording flag
import NavigationInstance
from timer import TimerEntry
from stat import ST_MTIME as stat_ST_MTIME
from time import time as time_time
from math import fabs as math_fabs

from struct import calcsize as struct_calcsize, unpack as struct_unpack, pack as struct_pack

MEDIAEXTENSIONS = {
		"m4a": "music",
		"mp2": "music",
		"mp3": "music",
		"wav": "music",
		"ogg": "music",
		"wma": "movie",
		"flac": "music",
		"jpg": "picture",
		"jpeg": "picture",
		"png": "picture",
		"bmp": "picture",
		"ts": "movie",
		"avi": "movie",
		"divx": "movie",
		"mpg": "movie",
		"mpeg": "movie",
		"mkv": "movie",
		"mp4": "movie",
		"mov": "movie",
		"wmv": "movie",
		"flv": "movie",
		"m4v": "movie",
		"dat": "movie"
	}

MEDIACACHELIST = {}

class MovieList(GUIComponent):
	SORT_ALPHANUMERIC = 1
	SORT_RECORDED = 2

	SORT_DATE_ASC = 3
	SORT_DATE_DESC = 4

	LISTTYPE_ORIGINAL = 1
	LISTTYPE_COMPACT_DESCRIPTION = 2
	LISTTYPE_COMPACT = 3
	LISTTYPE_MINIMAL = 4
	# Dr.Best: merlin listtype
	LISTTYPE_MINIMAL_MERLIN = 5

	HIDE_DESCRIPTION = 1
	SHOW_DESCRIPTION = 2

	SELECTION_MODE = 0

	def __init__(self, root, list_type=None, sort_type=None, descr_state=None, show_folders = False, show_progressbar = False, show_statusicon = False, show_statuscolor = False): # Dr.Best: folder in movielist, progressbar, staus icon and color status
		GUIComponent.__init__(self)
		self.list_type = list_type or self.LISTTYPE_ORIGINAL
		self.descr_state = descr_state or self.HIDE_DESCRIPTION
		self.sort_type = sort_type or self.SORT_RECORDED

		# Dr.Best: folder in movielist
		self.show_folders = show_folders

		# Dr.Best: progressbar in movielist
		self.show_progressbar = show_progressbar

		# Dr.Best: status icon in movielist
		self.show_statusicon = show_statusicon

		# Dr.Best: color status in movielist
		self.show_statuscolor = show_statuscolor
		self.l = eListboxPythonMultiContent()
		self.tags = set()
		
		if root is not None:
			self.reload(root)
		
		self.redrawList()
		self.l.setBuildFunc(self.buildMovieListEntry)
		
		self.onSelectionChanged = [ ]

		# Dr.Best: some color stuff
		try: self.watching_color =  parseColor("movieWatching").argb()    
		except: self.watching_color = 0x879CC1
		try: self.finished_color =  parseColor("movieFinished").argb()    
		except: self.finished_color = 0x56C856
		try: self.recording_color =  parseColor("movieRecording").argb()
		except: self.recording_color = 0xff4A3C
		# Dr.Best delete mode color
		try: self.deletemode_color =  parseColor("deleteMode").argb()
		except: self.deletemode_color = 0xd01709
		try: self.deletemodeselected_color =  parseColor("deleteModeSelected").argb()
		except: self.deletemodeselected_color = 0xa60f04
		# Dr.Best moveTo mode color
		try: self.movetomode_color =  parseColor("moveToMode").argb()
		except: self.movetomode_color = 0x5385c3
		try: self.movetomodeselected_color =  parseColor("moveToModeSelected").argb()
		except: self.movetomodeselected_color = 0x365b8a

		self.selectionList = {}

		self.use_mediacaching = config.merlin2.use_mediacache.value


	def connectSelChanged(self, fnc):
		if not fnc in self.onSelectionChanged:
			self.onSelectionChanged.append(fnc)

	def disconnectSelChanged(self, fnc):
		if fnc in self.onSelectionChanged:
			self.onSelectionChanged.remove(fnc)

	def selectionChanged(self):
		for x in self.onSelectionChanged:
			x()

	def setListType(self, type):
		self.list_type = type

	def setDescriptionState(self, val):
		self.descr_state = val

	def setSortType(self, type):
		self.sort_type = type

	# Dr.Best: folder in movielist
	def showFolders(self, val):
		self.show_folders = val

	# Dr.Best: progressbar in movielist
	def showProgressbar(self, val):
		self.show_progressbar = val

	# Dr.Best: progressbar in movielist
	def showStatusIcon(self, val):
		self.show_statusicon = val

	def showStatusColor(self, val):
		self.show_statuscolor = val

	def redrawList(self):
		if self.list_type == MovieList.LISTTYPE_ORIGINAL:
			self.l.setFont(0, gFont("Regular", 22))
			self.l.setFont(1, gFont("Regular", 18))
			self.l.setFont(2, gFont("Regular", 16))
			self.l.setItemHeight(75)
		elif self.list_type == MovieList.LISTTYPE_COMPACT_DESCRIPTION or self.list_type == MovieList.LISTTYPE_COMPACT:
			self.l.setFont(0, gFont("Regular", 20))
			self.l.setFont(1, gFont("Regular", 14))
			self.l.setItemHeight(37)
		else:
			# Dr.Best: merlin listtype
			if self.list_type == MovieList.LISTTYPE_MINIMAL_MERLIN:
				self.l.setFont(0, gFont("Regular",18))
			else:
				self.l.setFont(0, gFont("Regular", 20))
			self.l.setFont(1, gFont("Regular", 16))
			self.l.setItemHeight(25)

	def getLastPosition(self, filename):
		index1 = last = None
		if os.path.exists(filename):
			cuts_format = ">QI" # big endian, unsigned long long, unsigned int
			cuts_format_size = struct_calcsize(cuts_format)
			try:
				cuts_file = open(filename, 'rb')
			except IOError:
				cuts_file = None
			if cuts_file:
				last = 0
				while True:
					cuts_data = cuts_file.read(cuts_format_size)
					if len(cuts_data) <> cuts_format_size: # the string must contain exactly the amount of data required by the format
						break
					cuts_unpacked_data = struct_unpack(cuts_format, cuts_data)
					if cuts_unpacked_data[1] == 1:
						index1 = cuts_unpacked_data[0]
					elif cuts_unpacked_data[1] == 3: # CUT_TYPE_LAST = 3 --> InfoBarCueSheetSupport
						last = cuts_unpacked_data[0]
				cuts_file.close()
		return (index1, last)
	#
	# | name of movie              |
	#
	def buildMovieListEntry(self, serviceref, info, begin, len, last_pos = None):

		global MEDIACACHELIST
		width = self.l.getItemSize().width()

		if self.show_folders:
			# Dr.Best: folder in movielist
			if serviceref.flags & eServiceReference.mustDescent:
				res = [ None ]
				png = LoadPixmap(cached=True, path=resolveFilename(SCOPE_CURRENT_SKIN, "extensions/directory.png"))
				res.append((eListboxPythonMultiContent.TYPE_PIXMAP_ALPHATEST, 0, 2, 20, 20, png))
				res.append(MultiContentEntryText(pos=(25, 0), size=(width-40, 30), font = 0, flags = RT_HALIGN_LEFT, text=serviceref.getName()))
				return res
			# Dr.Best: show media icon
			extension = serviceref.toString().split('.')
			extension = extension[-1].lower()
			offset = 25
			if MEDIAEXTENSIONS.has_key(extension):
				png = LoadPixmap(cached=True, path=resolveFilename(SCOPE_CURRENT_SKIN, "extensions/" + MEDIAEXTENSIONS[extension] + ".png"))
			else:
				png = None
		else:
			if serviceref.flags & eServiceReference.mustDescent:
				return None
			offset = 0

		if len >0 and last_pos is not None:
			mps = (len,last_pos)
		else:
			extension = serviceref.getPath().split('.')[-1].lower()
			if extension in ("avi","divx","mpg","mpeg","mkv","mp4","mov", "ts"):
				cutsfilename = os.path.realpath("%s.cuts" % serviceref.getPath())
				mps = self.getLastPosition(cutsfilename)
			else:
				mps = (None,None)

		if len <= 0: #recalc len when not already done
			cur_idx = self.l.getCurrentSelectionIndex()
			x = self.list[cur_idx]
			if config.usage.load_length_of_movies_in_moviellist.value:
				len = x[1].getLength(x[0]) #recalc the movie length...
				if len <= 0:
					len = mps[0]
					if len is None:
						len = 0
					else:
						len = len / 90000
			else:
				len = 0 #dont recalc movielist to speedup loading the list
			self.list[cur_idx] = (x[0], x[1], x[2], len, mps[1]) #update entry in list... so next time we don't need to recalc
			if self.use_mediacaching:
				MEDIACACHELIST[serviceref.toString()] = (x[0], x[1], x[2], len, mps[1])


		# Dr.Best: movie status flag
		length = len
	
		if len > 0:
			len = "%d:%02d" % (len / 60, len % 60)
		else:
			len = ""
		
		res = [ None ]
		
		txt = info.getName(serviceref)
		service = ServiceReference(info.getInfoString(serviceref, iServiceInformation.sServiceref))
		description = info.getInfoString(serviceref, iServiceInformation.sDescription)
		tags = info.getInfoString(serviceref, iServiceInformation.sTags)


		color = None 
		# Dr.Best: recording flag
		recording = False
		if NavigationInstance.instance.getRecordings():
			for timer in NavigationInstance.instance.RecordTimer.timer_list:
				if timer.state == TimerEntry.StateRunning:
					try:
						filename = "%s.ts" % timer.Filename
					except:
						filename = ""
					if filename and os.path.realpath(filename) == os.path.realpath(serviceref.getPath()):
						recording = True
						break
		if not recording:
			filename = os.path.realpath(serviceref.getPath())
			if os.path.exists("%s.sc" % filename) and not os.path.exists("%s.ap" % filename):
				# double check, sometimes ap file was not created (e.g. after enigma2 crash)
				filestats = os.stat(filename)
				currentTime = time_time()
				mtime = filestats[stat_ST_MTIME]
				if math_fabs(mtime - int(currentTime)) <= 10:
					recording = True
		if recording and self.show_statuscolor:
			color = self.recording_color

		if self.show_statusicon and self.show_folders and recording:
			png = LoadPixmap(cached=True, path=resolveFilename(SCOPE_CURRENT_SKIN, "extensions/movie_recording.png"))

		# Dr.Best: movie status flag
		if self.show_progressbar or (self.show_statusicon and self.show_folders) or self.show_statuscolor:
			last = mps[1]
			perc = 0
			if last is not None and length > 0:
				perc = int((float(last)  / 90000 / float(length)) * 100);
				if self.show_statuscolor and not recording:
					if (perc > 1) and (perc <= config.merlin2.moviepercentseen.value):
						color = self.watching_color
					elif (perc > config.merlin2.moviepercentseen.value):
						color = self.finished_color
				if self.show_statusicon and self.show_folders and not recording:
					if (perc > 1) and (perc <= config.merlin2.moviepercentseen.value):
						png = LoadPixmap(cached=True, path=resolveFilename(SCOPE_CURRENT_SKIN, "extensions/movie_watching.png"))
					elif (perc > config.merlin2.moviepercentseen.value):
						png = LoadPixmap(cached=True, path=resolveFilename(SCOPE_CURRENT_SKIN, "extensions/movie_finished.png"))
			if self.show_progressbar:
				top = int((self.l.getItemSize().height() -6 ) / 2) + 1
				res.append(MultiContentEntryProgress(pos=(0 + offset,top), size = (50,6), percent = perc, borderWidth = 1,foreColor = color))
				offset = offset + 55


		begin_string = ""
		# Dr.Best: recording flag
		if recording:
			begin_string = _("recording...")
			if self.use_mediacaching and MEDIACACHELIST.has_key(serviceref.toString()):
				del MEDIACACHELIST[serviceref.toString()]
		else:
			if begin > 0:
				t = FuzzyTime(begin)
				begin_string = t[0] + ", " + t[1]

		# Dr.Best selection mode
		if self.SELECTION_MODE:
			value = self.selectionList.get(serviceref.toString(),False)
			if value:
				if self.SELECTION_MODE == 1: # Dr.Best delete mode
					backcolor = self.deletemode_color
					backcolor_sel = self.deletemodeselected_color
				else: # Dr.Best moveTo mode color
					backcolor = self.movetomode_color
					backcolor_sel = self.movetomodeselected_color
				res.append(MultiContentEntryText(pos=(0,0), size=(self.l.getItemSize().width(), self.l.getItemSize().height()), font=1, flags=RT_HALIGN_LEFT, text="", color = None, backcolor = backcolor, backcolor_sel = backcolor_sel))
				color = None

		if self.list_type == MovieList.LISTTYPE_ORIGINAL:
			if self.show_folders:
				# Dr.Best: show media icon
				res.append((eListboxPythonMultiContent.TYPE_PIXMAP_ALPHATEST, 0, 2, 20, 20, png))
			res.append(MultiContentEntryText(pos=(0+offset, 0), size=(width-182, 30), font = 0, flags = RT_HALIGN_LEFT, text=txt, color = color))
			if self.tags:
				res.append(MultiContentEntryText(pos=(width-180, 0), size=(180, 30), font = 2, flags = RT_HALIGN_RIGHT, text = tags, color = color))
				if service is not None:
					res.append(MultiContentEntryText(pos=(200, 50), size=(200, 20), font = 1, flags = RT_HALIGN_LEFT, text = service.getServiceName(), color = color))
			else:
				if service is not None:
					res.append(MultiContentEntryText(pos=(width-180, 0), size=(180, 30), font = 2, flags = RT_HALIGN_RIGHT, text = service.getServiceName(), color = color))
			res.append(MultiContentEntryText(pos=(0+offset, 30), size=(width, 20), font=1, flags=RT_HALIGN_LEFT, text=description, color = color))
			res.append(MultiContentEntryText(pos=(0+offset, 50), size=(200, 20), font=1, flags=RT_HALIGN_LEFT, text=begin_string, color = color))
			res.append(MultiContentEntryText(pos=(width-200, 50), size=(198, 20), font=1, flags=RT_HALIGN_RIGHT, text=len, color = color))
		elif self.list_type == MovieList.LISTTYPE_COMPACT_DESCRIPTION:
			if self.show_folders:
				# Dr.Best: show media icon
				res.append((eListboxPythonMultiContent.TYPE_PIXMAP_ALPHATEST, 0, 2, 20, 20, png))
			res.append(MultiContentEntryText(pos=(0+offset, 0), size=(width-120, 25), font = 0, flags = RT_HALIGN_LEFT, text = txt, color = color))
			res.append(MultiContentEntryText(pos=(0+offset, 20), size=(width-212, 17), font=1, flags=RT_HALIGN_LEFT, text=description, color = color))
			res.append(MultiContentEntryText(pos=(width-120, 6), size=(120, 20), font=1, flags=RT_HALIGN_RIGHT, text=begin_string, color = color))
			if service is not None:
				res.append(MultiContentEntryText(pos=(width-212, 20), size=(154, 17), font = 1, flags = RT_HALIGN_RIGHT, text = service.getServiceName(), color = color))
			res.append(MultiContentEntryText(pos=(width-58, 20), size=(58, 20), font=1, flags=RT_HALIGN_RIGHT, text=len, color = color))
		elif self.list_type == MovieList.LISTTYPE_COMPACT:
			if self.show_folders:
				# Dr.Best: show media icon
				res.append((eListboxPythonMultiContent.TYPE_PIXMAP_ALPHATEST, 0, 2, 20, 20, png))
			res.append(MultiContentEntryText(pos=(0+offset, 0), size=(width-77, 25), font = 0, flags = RT_HALIGN_LEFT, text = txt, color = color))
			if self.tags:
				res.append(MultiContentEntryText(pos=(width-200, 20), size=(200, 17), font = 1, flags = RT_HALIGN_RIGHT, text = tags, color = color))
				if service is not None:
					res.append(MultiContentEntryText(pos=(200, 20), size=(200, 17), font = 1, flags = RT_HALIGN_LEFT, text = service.getServiceName(), color = color))
			else:
				if service is not None:
					res.append(MultiContentEntryText(pos=(width-200, 20), size=(200, 17), font = 1, flags = RT_HALIGN_RIGHT, text = service.getServiceName(), color = color))
			res.append(MultiContentEntryText(pos=(0+offset, 20), size=(200, 17), font=1, flags=RT_HALIGN_LEFT, text=begin_string, color = color))
			res.append(MultiContentEntryText(pos=(width-75, 0), size=(75, 20), font=0, flags=RT_HALIGN_RIGHT, text=len, color = color))
		# Dr.Best: merlin listtype
		elif self.list_type == MovieList.LISTTYPE_MINIMAL_MERLIN:
			if self.show_folders:
				# Dr.Best: show media icon
				res.append((eListboxPythonMultiContent.TYPE_PIXMAP_ALPHATEST, 0, 2, 20, 20, png))
			res.append(MultiContentEntryText(pos=(0+offset, 4), size=(120, 20), font=1, flags=RT_HALIGN_LEFT, text=begin_string, color = color))
			offsetServiceName = 0
			if service is not None:
				servicename = str(service.getServiceName())
				res.append(MultiContentEntryText(pos=(width-160,4), size=(160, 20), font = 1, flags = RT_HALIGN_RIGHT, text = servicename, color = color))
				if servicename:
					offsetServiceName = 150
			displaytext = txt
			if description:
				displaytext = displaytext + " - " + description
			if len:
				displaytext = displaytext + " (" + len + " min)"
			res.append(MultiContentEntryText(pos=(0+offset+130, 2), size=(width -(0+offset+130+offsetServiceName) , 25), font = 0, flags = RT_HALIGN_LEFT, text = displaytext, color = color))
		else:
			assert(self.list_type == MovieList.LISTTYPE_MINIMAL)
			if self.show_folders:
				# Dr.Best: show media icon
				res.append((eListboxPythonMultiContent.TYPE_PIXMAP_ALPHATEST, 0, 2, 20, 20, png))
			if self.descr_state == MovieList.SHOW_DESCRIPTION:
				res.append(MultiContentEntryText(pos=(0+offset, 0), size=(width-146, 25), font = 0, flags = RT_HALIGN_LEFT, text = txt, color = color))
				res.append(MultiContentEntryText(pos=(width-145, 4), size=(145, 20), font=1, flags=RT_HALIGN_RIGHT, text=begin_string, color = color))
			else:
				res.append(MultiContentEntryText(pos=(0+offset, 0), size=(width-77, 25), font = 0, flags = RT_HALIGN_LEFT, text = txt, color = color))
				res.append(MultiContentEntryText(pos=(width-75, 0), size=(75, 20), font=0, flags=RT_HALIGN_RIGHT, text=len, color = color))
		
		return res

	def moveToIndex(self, index):
		self.instance.moveSelectionTo(index)

	def getCurrentIndex(self):
		return self.instance.getCurrentIndex()

	def getCurrentEvent(self):
		l = self.l.getCurrentSelection()
		return l and l[0] and l[1] and l[1].getEvent(l[0])

	def getCurrent(self):
		l = self.l.getCurrentSelection()
		return l and l[0]

	GUI_WIDGET = eListbox

	def postWidgetCreate(self, instance):
		instance.setContent(self.l)
		self.selectionChanged_conn = instance.selectionChanged.connect(self.selectionChanged)

	def preWidgetRemove(self, instance):
		instance.setContent(None)
		self.selectionChanged_conn = None

	def reload(self, root = None, filter_tags = None):
		if root is not None:
			self.load(root, filter_tags)
		else:
			self.load(self.root, filter_tags)
		self.l.setList(self.list)

	def removeService(self, service):
		for l in self.list[:]:
			if l[0] == service:
				self.list.remove(l)
		self.l.setList(self.list)

	def __len__(self):
		return len(self.list)

	def load(self, root, filter_tags):
		global MEDIACACHELIST
		# this lists our root service, then building a 
		# nice list
		
		self.list = [ ]
		self.serviceHandler = eServiceCenter.getInstance()
		
		self.root = root
		list = self.serviceHandler.list(root)
		if list is None:
			print "listing of movies failed"
			list = [ ]	
			return
		tags = set()
		
		# Dr.Best: folder in movielist
		dirs = []

		while 1:
			serviceref = list.getNext()
			if not serviceref.valid():
				break

			if self.show_folders:
				# Dr.Best: folder in movielist
				if serviceref.flags & eServiceReference.mustDescent:
					tempDir = serviceref.getPath()
					parts = tempDir.split("/")
					dirName = parts[-2]
					if not config.merlin2.show_hidden_folders_in_movielist.value and dirName.startswith('.'): # weazle: hide .dotdirs
						continue
					else:
						serviceref.setName(dirName)
						dirs.append((serviceref, None, -1, -1))
						continue
			else:
				if serviceref.flags & eServiceReference.mustDescent:
					continue

			if not self.use_mediacaching or (self.use_mediacaching and not MEDIACACHELIST.has_key(serviceref.toString())):
				info = self.serviceHandler.info(serviceref)
				if info is None:
					continue

				begin = info.getInfo(serviceref, iServiceInformation.sTimeCreate)
			else:

				info = MEDIACACHELIST[serviceref.toString()][1]
				begin = MEDIACACHELIST[serviceref.toString()][2]
		
			# convert space-seperated list of tags into a set
			this_tags = info.getInfoString(serviceref, iServiceInformation.sTags).split(' ')
			if this_tags == ['']:
				this_tags = []
			this_tags = set(this_tags)
			tags |= this_tags
		
			# filter_tags is either None (which means no filter at all), or 
			# a set. In this case, all elements of filter_tags must be present,
			# otherwise the entry will be dropped.			
			if filter_tags is not None and not this_tags.issuperset(filter_tags):
				continue
		
			if not self.use_mediacaching or (self.use_mediacaching and not MEDIACACHELIST.has_key(serviceref.toString())):
				self.list.append((serviceref, info, begin, -1))
			else:
				self.list.append(MEDIACACHELIST[serviceref.toString()])
				
		
		if self.sort_type == MovieList.SORT_ALPHANUMERIC:
			self.list.sort(key=self.buildAlphaNumericSortKey)
		else:
			if self.sort_type ==  MovieList.SORT_DATE_ASC:
				self.list.sort(self.sortbyDateAsc)
			else:
				self.list.sort(self.sortbyDateDesc)
#			# sort: key is 'begin'
#			self.list.sort(key=lambda x: -x[2])

		# Dr.Best: folder in movielist
		if self.show_folders:
			dirs.sort(self.sortFolders)
			for servicedirs in dirs:
				self.list.insert(0,servicedirs)
			tmp = self.root.getPath()
			if len(tmp) > 1:
				tt = eServiceReference(eServiceReference.idFile, eServiceReference.flagDirectory, ".." )
				tt.setName("..")
				tmpRoot = os.path.dirname(tmp[:-1])
				if len(tmpRoot) > 1:
					tmpRoot = tmpRoot + "/"
				tt.setPath(tmpRoot)
				self.list.insert(0,(tt,None,-1,-1))
	
		# finally, store a list of all tags which were found. these can be presented
		# to the user to filter the list
		self.tags = tags

	# Dr.Best: sort by Date asc and desc
	def sortbyDateAsc(self, a, b):
		return cmp(a[2],b[2])

	def sortbyDateDesc(self, a, b):
		return cmp(b[2],a[2])

	# Dr.Best: sort folders
	def sortFolders(self, a, b):
		return cmp(b[0].getName().lower(), a[0].getName().lower())

	def buildAlphaNumericSortKey(self, x):
		ref = x[0]
		info = self.serviceHandler.info(ref)
		name = info and info.getName(ref)
		return (name and name.lower() or "", -x[2])

	def moveTo(self, serviceref):
		count = 0
		for x in self.list:
			if x[0] == serviceref:
				self.instance.moveSelectionTo(count)
				return True
			count += 1
		return False
	
	def moveDown(self):
		self.instance.moveSelection(self.instance.moveDown)

	# Dr.Best set Movie Status
	def setMovieStatus(self, serviceref, status):
		global MEDIACACHELIST
		info = self.serviceHandler.info(serviceref)
		if info is None:
			return
		cur_idx = self.l.getCurrentSelectionIndex()
		filename = os.path.realpath(serviceref.getPath())
		if os.path.exists("%s.cuts" % (filename)):
			cutList = []
			cuts_format = ">QI" # big endian, unsigned long long, unsigned int
			cuts_format_size = struct_calcsize(cuts_format)
			cuts_file = open("%s.cuts" % (filename), 'rb')
			if cuts_file:
				while True:
					cuts_data = cuts_file.read(cuts_format_size)
					if len(cuts_data) <> cuts_format_size: # the string must contain exactly the amount of data required by the format
						break
					cuts_unpacked_data = struct_unpack(cuts_format, cuts_data)
					if cuts_unpacked_data[1] != 3: # CUT_TYPE_LAST = 3 --> InfoBarCueSheetSupport
						 cutList.append(cuts_data)
				cuts_file.close()
				x = self.list[cur_idx]
				last_pos = 0
				if status:
					length = x[1].getLength(x[0]) * 90000
					if length < 0:
						cutsfilename = "%s.cuts" % filename
						mps = self.getLastPosition(cutsfilename)
						length = mps[0]
					if length and length >=0:
						last_pos = length
						packed_data = struct_pack(cuts_format,long(length ),3)
						cutList.append(packed_data)
				self.list[cur_idx] = (x[0],x[1],x[2],x[3],last_pos)
				if self.use_mediacaching:
					MEDIACACHELIST[serviceref.toString()] = (x[0],x[1],x[2],x[3],last_pos) 
				try:
					f = open("%s.cuts" % (filename), 'wb')
					f.write(''.join(cutList))
					f.close()
				except: pass

	# Dr.Best selection mode
	def switchSelectionMode(self, status):
		self.SELECTION_MODE = status	
		self.selectionList = {}

	# Dr.Best selection mode
	def getSelectionMode(self):
		return self.SELECTION_MODE

	# Dr.Best selection mode
	def getSelectionList(self):
		return self.selectionList

	# Dr.Best selection mode
	def setDeleteValue(self, servicereference):
		value = self.selectionList.get(servicereference.toString(),False)
		self.selectionList[servicereference.toString()] = not value
		if value:
			del self.selectionList[servicereference.toString()]
		index = self.getCurrentIndex()
		self.l.invalidateEntry(index)

