#
# SkinSettings - this is a part of Merlin3-Image
#
# Coded by dre (c) 2013
# Support: www.dreambox-tools.info
# E-Mail: dre@dreambox-tools.info
#
# This plugin is open source but it is NOT free software.
#
# This plugin may only be distributed to and executed on hardware which
# is licensed by Dream Multimedia GmbH.
# In other words:
# It's NOT allowed to distribute any parts of this plugin or its source code in ANY way
# to hardware which is NOT licensed by Dream Multimedia GmbH.
# It's NOT allowed to execute this plugin and its source code or even parts of it in ANY way
# on hardware which is NOT licensed by Dream Multimedia GmbH.
#
# If you want to use or modify the code or parts of it,
# you have to keep MY license and inform me about the modifications by mail.
#

from Components.Button import Button
from Components.ActionMap import HelpableActionMap, ActionMap
from Components.ConfigList import ConfigListScreen
from Components.config import config, getConfigListEntry
from Components.Sources.StaticText import StaticText
from Screen import Screen
from Screens.HelpMenu import HelpableScreen
from Screens.MessageBox import MessageBox
from Screens.Standby import TryQuitMainloop
from Tools.Directories import fileExists

import xml.etree.cElementTree

CONVERTERDIR = "/usr/lib/enigma2/python/Components/Converter/"
RENDERERDIR  = "/usr/lib/enigma2/python/Components/Renderer/"

class SkinSettingsSetup(Screen, HelpableScreen, ConfigListScreen):
	skin = """
		<screen name="SkinSettingsSetup" position="center,center" size="600,400" title="Skin Settings" >
			<ePixmap pixmap="skin_default/buttons/red.png" position="0,0" zPosition="0" size="140,40" transparent="1" alphatest="on" />
			<ePixmap pixmap="skin_default/buttons/green.png" position="140,0" zPosition="0" size="140,40" transparent="1" alphatest="on" />
			<ePixmap pixmap="skin_default/buttons/yellow.png" position="280,0" zPosition="0" size="140,40" transparent="1" alphatest="on" />
			<ePixmap pixmap="skin_default/buttons/blue.png" position="420,0" zPosition="0" size="140,40" transparent="1" alphatest="on" />
			<widget render="Label" source="key_red" position="0,0" size="140,40" zPosition="5" valign="center" halign="center" backgroundColor="red" font="Regular;21" transparent="1" foregroundColor="white" shadowColor="black" shadowOffset="-1,-1" />
			<widget render="Label" source="key_green" position="140,0" size="140,40" zPosition="5" valign="center" halign="center" backgroundColor="red" font="Regular;21" transparent="1" foregroundColor="white" shadowColor="black" shadowOffset="-1,-1" />
			<widget render="Label" source="key_yellow" position="280,0" size="140,40" zPosition="5" valign="center" halign="center" backgroundColor="yellow" font="Regular;21" transparent="1" foregroundColor="white" shadowColor="black" shadowOffset="-1,-1" />
			<widget name="config" position="20,50" size="560,330" scrollbarMode="showOnDemand" />
		</screen>"""

	def __init__(self, session):
		Screen.__init__(self, session)
		HelpableScreen.__init__(self)
		self.setTitle(_("Skin Settings"))

		self["SetupActions"] = HelpableActionMap(self, "SetupActions",
		{
			"cancel":	(self.close, _("Discard changes and close")),
		}, -2)
		
		self["ColorActions"] = HelpableActionMap(self, "ColorActions",
		{
			"green":	(self.keySave, _("Save settings")),
			"red":		(self.keyCancel, _("Discard changes and close")),
		}, -2)
		
		self["key_blue"] = StaticText("")
		self["key_yellow"] = StaticText("")
		self["key_red"] = StaticText(_("Cancel"))
		self["key_green"] = StaticText(_("OK"))
		
		self.updateSkinXml = False
		
		self.list = []
		ConfigListScreen.__init__(self, self.list, session = session)
		
		self.createConfig()
		#notifier is only needed when settings are in the list that don't need a re-writing of the skin.xml
		#config.merlin2.skin_showsnrindb.addNotifier(self.setUpdateVariable, False)

	def createConfig(self):
		self.list = []

		self.list.append(getConfigListEntry(_("Show SNR"), config.merlin2.skin_showsnrindb))
		if fileExists(RENDERERDIR + "Picon.pyo"):
			self.list.append(getConfigListEntry(_("Show picon"), config.merlin2.skin_showpicon))
		if fileExists(RENDERERDIR + "ChannelNumber.pyo"):
			self.list.append(getConfigListEntry(_("Show channel number"), config.merlin2.skin_showchannelnumber))
		if fileExists(RENDERERDIR + "ChannelSelectionTitle.pyo"):
			self.list.append(getConfigListEntry(_("Channellist header style"), config.merlin2.skin_channellistheader))
		self.list.append(getConfigListEntry(_("Show menu icon"), config.merlin2.skin_showmenuicon))
		self.list.append(getConfigListEntry(_("Name / Orbital display"), config.merlin2.skin_shownameorbital))
			
		self["config"].list = self.list
		self["config"].l.setList(self.list)

	def setUpdateVariable(self, ConfigElement=""):
		if self.updateSkinXml == False:
			self.updateSkinXml = True
		else:
			self.updateSkinXml = False

	def keySave(self):
		for x in self["config"].list:
			x[1].save()
		
		if self.updateSkinXml:	
			self.updateSkin()

		info = self.session.openWithCallback(self.restartGUI,MessageBox,_("Please restart enigma2 for changes to take effect. Restart now?"), MessageBox.TYPE_YESNO)
		info.setTitle(_("Skin Settings"))
		
	def updateSkin(self):
		config.merlin2.skin_showsnrindb.save()
	
		skin = "/usr/share/enigma2/" + config.skin.primary_skin.value
		skinxml = file(skin,'r')
		skindom = xml.etree.cElementTree.parse(skinxml)
		skinxml.close()
		
		xmldata = skindom.getroot()
		for x in xmldata.findall("screen"):
			if x.get("name") == "InfoBar":
				print "InfoBar"
				for w in x.findall("widget"):
					if w.get("render") == "Label":
						for c in w.findall("convert"):
							if c.get("type") == "FrontendInfo" and c.text == "SNRdB" and config.merlin2.skin_showsnrindb.value == "False":
								c.text = "SNR"
							elif c.get("type") == "FrontendInfo" and c.text == "SNR" and config.merlin2.skin_showsnrindb.value == "True":
								c.text = "SNRdB"

		skindom.write("/usr/share/enigma2/" + config.skin.primary_skin.value)
		
	def restartGUI(self, answer):
		if answer:
			self.session.open(TryQuitMainloop, 3)
