#
#  MerlinSetup
#
#  Coded by Dr.Best (c) 2010
#  Support: www.dreambox-tools.info
#
#  This plugin is licensed under the Creative Commons 
#  Attribution-NonCommercial-ShareAlike 3.0 Unported 
#  License. To view a copy of this license, visit
#  http://creativecommons.org/licenses/by-nc-sa/3.0/ or send a letter to Creative
#  Commons, 559 Nathan Abbott Way, Stanford, California 94305, USA.
#
#  Alternatively, this plugin may be distributed and executed on hardware which
#  is licensed by Dream Multimedia GmbH.

#  This plugin is NOT free software. It is open source, you are allowed to
#  modify it (if you keep the license), but it may not be commercially 
#  distributed other than under the conditions noted above.
#

from enigma import eEnv
import xml.etree.cElementTree
from Setup import Setup

try:
	setupfile_merlin = file('data/merlin_setup.xml', 'r')
except:
	setupfile_merlin = file(eEnv.resolve('${datadir}/enigma2/merlin_setup.xml'), 'r')
setupdom_merlin = xml.etree.cElementTree.parse(setupfile_merlin)
setupfile_merlin.close()


class MerlinSetup(Setup):

	def refill(self, list):
		xmldata = setupdom_merlin.getroot()
		for x in xmldata.findall("setup"):
			if x.get("key") != self.setup:
				continue
			self.addItems(list, x);
			self.setup_title = x.get("title", "").encode("UTF-8")

def getSetupTitle(id):
	xmldata = setupdom_merlin.getroot()
	for x in xmldata.findall("setup"):
		if x.get("key") == id:
			return x.get("title", "").encode("UTF-8")
	raise SetupError("unknown setup id '%s'!" % repr(id))
