from Tools.Profile import profile

# workaround for required config entry dependencies.
from Screens.MovieSelection import MovieSelection

from Screen import Screen

profile("LOAD:enigma")
from enigma import iPlayableService

profile("LOAD:InfoBarGenerics")
from Screens.InfoBarGenerics import InfoBarShowHide, \
	InfoBarNumberZap, InfoBarChannelSelection, InfoBarMenu, InfoBarRdsDecoder, \
	InfoBarEPG, InfoBarSeek, InfoBarInstantRecord, \
	InfoBarAudioSelection, InfoBarAdditionalInfo, InfoBarDish, InfoBarUnhandledKey, \
	InfoBarSubserviceSelection, InfoBarShowMovies, InfoBarTimeshift,  \
	InfoBarServiceNotifications, InfoBarPVRState, InfoBarCueSheetSupport, InfoBarSimpleEventView, \
	InfoBarSummarySupport, InfoBarMoviePlayerSummarySupport, InfoBarTimeshiftState, InfoBarTeletextPlugin, InfobarHbbtvPlugin, InfoBarExtensions, InfoBarNotifications, \
	InfoBarSubtitleSupport, InfoBarPiP, InfoBarPlugins, InfoBarServiceErrorPopupSupport, InfoBarJobman, InfoBarAutoSleepTimer

profile("LOAD:InitBar_Components")
from Components.ActionMap import HelpableActionMap
from Components.config import config, ConfigBoolean
from Components.ServiceEventTracker import ServiceEventTracker, InfoBarBase
from Components.PluginComponent import plugins
from Plugins.Plugin import PluginDescriptor

profile("LOAD:HelpableScreen")
from Screens.HelpMenu import HelpableScreen

config.misc.initialharddisknotification = ConfigBoolean(True)
config.misc.missingdefaultstoragenotification = ConfigBoolean(False)

from Tools import Notifications
Notifications.notificationQueue.registerDomain("InfoBar", _("InfoBar"), Notifications.ICON_DEFAULT)

# Dr. Best Infobar position
from enigma import ePoint

#Dr. Best Select last played movie 
from enigma import eServiceReference

from struct import calcsize as struct_calcsize, unpack as struct_unpack, pack as struct_pack
from os import path as os_path

from enigma import eConsoleAppContainer

from Components.MovieList import MEDIACACHELIST
import NavigationInstance # Dr.Best stop potential currently recording before deleting a recording
from timer import TimerEntry # Dr.Best stop potential currently recording before deleting a recording


class InfoBar(InfoBarBase, InfoBarShowHide,
	InfoBarNumberZap, InfoBarChannelSelection, InfoBarMenu, InfoBarEPG, InfoBarRdsDecoder,
	InfoBarInstantRecord, InfoBarAudioSelection,
	HelpableScreen, InfoBarAdditionalInfo, InfoBarDish, InfoBarUnhandledKey,
	InfoBarSubserviceSelection, InfoBarTimeshift, InfoBarSeek,
	InfoBarSummarySupport, InfoBarTimeshiftState, InfoBarTeletextPlugin, InfobarHbbtvPlugin, InfoBarExtensions, InfoBarNotifications,
	InfoBarPiP, InfoBarPlugins, InfoBarSubtitleSupport, InfoBarServiceErrorPopupSupport, InfoBarJobman, InfoBarAutoSleepTimer,
	Screen):

	ALLOW_SUSPEND = True
	instance = None

	def __init__(self, session):
		Screen.__init__(self, session)
		self["actions"] = HelpableActionMap(self, "InfobarActions",
			{
				"showMovies": (self.showMovies, _("Play recorded movies...")),
				"showRadio": (self.showRadio, _("Show the radio player...")),
				"showTv": (self.showTv, _("Show the tv player...")),
			}, prio=2)

		self.allowPiP = True

		for x in HelpableScreen, \
				InfoBarBase, InfoBarShowHide, \
				InfoBarNumberZap, InfoBarChannelSelection, InfoBarMenu, InfoBarEPG, InfoBarRdsDecoder, \
				InfoBarInstantRecord, InfoBarAudioSelection, InfoBarUnhandledKey, \
				InfoBarAdditionalInfo, InfoBarDish, InfoBarSubserviceSelection, \
				InfoBarTimeshift, InfoBarSeek, InfoBarSummarySupport, InfoBarTimeshiftState, \
				InfoBarTeletextPlugin, InfobarHbbtvPlugin, InfoBarExtensions, InfoBarNotifications, InfoBarPiP, InfoBarSubtitleSupport, InfoBarJobman, \
				InfoBarPlugins, InfoBarServiceErrorPopupSupport, InfoBarAutoSleepTimer \
				:
			x.__init__(self)

		self.helpList.append((self["actions"], "InfobarActions", [("showMovies", _("view recordings..."))]))
		self.helpList.append((self["actions"], "InfobarActions", [("showRadio", _("hear radio..."))]))

		self.__event_tracker = ServiceEventTracker(screen=self, eventmap=
			{
				iPlayableService.evUpdatedEventInfo: self.__eventInfoChanged
			})

		self.current_begin_time=0
		assert InfoBar.instance is None, "class InfoBar is a singleton class and just one instance of this class is allowed!"
		InfoBar.instance = self
		for fnc in plugins.getPlugins(PluginDescriptor.WHERE_INFOBAR):
			fnc(session)

		self.showHarddiskPopup()

		self.onClose.append(self.__onClose)

		# Dr. Best Infobar position
		self.firstime = True # that is not nice :-(
		self.onExecBegin.append(self.__onExecBegin)

	def showHarddiskPopup(self, dev = None, media_state = None):
		from Components.Harddisk import harddiskmanager
		if not self.HDDDetectedCB in harddiskmanager.delayed_device_Notifier:
			harddiskmanager.delayed_device_Notifier.append(self.HDDDetectedCB)
		if config.misc.initialharddisknotification.value:
			from Screens.MessageBox import MessageBox
			if harddiskmanager.HDDCount() and not harddiskmanager.HDDEnabledCount():
				Notifications.AddNotificationWithCallback(self.HDDDetectedAnswer, MessageBox, _("Unconfigured storage devices found!")  + "\n" \
					+ _("Please make sure to set up your storage devices with the storage management in menu -> setup -> system -> storage devices.") + "\n\n" \
					+ _("Set up your storage device now?"), type = MessageBox.TYPE_YESNO, timeout = 15, default = False, domain = "InfoBar")
				config.misc.initialharddisknotification.value = False
				config.misc.initialharddisknotification.save()
		elif config.misc.missingdefaultstoragenotification.value and not config.misc.initialharddisknotification.value:
			from Screens.ChoiceBox import ChoiceBox
			from Components.UsageConfig import defaultStorageDevice
			choices = [
				(_("OK, do nothing"), "ok"),
				(_("OK, and don't ask again"), "ok_always")
			]
			if harddiskmanager.HDDCount():
				choices.append((_("OK, and set up a new default storage device"), "ok_setup"))
			titletxt = _("Default storage device is not available!") + "\n"
			if dev is None and defaultStorageDevice() != "<undefined>" and harddiskmanager.isDefaultStorageDeviceActivebyUUID(defaultStorageDevice()) is False:
				Notifications.AddNotificationWithCallback(self.missingDefaultHDDAnswer, ChoiceBox, title = titletxt \
					+ _("Please verify if your default storage device is attached or set up your default storage device in menu -> setup -> system -> storage devices.") + "\n", list = choices, domain = "InfoBar")
			elif dev is not None and defaultStorageDevice() != "<undefined>" and harddiskmanager.isDefaultStorageDeviceActivebyUUID(defaultStorageDevice()) is False:
				part = harddiskmanager.getPartitionbyDevice(dev)
				if part is not None and part.uuid is not None and media_state is not None and media_state == "remove_default":
					titletxt = _("Default storage device was removed!") + "\n"
					Notifications.AddNotificationWithCallback(self.missingDefaultHDDAnswer, ChoiceBox, title = titletxt \
						+ _("Please verify if your default storage device is attached or set up your default storage device in menu -> setup -> system -> storage devices.") + "\n", list = choices, domain = "InfoBar")

	def missingDefaultHDDAnswer(self, answer):
		answer = answer and answer[1]
		if answer is not None:
			if answer == "ok_always":
				print answer
				config.misc.missingdefaultstoragenotification.value = False
				config.misc.missingdefaultstoragenotification.save()
			elif answer == "ok_setup":
				print answer
				from Screens.HarddiskSetup import HarddiskDriveSelection
				self.session.open(HarddiskDriveSelection)

	def HDDDetectedAnswer(self, answer):
		if answer is not None:
			if answer:
				from Screens.HarddiskSetup import HarddiskDriveSelection
				self.session.open(HarddiskDriveSelection)

	def HDDDetectedCB(self, dev, media_state):
		if InfoBar.instance:
			if InfoBar.instance.execing:
				self.showHarddiskPopup(dev, media_state)
			else:
				print "HDDDetectedCB: main infobar is not execing... so we ignore hotplug event!"
		else:
				print "HDDDetectedCB: hotplug event.. but no infobar"

	# Dr. Best Infobar position
	def __onExecBegin(self):
		if self.firstime:
			orgpos = self.instance.position()	
			self.instance.move(ePoint(orgpos.x() + config.merlin2.infobar_position_offset_x.value, orgpos.y() + config.merlin2.infobar_position_offset_y.value))
			self.firstime = False

	def __onClose(self):
		InfoBar.instance = None

	def __eventInfoChanged(self):
		if self.execing:
			service = self.session.nav.getCurrentService()
			old_begin_time = self.current_begin_time
			info = service and service.info()
			ptr = info and info.getEvent(0)
			self.current_begin_time = ptr and ptr.getBeginTime() or 0
			if config.usage.show_infobar_on_event_change.value:
				if old_begin_time and old_begin_time != self.current_begin_time:
					self.doShow()

	def serviceStarted(self):  #override from InfoBarShowHide
		new = self.servicelist.newServicePlayed()
		if self.execing:
			InfoBarShowHide.serviceStarted(self)
			self.current_begin_time=0
		elif not self.__checkServiceStarted in self.onShown and new:
			self.onShown.append(self.__checkServiceStarted)

	def __checkServiceStarted(self):
		self.serviceStarted()
		self.onShown.remove(self.__checkServiceStarted)

	def showTv(self):
		self.showTvChannelList(True)

	def showRadio(self):
		if config.usage.e1like_radio_mode.value:
			self.showRadioChannelList(True)
		else:
			self.rds_display.hide() # in InfoBarRdsDecoder
			from Screens.ChannelSelection import ChannelSelectionRadio
			self.session.openWithCallback(self.ChannelSelectionRadioClosed, ChannelSelectionRadio, self)

	def ChannelSelectionRadioClosed(self, *arg):
		self.rds_display.show()  # in InfoBarRdsDecoder

	def showMovies(self):
		from Screens.MovieSelection import MovieSelection
		#Dr. Best Select last played movie 
		if config.merlin2.movieplayer_select_last_seen_movie.value and config.merlin2.movieplayer_last_service.value != "":
			ref = eServiceReference(config.merlin2.movieplayer_last_service.value)
		else:
			ref = None
		self.session.openWithCallback(self.movieSelected, MovieSelection, ref)

	def movieSelected(self, service):
		if service is not None:
			self.session.open(MoviePlayer, service)

class MoviePlayer(InfoBarBase, InfoBarShowHide, \
		InfoBarMenu, \
		InfoBarSeek, InfoBarShowMovies, InfoBarAudioSelection, HelpableScreen,
		InfoBarServiceNotifications, InfoBarPVRState, InfoBarCueSheetSupport, InfoBarSimpleEventView,
		InfoBarMoviePlayerSummarySupport, InfoBarSubtitleSupport, Screen, InfoBarTeletextPlugin,
		InfoBarServiceErrorPopupSupport, InfoBarExtensions, InfoBarNotifications, InfoBarPlugins, InfoBarPiP):

	ENABLE_RESUME_SUPPORT = True
	ALLOW_SUSPEND = True

	def __init__(self, session, service):
		from enigma import eServiceMP3
		Screen.__init__(self, session)

		self["actions"] = HelpableActionMap(self, "MoviePlayerActions",
			{
				"leavePlayer": (self.leavePlayer, _("leave movie player..."))
			})

		self.allowPiP = False
		self.TestAudio = False # for weazle

		for x in HelpableScreen, InfoBarShowHide, InfoBarMenu, \
				InfoBarBase, InfoBarSeek, InfoBarShowMovies, \
				InfoBarAudioSelection, InfoBarSimpleEventView, \
				InfoBarServiceNotifications, InfoBarPVRState, InfoBarCueSheetSupport, \
				InfoBarMoviePlayerSummarySupport, InfoBarSubtitleSupport, \
				InfoBarTeletextPlugin, InfoBarServiceErrorPopupSupport, InfoBarExtensions, InfoBarNotifications, \
				InfoBarPlugins, InfoBarPiP:
			x.__init__(self)

		self.lastservice = session.nav.getCurrentlyPlayingServiceReference()
		session.nav.playService(service)
		self.returning = False
		self.onClose.append(self.onCloseRemoveNotifier)
		self.onClose.append(self.__onClose)

		if config.merlin2.movie_list_force_audio_track_null_hidden_feature.value:
			self.__event_tracker = ServiceEventTracker(screen=self, eventmap=
			{
				eServiceMP3.evAudioDecodeError: self.__evAudioDecodeError,
				eServiceMP3.evVideoDecodeError: self.__evVideoDecodeError,
				eServiceMP3.evPluginError: self.__evPluginError,
				eServiceMP3.evStreamingSrcError: self.__evStreamingSrcError,
				iPlayableService.evUpdatedEventInfo: self.__weazle__UpdatedEventInfo # for weazle
			})
		else:
			self.__event_tracker = ServiceEventTracker(screen=self, eventmap=
			{
				eServiceMP3.evAudioDecodeError: self.__evAudioDecodeError,
				eServiceMP3.evVideoDecodeError: self.__evVideoDecodeError,
				eServiceMP3.evPluginError: self.__evPluginError,
				eServiceMP3.evStreamingSrcError: self.__evStreamingSrcError
			})

		# Dr. Best Infobar position
		self.firstime = True # that is not nice :-(
		self.onExecBegin.append(self.__onExecBegin)

		if config.merlin2.movieplayer_close_on_standby.value:
			config.misc.standbyCounter.addNotifier(self.standbyCounterChanged, initial_call = False)

	def __evAudioDecodeError(self):
		from Screens.MessageBox import MessageBox
		from enigma import iServiceInformation
		currPlay = self.session.nav.getCurrentService()
		sTagAudioCodec = currPlay.info().getInfoString(iServiceInformation.sTagAudioCodec)
		print "[__evAudioDecodeError] audio-codec %s can't be decoded by hardware" % (sTagAudioCodec)
		self.session.open(MessageBox, _("This Dreambox can't decode %s streams!") % sTagAudioCodec, type = MessageBox.TYPE_INFO,timeout = 20 )

	def __evVideoDecodeError(self):
		from Screens.MessageBox import MessageBox
		from enigma import iServiceInformation
		currPlay = self.session.nav.getCurrentService()
		sTagVideoCodec = currPlay.info().getInfoString(iServiceInformation.sTagVideoCodec)
		print "[__evVideoDecodeError] video-codec %s can't be decoded by hardware" % (sTagVideoCodec)
		self.session.open(MessageBox, _("This Dreambox can't decode %s streams!") % sTagVideoCodec, type = MessageBox.TYPE_INFO,timeout = 20 )

	def __evPluginError(self):
		from Screens.MessageBox import MessageBox
		from enigma import iServiceInformation
		currPlay = self.session.nav.getCurrentService()
		message = currPlay.info().getInfoString(iServiceInformation.sUser+12)
		print "[__evPluginError]" , message
		self.session.open(MessageBox, message, type = MessageBox.TYPE_INFO,timeout = 20 )

	def __evStreamingSrcError(self):
		from Screens.MessageBox import MessageBox
		from enigma import iServiceInformation
		currPlay = self.session.nav.getCurrentService()
		message = currPlay.info().getInfoString(iServiceInformation.sUser+12)
		print "[__evStreamingSrcError]", message
		self.session.open(MessageBox, _("Streaming error: %s") % message, type = MessageBox.TYPE_INFO,timeout = 20 )

	def standbyCounterChanged(self, configElement):
		from Screens.Standby import inStandby
		if inStandby.prev_running_service:
			config.merlin2.movieplayer_last_service.value = inStandby.prev_running_service.toString() 
		else:
			config.merlin2.movieplayer_last_service.value = ""
		config.merlin2.movieplayer_last_service.save()
		inStandby.prev_running_service = self.lastservice
		inStandby.onClose.append(self.leaveStandby)

	def leaveStandby(self):
		self.close()

	# Dr. Best Infobar position
	def __onExecBegin(self):
		if self.firstime:
			orgpos = self.instance.position()	
			self.instance.move(ePoint(orgpos.x() + config.merlin2.movieplayer_infobar_position_offset_x.value, orgpos.y() + config.merlin2.movieplayer_infobar_position_offset_y.value))
			self.firstime = False

	def onCloseRemoveNotifier(self):
		if config.merlin2.movieplayer_close_on_standby.value and self.standbyCounterChanged in config.misc.standbyCounter.getNotifiers():
			config.misc.standbyCounter.removeNotifier(self.standbyCounterChanged)

	def __onClose(self):
		self.session.nav.playService(self.lastservice)

	def handleLeave(self, how):
		self.is_closing = True
		if how == "ask":
			if config.usage.setup_level.index < 2: # -expert
				list = (
					(_("Yes"), "quit"),
					(_("No"), "continue")
				)
			else:
				list = (
					(_("Yes"), "quit"),
					(_("Yes, returning to movie list"), "movielist"),
					(_("Yes, and delete this movie"), "quitanddelete"),
					(_("Yes, and after deleting return to movie list"), "returnanddelete"),
					(_("No"), "continue"),
					(_("No, but restart from begin"), "restart")
				)

			from Screens.ChoiceBox import ChoiceBox
			self.session.openWithCallback(self.leavePlayerConfirmed, ChoiceBox, title=_("Stop playing this movie?"), list = list)
		else:
			self.leavePlayerConfirmed([True, how])

	def leavePlayer(self):
		self.handleLeave(config.usage.on_movie_stop.value)

	def deleteConfirmed(self, answer):
		if answer:
			self.leavePlayerConfirmed((True, "quitanddeleteconfirmed"))
			
	def returnanddeleteConfirmed(self, answer):
		if answer:
			self.leavePlayerConfirmed((True, "returnanddeleteconfirmed"))

	def leavePlayerConfirmed(self, answer):
		answer = answer and answer[1]
		#Dr. Best Select last played movie
		if self.session.nav.getCurrentlyPlayingServiceReference():
			config.merlin2.movieplayer_last_service.value = self.session.nav.getCurrentlyPlayingServiceReference().toString() 
		else:
			config.merlin2.movieplayer_last_service.value = ""
		if answer in ("quitanddelete", "quitanddeleteconfirmed", "returnanddelete", "returnanddeleteconfirmed"):
			ref = self.session.nav.getCurrentlyPlayingServiceReference()
			from enigma import eServiceCenter
			serviceHandler = eServiceCenter.getInstance()
			info = serviceHandler.info(ref)
			name = info and info.getName(ref) or _("this recording")

			if answer == "quitanddelete":
				from Screens.MessageBox import MessageBox
				self.session.openWithCallback(self.deleteConfirmed, MessageBox, _("Do you really want to delete %s?") % name)
				return
			elif answer == "returnanddelete":
				from Screens.MessageBox import MessageBox
				self.session.openWithCallback(self.returnanddeleteConfirmed, MessageBox, _("Do you really want to delete %s?") % name)
				return
			
			elif answer in("quitanddeleteconfirmed", "returnanddeleteconfirmed"):
				offline = serviceHandler.offlineOperations(ref)
				self.stopRecording(ref.getPath()) # Dr.Best: check for current recording and stop it without questioning
				if offline.deleteFromDisk(0):
					from Screens.MessageBox import MessageBox
					self.session.openWithCallback(self.close, MessageBox, _("You cannot delete this!"), MessageBox.TYPE_ERROR)
					return
				else: #Dr. Best Select last played movie 
					config.merlin2.movieplayer_last_service.value = ""
					filename = os_path.realpath(ref.getPath())
					extension = filename.split('.')[-1].lower()
					if extension in ("avi","divx","mpg","mpeg","mkv","mp4","mov"):
						container = eConsoleAppContainer()
						container.execute("rm '%s.cuts'" % filename)

		#Dr. Best Select last played movie 
		config.merlin2.movieplayer_last_service.save()

		self.updateMovieData()

		if answer in ("quit", "quitanddeleteconfirmed"):
			self.close()
		elif answer in ("movielist", "returnanddeleteconfirmed"):
			ref = self.session.nav.getCurrentlyPlayingServiceReference()
			self.returning = True
			from Screens.MovieSelection import MovieSelection
			self.session.openWithCallback(self.movieSelected, MovieSelection, ref)
			self.session.nav.stopService()
		elif answer == "restart":
			self.doSeek(0)
			self.setSeekState(self.SEEK_STATE_PLAY)

	def doEofInternal(self, playing):
		self.updateMovieData()
		if not self.execing:
			return
		if not playing :
			return
		self.handleLeave(config.usage.on_movie_eof.value)

	def showMovies(self):
		self.updateMovieData()
		ref = self.session.nav.getCurrentlyPlayingServiceReference()
		from Screens.MovieSelection import MovieSelection
		self.session.openWithCallback(self.movieSelected, MovieSelection, ref)

	def movieSelected(self, service):
		self.updateMovieData()
		if service is not None:
			self.is_closing = False
			self.TestAudio = False # for weazle
			self.session.nav.playService(service)
			self.returning = False
		elif self.returning:
			self.close()

	def updateMovieData(self):
		ref = self.session.nav.getCurrentlyPlayingServiceReference()
		if ref is not None and ref.type != 1: 
			extension = ref.getPath().split('.')[-1].lower()
			if extension in ("avi","divx","mpg","mpeg","mkv","mp4","mov"):
				seek = self.getSeek()
				if seek:
					pos = seek.getPlayPosition()
					length = seek.getLength()
					cutList = []
					cuts_format = ">QI" # big endian, unsigned long long, unsigned int
					cuts_format_size = struct_calcsize(cuts_format)
					packed_data = struct_pack(cuts_format,long(length[1]),1)
					cutList.append(packed_data)
					packed_data = struct_pack(cuts_format,long(pos[1]),3)
					cutList.append(packed_data)
					try:
						filename = os_path.realpath(ref.getPath())
						f = open("%s.cuts" % (filename), 'wb')
						f.write(''.join(cutList))
						f.close()
					except: pass
		if config.merlin2.use_mediacache.value:
			try:
				del MEDIACACHELIST[ref.toString()]
			except: pass

	# Dr.Best: check for current recording and stop it without questioning
	def stopRecording(self, servicepath):
		t = None
		if NavigationInstance.instance.getRecordings():
			for timer in NavigationInstance.instance.RecordTimer.timer_list:
				if timer.state == TimerEntry.StateRunning:
					try:
						filename = "%s.ts" % timer.Filename
					except:
						filename = ""
					if filename and os_path.realpath(filename) == os_path.realpath(servicepath):
						t = timer
						break
		if t is not None:
			self.session.nav.RecordTimer.removeEntry(t)


	# for weazle
	# Use 'config.merlin2.movie_list_force_audio_track_null_hidden_feature=true' in settings file to enable
	# Thanks to Dr.Best for the code
	def __weazle__UpdatedEventInfo(self):
		if not self.TestAudio:
			ref = self.session.nav.getCurrentlyPlayingServiceReference()
			if ref is None: return
			if ref.type == eServiceReference.idDVB:
				self.TestAudio = True
			else:
				service = self.session.nav.getCurrentService()
				if service is not None:
					audio = service and service.audioTracks()
					if audio is not None:
						n = audio and audio.getNumberOfTracks() or 0
						if n > 0:
							self.TestAudio = True
							audio.selectTrack(0)
