# -*- coding: utf-8 -*-
#===============================================================================
# NetworkServer System Plugin 0.1 OE 2.2 by DarkVolli 2009-2014
#
# This is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free
# Software Foundation; either version 2, or (at your option) any later
# version.
#===============================================================================

# for localized messages
from __init__ import _

from Plugins.Plugin import PluginDescriptor
from setupSamba import setupSamba
from setupNfs import setupNfs
from os.path import isfile

plugin_path = ""

def setupSambaMain(session, iface = None, **kwargs):
	session.open(setupSamba, iface, plugin_path)

def setupNfsMain(session, iface = None, **kwargs):
	session.open(setupNfs, iface, plugin_path)

def menu_samba(menuid, **kwargs):
	if menuid == "network":
		if isfile("/usr/sbin/smbd"):
			return [(_("Samba-Server"), setupSambaMain, "stpsamba", 20)]
		else:
			return []
	else:
		return []

def menu_nfs(menuid, **kwargs):
	if menuid == "network":
		if isfile("/usr/sbin/exportfs"):
			return [(_("NFS-Server"), setupNfsMain, "stpnfs", 21)]
		else:
			return []
	else:
		return []

def Plugins(path, **kwargs):
	global plugin_path
	plugin_path = path
	return [
		PluginDescriptor(name=_("setupSamba"), description=_("Activate and configurate your Samba-Server"), where=PluginDescriptor.WHERE_MENU, fnc=menu_samba),
		PluginDescriptor(name=_("setupNFS"), description=_("Activate and configurate your NFS-Server"), where=PluginDescriptor.WHERE_MENU, fnc=menu_nfs),
	]

