//TODOs:
// - simple pages (about, news) umbauen (analog simplePages in core.js)
// - iframe pages umbauen (analog simplePages in core.js)

var feedpage = "None";

// merlin core

var MerlinCore = Class.create({
	initialize: function(name){
		// Check WebIf Version
		if (typeof core == "undefined"){
			alert("Old WebInterface found!\nPlease update the WebInterface Plugin first.");
			return;
		}
		// Start Merlin WebIf
		// Instantiate all elements
		this.menu = new MerlinMenuController('contentMerlinMenu');
		this.about = new AboutPage('contentMerlinContent');
		this.feed = new FeedPage('contentMerlinContent');
		this.feednav = new FeedNavPage('navContent');
		//this.news = new NewsPage('contentMerlinContent');
		this.settingsnav = new MerlinSettingsNavPage('navContent');
		this.settings = new MerlinSettingsController('contentMerlinContent');
		this.channellistsettings = new ChannellistSettingsController('contentMerlinContent');
		this.dmmsettings = new DMMSettingsController('contentMerlinContent');
		this.piconmapper = new PiconMapperController('contentMerlinContent');
		this.wiki = new WikiPage('contentMerlinContent');
		//this.plugins = new PluginsPage('contentMerlinContent'); // to be updated as a left navi is required
		this.infonav = new InfoNavPage('navContent');
		this.meminfo = new MemoryInfoController('contentMerlinContent');
		this.sessionProvider = new SessionProvider( this.onSessionAvailable.bind(this) );
		this.sessionProvider.load({});
	},
	
	onSessionAvailable: function(sid){
		debug("[MerlinWebinterface].onSessionAvailable, " + sid)
		global_sessionid = sid;
		
		// Display menu
		this.menu.load();
		// Register Events
		this.registerEvents();
	},
	
	registerEvents: function(){
		var contentmerlinnavi = $('navContent');
		var device = merlincore.getDevice();
		contentmerlinnavi.on(
			'click',
			'.boxfeed',
			function(event, element){
				if(opener)
				{
					this.setFeedPage(device, device);
					this.feed.load($('contentMerlinContent'));
				}
			}.bind(this)
		);
		contentmerlinnavi.on(
			'click',
			'.all',
			function(event, element){
				this.setFeedPage("all", device);
				this.feed.load($('contentMerlinContetnt'));
			}.bind(this)
		);
		contentmerlinnavi.on(
			'click',
			'.mipsel',
			function(event, element){
				if(opener)
				{
					var mipselfeed = "mips32el"
					if (device == "dm800") {
						mipselfeed = "mips32el-nf";
					}
					this.setFeedPage(mipselfeed,device);
					this.feed.load($('contentMerlinContent'));
				}
			}.bind(this)
		);
		contentmerlinnavi.on(
			'click',
			'.third-party',
			function(event, element){
				var thirdpartyfeed = "third-party";
				if (device == "dm7080")
				{
					thirdpartyfeed = "merlin4-thirdparty";
				}
				this.setFeedPage(thirdpartyfeed,device);
				this.feed.load($('contentMerlinContent'));
			}.bind(this)
		);
		
		contentmerlinnavi.on(
			'click',
			'.merlin4-plugins',
			function(event, element){
				this.setFeedPage("merlin4-plugins",device);
				this.feed.load($('contentMerlinContent'));
			}.bind(this)
		);
		
		contentmerlinnavi.on(
			'click',
			'.merlin4-skins',
			function(event, element){
				this.setFeedPage("merlin4-skins",device);
				this.feed.load($('contentMerlinContent'));
			}.bind(this)
		);		
		
		contentmerlinnavi.on(
			'click',
			'.merlinsettings',
			function(event, element){
				this.settings.loadList($('contentMerlinContent'));
			}.bind(this)
		);
		
		contentmerlinnavi.on(
			'click',
			'.channellistsettings',
			function(event, element){
				this.channellistsettings.loadList($('contentMerlinContent'));
			}.bind(this)
		);
		
		contentmerlinnavi.on(
			'click',
			'.dmmsettings',
			function(event,element){
				this.dmmsettings.loadList($('contentMerlinContent'));
			}.bind(this)
		);
		
		contentmerlinnavi.on(
			'click',
			'.piconmapper',
			function(event,element){
				this.piconmapper.loadList($('contentMerlinContent'));
			}.bind(this)
		);
		
		var contentmerlin = $('contentMerlinContent');
		contentmerlin.on(
			'click',
			'.mSettingsButton',
			function(event, element){
				this.settings.save($('settingsEditForm'));
			}.bind(this)
		);
		contentmerlin.on(
			'click',
			'.mChannellistSettingsButton',
			function(event, element){
				this.channellistsettings.save($('settingsEditForm'));
			}.bind(this)
		);
	},
	
	getFeedPage: function(){
		return feedpage;
	},
	
	resetNavigation: function(id, text){
		
		$(id).update('<div class="block center fullwidth oneliner">' + text + '</div>');
	},
	
	setFeedPage: function(dir,device){
		var feedurl = "http://feed.merlin3.info/index.php?dir="
		if (device == "dm7080")
		{
			feedurl = "http://debfeed4.merlin.xyz/"
		}
		feedpage = feedurl + dir;
	},
	
	getDevice: function(){
		var device = "unknown";
		if (opener) {
			device = opener.core.deviceInfo.info.devicename;
		}
		return device;
	}
	
});

// controllers

var MerlinMenuController  = Class.create(Controller, {
	initialize: function($super, target){
		$super(new MerlinMenuHandler(target));
	},
	
	back: function(){
		window.location = window.location.protocol + "//" + window.location.hostname;
	},
	
	load: function(){
		this.handler.load({});
	},
	
	feed: function(){
		merlincore.feednav.load();
		merlincore.feed.load();
	},
	
	about: function(){
		merlincore.about.load();
	},
	
	/*news: function(){
		merlincore.news.load();
	},*/
	
	settings: function(){
		merlincore.settingsnav.load();
		merlincore.settings.loadList();
	},
	
	wiki: function(){
		merlincore.wiki.load();
	},
	
	merlininfo: function(){
		merlincore.infonav.load();
		merlincore.meminfo.loadList();
	},
	
	/*plugins: function(){
		merlincore.plugins.load();
	},*/

	registerEvents: function(){
		$('back').on(
			'click',
			function(event, element){
				this.back();
			}.bind(this)
		);
		$('back').title = "Return to Dreambox Webcontrol";

		$('feed').on(
			'click',
			function(event, element){
				this.feed();
			}.bind(this)
		);
		$('feed').title = "Show Merlin Feed";
		
		/*$('news').on(
			'click',
			function(event, element){
				this.news();
			}.bind(this)
		);
		$('news').title = "Show Merlin News";*/
		
		$('settings').on(
			'click',
			function(event, element){
				this.settings();
				//this.settings.loadList.bind(this.settings);
			}.bind(this)
		);
		$('settings').title = "Show Merlin Settings";

		$('wiki').on(
			'click',
			function(event, element){
				this.wiki();
			}.bind(this)
		);
		$('wiki').title = "Show Merlin Wiki";
		
		/*$('plugins').on(
			'click',
			function(event, element){
				this.plugins();
			}.bind(this)
		);
		$('plugins').title = "Show Merlin Plugins";*/
		
		$('merlininfo').on(
			'click',
			function(event, element){
				this.merlininfo();
			}.bind(this)
		);
		$('merlininfo').title = "Show Merlin info";
		
		$('about').on(
			'click',
			function(event, element){
				this.about();
			}.bind(this)
		);
		$('about').title = "Some information about author, license, support...";
	},
	
	onFinished: function(){
		merlincore.wiki.load();
	}
});

var MerlinSettingsController = Class.create(Controller, {
	initialize: function($super, target){
		$super(new MerlinSettingsListHandler(target));
		this.merlinsettingshandler = new MerlinSettingsHandler(target, this.loadList.bind(this), []);
	},
	
	loadList: function(){
		$('headermerlincontent').innerHTML = "Merlin-Settings";
		this.handler.load({});
	},
	
	save: function(element){
		debug("MerlinSettingsController.save");
		//alert(element);
		
		this.merlinsettingshandler.commitForm(element);
	}
});

var ChannellistSettingsController = Class.create(Controller, {
	initialize: function($super, target){
		$super(new ChannellistSettingsListHandler(target));
		this.channellistsettingshandler = new ChannellistSettingsHandler(target, this.loadList.bind(this), []);
	},
	
	loadList: function(){
		$('headermerlincontent').innerHTML = "Channel Settings";
		this.handler.load({});
	},
	
	save: function(element){
		debug("ChannellistSettingsController.save");
		
		this.channellistsettingshandler.commitForm(element);
	}
});

var PiconMapperController = Class.create(Controller, {
	initialize: function($super, target){
		$super(new PiconMapperListHandler(target));
		this.piconmapperhandler = new PiconMapperHandler(target, this.loadList.bind(this), []);
	},
	
	loadList: function(){
		$('headermerlincontent').innerHTML = "Picon Mapper";
		this.handler.load({});
	},
});

var DMMSettingsController = Class.create(Controller, {
	initialize: function($super, target){
		$super(new DMMSettingsListHandler(target));
		this.dmmsettingshandler = new DMMSettingsHandler(target, this.loadList.bind(this), []);
	},
	
	loadList: function(){
		$('headermerlincontent').innerHTML = "DMM-Settings";
		this.handler.load({});
	},
	
	save: function(element){
		debug("DMMSettingsController.save");
		
		this.dmmsettingshandler.commitForm(element);
	}
});

var MemoryInfoController = Class.create(Controller, {
	initialize: function($super, target){
		$super(new MemDevicesListHandler(target));
	},
	
	loadList: function(){
		$('headermerlincontent').innerHTML = "Merlin-Info: Memory";
		this.handler.load({});
	},
});

// pages
var AboutPage = Class.create({
	initialize: function(target){
		this.simpleHandler = new MerlinSimplePageHandler(target);
	},

	show: function(tpl, data){
		if(!data)
			data = {};
		this.simpleHandler.show(tpl, data);
	},

	load: function(){
		merlincore.resetNavigation('navContent','');
		$('navHd').innerHTML = "Merlin About";
		$('headermerlincontent').innerHTML = "Merlin WebIf About";
		this.show('tplAbout');
	},
});

/*var NewsPage = Class.create({
	initialize: function(target){
		this.simpleHandler = new MerlinSimplePageHandler(target);
	},
	
	show: function(tpl, data){
		if(!data)
			data = {};
		this.simpleHandler.show(tpl, data);
	},
	
	load: function(){
		merlincore.resetNavigation('navContent','');
		$('navHd').innerHTML = "Merlin-News";
		$('headermerlincontent').innerHTML = "Merlin-News";
		this.show('tplMerlinNews');
	},
});*/

var PluginsPage = Class.create({
	initialize: function(target){
		this.simpleHandler = new MerlinSimplePageHandler(target);
	},
	
	show: function(tpl, data){
		if(!data)
			data = {};
		this.simpleHandler.show(tpl, data);
	},
	
	load: function(){
		merlincore.resetNavigation('navContent','');
		$('navHd').innerHTML = "Merlin-Plugins";
		$('headermerlincontent').innerHTML = "Merlin-Plugins";
		this.show('tplMerlinPlugins');
	},
});

var FeedNavPage = Class.create({
	initialize: function(nav){
		this.simpleHandler = new MerlinSimplePageHandler(nav);
	},
	
	show: function(tpl, data){
		if(!data)
			data = {};
		this.simpleHandler.show(tpl, data);
	},
	
	load: function(){
		$('navHd').innerHTML = "Merlin-Feeds";
		this.show('tplNaviMerlinFeed');
	},
	
});

var FeedPage = Class.create({
	initialize: function(content){
		this.simpleHandler = new MerlinSimplePageHandler(content);
	},
	
	show: function(tpl, data){
		if(!data)
			data = {};
		this.simpleHandler.show(tpl, data);
	},
	
	load: function(){
		$('headermerlincontent').innerHTML = "Merlin-Feeds";
		this.show('tplMerlinFeed');
	},
});

var WikiPage = Class.create({
	initialize: function(target){
		this.simpleHandler = new MerlinSimplePageHandler(target);
	},
	
	show: function(tpl, data){
		if(!data)
			data = {};
		this.simpleHandler.show(tpl, data);
	},
	
	load: function(){
		merlincore.resetNavigation('navContent','');
		$('navHd').innerHTML = "Merlin-Wiki";
		$('headermerlincontent').innerHTML = "Merlin-Wiki";
		this.show('tplMerlinWiki');
		},
	});
	
var InfoNavPage = Class.create({
	initialize: function(nav){
		this.simpleHandler = new MerlinSimplePageHandler(nav);
	},
	
	show: function(tpl, data){
		if(!data)
			data = {};
		this.simpleHandler.show(tpl, data);
	},
	
	load: function(){
		$('navHd').innerHTML = "Merlin-Info";
		this.show('tplNaviMerlinInfo');
	},
});

var MerlinSettingsNavPage = Class.create({
	initialize: function(nav){
		this.simpleHandler = new MerlinSimplePageHandler(nav);
	},
	
	show: function(tpl, data){
		if(!data)
			data = {};
		this.simpleHandler.show(tpl, data);
	},
	
	load: function(){
		$('navHd').innerHTML = "Merlin-Settings";
		this.show('tplNaviMerlinSettings');
	},
});