#
# MerlinWebInterface
#
# Coded by dre (c) 2012
# Support: www.dreambox-tools.info
# E-Mail: dre@dreambox-tools.info
#
# This plugin is open source but it is NOT free software.
#
# This plugin may only be distributed to and executed on hardware which
# is licensed by Dream Multimedia GmbH.
# In other words:
# It's NOT allowed to distribute any parts of this plugin or its source code in ANY way
# to hardware which is NOT licensed by Dream Multimedia GmbH.
# It's NOT allowed to execute this plugin and its source code or even parts of it in ANY way
# on hardware which is NOT licensed by Dream Multimedia GmbH.
#
# If you want to use or modify the code or parts of it,
# you have to keep MY license and inform me about the modifications by mail.

#Plugin
from Components.ActionMap import *
from Components.Label import Label
from Components.Pixmap import Pixmap
from Components.PluginComponent import plugins
from Components.config import config, ConfigYesNo, getConfigListEntry, ConfigSubsection
from Components.ConfigList import ConfigListScreen
from Plugins.Plugin import PluginDescriptor
from Screens.HelpMenu import HelpableScreen
from Screens.Screen import Screen
from Tools.Directories import fileExists
#Webinterface
from Plugins.Extensions.WebInterface.WebChilds.Toplevel import addExternalChild
from Plugins.Extensions.WebInterface.WebChilds.Screenpage import ScreenPage
from Plugins.Extensions.MerlinWebInterface.WebScreens import *
#Twisted
from twisted.web import static
from twisted.python import util
#enigma
from enigma import eEnv
from os import listdir as os_listdir, path as os_path

config.plugins.MerlinWebInterface = ConfigSubsection()
config.plugins.MerlinWebInterface.allowsettingschange = ConfigYesNo(default=False)
#config.plugins.MerlinWebInterface.enabledreamcc = ConfigYesNo(default=False)

if hasattr(static.File, 'render_GET'):
	class File(static.File):
		def render_POST(self, request):
			return self.render_GET(request)
else:
	File = static.File

# Webgui
def sessionstart(reason, **kwargs):
	if "session" in kwargs:
		# webgui
		session = kwargs["session"]
		root = File(eEnv.resolve("${libdir}/enigma2/python/Plugins/Extensions/MerlinWebInterface/web-data"))
		root.putChild("web", ScreenPage(session, util.sibpath(__file__, "web"), True) )
		addExternalChild( ("merlin", root, "Merlin", "1", True) )
		directorylist = ["/usr/share/enigma2/picon_50x30","/media/cf/picon_50x30", "/media/usb/picon_50x30","/media/hdd/picon_50x30","/usr/share/enigma2/picon","/media/cf/picon", "/media/usb/picon","/media/hdd/picon"]
		if os_path.ismount("/data"):
			directorylist.append("/data/picon_50x30")
			directorylist.append("/data/picon")
		pic = ""
		for path in directorylist:
			if os_path.exists(path) and len(os_listdir(path)) > 0:
				pic = File(path)
				break
		if pic != "":
			root.putChild("pic", ScreenPage(session, util.sibpath(__file__, "pic"), True) )
			addExternalChild( ("pic", pic, "Picon", "1", False) )
		
def main(session, **kwargs):
	session.open(MerlinWebInterfaceConfigScreen)
	
class MerlinWebInterfaceConfigScreen(Screen, HelpableScreen, ConfigListScreen):
	skin = """
		<screen position="center,center" size="550,200" title="Merlin WebInterface - Config" >
			<widget itemHeight="25" name="config" position="10,10" size="520,150" scrollbarMode="showOnDemand"/>
			<widget name="ButtonGreen" position="10,160" pixmap="skin_default/buttons/key_green.png" zPosition="10" size="35,25" transparent="1" alphatest="on" />
			<widget name="TextGreen" position="50,160" size="220,20" valign="center" halign="left" zPosition="10" font="Regular;18" transparent="1" />
		</screen>"""
		
	def __init__(self, session):
		Screen.__init__(self, session)
		HelpableScreen.__init__(self)
		self.session = session
		self.skin = MerlinWebInterfaceConfigScreen.skin
		
		self["ButtonGreen"] = Pixmap()
		self["TextGreen"] = Label(_("Save"))
		
		self["ColorActions"] = HelpableActionMap(self, "ColorActions",
		{
			"green":	(self.saveConfig, _("Save settings")),
		}, -1)
		
		self["OkCancelActions"] = HelpableActionMap(self, "OkCancelActions",
		{
			"cancel":	(self.close, _("Close plugin")),
		}, -1)
		
		self.list = []
		
		ConfigListScreen.__init__(self, self.list)
		
		self.list.append(getConfigListEntry(_("Allow settings modification in MerlinWebInterface: "), config.plugins.MerlinWebInterface.allowsettingschange))
		#if fileExists("/usr/lib/enigma2/python/Plugins/Extensions/DreamCC/plugin.pyo"):
			#self.list.append(getConfigListEntry(_("Enable DreamCC web interface: "), config.plugins.MerlinWebInterface.enabledreamcc))
		
		self["config"].setList(self.list)
		
	def saveConfig(self):
		for x in self.list:
			x[1].save()
		self.close()

def Plugins(**kwargs):
	l = [
		PluginDescriptor(where=PluginDescriptor.WHERE_SESSIONSTART, fnc=sessionstart, needsRestart=False),
		PluginDescriptor(name="Merlin WebInterface Config", description="Plugin to configure the Merlin WebInterface", where=PluginDescriptor.WHERE_PLUGINMENU, fnc=main, needsRestart=True)
	]
	return l

