#
# MerlinWebInterface
#
# Coded by dre (c) 2012
# Support: www.dreambox-tools.info
# E-Mail: dre@dreambox-tools.info
#
# This plugin is open source but it is NOT free software.
#
# This plugin may only be distributed to and executed on hardware which
# is licensed by Dream Multimedia GmbH.
# In other words:
# It's NOT allowed to distribute any parts of this plugin or its source code in ANY way
# to hardware which is NOT licensed by Dream Multimedia GmbH.
# It's NOT allowed to execute this plugin and its source code or even parts of it in ANY way
# on hardware which is NOT licensed by Dream Multimedia GmbH.
#
# If you want to use or modify the code or parts of it,
# you have to keep MY license and inform me about the modifications by mail.

from Components.Sources.Source import Source
import os

class MerlinMemoryInfo(Source):
	MEMORY = 0
	def __init__(self, session, func):
		self.func = func
		self.session = session
		Source.__init__(self)

	def handleCommand(self, cmd):
		print "in handleCommand"
		if self.func is self.MEMORY:
			print "[MerlinWebInterface]: In Memory"
			self.result = self.getMemoryInfo()
		else:
			self.result = False

	def getMemoryInfo(self):
		merlinMemoryList = []
		
		os.system("df -P > /tmp/diskinfo")
		
		f = open("/tmp/diskinfo", "r")
		for line in f:
			if not line.startswith("Filesystem"):
				print line.split()
				info = line.split()
				total = float(info[1])
				used = float(info[2])
				unitindex = 0
				units = ["KB", "MB", "GB", "TB"]
				while total > 1024:
					total = total/1024
					unitindex = unitindex+1
				unit = units[unitindex]
				total = "%.3f %s" %(total, unit)
				
				unitindex = 0
				while used > 1024:
					used = used/1024
					unitindex = unitindex+1
				unit = units[unitindex]
				used = "%.3f %s" %(used, unit)
				merlinMemoryList.append((info[0],info[5],used,total,info[4]))
				#info[3] = available, info[4] = use in %, info[5] = mountpoint
		
		return merlinMemoryList
		

	def getText(self):
		self.handleCommand(None)
		if self.result:
			return str(self.result)
		else:
			return ""

	def getList(self):
		self.handleCommand(None)
		list = self.result
		if list is None:
			list = ()

		return list

	text = property(getText)
	list = property(getList)
	lut = {"DeviceName": 0, "MountPoint": 1, "UsedSpace": 2, "TotalSpace": 3, "PercUsed": 4}
