# -*- coding: utf-8 -*-
#
# CoverCollection
#
# Coded by Dr.Best (c) 2014
# Support: www.dreambox-tools.info
# E-Mail: dr.best@dreambox-tools.info
#
# This plugin is open source but it is NOT free software.
#
# This plugin may only be distributed to and executed on hardware which
# is licensed by Dream Multimedia GmbH.
# In other words:
# It's NOT allowed to distribute any parts of this plugin or its source code in ANY way
# to hardware which is NOT licensed by Dream Multimedia GmbH.
# It's NOT allowed to execute this plugin and its source code or even parts of it in ANY way
# on hardware which is NOT licensed by Dream Multimedia GmbH.
#
# If you want to use or modify the code or parts of it,
# you have to keep MY license and inform me about the modifications by mail.
#

from merlin_covercollection.ecovercollection import eCoverCollection, eVideoDBPictureBox
from Components.GUIComponent import GUIComponent
from skin import parseSize, parsePosition
from Components.AVSwitch import AVSwitch

def getScale():
	return AVSwitch().getFramebufferScale()

class CoverCollection(GUIComponent, object):
	def __init__(self):
		GUIComponent.__init__(self)
		self.onSelectionChanged = [ ]
		self.list = []
		self.index = -1

	GUI_WIDGET = eCoverCollection

		
	def setMode(self, mode):
		self.instance.setMode(mode)

	def MoveLeft(self):
		self.instance.MoveLeft()

	def MoveRight(self):
		self.instance.MoveRight()
		
	def MoveDown(self):
		self.instance.MoveDown()

	def MoveUp(self):
		self.instance.MoveUp()
	
	def moveSelectionTo(self, index):
		self.instance.moveSelectionTo(index)
		self.index = index
		
	def setList(self, list, posterlist, index=0):
		self.list = list
		self.index = index
		self.instance.setList(posterlist,index);
	
	def postWidgetCreate(self, instance):
		self.selectionChanged_conn = instance.selectionChanged.connect(self.selectionChanged)
		sc = getScale()
		self.instance.setAspectRatio(sc[0], sc[1])

	def preWidgetRemove(self, instance):
		self.selectionChanged_conn = None
	
	def connectSelChanged(self, fnc):
		if not fnc in self.onSelectionChanged:
			self.onSelectionChanged.append(fnc)

	def disconnectSelChanged(self, fnc):
		if fnc in self.onSelectionChanged:
			self.onSelectionChanged.remove(fnc)

	def selectionChanged(self, index):
		self.index = index
		for x in self.onSelectionChanged:
			x(index)
	
	def getCurrentIndex(self):
		return self.index
	      
	def getCurrent(self):
		if self.index != -1:
			return self.list[self.index][0]
		else:
			return None
		      
	def updateRowData(self, row):
		tmp = self.list[self.index]
		self.list[self.index] = (row,)
		self.instance.invalidate()
		
	def getTotalPages(self):
		return self.instance.getTotalPages()
	      
	def getCurrentPage(self):
		return self.instance.getCurrentPage()
		      
	def applySkin(self, desktop, screen):
		if self.skinAttributes is not None:
			attribs = [ ]
			for (attrib, value) in self.skinAttributes:
					if attrib == "coverSize":
						size = parseSize(value, ((1,1),(1,1)))
						self.instance.setCoverSize(size)
					elif attrib == "selectedCoverScale":
						self.instance.setSelectedCoverScaleValue(float(value))
					elif attrib == "unselectedCoverDimm":
						self.instance.setCoverUnselectedDimm(float(value))
					elif attrib == "coverBeginPosition":
						position = parsePosition(value, ((1,1),(1,1)))
						self.instance.setCoverBeginPosition(position)
					elif attrib == "coverDistance":
						position = parsePosition(value, ((1,1),(1,1)))
						self.instance.setCoverDistance(position)
					elif attrib == "coverflowCurrentPosition":
						position = parsePosition(value, ((1,1),(1,1)))
						self.instance.setCoverflowCurrentPosition(position)
					elif attrib == "coverflowCurrentXDistance":
						self.instance.setCoverflowXDistance(int(value))
					elif attrib == "coverflowCurrentCenterDistance":
						self.instance.setCoverflowCenterDistance(int(value))
					elif attrib == "style":
						self.instance.setStyle(int(value))
					elif attrib == "noCoverAvailablePic":
						self.instance.setNoCoverPic(value)
					else:
						attribs.append((attrib,value))
			self.skinAttributes = attribs
		return GUIComponent.applySkin(self, desktop, screen)		      


class VideoDBPictureBox(GUIComponent, object):
	def __init__(self):
		GUIComponent.__init__(self)

	GUI_WIDGET = eVideoDBPictureBox
	
	def postWidgetCreate(self, instance):
		sc = getScale()
		self.instance.setAspectRatio(sc[0], sc[1])

	def setPicture(self, filename):
		self.instance.setPicture(filename);
	
	def setTransitionDuration(self, duration):
		self.instance.setTransitionDuration(duration)

	def applySkin(self, desktop, screen):
		if self.skinAttributes is not None:
			attribs = [ ]
			for (attrib, value) in self.skinAttributes:
					if attrib == "transitionDuration":
						self.instance.setTransitionDuration(int(value))
					else:
						attribs.append((attrib,value))
			self.skinAttributes = attribs
		return GUIComponent.applySkin(self, desktop, screen)		      		
