# -*- coding: utf-8 -*-
#
#  mFeInfo - Converter
#
#  Coded by weazle (c) 2013
#  Support: www.dreambox-tools.info
#  E-Mail: weazle@dreambox-tools.info
#
#  This converter is licensed under the Creative Commons 
#  Attribution-NonCommercial-ShareAlike 3.0 Unported 
#  License. To view a copy of this license, visit
#  http://creativecommons.org/licenses/by-nc-sa/3.0/ or send a letter to Creative
#  Commons, 559 Nathan Abbott Way, Stanford, California 94305, USA.
#
#  Alternatively, this converter may be distributed and executed on hardware which
#  is licensed by Dream Multimedia GmbH.

#  This converter is NOT free software. It is open source, you are allowed to
#  modify it (if you keep the license), but it may not be commercially 
#  distributed other than under the conditions noted above.
#	

from Components.Converter.Converter import Converter
from Components.Element import cached

class mFeInfo(Converter, object):
	def __init__(self, type):
		Converter.__init__(self, type)

	@cached
	def getData(self):
		system_info = None
		tuner_info = None		
		service = self.source.service
		if service:
			frontend_info = service.frontendInfo()
			if frontend_info:
				frontend_data = frontend_info.getAll(True)
				tuner_info = frontend_data.get('tuner_type')
				system_info = frontend_data.get('system')
			if system_info is not None:	
				if (tuner_info == 'DVB-S') and (system_info == 0):			
					return 0
				elif (tuner_info == 'DVB-S') and (system_info == 1): # DVB-S2: This doesn't work on all Channels because some Channels like ATV-HD do not respond 'system 1'
					return 3
			if tuner_info is not None:						
				if tuner_info == 'DVB-C':
					return 1
				elif tuner_info == 'DVB-T':
					return 2
		return -1

	@cached
	def getText(self):
		tval = self.getData()
		if tval is not None:
			if tval == 0:
				return 'DVB-S'
			elif tval == 1:
				return 'DVB-C'
			elif tval == 2:
				return 'DVB-T'
			elif tval == 3:
				return 'DVB-S2'
		return ""

	text = property(getText)

	@cached
	def getValue(self):
		val = self.getData()
		if val is not None:
			return val
		return -1	

	value = property(getValue)
