#
# ChannelNumber
#
# Coded by dre (c) 2013
# Support: www.dreambox-tools.info
# E-Mail: dre@dreambox-tools.info
#
# This renderer is open source but it is NOT free software.
#
# This renderer may only be distributed to and executed on hardware which
# is licensed by Dream Multimedia GmbH.
# In other words:
# It's NOT allowed to distribute any parts of this renderer or its source code in ANY way
# to hardware which is NOT licensed by Dream Multimedia GmbH.
# It's NOT allowed to execute this renderer and its source code or even parts of it in ANY way
# on hardware which is NOT licensed by Dream Multimedia GmbH.
#
# If you want to use or modify the code or parts of it,
# you have to keep MY license and inform me about the modifications by mail.
#

from Components.VariableText import VariableText
from enigma import eLabel, eServiceCenter, eServiceReference
from Renderer import Renderer
from Screens.InfoBar import InfoBar
from Components.config import config

ChannelSelectionServicelist = InfoBar.instance.servicelist

class ChannelNumber(Renderer, VariableText):
	def __init__(self):
		Renderer.__init__(self)
		VariableText.__init__(self)
	GUI_WIDGET = eLabel
	
	def changed(self, what):
		if not self.suspended:
			service = self.source.service
			info = service and service.info()
			if info is None or config.merlin2.skin_showchannelnumber.value == False:
				self.text = " "
				return

			myRoot = ChannelSelectionServicelist.getRoot()
			channelIndex = ChannelSelectionServicelist.servicelist.getCurrentIndex()
			markerCounter = 0
			serviceCounter = 0	
			#check if channel is in bouquet as we only show a number for channels in bouquets
			if not ChannelSelectionServicelist.inBouquet():
				self.text = " "
			else:
				servicelist = eServiceCenter.getInstance().list(myRoot)

				if not servicelist is None:
					while True:
						myservice = servicelist.getNext()
						if not myservice.valid():
							break
						if serviceCounter == channelIndex:
							break
						elif (myservice.flags & eServiceReference.isMarker):
							markerCounter = markerCounter + 1
							continue
						serviceCounter = serviceCounter + 1
			
				#subtract markers as they don't have a number
				channelIndex = (channelIndex - markerCounter) + 1
				#get offset (previous bouquets)
				bouquetOffset = ChannelSelectionServicelist.getBouquetNumOffset(myRoot)
				self.text = str(channelIndex + bouquetOffset)

