// providers

var MerlinSettingsListProvider = Class.create(AbstractContentProvider, {
	initialize: function($super, showFnc){
		$super(URL.merlinsettings, showFnc);
		},
		
		renderXML: function(xml){
			var list = new MerlinSettingsList(xml).getArray();
			return { merlinsetting : list };
		}
	});
	
var ChannellistSettingsListProvider = Class.create(AbstractContentProvider, {
	initialize: function($super, showFnc){
		$super(URL.channellistsettings, showFnc);
		},
		
		renderXML: function(xml){
			var list = new ChannellistSettingsList(xml).getArray();
			return { channellistsetting : list };
		}
	});
	
var DMMSettingsListProvider = Class.create(AbstractContentProvider, {
	initialize: function($super, showFnc){
		$super(URL.dmmsettings, showFnc);
		},
		
		renderXML: function(xml){
			var list = new DMMSettingsList(xml).getArray();
			return { merlinsetting : list };
		}
	});

var PiconMapperListProvider = Class.create(AbstractContentProvider, {
	initialize: function($super, showFnc){
		$super(URL.piconmapper, showFnc);
		},
		
		renderXML: function(xml){
			var list = new PiconMappingList(xml).getArray();
			return { piconmapping : list };
		}
	});
	
var MemDevicesListProvider = Class.create(AbstractContentProvider, {
	initialize: function($super, showFnc){
		$super(URL.merlinmeminfo, showFnc);
		},
		
		renderXML: function(xml){
			var list = new MerlinMemDevicesList(xml).getArray();
			return { memdevices : list };
		}
	});