#
# MerlinWebInterface
#
# Coded by dre (c) 2012
# Support: www.dreambox-tools.info
# E-Mail: dre@dreambox-tools.info
#
# This plugin is open source but it is NOT free software.
#
# This plugin may only be distributed to and executed on hardware which
# is licensed by Dream Multimedia GmbH.
# In other words:
# It's NOT allowed to distribute any parts of this plugin or its source code in ANY way
# to hardware which is NOT licensed by Dream Multimedia GmbH.
# It's NOT allowed to execute this plugin and its source code or even parts of it in ANY way
# on hardware which is NOT licensed by Dream Multimedia GmbH.
#
# If you want to use or modify the code or parts of it,
# you have to keep MY license and inform me about the modifications by mail.

from Components.Sources.Source import Source
from Components.config import config, configfile, ConfigYesNo, ConfigInteger, ConfigSelection, ConfigNumber, ConfigBoolean, ConfigOnOff, ConfigEnableDisable, ConfigSequence
from Components.UsageConfig import *
from enigma import eEnv
import xml.etree.cElementTree
import re
from collections import OrderedDict

class MerlinSettings(Source):
	MERLINSETTINGS = 0
	MERLINSETTINGSSAVE = 1
	CHANNELLISTSETTINGS = 2
	CHANNELLISTSETTINGSSAVE = 3
	DMMSETTINGS = 4
	DMMSETTINGSSAVE = 5
	def __init__(self, session, func):
		self.func = func
		self.session = session
		Source.__init__(self)

	def handleCommand(self, cmd):
		if self.func is self.MERLINSETTINGS:
			print "[MerlinWebInterface]: In MerlinSettings"
			self.result = self.getMerlinSettings('merlin_setup.xml')
		elif self.func is self.MERLINSETTINGSSAVE:
			print "[MerlinWebInterface]: In MerlinSettingsSave"
			self.result = self.saveMerlinSettings(cmd)
		elif self.func is self.CHANNELLISTSETTINGS:
			self.result = self.getChannellistSettings() 
		elif self.func is self.CHANNELLISTSETTINGSSAVE:
			self.result = self.saveChannellistSettings(cmd)
		#elif self.func is self.DMMSETTINGS(cmd):
		elif self.func is self.DMMSETTINGS:
			self.result = self.getMerlinSettings('setup.xml')
		elif self.func is self.DMMSETTINGSSAVE:
			self.result = self.saveMerlinSettings(cmd)
		else:
			self.result = False

	def getMerlinSettings(self, setupfile):
		merlinConfigList = []

		self.getDescription(merlinConfigList, setupfile)
		
		return merlinConfigList
	
	def getDescription(self, merlinConfigList, setupfile):
		try:
			setupfile_merlin = file('data/%s' %(setupfile), 'r')
		except:
			setupfile_merlin = file(eEnv.resolve('${datadir}/enigma2/%s' %(setupfile)), 'r')
		setupdom_merlin = xml.etree.cElementTree.parse(setupfile_merlin)
		setupfile_merlin.close()

		xmldata = setupdom_merlin.getroot()
		for x in xmldata.findall("setup"):
			key = x.get("key")
			category = x.get("title")
			print key
			if key == "rc" or key == "network" or key == "RFmod" or key == "satconfig" or key == "osd" or key == "lcd" or key == "timezone":
				continue
			#if key = cmd:
			else:
				self.addItems(merlinConfigList, x, category)
			
	
	def addItems(self, merlinConfigList, parentNode, category):
		for x in parentNode:
			if x.tag == 'item':
				item_config = x.text
				print item_config
				requires = x.get("requires")
				if requires and not SystemInfo.get(requires, False):
					continue

				item_text = _(x.get("text", "??").encode("UTF-8"))
				print item_text
				b = eval(x.text or "");
				if b == "":
					continue
				item = b
				item_type = "No Type"
				item_values = []
				item_setvalue = ""
				if isinstance(item, ConfigYesNo):
					item_type = "ConfigYesNo"
					item_values = item.getSelectionHTML(item_config, "MerlinSetting")
					item_setvalue = item.value
				elif isinstance(item, ConfigInteger):
					item_type = "ConfigInteger"
					item_setvalue = item.value
					item_values = item.getHTML(item_config, "MerlinSetting")
				elif isinstance(item, ConfigSelection):
					item_type = "ConfigSelection"
					item_setvalue =  item.getMulti(item.value)[1]
					item_values = item.getSelectionHTML(item_config, "MerlinSetting")
				elif isinstance(item, ConfigNumber):
					item_type = "ConfigNumber"
					item_setvalue = item.value
					item_values = item.getHTML(item_config, "MerlinSetting")
				elif isinstance(item, ConfigBoolean):
					item_type = "ConfigBoolean"
					item_setvalue =  item.getMulti(item.value)[1]
					item_values = item.getSelectionHTML(item_config, "MerlinSetting")
				elif isinstance(item, ConfigOnOff):
					item_type = "ConfigOnOff"
					item_setvalue =  item.getMulti(item.value)[1]
					item_values = item.getSelectionHTML(item_config, "MerlinSetting")
				elif isinstance(item, ConfigEnableDisable):
					item_type = "ConfigEnableDisable"
					item_setvalue =  item.getMulti(item.value)[1]
					item_values = item.getSelectionHTML(item_config, "MerlinSetting")
				elif isinstance(item, ConfigSequence):
					item_type = "ConfigSequence"
					item_setvalue =  item.getMulti(item.value)[1]
					item_values = item.getHTML(item_config, "MerlinSetting")
				elif isinstance(item, ConfigSet):
					item_type = "ConfigSet"
					item_setvalue = item.getMulti(item.value)[1]
					item_values = item.getSelectionHTML(item_config, "MerlinSetting")
					default_length = item.getDefaultLength()
				item_cat = category
				merlinConfigList.append((item_text, item_config, item_setvalue, item_values, item_cat))

	def saveMerlinSettings(self, param):
		if config.plugins.MerlinWebInterface.allowsettingschange.value == True:
			print "[WebComponents.MerlinWebInterface] save settings with param = ", param
		
			configvaluelist = param['configvalues'].split(',')
			configentrylist = param['confignames'].split(',')
			configdict = dict(zip(configentrylist, configvaluelist))
			#print configdict
		
			for k, v in configdict.iteritems():
				configobject = eval(k)
				if eval(k).value != str(v):
					if isinstance(configobject, ConfigNumber):
						configobject.value = int(v)
					elif isinstance(configobject, ConfigInteger):
						configobject.value = int(v)
					elif isinstance(configobject, (ConfigYesNo, ConfigBoolean, ConfigOnOff, ConfigEnableDisable)):
						if v == "True":
							tostore = True
						elif v == "False":
							tostore = False
						configobject.value = tostore
					elif isinstance(configobject, (ConfigSequence, ConfigSelection)):
						eval(k).value = v
					elif isinstance(configobject, ConfigSet):
						values = []
						values = v.split('#')
						values = map(int, values)
						#compare old and new again as first check will always return true for ConfigSet
						if eval(k).value != values:
							eval(k).value = values
					eval(k).save()
			configfile.save()
		
			return (True, "Settings have been updated")
		else:
			return (False, "Settings have not been updated. Modification of settings is disabled.")
			
	def getChannellistSettings(self):
		
		merlinConfigList = []
		#forget about dynamically reading the config entries as it's not possible to get a description
		#self.searchConfigEntries(merlinConfigList, "/usr/lib/enigma2/python/Screens/ChannelSelectionDisplaySettings.py", "ChannellistSetting")

		configitems = OrderedDict([
		("config.usage.configselection_columnstyle" , _("Column style")),
		("config.usage.configselection_secondlineinfo" , _("2nd line info")),
		("config.usage.configselection_showservicename" , _("Show service name")),
		("config.usage.show_event_progress_in_servicelist" , _("Show event-progress")),
		("config.usage.configselection_showadditionaltimedisplay" , _("Additional event-time info")),
		("config.usage.configselection_additionaltimedisplayposition" , _("Additional event-time position")),
		("config.usage.configselection_servicenamecolwidth" , _("Service name column width")),
		("config.usage.configselection_progressbarposition" , _("Event-progessbar position")),
		("config.usage.configselection_showrecordings" , _("Show recordings")),
		("config.usage.configselection_showlistnumbers" , _("Show service numbers")),
		("config.usage.configselection_showpicons" , _("Show Picons")),
		("config.usage.configselection_piconspath" , _("Picons path"))
		#("config.merlin2.configselection_showsettingsincontextmenu" , _("Show settings in channel context menu"))
		
		])
		
		showPicons = False
		useColumnStyle = False
		useBigPicons = False
		showEventProgress = False
		showServiceName = False
		additionalEventInfo = 0
	
		c = eval("config.usage.configselection_bigpicons" or "")
		if c != "":
			item = c
			useBigPicons = item.value
	
		for entry in configitems.keys():
			item_config = entry
			b = eval(item_config or "")
			if b == "":
				continue
			item = b
			print item_config
			item_text = configitems.get(entry)
			item_type = "No Type"
			item_values = []
			item_setvalue = ""
			skipList = []
			if isinstance(item, ConfigYesNo):
				item_type = "ConfigYesNo"
				item_values = item.getSelectionHTML(item_config, "ChannellistSetting")
				item_setvalue = item.value
			elif isinstance(item, ConfigInteger):
				item_type = "ConfigInteger"
				item_setvalue = item.value
				item_values = item.getHTML(item_config, "ChannellistSetting")
			elif isinstance(item, ConfigSelection):
				item_type = "ConfigSelection"
				item_setvalue =  item.getMulti(item.value)[1]
				#Remove  progress bar position option 1 when column style or show service name is not used
				if item_config == "config.usage.configselection_progressbarposition" and (useColumnStyle == False or showServiceName == False):
					skipList.append("1")
				item_values = item.getSelectionHTML(item_config, "ChannellistSetting", skipList)
			elif isinstance(item, ConfigNumber):
				item_type = "ConfigNumber"
				item_setvalue = item.value
				item_values = item.getHTML(item_config, "ChannellistSetting")
			elif isinstance(item, ConfigBoolean):
				item_type = "ConfigBoolean"
				item_setvalue =  item.getMulti(item.value)[1]
				item_values = item.getSelectionHTML(item_config, "ChannellistSetting", skipList)
			elif isinstance(item, ConfigOnOff):
				item_type = "ConfigOnOff"
				item_setvalue =  item.getMulti(item.value)[1]
				item_values = item.getSelectionHTML(item_config, "ChannellistSetting")
			elif isinstance(item, ConfigEnableDisable):
				item_type = "ConfigEnableDisable"
				item_setvalue =  item.getMulti(item.value)[1]
				item_values = item.getSelectionHTML(item_config, "ChannellistSetting")
			elif isinstance(item, ConfigSequence):
				item_type = "ConfigSequence"
				item_setvalue =  item.getMulti(item.value)[1]
				item_values = item.getHTML(item_config, "ChannellistSetting")
			
			#set showPicons
			if item_config == "config.usage.configselection_showpicons" and item.value == True:
				showPicons = True
			
			#set useColumnStyle	
			if item_config == "config.usage.configselection_columnstyle" and item.value == True:
				useColumnStyle = True
				
			#set showEventProgress
			if item_config == "config.usage.show_event_progress_in_servicelist" and item.value == True:
				showEventProgress = True
				
			#set additionalEventInfo
			if item_config == "config.usage.configselection_additionaltimedisplayposition":
				additionalEventInfo = item.value
				
			#set showServiceName
			if item_config == "config.usage.configselection_showservicename" and item.value == True:
				showServiceName = True

			#Don't show "Picons path" option when show Picons is not activated
			if item_config == "config.usage.configselection_piconspath" and showPicons == False:
				print "[MerlinSettings.py]: hiding piconspath"
				continue
			
			#Don't show "2nd line info" option when column style and big picons are not used or column style is used and big picons are not used
			if item_config == "config.usage.configselection_secondlineinfo" and (useColumnStyle == False or useColumnStyle == True and useBigPicons == False):
				print "[MerlinSettings.py]: hiding secondlineinfo"
				continue
				
			#Don't show "Show service name" option when column style is not used			
			if item_config == "config.usage.configselection_showservicename" and useColumnStyle == False:
				print "[MerlinSettings.py]: hiding showservicename"			
				continue
				
			#Don't show "Event-progressbar position" option when show event progress is not activated
			if item_config == "config.usage.configselection_progressbarposition" and showEventProgress == False:
				print "[MerlinSettings.py]: hiding progressbarposition"				
				continue
				
			#Don't show "Service name column width" when column style is not used
			if item_config == "config.usage.configselection_servicenamecolwidth" and useColumnStyle == False:
				print "[MerlinSettings.py]: hiding servicenamecolwidth"
				continue
				
			#Don't show "Additional event-time position" option when is not activated
			if item_config == "config.usage.configselection_additionaltimedisplayposition" and additionalEventInfo == "0":
				print "[MerlinSettings.py]: hiding additionaltimedisplayposition"				
				continue
			item_cat = ""
			merlinConfigList.append((item_text, item_config, item_setvalue, item_values, item_cat))			
		
		
		return merlinConfigList
	
	def saveChannellistSettings(self, param):
		if config.plugins.MerlinWebInterface.allowsettingschange.value == True:
			print "[WebComponents.MerlinWebInterface] save settings with param = ", param
			
			configvaluelist = param['configvalues'].split(',')
			configentrylist = param['confignames'].split(',')
			configdict = dict(zip(configentrylist, configvaluelist))
			
			#TODO: implement handling for big picons and picons path
			
			for k, v in configdict.iteritems():
				configobject = eval(k)
				if eval(k).value != str(v):
					if isinstance(configobject, ConfigNumber):
						configobject.value = int(v)
					elif isinstance(configobject, ConfigInteger):
						configobject.value = int(v)
					elif isinstance(configobject, (ConfigYesNo, ConfigBoolean, ConfigOnOff, ConfigEnableDisable)):
						if v == "True":
							tostore = True
						elif v == "False":
							tostore = False
						configobject.value = tostore
					elif isinstance(configobject, (ConfigSequence, ConfigSelection)):
						eval(k).value = v
					eval(k).save()
			configfile.save()
			
			c = eval("config.usage.configselection_showpicons" or "")
			if c != "":
				item = c
				if item.value == False:
					configobject = eval("config.usage.configselection_bigpicons")
					if isinstance(configobject, (ConfigYesNo, ConfigBoolean, ConfigOnOff, ConfigEnableDisable)):
						configobject.value = "False"
						configobject.save()
					configobject2 = eval("config.usage.configselection_piconspath")
					if isinstance(configobject2, (ConfigSequence, ConfigSelection)):
						configobject2.value = None
						configobject2.save()
				elif item.value == True:
					configobject2 = eval("config.usage.configselection_piconspath")
					if isinstance(configobject2, (ConfigSequence, ConfigSelection)):
						if configobject2.getIndex() > 2:
							print "configobject2 is gt 2"
							configobject = eval("config.usage.configselection_bigpicons")
							if isinstance(configobject, (ConfigYesNo, ConfigBoolean, ConfigOnOff, ConfigEnableDisable)):
								configobject.value = True
								configobject.save()
						elif configobject2.getIndex() <= 2:
							print "configobject2 is 2 or smaller"
							configobject = eval("config.usage.configselection_bigpicons")
							if isinstance(configobject, (ConfigYesNo, ConfigBoolean, ConfigOnOff, ConfigEnableDisable)):
								configobject.value = False
								configobject.save()
			configfile.save()
						 
					
			
			return (True, "Settings have been updated. Please check if new settings are available due to the latest changes")
		else:
			return (False, "Settings have not been updated. Modification of settings is disabled.")
	
	def getText(self):
		self.handleCommand(None)
		if self.result:
			return str(self.result)
		else:
			return ""

	def getList(self):
		self.handleCommand(None)
		list = self.result
		if list is None:
			list = ()

		return list

	text = property(getText)
	list = property(getList)
	lut = {"Name": 0, "Config": 1, "DefaultValue": 2, "Value": 3, "Category": 4}
