##
## Picon renderer by Gruffy .. some speedups by Ghost
##
from Renderer import Renderer
from enigma import ePixmap, eEnv
from Tools.Directories import fileExists, SCOPE_SKIN_IMAGE, SCOPE_CURRENT_SKIN, resolveFilename
from re import compile
from Components.config import config

import xml.etree.cElementTree

class Picon(Renderer):
	searchPaths = (eEnv.resolve('${datadir}/enigma2/%s/'),
				'/media/cf/%s/',
				'/media/usb/%s/',
				'/data/%s/')

	def __init__(self):
		Renderer.__init__(self)
		self.path = "picon"
		self.nameCache = { }
		self.pngname = ""
		self.partnerbox = compile('1:0:[0-9a-fA-F]+:[1-9a-fA-F]+[0-9a-fA-F]*:[1-9a-fA-F]+[0-9a-fA-F]*:[1-9a-fA-F]+[0-9a-fA-F]*:[1-9a-fA-F]+[0-9a-fA-F]*:[0-9a-fA-F]+:[0-9a-fA-F]+:[0-9a-fA-F]+:[http|rtp]')
 
	def applySkin(self, desktop, parent):
		attribs = [ ]
		for (attrib, value) in self.skinAttributes:
			if attrib == "path":
				self.path = value
			else:
				attribs.append((attrib,value))
		self.skinAttributes = attribs
		return Renderer.applySkin(self, desktop, parent)

	GUI_WIDGET = ePixmap

	def changed(self, what):
		#dre
		if self.instance and config.merlin2.skin_showpicon.value:
		#if self.instance:
			pngname = ""
			if what[0] != self.CHANGED_CLEAR:
				sname = self.source.text
				pos = sname.rfind(':')
				pos2 = sname.rfind(':', 0, pos)
				if pos - pos2 == 1 or self.partnerbox.match(sname) is not None:
					sname = sname[:pos2].replace(':', '_')
				elif sname.startswith('4097:0:1:0:0:0:0:0:0:0:http'):
					sname = sname[pos+1:].replace(' ','_')
				else:
					sname = sname[:pos].replace(':', '_')
				pngname = self.nameCache.get(sname, "")
				if pngname == "":
					pngname = self.findPicon(sname)
					if pngname != "":
						self.nameCache[sname] = pngname
			if pngname == "": # no picon for service found
				pngname = self.nameCache.get("default", "")
				if pngname == "": # no default yet in cache..
					pngname = self.findPicon("picon_default")
					if pngname == "":
						tmp = resolveFilename(SCOPE_CURRENT_SKIN, "picon_default.png")
						if fileExists(tmp):
							pngname = tmp
						else:
							pngname = resolveFilename(SCOPE_SKIN_IMAGE, "skin_default/picon_default.png")
					self.nameCache["default"] = pngname
			if self.pngname != pngname:
				self.instance.setPixmapFromFile(pngname)
				self.pngname = pngname

	def findPicon(self, serviceName):
		mappedServiceName = None
		if fileExists("/usr/share/enigma2/piconmapper.xml"):
			mappedServiceName = self.getPiconMapping(serviceName)
					
		for path in self.searchPaths:
			if not mappedServiceName is None:
				pngname = (path % self.path) + mappedServiceName + ".png"
				if fileExists(pngname):
					return pngname
			pngname = (path % self.path) + serviceName + ".png"
			if fileExists(pngname):
				return pngname
		return ""
		
	def getPiconMapping(self, serviceName):
		
		piconmapper = file("/usr/share/enigma2/piconmapper.xml")
		
		piconmapperdom = xml.etree.cElementTree.parse(piconmapper)
		
		piconmapper.close()
		
		xmldata = piconmapperdom.getroot()
		
		for x in xmldata.findall('piconmapping'):
			if x.get('sref') == serviceName:
				return x.get('picon')
		
		return None
