#
#  AddOnManager for OE 1.6
#  Coded by Dr.Best (c)2010
#  Support: www.dreambox-tools.info
#
#  This plugin is licensed under the Creative Commons 
#  Attribution-NonCommercial-ShareAlike 3.0 Unported 
#  License. To view a copy of this license, visit
#  http://creativecommons.org/licenses/by-nc-sa/3.0/ or send a letter to Creative
#  Commons, 559 Nathan Abbott Way, Stanford, California 94305, USA.
#
#  This plugin is NOT free software. It is open source, you are allowed to
#  modify it (if you keep the license), but it may not be commercially 
#  distributed.
#

from Screens.Screen import Screen
from enigma import eConsoleAppContainer
from Components.ActionMap import ActionMap
from Components.PluginComponent import plugins
from Components.Label import Label
from Screens.MessageBox import MessageBox
from Screens.Console import Console
from Plugins.Plugin import PluginDescriptor
from Tools.Directories import resolveFilename, SCOPE_PLUGINS, SCOPE_SKIN_IMAGE, fileExists, SCOPE_CURRENT_SKIN
from Tools.LoadPixmap import LoadPixmap

from Components.Pixmap import Pixmap
from Components.Sources.StaticText import StaticText
from Components.MultiContent import MultiContentEntryText, MultiContentEntryPixmapAlphaTest
from Components.MenuList import MenuList
from enigma import eListboxPythonMultiContent, gFont

def main(session,**kwargs):
    session.open(MerlinDownloadBrowser)

def Plugins(**kwargs):
    return [PluginDescriptor(name="Addon Manager", description=_("Manage your additional software"), where = [PluginDescriptor.WHERE_PLUGINMENU, PluginDescriptor.WHERE_EXTENSIONSMENU ], fnc=main, icon = "plugin.png")]

class MerlinPluginList(MenuList):
	def __init__(self, list, enableWrapAround=True):
		MenuList.__init__(self, list, enableWrapAround, eListboxPythonMultiContent)
		self.l.setFont(0, gFont("Regular", 20))
		self.l.setFont(1, gFont("Regular", 14))
		self.l.setItemHeight(50)


def AddOnCategoryComponent(name, png):
	res = [ name ]
	
	res.append(MultiContentEntryText(pos=(130, 20), size=(300, 25), font=0, text=name))
	res.append(MultiContentEntryPixmapAlphaTest(pos=(5, 20), size=(25,25), png = png))
	
	return res


def AddOnDownloadComponent(plugin, name):
	res = [ plugin ]
	text = ""
	if plugin.installed_version and plugin.installed_version != plugin.version:
		text = "%s -> updatable to %s" % (plugin.installed_version, plugin.version)
	elif plugin.installed_version:
		text = "Installed package version: %s" % (plugin.installed_version)
	else:
		text = "Package version: %s" % (plugin.version)
	
	res.append(MultiContentEntryText(pos=(50, 5), size=(640, 25), font=0, text = name))
	res.append(MultiContentEntryText(pos=(50, 30), size=(640, 17), font=1, text=plugin.description))
	res.append(MultiContentEntryText(pos=(50, 46), size=(640, 17), font=1, text=text))

	#if plugin.icon is None:
		#png = LoadPixmap(resolveFilename(SCOPE_SKIN_IMAGE, "skin_default/icons/plugin.png"))
	#else:
		#png = plugin.icon

	#res.append(MultiContentEntryPixmapAlphaTest(pos=(10, 0), size=(100, 50), png = png))

	if plugin.statusicon is None:
		if fileExists(resolveFilename(SCOPE_CURRENT_SKIN, "skin_default/icons/plugin.png")):
			png1 = LoadPixmap(resolveFilename(SCOPE_CURRENT_SKIN, "skin_default/icons/plugin.png"))
		else:
			png1 = LoadPixmap(resolveFilename(SCOPE_SKIN_IMAGE, "skin_default/icons/plugin.png"))
	else:
		png1 = plugin.statusicon

	res.append(MultiContentEntryPixmapAlphaTest(pos=(20,12), size=(14,14), png = png1))
	
	return res

class AddOnDescriptor:
	def __init__(self, name = "", what = "", description = "", status = 0, version = "", icon = None, statusicon = None, installed_version = ""):
		self.name = name
		self.what = what
		self.description = description
		self.status = status
		self.version = version
		if icon is None:
			self.icon = None
		else:
			self.icon = icon
		
		if statusicon is None:
			self.statusicon = None
		else:
			self.statusicon = statusicon
		self.installed_version = installed_version

class AddOn:
	def __init__(self, name = "", version = "", description = "", status = 0, installed_version = ""):
		self.name = name
		self.version = version
		self.description = description
		self.status = status
		self.installed_version = installed_version

class MerlinDownloadBrowser(Screen):

	skin = """
		<screen name="MerlinDownloadBrowser" position="center,center" size="660,475" title="Addon Manager">
			<widget font="Regular;20" halign="center" name="text" position="10,10" size="640,455" valign="center" zPosition="1"/>
			<widget name="list" position="10,10" scrollbarMode="showOnDemand" size="640,455" zPosition="2"/>
		</screen>"""
		

	def __init__(self, session, args = None):
		Screen.__init__(self, session)
		
		self.container = eConsoleAppContainer()
		self.appClosed_conn = self.container.appClosed.connect(self.runFinished)
		self.dataAvail_conn = self.container.dataAvail.connect(self.dataAvail)
		
		
		self.container2 = eConsoleAppContainer()
		self.appClosed_conn2 = self.container2.appClosed.connect(self.runFinished2)
		self.dataAvail_conn2 = self.container2.dataAvail.connect(self.dataAvail2)
		
		self.onLayoutFinish.append(self.startRun)
		self.onShown.append(self.setWindowTitle)
		
		self.list = []
		self["list"] = MerlinPluginList(self.list)
		self.pluginlist = []
		self.expanded = []
		self.addoninstalled = []
		self.found = 0
		
		self["text"] = Label(_("Downloading addon information. Please wait..."))
		
		self.run = 0

		self.remainingdata = ""
		self.afteractiondata = ""

		self["actions"] = ActionMap(["WizardActions"], 
		{
			"ok": self.go,
			"back": self.close,
		})
		
		self["list"].onSelectionChanged.append(self.updateSummary)
		self.onShown.append(self.updateSummary)
	
	def createSummary(self):
		return AddOnManagerLCDScreen
		
	def updateSummary(self):
		text = ""
		if len(self.list):
			selection = self["list"].getCurrent()
			text = selection[1][7]
		
		self.summaries.setText(text)

	def go(self):
		sel = self["list"].l.getCurrentSelection()

		if sel is None:
			return

		if type(sel[0]) is str: # category
			if sel[0] in self.expanded:
				self.expanded.remove(sel[0])
			else:
				self.expanded.append(sel[0])
			self.updateList()
		else:
			if sel[0].status == 0:
				self.session.openWithCallback(self.runInstall, MessageBox, _("Do you really want to download\nthe addon \"%s\"?") % sel[0].name)
			elif sel[0].status == 1:
				self.session.openWithCallback(self.runInstall, MessageBox, _("Do you really want to REMOVE\nthe addon \"%s\"?") % sel[0].name)
			elif sel[0].status == 2:
				self.session.openWithCallback(self.runDeleteUpdateCallBack, DialogUpdateDelete, _("The addon \"%s\" is already installed and an update is available.\nWhat do you want to do?") % sel[0].name)

	def runInstall(self, val):
		if val:
			if self["list"].l.getCurrentSelection()[0].status != 1:
				self.session.openWithCallback(self.installFinished, Console, cmdlist = ["opkg install " + self["list"].l.getCurrentSelection()[0].name])
			else:
				self.session.openWithCallback(self.installFinished, Console, cmdlist = ["opkg remove " + self["list"].l.getCurrentSelection()[0].name])
	
	def runDeleteUpdateCallBack(self, answer):
		print "answer:", answer
		if answer == 1:
			self.session.openWithCallback(self.installFinished, Console, cmdlist = ["opkg install " + self["list"].l.getCurrentSelection()[0].name])
		elif answer == 0:
			self.session.openWithCallback(self.installFinished, Console, cmdlist = ["opkg remove " + self["list"].l.getCurrentSelection()[0].name])


	def setWindowTitle(self):
		self.setTitle(_("Merlin AddOn Browser"))

	def startRun(self):
		print "startRun(self):"
		self["list"].instance.hide()
		self.container.execute("opkg update")

	def installFinished(self):
		self.container2.execute("opkg list-installed %s" % self["list"].l.getCurrentSelection()[0].name)
		
	def dataAvail2(self, str):
	      self.afteractiondata = self.afteractiondata = str
	      
	def runFinished2(self, retval):
	      lines = self.afteractiondata.split('\n')
	      name = ""
	      version = ""
	      for x in lines:
		  plugin = x.split(" - ")
		  if len(plugin) >= 2:
			  name = plugin[0]
			  version = plugin[1]
			  break
	      
	      if name != "" and version != "":
			for aa in self.pluginlist:
				if aa.name == name:
					if version == self["list"].l.getCurrentSelection()[0].version:
						aa.status = 1
						aa.installed_version = aa.version
					else:
						aa.status = 2
	      else:
		      for aa in self.pluginlist:
			      if aa.name == self["list"].l.getCurrentSelection()[0].name:
				      aa.status = 0
	      self.updateList()
	      plugins.readPluginList(resolveFilename(SCOPE_PLUGINS))
	      self["list"].instance.show()
	      self.afteractiondata = ""

	def runFinished(self, retval):
		self.remainingdata = ""
		if self.run == 0:
			self.run = 1
			self.container.execute("opkg list-installed enigma2-*")
		elif self.run == 1:
			self.run = 2
			self.container.execute("opkg list enigma2-*")
		elif self.run == 2:
			if len(self.pluginlist) > 0:
				self.updateList()
				self["list"].instance.show()
			else:
				self["text"].setText("No new plugins found")

	def dataAvail(self, str):
		#prepend any remaining data from the previous call
		str = self.remainingdata + str
		#split in lines
		lines = str.split('\n')
		#'str' should end with '\n', so when splitting, the last line should be empty. If this is not the case, we received an incomplete line
		if len(lines[-1]):
			#remember this data for next time
			self.remainingdata = lines[-1]
			lines = lines[0:-1]
		else:
			self.remainingdata = ""
		for x in lines:
			plugin = x.split(" - ")
			if len(plugin) >= 2 and self.run == 1:
				self.addoninstalled.append(AddOn(name = plugin[0], version = plugin[1], status = 1))
			elif len(plugin) == 3 and self.run == 2:
				flagStatus = 0 # nicht installiert
				installedVersion = ""
				for cb in self.addoninstalled:
					if plugin[0] == cb.name:
						if plugin[1] == cb.version:
							if cb.status != 2:
								flagStatus = 1 # installiert
								installedVersion = cb.version
							else:
								flagStatus = -1 # brauchen wir nicht, da schon als update gekennzeichnet
						else:
							cb.status = 2
							flagStatus = 2 # update
							installedVersion = cb.version
				if flagStatus != -1:
					self.pluginlist.append(AddOn(name = plugin[0], version = plugin[1], description = plugin[2], status = flagStatus, installed_version = installedVersion))

	def updateList(self):
		self.list = []
		
		if fileExists(resolveFilename(SCOPE_CURRENT_SKIN, "skin_default/icons/folder.png")):
			expandableIcon = LoadPixmap(resolveFilename(SCOPE_CURRENT_SKIN, "skin_default/icons/folder.png"))
		else:
			expandableIcon = LoadPixmap(resolveFilename(SCOPE_SKIN_IMAGE, "skin_default/icons/folder.png"))
		
		if fileExists(resolveFilename(SCOPE_CURRENT_SKIN, "skin_default/icons/lock_on.png")):
			expandedIcon = LoadPixmap(resolveFilename(SCOPE_CURRENT_SKIN, "skin_default/icons/lock_on.png"))
		else:
			expandedIcon = LoadPixmap(resolveFilename(SCOPE_SKIN_IMAGE, "skin_default/icons/lock_on.png"))
		
		if fileExists(resolveFilename(SCOPE_CURRENT_SKIN, "skin_default/verticalline-plugins.png")):
			verticallineIcon = LoadPixmap(resolveFilename(SCOPE_CURRENT_SKIN, "skin_default/verticalline-plugins.png"))
		else:
			verticallineIcon = LoadPixmap(resolveFilename(SCOPE_SKIN_IMAGE, "skin_default/verticalline-plugins.png"))
		
		installedIcon = LoadPixmap(resolveFilename(SCOPE_PLUGINS, "/usr/share/enigma2/Merlin/green.png"))
		notinstalledIcon = LoadPixmap(resolveFilename(SCOPE_PLUGINS, "/usr/share/enigma2/Merlin/red.png"))
		updateIcon = LoadPixmap(resolveFilename(SCOPE_PLUGINS, "/usr/share/enigma2/Merlin/blue.png"))
		self.plugins = {}
		for x in self.pluginlist:
			temp = ""
			temp1 = x.name
			if x.name.startswith('enigma2-skin-') or x.name.startswith('enigma2-cams-') or x.name.startswith('enigma2-configs-') or x.name.startswith('enigma2-picons-') or x.name.startswith('enigma2-languages-') or x.name.startswith('enigma2-merlinepgcenter-skin-') or x.name.startswith('enigma2-piconmapper-'):
				temp = x.name[8:]
			elif x.name.startswith('enigma2-plugin-'):
				temp = x.name[15:]
			else:
				continue
			split = temp.split('-')
			if len(split) < 2:
				print "len(split) < 2", split
				continue
			pluginname = temp[len(split[0])+1:]
			if split[0] == "skin":
				split[0] = "skins" # manuelle Korrektur, damit ich die CVS Skins nicht neu erstellen muss...
			if not self.plugins.has_key(split[0]):
				self.plugins[split[0]] = []
			if x.status == 0:			
				pngstatus = notinstalledIcon
			elif x.status == 1:
				pngstatus = installedIcon
			elif x.status == 2:
				pngstatus = updateIcon
			else:
				pngstatus = None
			self.plugins[split[0]].append((AddOnDescriptor(name = x.name, what = split[0], description = x.description, icon = verticallineIcon, status = x.status, version = x.version, statusicon = pngstatus, installed_version = x.installed_version), pluginname))
		for x in self.plugins.keys():
			if x in self.expanded:
				self.list.append(AddOnCategoryComponent(x, expandedIcon))
				for plugin in self.plugins[x]:
					self.list.append(AddOnDownloadComponent(plugin[0], plugin[1]))
			else:
				self.list.append(AddOnCategoryComponent(x, expandableIcon))
		self["list"].l.setItemHeight(65)
		self["list"].l.setList(self.list)

class DialogUpdateDelete(Screen):

	skin = """
		<screen name="DialogUpdateDelete" position="60,245" size="600,10" title="AddOnManager">
		<widget name="text" position="65,8" size="520,0" font="Regular;22" />
		<widget name="QuestionPixmap" pixmap="skin_default/icons/input_question.png" position="5,5" size="53,53" alphatest="on" />
		<widget name="list" position="100,100" size="480,375" />
		<applet type="onLayoutFinish">
# this should be factored out into some helper code, but currently demonstrates applets.
from enigma import eSize, ePoint

orgwidth = self.instance.size().width()
orgpos = self.instance.position()
textsize = self[&quot;text&quot;].getSize()

# y size still must be fixed in font stuff...
textsize = (textsize[0] + 50, textsize[1] + 50)
offset = 0
offset = 60
wsizex = textsize[0] + 60
wsizey = textsize[1] + offset
if (280 &gt; wsizex):
	wsizex = 280
wsize = (wsizex, wsizey)


# resize
self.instance.resize(eSize(*wsize))

# resize label
self[&quot;text&quot;].instance.resize(eSize(*textsize))

# move list
listsize = (wsizex, 50)
self[&quot;list&quot;].instance.move(ePoint(0, textsize[1]))
self[&quot;list&quot;].instance.resize(eSize(*listsize))

# center window
newwidth = wsize[0]
self.instance.move(ePoint(orgpos.x() + (orgwidth - newwidth)/2, orgpos.y()))
		</applet>
	</screen>"""

	def __init__(self, session, text,):
		Screen.__init__(self, session)
 		self["text"] = Label(text)
		self["Text"] = StaticText(text)
		self.text = text
		self["QuestionPixmap"] = Pixmap()
		self.list = []
		self.list = [ (_("Update Addon"), 0), (_("Delete Addon"), 1) ]
		self["list"] = MenuList(self.list)
		self["actions"] = ActionMap(["MsgBoxActions", "DirectionActions"], 
			{
				"cancel": self.cancel,
				"ok": self.ok,
				"up": self.up,
				"down": self.down,
				"left": self.left,
				"right": self.right,
				"upRepeated": self.up,
				"downRepeated": self.down,
				"leftRepeated": self.left,
				"rightRepeated": self.right
			}, -1)

	def __onShown(self):
		self.onShown.remove(self.__onShown)
	def cancel(self):
		self.close(-1)
	def ok(self):
		self.close(self["list"].getCurrent()[1] == 0)
	def up(self):
		self.move(self["list"].instance.moveUp)
	def down(self):
		self.move(self["list"].instance.moveDown)
	def left(self):
		self.move(self["list"].instance.pageUp)
	def right(self):
		self.move(self["list"].instance.pageDown)
	def move(self, direction):
		self["list"].instance.moveSelection(direction)
	def __repr__(self):
		return str(type(self)) + "(" + self.text + ")"

class AddOnManagerLCDScreen(Screen):
	skin = (
	"""	<screen name="AddOnManagerLCDScreen" position="0,0" size="132,64" id="1">
			<widget name="plugin" position="4,0" size="132,30" font="Regular;14"/>
			<widget name="addon" position="4,30" size="132,30" font="Regular;12"/>
		</screen>""",
	"""	<screen name="AddOnManagerLCDScreen" position="0,0" size="96,64" id="2">
			<widget name="plugin" position="0,0" size="96,30" font="Regular;14"/>
			<widget name="addon" position="0,30" size="96,30" font="Regular;12"/>
		</screen>""" )
	
	def __init__(self,session,parent):
		Screen.__init__(self, session)
		self["plugin"] = Label(_("Merlin AddOn Browser"))
		self["addon"] = Label("")
		
	def setText(self, text):
		self["addon"].setText(text)