#
# ChannelSelectionTitle
#
# Coded by dre (c) 2013 based on valioChSelTitle
# Support: www.dreambox-tools.info
# E-Mail: dre@dreambox-tools.info
#
# This renderer is open source but it is NOT free software.
#
# This renderer may only be distributed to and executed on hardware which
# is licensed by Dream Multimedia GmbH.
# In other words:
# It's NOT allowed to distribute any parts of this renderer or its source code in ANY way
# to hardware which is NOT licensed by Dream Multimedia GmbH.
# It's NOT allowed to execute this renderer and its source code or even parts of it in ANY way
# on hardware which is NOT licensed by Dream Multimedia GmbH.
#
# If you want to use or modify the code or parts of it,
# you have to keep MY license and inform me about the modifications by mail.
#

from Components.config import config, ConfigSelection
from Components.VariableText import VariableText
from Renderer import Renderer
from enigma import eLabel

class ChannelSelectionTitle(VariableText, Renderer):
	def __init__(self):
		Renderer.__init__(self)
		VariableText.__init__(self)

	GUI_WIDGET = eLabel

	def connect(self, source):
		Renderer.connect(self, source)
		self.changed((self.CHANGED_DEFAULT,))

	def changed(self, what):
		if what[0] == self.CHANGED_CLEAR:
			self.text = ""
		elif config.merlin2.skin_channellistheader.value == "2":
			pos = self.source.text.find("/")
			self.text = _("%s") %(self.source.text[pos+1:])
		elif config.merlin2.skin_channellistheader.value == "1":
			self.text = _("%s") %(self.source.text.replace('Channel Selection (', '('))
		elif config.merlin2.skin_channellistheader.value == "0":
			self.text = _("%s") %(self.source.text)