
from Components.ActionMap import HelpableActionMap, ActionMap
from Components.Button import Button
from Components.ConfigList import ConfigListScreen
from Components.config import config, getConfigListEntry
from Components.Label import Label
from Components.MenuList import MenuList
from Components.Sources.StaticText import StaticText
from Plugins.Plugin import PluginDescriptor
from Screens.HelpMenu import HelpableScreen
from Screens.MessageBox import MessageBox
from Screens.Screen import Screen
from Screens.Standby import TryQuitMainloop
from Tools.LoadPixmap import LoadPixmap
from enigma import RT_HALIGN_LEFT, RT_VALIGN_CENTER, eListboxPythonMultiContent, gFont, getDesktop
from os import walk as os_walk
from os import system as os_system

def main(session,**kwargs):
    session.open(DreamCC)



def autostart(reason, **kwargs):
	global DreamCC_auto
	if reason == 0:
		DreamCC_auto = DreamCCAuto()



def Plugins(**kwargs):
    return [PluginDescriptor(name="DreamCC", description=_("Dreambox Cam Center"), where = [PluginDescriptor.WHERE_PLUGINMENU, PluginDescriptor.WHERE_EXTENSIONSMENU ], icon="dreamcc.png", fnc=main),
			PluginDescriptor(where = PluginDescriptor.WHERE_AUTOSTART, fnc = autostart)]



def DreamCCExtra(name, index, isActive = False):
	res = [ index ]
	res.append((eListboxPythonMultiContent.TYPE_TEXT, 30, 5, 200, 24, 0, RT_HALIGN_LEFT|RT_VALIGN_CENTER ,name))
	if isActive:
		png = LoadPixmap("/usr/share/enigma2/Merlin/green.png")
	else:
		png = LoadPixmap("/usr/share/enigma2/Merlin/red.png")
	res.append((eListboxPythonMultiContent.TYPE_PIXMAP_ALPHATEST, 10, 10, 14, 14, png))
	return res



class DCCMenu(MenuList):
	def __init__(self, list, selection = 0, enableWrapAround=True):
		MenuList.__init__(self, list, enableWrapAround, eListboxPythonMultiContent)
		self.l.setFont(0, gFont("Regular", 20))
		self.l.setItemHeight(32)
		self.selection = selection

	def postWidgetCreate(self, instance):
		MenuList.postWidgetCreate(self, instance)
		self.moveToIndex(self.selection)


class DreamCCAuto:
	def __init__(self):
		self.readCurrent()
	
	def readCurrent(self):
		current = None
		try:
			clist = open("/etc/clist.list", "r")
		except:
			return None
		if clist is not None:
			for line in clist:
				current = line
			clist.close()
		scriptliste = []
		path = "/usr/script/cam/"
		for root, dirs, files in os_walk(path):
			for name in files:
				scriptliste.append(name)
		for lines in scriptliste:
			dat = path + lines 
			datei = open(dat, "r")
			for line in datei:
				if line[0:3] == "OSD":
					nam = line[5:len(line)-2]
					if current == nam:
						os_system(dat + " cam_startup &")
			datei.close()



class DreamCC(Screen):
	sz_w = getDesktop(0).size().width()
	if sz_w == 1280:
		HDSkn = True
	else:
		HDSkn = False
	if HDSkn:
		skin = """
			<screen position="center,140" size="400,400" title="DreamCC" >
				<ePixmap pixmap="/usr/lib/enigma2/python/Plugins/Extensions/DreamCC/buttons.png" position="100,355" size="200,40" alphatest="on" zPosition="5"/>
				<widget name="menu" position="5,5" size="390,340" scrollbarMode="showOnDemand" />
			</screen>"""
	else:
		skin = """
			<screen position="center,100" size="400,400" title="DreamCC" >
				<ePixmap pixmap="/usr/lib/enigma2/python/Plugins/Extensions/DreamCC/buttons.png" position="100,355" size="200,40" alphatest="on" zPosition="5"/>
				<widget name="menu" position="5,5" size="390,340" scrollbarMode="showOnDemand" />
			</screen>"""

	def __init__(self, session, args = 0):
		self.skin = DreamCC.skin
		self.session = session
		Screen.__init__(self, session)
		self.index = 0
		self.sclist = []
		self.namelist = []
		self.oldService = self.session.nav.getCurrentlyPlayingServiceReference()
		self["actions"] = ActionMap(["OkCancelActions", "ColorActions","MenuActions"],
		{
			"ok": self.action,
			"cancel": self.close,
			"green": self.action,
			"red": self.stop,
			"menu": self.openSkinSettings,
		}, -1)
		self.lastCam = self.readCurrent()
		self.softcamlist = []
		self["menu"] = DCCMenu(self.softcamlist)
		self.readScripts()
		
		self["menu"].onSelectionChanged.append(self.updateSummary)
		self.onShown.append(self.updateSummary)
		
	def getLastIndex(self):
		a = 0
		if len(self.namelist) > 0:
			for x in self.namelist:
				if x == self.lastCam:
					return a
				else:
					a+=1
		else:
			return -1
		return -1

	def action(self):
		self.session.nav.playService(None)
		last = self.getLastIndex()
		var = self["menu"].getSelectionIndex()
		if last > -1:
			if last == var:
				os_system("/usr/script/cam/" + self.sclist[var] + " cam_res &")
			else:
				os_system("/usr/script/cam/" + self.sclist[last] + " cam_down &")
				os_system("/usr/script/cam/" + self.sclist[var] + " cam_up &")
		else:
			os_system("/usr/script/cam/" + self.sclist[var] + " cam_up &")
		if last != var:
			self.lastCam = self["menu"].l.getCurrentSelection()[1][7]
			self.writeFile()
		self.readScripts()
		self.session.nav.playService(self.oldService)

	def writeFile(self):
		if not self.lastCam is None:
			clist = open("/etc/clist.list", "w")
			clist.write(self.lastCam)
			clist.close()

	def stop(self):
		self.session.nav.playService(None)
		last = self.getLastIndex()
		if last > -1:
			os_system("/usr/script/cam/" + self.sclist[last] + " cam_down &")
		else:
			return
		self.lastCam = "no"
		self.writeFile()
		os_system("sleep 1")
		self.readScripts()
		self.session.nav.playService(self.oldService)

	def readScripts(self):
		self.index = 0
		scriptliste = []
		pliste = []
		path = "/usr/script/cam/"
		for root, dirs, files in os_walk(path):
			for name in files:
				scriptliste.append(name)
		self.sclist = scriptliste
		i = len(self.softcamlist)
		del self.softcamlist[0:i]
		for lines in scriptliste:
			dat = path + lines 
			datei = open(dat, "r")
			for line in datei:
				if line[0:3] == "OSD":
					nam = line[5:len(line)-2]
					if not self.lastCam is None:
						if nam == self.lastCam:
							self.softcamlist.append(DreamCCExtra(name = nam, index = self.index, isActive = True))
						else:
							self.softcamlist.append(DreamCCExtra(name = nam, index = self.index, isActive = False))
						self.index += 1
					else:
						self.softcamlist.append(DreamCCExtra(name = nam, index = self.index, isActive = False))
						self.index += 1
					pliste.append(nam)
			datei.close()
			self["menu"].setList(self.softcamlist)
			self.namelist = pliste
	
	def readCurrent(self):
		try:
			clist = open("/etc/clist.list", "r")
		except:
			return None
		lastcam = "nothing"
		if not clist is None:
			for line in clist:
				lastcam = line
			clist.close()
		return lastcam

	def createSummary(self):
		return DreamCCLCDScreen
		
	def updateSummary(self):
		text = ""
		status = ""
		if len(self.softcamlist):
			selection = self["menu"].getCurrent()
			text = selection[1][7]
			if text == self.lastCam:
				status = "running"
			else:
				status = "stopped"
		self.summaries.setText(text, 1)
		self.summaries.setText(status, 2)
		
	def openSkinSettings(self):
		self.session.open(SkinSettingsDreamCC)

class DreamCCLCDScreen(Screen):
	skin = (
	"""<screen name="DreamCCLCDScreen" position="0,0" size="132,64" id="1">
		<widget name="plugin" position="4,0" size="132,35" font="Regular;16"/>
		<widget name="listentry" position="4,36" size="132,14" font="Regular;10"/>
		<widget name="status" position="4,49" size="132,14" font="Regular;10"/>
	</screen>""",
	"""<screen name="DreamCCLCDScreen" position="0,0" size="96,64" id="2">
		<widget name="plugin" position="0,0" size="96,35" font="Regular;14"/>
		<widget name="listentry" position="0,36" size="96,14" font="Regular;10"/>
		<widget name="status" position="0,49" size="96,14" font="Regular;10"/>
	</screen>""")

	def __init__(self, session, parent):
		Screen.__init__(self, session)
		self["plugin"] = Label("DreamCC")
		self["listentry"] = Label("test")
		self["status"] = Label("")

	def setText(self, text, line):
		if line == 1:
			self["listentry"].setText(text)
		if line == 2:
			self["status"].setText(text)

class SkinSettingsDreamCC(Screen, HelpableScreen, ConfigListScreen):
	skin = """
		<screen name="SkinSettingsDreamCC" position="center,center" size="600,400" title="Skin Settings" >
			<ePixmap pixmap="skin_default/buttons/red.png" position="0,0" zPosition="0" size="140,40" transparent="1" alphatest="on" />
			<ePixmap pixmap="skin_default/buttons/green.png" position="140,0" zPosition="0" size="140,40" transparent="1" alphatest="on" />
			<ePixmap pixmap="skin_default/buttons/yellow.png" position="280,0" zPosition="0" size="140,40" transparent="1" alphatest="on" />
			<ePixmap pixmap="skin_default/buttons/blue.png" position="420,0" zPosition="0" size="140,40" transparent="1" alphatest="on" />
			<widget render="Label" source="key_red" position="0,0" size="140,40" zPosition="5" valign="center" halign="center" backgroundColor="red" font="Regular;21" transparent="1" foregroundColor="white" shadowColor="black" shadowOffset="-1,-1" />
			<widget render="Label" source="key_green" position="140,0" size="140,40" zPosition="5" valign="center" halign="center" backgroundColor="red" font="Regular;21" transparent="1" foregroundColor="white" shadowColor="black" shadowOffset="-1,-1" />
			<widget render="Label" source="key_yellow" position="280,0" size="140,40" zPosition="5" valign="center" halign="center" backgroundColor="yellow" font="Regular;21" transparent="1" foregroundColor="white" shadowColor="black" shadowOffset="-1,-1" />
			<widget name="config" position="20,50" size="560,330" scrollbarMode="showOnDemand" />
		</screen>"""

	def __init__(self, session):
		Screen.__init__(self, session)
		HelpableScreen.__init__(self)
		self.setTitle(_("Skin Settings"))

		self["SetupActions"] = HelpableActionMap(self, "SetupActions",
		{
			"cancel":	(self.close, _("Discard changes and close")),
		}, -2)
		
		self["ColorActions"] = HelpableActionMap(self, "ColorActions",
		{
			"green":	(self.keySave, _("Save settings")),
			"red":		(self.keyCancel, _("Discard changes and close")),
		}, -2)
		
		self["key_blue"] = StaticText("")
		self["key_yellow"] = StaticText("")
		self["key_red"] = StaticText(_("Cancel"))
		self["key_green"] = StaticText(_("OK"))

		self.list = []
		ConfigListScreen.__init__(self, self.list, session = session)
		
		self.createConfig()
		config.merlin2.skin_showdecryption.addNotifier(self.createConfig)
		config.merlin2.skin_showfta.addNotifier(self.createConfig)
		config.merlin2.skin_simpledecodeinfo.addNotifier(self.createConfig)

	def createConfig(self,configElement=""):
		self.list = []

		self.list.append(getConfigListEntry(_("Show camd name"), config.merlin2.skin_showcamdname))
		self.list.append(getConfigListEntry(_("Show encryption"), config.merlin2.skin_showencryption))
		self.list.append(getConfigListEntry(_("Show decryption"), config.merlin2.skin_showdecryption))
		if config.merlin2.skin_showdecryption.value:
			self.list.append(getConfigListEntry(_("Show FTA"), config.merlin2.skin_showfta))
			if config.merlin2.skin_showfta.value:
				self.list.append(getConfigListEntry(_("FTA text"), config.merlin2.skin_ftatext))
			self.list.append(getConfigListEntry(_("Simple decodeinfo"), config.merlin2.skin_simpledecodeinfo))
			if not config.merlin2.skin_simpledecodeinfo.value:
				self.list.append(getConfigListEntry(_("Reader / source display"), config.merlin2.skin_readersource))
		else:
			config.merlin2.skin_showfta.value = False
			config.merlin2.skin_simpledecodeinfo.value = False
			
		self["config"].list = self.list
		self["config"].l.setList(self.list)

	def keySave(self):
		for x in self["config"].list:
			x[1].save()
		
		info = self.session.openWithCallback(self.restartGUI,MessageBox,_("Please restart enigma2 for changes to take effect. Restart now?"), MessageBox.TYPE_YESNO)
		info.setTitle(_("Skin Settings"))	
		#self.updateSkin()
	
	def restartGUI(self, answer):
		if answer:
			self.session.open(TryQuitMainloop, 3)


