// handlers

var AbstractMerlinContentHandler = Class.create(AbstractContentHandler, {
	show: function(data){
		this.data = data;
		MerlinTemplateEngine.process(this.tpl, data, this.target, this.finished.bind(this));
		}
});

var MerlinSimplePageHandler = Class.create(AbstractMerlinContentHandler, {
	initialize: function($super, target){
		$super(null, target);
	},
	
	show: function(tpl, data){
		MerlinTemplateEngine.process(tpl, data, this.target, this.finished.bind(this));
	}
});

var MerlinMenuHandler = Class.create(AbstractMerlinContentHandler,{
	initialize: function($super, target){
		$super('tplMerlinMenu', target);
		this.provider = new SimpleRequestProvider();
	},
	
	load: function(){
		this.show({});
	},
	
});

var MerlinSettingsListHandler = Class.create(AbstractMerlinContentHandler, {
	initialize: function($super, target){
		$super('tplMerlinSettings', target);
		this.provider = new MerlinSettingsListProvider(this.show.bind(this));
		this.ajaxload = true;
	}
});

var MerlinSettingsHandler = Class.create(AbstractMerlinContentHandler, {
	initialize: function($super, target, reloadCallback, onFinished){
		$super('tplMerlinSettings', target, onFinished);
		this.m = {};
		this.provider = new SimpleRequestProvider();
		this.ajaxload = true;
		this.reloadCallback = reloadCallback;
		this.dat = {};
	},
	
	simpleResultCallback: function(transport, callback){
		this.provider.simpleResultCallback(
			transport,
			function(result){
				this.showSimpleResult(result, callback);
			}.bind(this)
		);
	},
	
	showSimpleResult: function($super, result, callback){
		$super(result);
		if(callback){
			callback(result);
			return;
		} else if(this.reloadCallback){
			this.reloadCallback();
		}
	},
	
	change: function(m){
		var key, confignames="", configvalues="";
		for (key in m){
			if (m.hasOwnProperty(key))
			{
				if (confignames == "")
				{
					confignames = confignames + key;
					configvalues = configvalues + m[key];
				}
				else
				{
					confignames = confignames + "," + key;
					configvalues = configvalues + "," + m[key];
				}
			}
		}

		var parms = {
			'confignames' : confignames,
			'configvalues' : configvalues,
		};
		
		this.provider.simpleResultQuery(
			URL.merlinsettingssave,
			parms,
			this.simpleResultCallback.bind(this)
		);
	},
	
	commitForm: function(id){
		debug("MerlinSettingsHandler.commitForm");
		// as the serialize thing is not working for me (or I'm just too stupid), I use a little hack
		// by assigning the class MerlinSetting to all elements...
		var merlinsettings = new Array();
		var values = new Array();
		lastelement = "";
		$$('.MerlinSetting').each(function(element){
			if (element.type == "checkbox")
			{
				if (element.name == lastelement && element.checked == true)
				{
					values.push(element.value);
				}
				else if (element.name != lastelement && element.checked == true)
				{
					values = [];
					values.push(element.value);
				}
				else if (element.name != lastelement && element.checked == false)
				{
					values = [];
				}
				if (element.checked == true)
				{
					valuestring = "";
					for (var i=0; i< values.length; i++)
					{
						if (i == values.length-1)
						{
							valuestring += values[i];
						}
						else
						{
							valuestring += values[i] + "#";
						}
					}
					merlinsettings [ element.name ] = valuestring;
				}
				lastelement = element.name;
			}		
			else
			{
				merlinsettings[ element.name ] = element.value;
			}
		}
		);

		this.change(merlinsettings);
	},
	
	renderXML: function(xml){
		var list = new MerlinSettingsList(xml).getArray();
		return {merlinsettings : list};
	}
});

var ChannellistSettingsListHandler = Class.create(AbstractMerlinContentHandler, {
	initialize: function($super, target){
		$super('tplChannellistSettings', target);
		this.provider = new ChannellistSettingsListProvider(this.show.bind(this));
		this.ajaxload = true;
	}
});

var ChannellistSettingsHandler = Class.create(AbstractMerlinContentHandler, {
	initialize: function($super, target, reloadCallback, onFinished){
		$super('tplChannellistSettings', target, onFinished);
		this.m = {};
		this.provider = new SimpleRequestProvider();
		this.ajaxload = true;
		this.reloadCallback = reloadCallback;
		this.dat = {};
	},
	
	simpleResultCallback: function(transport, callback){
		this.provider.simpleResultCallback(
			transport,
			function(result){
				this.showSimpleResult(result, callback);
			}.bind(this)
		);
	},
	
	showSimpleResult: function($super, result, callback){
		$super(result);
		if(callback){
			callback(result);
			return;
		} else if(this.reloadCallback){
			this.reloadCallback();
		}
	},
	
	change: function(m){
		var key, confignames="", configvalues="";
		for (key in m){
			if (m.hasOwnProperty(key))
			{
				if (confignames == "")
				{
					confignames = confignames + key;
					configvalues = configvalues + m[key];
				}
				else
				{
					confignames = confignames + "," + key;
					configvalues = configvalues + "," + m[key];
				}
			}
		}

		var parms = {
			'confignames' : confignames,
			'configvalues' : configvalues,
		};
		
		this.provider.simpleResultQuery(
			URL.channellistsettingssave,
			parms,
			this.simpleResultCallback.bind(this)
		);
	},
	
	commitForm: function(id){
		debug("ChannellistSettingsHandler.commitForm");
		// as the serialize thing is not working for me (or I'm just too stupid), I use a little hack
		// by assigning the class MerlinSetting to all elements...
		var channellistsettings = new Array();
		$$('.ChannellistSetting').each(function(element){
			channellistsettings[ element.name ] = element.value;
			}
		);

		this.change(channellistsettings);
	},
	
	renderXML: function(xml){
		var list = new ChannellistSettingsList(xml).getArray();
		return {channellistsettings : list};
	}
});

var DMMSettingsListHandler = Class.create(AbstractMerlinContentHandler, {
	initialize: function($super, target){
		$super('tplMerlinSettings', target);
		this.provider = new DMMSettingsListProvider(this.show.bind(this));
		this.ajaxload = true;
	}
});

var DMMSettingsHandler = Class.create(AbstractMerlinContentHandler, {
	initialize: function($super, target, reloadCallback, onFinished){
		$super('tplMerlinSettings', target, onFinished);
		this.m = {};
		this.provider = new SimpleRequestProvider();
		this.ajaxload = true;
		this.reloadCallback = reloadCallback;
		this.dat = {};
	},
	
	simpleResultCallback: function(transport, callback){
		this.provider.simpleResultCallback(
			transport,
			function(result){
				this.showSimpleResult(result, callback);
			}.bind(this)
		);
	},
	
	showSimpleResult: function($super, result, callback){
		$super(result);
		if(callback){
			callback(result);
			return;
		} else if(this.reloadCallback){
			this.reloadCallback();
		}
	},
	
	change: function(m){
		var key, confignames="", configvalues="";
		for (key in m){
			if (m.hasOwnProperty(key))
			{
				if (confignames == "")
				{
					confignames = confignames + key;
					configvalues = configvalues + m[key];
				}
				else
				{
					confignames = confignames + "," + key;
					configvalues = configvalues + "," + m[key];
				}
			}
		}

		var parms = {
			'confignames' : confignames,
			'configvalues' : configvalues,
		};
		
		this.provider.simpleResultQuery(
			URL.dmmsettingssave,
			parms,
			this.simpleResultCallback.bind(this)
		);
	},
	
	commitForm: function(id){
		debug("DMMSettingsHandler.commitForm");
		// as the serialize thing is not working for me (or I'm just too stupid), I use a little hack
		// by assigning the class MerlinSetting to all elements...
		var dmmsettings = new Array();
		$$('.MerlinSetting').each(function(element){
			dmmsettings[ element.name ] = element.value;
			}
		);

		this.change(dmmsettings);
	},
	
	renderXML: function(xml){
		var list = new DMMSettingsList(xml).getArray();
		return {dmmsettings : list};
	}
});

var PiconMapperListHandler = Class.create(AbstractMerlinContentHandler, {
	initialize: function($super, target){
		$super('tplMerlinPiconMapper', target);
		this.provider = new PiconMapperListProvider(this.show.bind(this));
		this.ajaxload = true;
	}
});

var PiconMapperHandler = Class.create(AbstractMerlinContentHandler, {
	initialize: function($super, target, reloadCallback, onFinished){
		$super('tplMerlinPiconMapper', target, onFinished);
		this.pm = {};
		this.provider = new SimpleRequestProvider();
		this.ajaxload = true;
		this.reloadCallback = reloadCallback;
		this.dat = {};
	},
	
	renderXML: function(xml){
		var list = new PiconMappingList(xml).getArray();
		return {piconmapping : list};
	}
});

var MemDevicesListHandler = Class.create(AbstractMerlinContentHandler, {
	initialize: function($super, target){
		$super('tplMerlinMemoryInfo', target);
		this.provider = new MemDevicesListProvider(this.show.bind(this));
		this.ajaxload = true;
	}
});