#
#  Infobar Position
#
#  Coded by Dr.Best (c) 2010
#  Support: www.dreambox-tools.info
#
#  This plugin is licensed under the Creative Commons 
#  Attribution-NonCommercial-ShareAlike 3.0 Unported 
#  License. To view a copy of this license, visit
#  http://creativecommons.org/licenses/by-nc-sa/3.0/ or send a letter to Creative
#  Commons, 559 Nathan Abbott Way, Stanford, California 94305, USA.
#
#  Alternatively, this plugin may be distributed and executed on hardware which
#  is licensed by Dream Multimedia GmbH.

#  This plugin is NOT free software. It is open source, you are allowed to
#  modify it (if you keep the license), but it may not be commercially 
#  distributed other than under the conditions noted above.
#


from Screens.Screen import Screen
from Components.ActionMap import NumberActionMap
from enigma import ePoint, eTimer, getDesktop
from Components.config import config, ConfigInteger
from Screens.Standby import TryQuitMainloop
from Screens.MessageBox import MessageBox
from Components.Sources.StaticText import StaticText
from Screens.InfoBarGenerics import InfoBarAdditionalInfo, InfobarHbbtvPlugin

class InfobarPositionSetupHelpText(Screen):
	sz_w = getDesktop(0).size().width()
	skin = """<screen name="InfobarPositionSetupHelpText" position="0,0" size="%d,100" title="InfobarPositionSetup">
			<widget render="Label" source="helptext" position="40,40" size="%d,60" zPosition="1" valign="left" halign="center" font="Regular;21" transparent="1" foregroundColor="white"/>
		</screen>""" % (sz_w,sz_w)
	def __init__(self, session):
		Screen.__init__(self, session)
		self["helptext"] = StaticText(_("Use direction keys to move the Infobar window.\nPress OK save, EXIT to cancel or red button for original position."))

class InfobarPositionSetup(Screen, InfoBarAdditionalInfo,  InfobarHbbtvPlugin):

	INFOBAR = 0
	MOVIEPLAYER = 1

	def __init__(self, session, mode):
		Screen.__init__(self, session)
		InfoBarAdditionalInfo.__init__(self)
		InfobarHbbtvPlugin.__init__(self)
		self["actions"] = NumberActionMap(["WizardActions", "InputActions", "ColorActions"], 
		{
			"ok": self.go,
			"back": self.exit,
			"up": self.up,
			"down": self.down,
			"left": self.left,
			"right": self.right,
			"red": self.red,
		}, -1)
		self.mode = mode
		if self.mode == self.INFOBAR:
			self.skinName = "InfoBar"
		else:
			self.skinName = "MoviePlayer"
		self.onExecBegin.append(self.__onExecBegin)

	def __onExecBegin(self):
		self.orgpos = self.instance.position()
		if self.mode == self.INFOBAR:
			offsetX = config.merlin2.infobar_position_offset_x.value
			offsetY = config.merlin2.infobar_position_offset_y.value
		else:
			offsetX = config.merlin2.movieplayer_infobar_position_offset_x.value
			offsetY = config.merlin2.movieplayer_infobar_position_offset_y.value
		self.instance.move(ePoint(self.orgpos.x() + offsetX, self.orgpos.y() + offsetY))
		self.screenInfobarPositionSetupHelpText = self.session.instantiateDialog(InfobarPositionSetupHelpText)
		self.screenInfobarPositionSetupHelpText.show()


	def red(self):
		self.instance.move(ePoint(self.orgpos.x(), self.orgpos.y()))
		print "[InfobarPositionSetup] New skin position: x = %d, y = %d" % (self.instance.position().x(), self.instance.position().y())
		
	def go(self):
		if self.mode == self.INFOBAR:
			config.merlin2.infobar_position_offset_x.value = self.instance.position().x() - self.orgpos.x()
			config.merlin2.infobar_position_offset_x.save()
			config.merlin2.infobar_position_offset_y.value = self.instance.position().y() - self.orgpos.y()
			config.merlin2.infobar_position_offset_y.save()
			# apply changes immediately
			from Screens.InfoBar import InfoBar
			InfoBar.instance.instance.move(ePoint(self.instance.position().x(), self.instance.position().y()))

		else:
			config.merlin2.movieplayer_infobar_position_offset_x.value = self.instance.position().x() - self.orgpos.x()
			config.merlin2.movieplayer_infobar_position_offset_x.save()
			config.merlin2.movieplayer_infobar_position_offset_y.value = self.instance.position().y() - self.orgpos.y()
			config.merlin2.movieplayer_infobar_position_offset_y.save()
		self.exit()

	def exit(self):
		self.screenInfobarPositionSetupHelpText.doClose()
		self.close()
	
	def moveRelative(self, x=0, y=0):
		self.instance.move(ePoint(self.instance.position().x() + x, self.instance.position().y() + y))
		print "[InfobarPositionSetup] New skin position: x = %d, y = %d" % (self.instance.position().x() + x, self.instance.position().y() + y)
	
	def up(self):
		self.moveRelative(y =  - 2)

	def down(self):
		self.moveRelative(y =  2)
	
	def left(self):
		self.moveRelative(x = - 2)
	
	def right(self):
		self.moveRelative(x =  2)
	

