#
# MerlinWebInterface
#
# Coded by dre (c) 2012
# Support: www.dreambox-tools.info
# E-Mail: dre@dreambox-tools.info
#
# This plugin is open source but it is NOT free software.
#
# This plugin may only be distributed to and executed on hardware which
# is licensed by Dream Multimedia GmbH.
# In other words:
# It's NOT allowed to distribute any parts of this plugin or its source code in ANY way
# to hardware which is NOT licensed by Dream Multimedia GmbH.
# It's NOT allowed to execute this plugin and its source code or even parts of it in ANY way
# on hardware which is NOT licensed by Dream Multimedia GmbH.
#
# If you want to use or modify the code or parts of it,
# you have to keep MY license and inform me about the modifications by mail.

from Components.Sources.Source import Source
from enigma import eEnv
import xml.etree.cElementTree

class PiconMappings(Source):
	PICONMAPPINGS = 0
	def __init__(self, session, func):
		self.func = func
		self.session = session
		Source.__init__(self)

	def handleCommand(self, cmd):
		if self.func is self.PICONMAPPINGS:
			self.result = self.getPiconMappings('piconmapper.xml')
		else:
			self.result = False

	def getPiconMappings(self, setupfile):
		merlinConfigList = []

		self.getDescription(merlinConfigList, setupfile)
		
		return merlinConfigList
	
	def getDescription(self, merlinConfigList, setupfile):
		try:
			setupfile_merlin = file(eEnv.resolve('${datadir}/enigma2/%s' %(setupfile)), 'r')
		except:
			pass
		setupdom_merlin = xml.etree.cElementTree.parse(setupfile_merlin)
		setupfile_merlin.close()

		xmldata = setupdom_merlin.getroot()
		for x in xmldata.findall("piconmapping"):
			channel = _(x.get("channel", "??").encode("UTF-8"))
			localsref = (x.get("localsref", "??").encode("UTF-8"))
			satsref = (x.get("satsref", "??").encode("UTF-8"))

			merlinConfigList.append((channel, localsref, satsref))
			
		print merlinConfigList
			
	def getText(self):
		self.handleCommand(None)
		if self.result:
			return str(self.result)
		else:
			return ""

	def getList(self):
		self.handleCommand(None)
		list = self.result
		if list is None:
			list = ()

		return list

	text = property(getText)
	list = property(getList)
	lut = {"Channel": 0, "LocalServicereference": 1, "SatServicereference": 2}
