﻿# -*- coding: utf-8 -*-
from Plugins.Extensions.MediaPortal.plugin import _
from Plugins.Extensions.MediaPortal.resources.imports import *

def deluxemusicGenreListEntry(entry):
	return [entry,
		(eListboxPythonMultiContent.TYPE_TEXT, 20, 0, 860, 25, 0, RT_HALIGN_CENTER | RT_VALIGN_CENTER, entry[0])
		]

def deluxemusicListEntry(entry):
	return [entry,
		(eListboxPythonMultiContent.TYPE_TEXT, 20, 0, 860, 25, 0, RT_HALIGN_LEFT | RT_VALIGN_CENTER, entry[0])
		]

class deluxemusicGenreScreen(MPScreen):

	def __init__(self, session):

		self.plugin_path = mp_globals.pluginPath
		self.skin_path =  mp_globals.pluginPath + "/skins"

		path = "%s/%s/defaultGenreScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + "/original/defaultGenreScreen.xml"

		with open(path, "r") as f:
			self.skin = f.read()
			f.close()

		MPScreen.__init__(self, session)

		self["actions"]  = ActionMap(["MP_Actions"], {
			"0"		: self.closeAll,
			"ok"    : self.keyOK,
			"cancel": self.keyCancel
		}, -1)

		self.lastservice = session.nav.getCurrentlyPlayingServiceReference()
		self.playing = False

		self.keyLocked = True
		self['title'] = Label("Deluxemusic.tv")
		self['ContentTitle'] = Label("Genre:")

		self.genreliste = []
		self.chooseMenuList = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self.chooseMenuList.l.setFont(0, gFont('mediaportal', 23))
		self.chooseMenuList.l.setItemHeight(25)
		self['liste'] = self.chooseMenuList

		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		self.genreliste = [('Deluxemusic Live',"http://deluxemusic.tv.cms.ipercast.net/?ContentId=349")]

		self.chooseMenuList.setList(map(deluxemusicGenreListEntry, self.genreliste))
		self.keyLocked = False

	def keyOK(self):
		if self.keyLocked:
			return
		deluxemusicName = self['liste'].getCurrent()[0][0]
		deluxemusicUrl = self['liste'].getCurrent()[0][1]

		print deluxemusicName, deluxemusicUrl
		getPage(deluxemusicUrl, headers={'Content-Type':'application/x-www-form-urlencoded'}).addCallback(self.loadPageData).addErrback(self.dataError)

	def loadPageData(self, data):
		url = re.findall('file: "(.*?)"', data, re.S)
		if url:
			getPage(url[0], headers={'Content-Type':'application/x-www-form-urlencoded'}).addCallback(self.getStream).addErrback(self.dataError)

	def getStream(self, data):
		rtmp_infos = re.findall('<location>(.*?)</location.*?<meta rel="streamer">(.*?)<', data, re.S)
		if rtmp_infos:
			if len(rtmp_infos[0]) == 2:
				(playpath, rtmp) = rtmp_infos[0]
				stream_url = "%s%s" % (rtmp, playpath)
				playlist = []
				playlist.append(("Deluxemusic.tv", stream_url))
				self.session.open(SimplePlayer, playlist, showPlaylist=False)