﻿# -*- coding: utf-8 -*-
from Plugins.Extensions.MediaPortal.plugin import _
from Plugins.Extensions.MediaPortal.resources.imports import *

def netzKinoGenreListEntry(entry):
	return [entry,
		(eListboxPythonMultiContent.TYPE_TEXT, 20, 0, 860, 25, 0, RT_HALIGN_CENTER | RT_VALIGN_CENTER, entry[1])
		]

class netzKinoGenreScreen(MPScreen):

	def __init__(self, session):
		self.plugin_path = mp_globals.pluginPath
		self.skin_path =  mp_globals.pluginPath + "/skins"
		path = "%s/%s/defaultGenreScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + "/original/defaultGenreScreen.xml"
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()
		MPScreen.__init__(self, session)

		self["actions"]  = ActionMap(["MP_Actions"], {
			"0"		: self.closeAll,
			"ok"    : self.keyOK,
			"cancel": self.keyCancel
		}, -1)

		self['title'] = Label("Netzkino.de")
		self['ContentTitle'] = Label("Genre:")

		self.genreliste = []
		self.chooseMenuList = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self.chooseMenuList.l.setFont(0, gFont('mediaportal', 23))
		self.chooseMenuList.l.setItemHeight(25)
		self['liste'] = self.chooseMenuList

		self.onLayoutFinish.append(self.layoutFinished)

	def layoutFinished(self):
		self.genreliste.append(('81', 'Neu bei Netzkino'))
		self.genreliste.append(('61', 'HD-Kino'))
		self.genreliste.append(('39', 'Starkino'))
		self.genreliste.append(('1', 'Actionkino'))
		self.genreliste.append(('4', 'Dramakino'))
		self.genreliste.append(('32', 'Thrillerkino'))
		self.genreliste.append(('18', 'Liebesfilmkino'))
		self.genreliste.append(('6', 'Scifikino'))
		self.genreliste.append(('51', 'Arthousekino'))
		self.genreliste.append(('31', 'Queerkino'))
		self.genreliste.append(('3', 'Spasskino'))
		self.genreliste.append(('10', 'Asiakino'))
		self.genreliste.append(('5', 'Horrorkino'))
		self.genreliste.append(('33', 'Klassikerkino'))
		self.genreliste.append(('34', 'Westernkino'))
		self.genreliste.append(('71', 'Kino ab 18'))
		self.chooseMenuList.setList(map(netzKinoGenreListEntry, self.genreliste))

	def keyOK(self):
		Name = self['liste'].getCurrent()[0][1]
		genreID = self['liste'].getCurrent()[0][0]
		self.session.open(netzKinoFilmeScreen, genreID, Name)

def netzKinoFilmeListEntry(entry):
	return [entry,
		(eListboxPythonMultiContent.TYPE_TEXT, 20, 0, 860, 25, 0, RT_HALIGN_LEFT | RT_VALIGN_CENTER, entry[0])
		]

class netzKinoFilmeScreen(MPScreen, ThumbsHelper):

	def __init__(self, session, genreID, Name):
		self.genreID = genreID
		self.Name = Name
		self.plugin_path = mp_globals.pluginPath
		self.skin_path =  mp_globals.pluginPath + "/skins"
		path = "%s/%s/defaultGenreScreenCover.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + "/original/defaultGenreScreenCover.xml"
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()
		MPScreen.__init__(self, session)
		ThumbsHelper.__init__(self)

		self["actions"]  = ActionMap(["MP_Actions"], {
			"0"		: self.closeAll,
			"ok" : self.keyOK,
			"cancel" : self.keyCancel,
			"5" : self.keyShowThumb,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft
		}, -1)

		self['title'] = Label("Netzkino.de")
		self['ContentTitle'] = Label("Film Auswahl: %s" % self.Name)
		self['name'] = Label(_("Selection:"))

		self.keyLocked = True

		self.filmliste = []
		self.chooseMenuList = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self.chooseMenuList.l.setFont(0, gFont('mediaportal', 23))
		self.chooseMenuList.l.setItemHeight(25)
		self['liste'] = self.chooseMenuList

		self.onLayoutFinish.append(self.layoutFinished)

	def layoutFinished(self):
		self.keyLocked = True
		url = "http://www.netzkino.de/capi/get_category_posts?id=%s&count=500&custom_fields=Streaming" % self.genreID
		getPage(url, headers={'Content-Type':'application/x-www-form-urlencoded'}).addCallback(self.genreData).addErrback(self.dataError)

	def genreData(self, data):
		nkDaten = re.findall('"title_plain":"(.*?)".*?"images":."full":."url":"(.*?)".*?"custom_fields":\{(.*?\})', data, re.S|re.I)
		if nkDaten:
			for (nkTitle,nkImage,nkStream) in nkDaten:
				nkImage = nkImage.replace('\\','')
				nkUrl = re.findall('"Streaming":."(.*?)"', nkStream)
				if nkUrl:
					nkUrl = "http://pmd.netzkino-seite.netzkino.de/%s.mp4" % nkUrl[0].replace('\\','').replace('\\','')
					self.filmliste.append((decodeHtml(nkTitle),nkImage,nkUrl))
				self.chooseMenuList.setList(map(netzKinoFilmeListEntry, self.filmliste))
			self.keyLocked = False
			self.th_ThumbsQuery(self.filmliste, 0, 2, 1, None, None, 1, 1)
			self.showInfos()

	def showInfos(self):
		nkTitle = self['liste'].getCurrent()[0][0]
		nkImage = self['liste'].getCurrent()[0][1]
		self['name'].setText(nkTitle)
		CoverHelper(self['coverArt']).getCover(nkImage)

	def keyOK(self):
		if self.keyLocked:
			return
		nkLink = self['liste'].getCurrent()[0][2]
		nkTitle = self['liste'].getCurrent()[0][0]
		self.session.open(SimplePlayer, [(nkTitle, nkLink)], showPlaylist=False, ltype='netzkino')