﻿# -*- coding: utf-8 -*-
from Plugins.Extensions.MediaPortal.plugin import _
from Plugins.Extensions.MediaPortal.resources.imports import *
from Plugins.Extensions.MediaPortal.resources.simpleplayer import SimplePlayer, SimplePlaylist

FGTV_Version = "fashionguide-tv.com v0.90"

FGTV_siteEncoding = 'utf-8'

def FashionGuideTvGenreListEntry(entry):
	return [entry,
		(eListboxPythonMultiContent.TYPE_TEXT, 20, 0, 860, 25, 0, RT_HALIGN_CENTER | RT_VALIGN_CENTER, entry[1])
		]

class FashionGuideTvGenreScreen(MPScreen):

	def __init__(self, session):
		self.plugin_path = mp_globals.pluginPath
		self.skin_path =  mp_globals.pluginPath + "/skins"
		path = "%s/%s/defaultGenreScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + "/original/defaultGenreScreen.xml"
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()

		MPScreen.__init__(self, session)

		self["actions"]  = ActionMap(["OkCancelActions", "ShortcutActions", "WizardActions", "ColorActions", "SetupActions", "NumberActions", "MenuActions"], {
			"0"		: self.closeAll,
			"ok"    : self.keyOK,
			"cancel": self.keyCancel
		}, -1)

		self['title'] = Label(FGTV_Version)
		self['ContentTitle'] = Label("M e n ü")
		self['name'] = Label(_("Selection:"))
		self['F1'] = Label(_("Exit"))

		self.genreliste = []
		self.chooseMenuList = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self.chooseMenuList.l.setFont(0, gFont('mediaportal', 23))
		self.chooseMenuList.l.setItemHeight(25)
		self['liste'] = self.chooseMenuList

		self.onLayoutFinish.append(self.layoutFinished)

	def layoutFinished(self):
		self.genreliste.append((1,'Aktuelles Programm', 'http://www.fashionguide-tv.tv.grid-tv.com/?contentpart=prog_video'))
		self.genreliste.append((2,'Filme auf Abruf', 'http://www.fashionguide-tv.tv.grid-tv.com/c/mid,1540,Filme_auf_Abruf/'))
		self.genreliste.append((3,'TV-Programmvorschau', 'http://www.fashionguide-tv.tv.grid-tv.com/c/mid,2420,Programmhinweis/'))
		self.chooseMenuList.setList(map(FashionGuideTvGenreListEntry, self.genreliste))

	def keyOK(self):
		genreID = self['liste'].getCurrent()[0][0]
		genre = self['liste'].getCurrent()[0][1]
		tvLink = self['liste'].getCurrent()[0][2]
		if genreID == 1:
			self.session.open(
				GermanyTVPlayer2,
				[(genre, tvLink)],
				'Fashion-TV - aktuelles Programm'
				)
		else:
			self.session.open(FashionGuideTvListScreen, genreID, tvLink, genre)

def FashionGuideTvListEntry(entry):
	return [entry,
		(eListboxPythonMultiContent.TYPE_TEXT, 20, 0, 900, 50, 0, RT_HALIGN_LEFT | RT_VALIGN_CENTER, entry[0]+entry[1])
		]

class FashionGuideTvListScreen(MPScreen):

	def __init__(self, session, genreID, tvLink, stvGenre):
		self.genreID = genreID
		self.tvLink = tvLink
		self.genreName = stvGenre
		self.plugin_path = mp_globals.pluginPath
		self.skin_path =  mp_globals.pluginPath + "/skins"
		path = "%s/%s/defaultGenreScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + "/original/defaultGenreScreen.xml"
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()

		MPScreen.__init__(self, session)

		self["actions"] = ActionMap(["MP_Actions"], {
			"0" : self.closeAll,
			"ok" : self.keyOK,
			"cancel" : self.keyCancel,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft
		}, -1)

		self['title'] = Label(FGTV_Version)
		self['ContentTitle'] = Label("Genre: %s" % self.genreName)
		self['F1'] = Label(_("Exit"))
		self.keyLocked = True
		self.baseUrl = "http://www.fashionguide-tv.tv"

		self.filmliste = []
		self.chooseMenuList = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self.chooseMenuList.l.setFont(0, gFont('mediaportal', 23))
		self.chooseMenuList.l.setItemHeight(50)
		self['liste'] = self.chooseMenuList

		self.onLayoutFinish.append(self.layoutFinished)

	def layoutFinished(self):
		self.keyLocked = True
		print "getPage: ",self.tvLink
		getPage(self.tvLink, headers={'Content-Type':'application/x-www-form-urlencoded'}).addCallback(self.genreData).addErrback(self.dataError)

	def genreData(self, data):
		print "genreData:"
		if self.genreID == 2:
			stvDaten = re.findall('<a href="\?v=(.*?)" title="(.*?)".*?<img src="(.*?)".*?_time">(.*?)<', data)
			if stvDaten:
				print "Movies found"
				for (href,title,img,dura) in stvDaten:
					self.filmliste.append(('',title.replace(' - ','\n',1)+' ['+dura+']',href,img))
				self.keyLocked = False
			else:
				self.filmliste.append(('Keine Filme gefunden !','','',''))
			self.chooseMenuList.setList(map(FashionGuideTvListEntry, self.filmliste))
		elif self.genreID == 3:
			m = re.search('<div id="bx_main_c">(.*?)"center">', data, re.S)
			if m:
				stvDaten = re.findall('<td .*?<strong>(.*?)</strong></td>.*?title="(.*?)"><img src="(.*?)".*?onclick=', m.group(1), re.S)
			if stvDaten:
				print "EPG Data found"
				for (ptime,title,img) in stvDaten:
					title = title.replace(' - ','\n\t',1)
					self.filmliste.append((ptime+'\t',title,'',img))
				self.keyLocked = False
			else:
				self.filmliste.append(('Keine Programmdaten gefunden !','','',''))
			self.chooseMenuList.setList(map(FashionGuideTvListEntry, self.filmliste))
		else:
			print "Wrong genre"

	def keyOK(self):
		if self.keyLocked:
			return
		if self.genreID == 2:
			self.session.open(
				GermanyTVPlayer,
				self.filmliste,
				"http://www.fashionguide-tv.tv.grid-tv.com/inc/mod/video/play.php/vid,%s/q,mp4/typ,ondemand/file.mp4",
				playIdx = self['liste'].getSelectedIndex(),
				playAll = True,
				listTitle = self.genreName
				)

class GermanyTVPlayer(SimplePlayer):

	def __init__(self, session, playList, tvLink, playIdx=0, playAll=False, listTitle=None):
		print "GermanyTVPlayer:"
		self.tvLink = tvLink
		SimplePlayer.__init__(self, session, playList, playIdx, playAll, listTitle, listEntryPar=[20, 0, 860, 50, 0, '', 0, 1], useResume=False)

	def getVideo(self):
		tvLink = self.tvLink % self.playList[self.playIdx][2]
		tvTitle = self.playList[self.playIdx][1]
		self.playStream(tvTitle, tvLink)

class GermanyTVPlayer2(SimplePlayer):

	def __init__(self, session, playList, tvTitle, playIdx=0, playAll=False, listTitle=None):
		print "GermanyTVPlayer2:"
		self.tvLink = None
		self.tryCount = 7
		self.tvTitle = tvTitle

		SimplePlayer.__init__(self, session, playList, playIdx, playAll, listTitle, showPlaylist=False, useResume=False)

	def getVideo(self):
		url = self.playList[self.playIdx][1]
		getPage(url, headers={'Content-Type':'application/x-www-form-urlencoded'}).addCallback(self.genreData).addErrback(self.dataError)

	def genreData(self, data):
		tvStream = re.findall('video src=&quot;(.*?)&quot;', data)
		if tvStream:
			print "TV stream found"
			if self.tvLink != tvStream[0]:
				self.tvLink = tvStream[0]
				self.playStream(self.tvTitle, self.tvLink)
			elif self.tryCount:
				self.tryCount -= 1
				self.getVideo()

	def doEofInternal(self, playing):
		print "doEofInt:"
		if playing == True:
			self.tryCount = 7
			reactor.callLater(1, self.getVideo)
