﻿# -*- coding: utf-8 -*-
from Plugins.Extensions.MediaPortal.plugin import _
from Plugins.Extensions.MediaPortal.resources.imports import *

def appletrailersGenreListEntry(entry):
	return [entry,
		(eListboxPythonMultiContent.TYPE_TEXT, 20, 0, 860, 25, 0, RT_HALIGN_CENTER | RT_VALIGN_CENTER, entry[0])
		]

def appletrailersFilmListEntry(entry):
	return [entry,
		(eListboxPythonMultiContent.TYPE_TEXT, 20, 0, 860, 25, 0, RT_HALIGN_LEFT | RT_VALIGN_CENTER, entry[0])
		]

class appletrailersGenreScreen(MPScreen):

	def __init__(self, session):
		self.plugin_path = mp_globals.pluginPath
		self.skin_path =  mp_globals.pluginPath + "/skins"
		path = "%s/%s/defaultGenreScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + "/original/defaultGenreScreen.xml"
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()

		MPScreen.__init__(self, session)

		self["actions"]  = ActionMap(["MP_Actions"], {
			"ok" : self.keyOK,
			"0" : self.closeAll,
			"cancel" : self.keyCancel,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft
		}, -1)

		self['title'] = Label("Apple Movie Trailers")
		self['ContentTitle'] = Label("Genre:")
		self.keyLocked = True
		self.suchString = ''

		self.genreliste = []
		self.chooseMenuList = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self.chooseMenuList.l.setFont(0, gFont('mediaportal', 23))
		self.chooseMenuList.l.setItemHeight(25)
		self['liste'] = self.chooseMenuList

		self.onLayoutFinish.append(self.layoutFinished)

	def layoutFinished(self):
		self.genreliste.append(("Newest (HD-1080p)", "http://trailers.apple.com/trailers/home/xml/newest_720p.xml", "1080p"))
		self.genreliste.append(("Current (HD-1080p)", "http://trailers.apple.com/trailers/home/xml/current_720p.xml", "1080p"))
		self.genreliste.append(("Newest (HD-720p)", "http://trailers.apple.com/trailers/home/xml/newest_720p.xml", "720p"))
		self.genreliste.append(("Current (HD-720p)", "http://trailers.apple.com/trailers/home/xml/current_720p.xml", "720p"))
		self.genreliste.append(("Newest (HD-480p)", "http://trailers.apple.com/trailers/home/xml/newest_480p.xml", "480p"))
		self.genreliste.append(("Current (HD-480p)", "http://trailers.apple.com/trailers/home/xml/current_480p.xml", "480p"))
		self.genreliste.append(("Newest (SD)", "http://trailers.apple.com/trailers/home/xml/newest.xml", "SD"))
		self.genreliste.append(("Current (SD)", "http://trailers.apple.com/trailers/home/xml/current.xml", "SD"))
		self.chooseMenuList.setList(map(appletrailersGenreListEntry, self.genreliste))
		self.keyLocked = False

	def keyOK(self):
		if self.keyLocked:
			return
		Link = self['liste'].getCurrent()[0][1]
		HD = self['liste'].getCurrent()[0][2]
		self.session.open(appletrailersFilmScreen, Link, HD)

class appletrailersFilmScreen(MPScreen, ThumbsHelper):

	def __init__(self, session, Link, HD):
		self.Link = Link
		self.HD = HD
		self.plugin_path = mp_globals.pluginPath
		self.skin_path =  mp_globals.pluginPath + "/skins"
		path = "%s/%s/defaultListScreen.xml" % (self.skin_path, config.mediaportal.skin.value)
		if not fileExists(path):
			path = self.skin_path + "/original/defaultListScreen.xml"
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()
		MPScreen.__init__(self, session)
		ThumbsHelper.__init__(self)

		self.useragent = "QuickTime/7.6.2 (qtver=7.6.2;os=Windows NT 5.1Service Pack 3)"

		try:
			config.mediaplayer.useAlternateUserAgent.value = True
			config.mediaplayer.alternateUserAgent.value = self.useragent
			config.mediaplayer.useAlternateUserAgent.save()
			config.mediaplayer.alternateUserAgent.save()
			config.mediaplayer.save()
		except Exception, errormsg:
			config.mediaplayer = ConfigSubsection()
			config.mediaplayer.useAlternateUserAgent = ConfigYesNo(default=True)
			config.mediaplayer.alternateUserAgent = ConfigText(default=self.useragent)

		self["actions"]  = ActionMap(["MP_Actions"], {
			"0" : self.closeAll,
			"5" : self.keyShowThumb,
			"ok" : self.keyOK,
			"cancel" : self.keyCancel,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft
		}, -1)

		self['title'] = Label("Apple Movie Trailers")
		self['ContentTitle'] = Label("Film Auswahl")

		self.keyLocked = True

		self.filmliste = []
		self.chooseMenuList = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self.chooseMenuList.l.setFont(0, gFont('mediaportal', 23))
		self.chooseMenuList.l.setItemHeight(25)
		self['liste'] = self.chooseMenuList

		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		self.keyLocked = True
		self.filmliste = []
		url = self.Link
		getPage(url, headers={'Content-Type':'application/x-www-form-urlencoded'}).addCallback(self.loadData).addErrback(self.dataError)

	def loadData(self, data):
		Movies = re.findall('<movieinfo.*?<title>(.*?)</title>.*?<runtime>(.*?)</runtime>.*?<location>(.*?)</location>.*?<large filesize=".*?">(.*?)</large>', data, re.S)
		if Movies:
			for (Title, Runtime, Image, Url) in Movies:
				self.filmliste.append((decodeHtml(Title), Url, Image, Runtime))
			self.chooseMenuList.setList(map(appletrailersFilmListEntry, self.filmliste))
			self.th_ThumbsQuery(self.filmliste, 0, 1, 2, None, None, 1, 1)
			self.showInfos()

	def showInfos(self):
		title = self['liste'].getCurrent()[0][0]
		coverUrl = self['liste'].getCurrent()[0][2]
		runtime = self['liste'].getCurrent()[0][3]
		self['name'].setText(title)
		self['handlung'].setText("\n\nRuntime: %s" % (runtime))
		CoverHelper(self['coverArt']).getCover(coverUrl)
	def keyOK(self):
		if self.keyLocked:
			return
		Title = self['liste'].getCurrent()[0][0]
		Link = self['liste'].getCurrent()[0][1]
		HD = self.HD
		if HD == "720p":
			Link = Link.replace('a720p.m4v','h720p.mov')
		if HD == "1080p":
			Link = Link.replace('a720p.m4v','h1080p.mov')
			Link = Link.replace('h720p.mov','h1080p.mov')
		self.keyLocked = False
		self.play(Link)

	def play(self,file):
		Title = self['liste'].getCurrent()[0][0]
		self.session.open(SimplePlayer, [(Title, file)], showPlaylist=False, ltype='appletrailers')

	def keyCancel(self):
		try:
			config.mediaplayer.useAlternateUserAgent.value = False
			config.mediaplayer.alternateUserAgent.value = ""
			config.mediaplayer.useAlternateUserAgent.save()
			config.mediaplayer.alternateUserAgent.save()
			config.mediaplayer.save()
		except Exception, errormsg:
			config.mediaplayer = ConfigSubsection()
			config.mediaplayer.useAlternateUserAgent = ConfigYesNo(default=False)
			config.mediaplayer.alternateUserAgent = ConfigText(default="")
		self.close()